/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.holder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.IdRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ViewUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.utils.GlideUtils;

public class PocConversationSearchHolder
extends BaseViewHolder<POCMemberInfo> {
    private TextView mTvName;
    private TextView mTvPart;
    private TextView mTvId;
    private ImageView mImgHeadIcon;
    private ImageView mImgIsSelected;
    private View mRelItemRoot;
    private IHolderClickLinstener mListener;

    public PocConversationSearchHolder(ViewGroup itemView, IHolderClickLinstener listener) {
        super(itemView, R.layout.poc_conversation_list_item_layout);
        this.mListener = listener;
        String account = PreferenceHelper.getString((String)"login_account", (String)"");
        this.mRelItemRoot = this.$(R.id.rel_item_root);
        this.mImgHeadIcon = (ImageView)this.$(R.id.img_head_icon);
        this.mTvName = (TextView)this.$(R.id.tv_name);
        this.mTvPart = (TextView)this.$(R.id.tv_part);
        this.mTvId = (TextView)this.$(R.id.tv_small_text);
        this.mImgIsSelected = (ImageView)this.$(R.id.img_is_select);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void setData(POCMemberInfo data) {
        super.setData((Object)data);
        if (!StringUtils.isEmpty((String)data.getIcon())) {
            if (data.isOnLine()) {
                ViewUtils.intoView((Context)this.getContext(), (ImageView)this.mImgHeadIcon, (int)R.drawable.poc_icon_default_avatar, (String)GlideUtils.checkImagePath(data.getIcon()));
            } else {
                ViewUtils.intoView((Context)this.getContext(), (ImageView)this.mImgHeadIcon, (int)R.drawable.poc_icon_hungup, (String)GlideUtils.checkImagePath(data.getIcon()));
            }
        } else if (data.isOnLine()) {
            this.mImgHeadIcon.setImageDrawable(this.getContext().getDrawable(R.drawable.poc_icon_default_avatar));
            this.mRelItemRoot.setBackground(this.getContext().getDrawable(R.drawable.poc_list_select_on_bg));
        } else {
            this.mImgHeadIcon.setImageDrawable(this.getContext().getDrawable(R.drawable.poc_icon_hungup));
            this.mRelItemRoot.setBackground(this.getContext().getDrawable(R.drawable.poc_list_select_off_bg));
        }
        this.mTvName.setText((CharSequence)data.getName());
        if (!TextUtils.isEmpty((CharSequence)data.getDeptName())) {
            this.mTvPart.setText((CharSequence)data.getDeptName());
            this.mTvPart.setVisibility(0);
        } else {
            this.mTvPart.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)data.getAccount())) {
            this.mTvId.setText((CharSequence)("ID: " + data.getAccount()));
        }
        this.mImgIsSelected.setVisibility(4);
        this.mImgHeadIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PocConversationSearchHolder.this.mListener != null) {
                    PocConversationSearchHolder.this.mListener.OnClick(v.getId(), PocConversationSearchHolder.this.getAdapterPosition());
                }
            }
        });
        if (data.isChecked()) {
            this.mImgIsSelected.setImageDrawable(this.getContext().getDrawable(R.drawable.poc_member_selected));
        } else {
            this.mImgIsSelected.setImageDrawable(this.getContext().getDrawable(R.drawable.poc_member_noselect));
        }
    }

    public static interface IHolderClickLinstener {
        public void OnClick(@IdRes int var1, int var2);
    }
}

