/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.record.http.HttpsUtils;
import com.xdja.poc.sdk.utils.IPHost;
import java.io.File;
import java.util.Calendar;

public class GlideUtils {
    private static final String TAG = GlideUtils.class.getSimpleName();
    private static final String VIDEO_USER_ID = "xdja-app-policevp";
    private static final String VIDEO_SECRET = "xdja-xa-policevp";

    public static void setImageUseFile(Context context, String fileUri, ImageView view) {
        Glide.with((Context)context).load(new File(fileUri)).error(R.drawable.poc_icon_default_avatar).placeholder(R.drawable.poc_icon_default_avatar).into(view);
    }

    public static void setImageUseNetWithCircle(Context context, String NetUri, ImageView view) {
        Glide.with((Context)context).load(NetUri).bitmapTransform(new Transformation[]{new GlideCircleTransform(context)}).error(R.drawable.poc_icon_default_avatar).placeholder(R.drawable.poc_icon_default_avatar).into(view);
    }

    public static void setImageUseNet(Fragment context, String NetUri, ImageView view) {
        Glide.with((Fragment)context).load(NetUri).error(R.drawable.poc_icon_default_avatar).placeholder(R.drawable.poc_icon_default_avatar).diskCacheStrategy(DiskCacheStrategy.NONE).into(view);
    }

    public static void transformImageToBitmap(Context context, String source, final Callback callback) {
        if (TextUtils.isEmpty((CharSequence)source) || callback == null) {
            return;
        }
        Glide.with((Context)context).load(source).asBitmap().into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                Bitmap bitmap = GlideUtils.getRoundedCornerBitmap(resource);
                Log.d((String)TAG, (String)("testBitmap onResourceReady " + bitmap));
                if (bitmap != null) {
                    callback.onSuccess(bitmap);
                } else {
                    callback.onFailed("transform failed");
                }
            }

            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                super.onLoadFailed(e, errorDrawable);
                callback.onFailed("transform failed");
            }
        });
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        try {
            Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            Paint paint = new Paint();
            Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF rectF = new RectF(new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()));
            int bSize = Math.min(bitmap.getWidth(), bitmap.getHeight());
            float roundPx = bSize / 2;
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(-16777216);
            canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            Rect src = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            canvas.drawBitmap(bitmap, src, rect, paint);
            return output;
        }
        catch (Exception e) {
            return bitmap;
        }
    }

    public static String checkImagePath(String imageUrl) {
        String path = imageUrl;
        if (!TextUtils.isEmpty((CharSequence)imageUrl) && !imageUrl.startsWith("http")) {
            boolean isMisUrl = imageUrl.startsWith("/mis/");
            path = isMisUrl ? IPHost.getMisServer() + imageUrl : IPHost.getFastDfsUrl() + File.separator + imageUrl;
        }
        path = GlideUtils.dealFileUrl(path);
        LogUtils.DLog((String)"GlideUtils", (String)("imagepath:" + path));
        return path;
    }

    public static String dealFileUrl(String imageUrl) {
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            return "";
        }
        if (GlideUtils.isSignUrl(imageUrl)) {
            return imageUrl;
        }
        return GlideUtils.addSignUrl(imageUrl);
    }

    public static String addSignUrl(String pictureUrl) {
        if (TextUtils.isEmpty((CharSequence)pictureUrl)) {
            return "";
        }
        if (!pictureUrl.startsWith("http")) {
            return pictureUrl;
        }
        return pictureUrl + GlideUtils.createAuthInfo();
    }

    public static boolean isSignUrl(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.contains("userid=") && path.contains("ts=") && path.contains("sign=");
    }

    public static String createAuthInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(12, 10);
        long timeStamp = calendar.getTimeInMillis();
        String originalStr = IPHost.getFastDfsAppId() + timeStamp;
        String sign = HttpsUtils.getSignature(IPHost.getFastDfsSecret(), originalStr);
        stringBuilder.append("?").append("userid=").append(IPHost.getFastDfsAppId()).append("&").append("ts=").append(timeStamp).append("&").append("sign=").append(sign).append("&").append("mvdp=").append("1");
        return stringBuilder.toString();
    }

    public static interface Callback {
        public void onSuccess(Bitmap var1);

        public void onFailed(String var1);
    }

    private static class GlideCircleTransform
    extends BitmapTransformation {
        GlideCircleTransform(Context context) {
            super(context);
        }

        protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
            return this.circleCrop(pool, toTransform);
        }

        private Bitmap circleCrop(BitmapPool pool, Bitmap source) {
            if (source == null) {
                return null;
            }
            int size = Math.min(source.getWidth(), source.getHeight());
            int x = (source.getWidth() - size) / 2;
            int y = (source.getHeight() - size) / 2;
            Bitmap squared = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)size, (int)size);
            Bitmap result = pool.get(size, size, Bitmap.Config.ARGB_8888);
            if (result == null) {
                result = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            Canvas canvas = new Canvas(result);
            Paint paint = new Paint();
            paint.setShader((Shader)new BitmapShader(squared, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            paint.setAntiAlias(true);
            float r = (float)size / 2.0f;
            canvas.drawCircle(r, r, r, paint);
            return result;
        }

        public String getId() {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
}

