/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.text.TextUtils;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;

public class POCGroupOrderComparator
implements Comparator<DBGroupEntity> {
    @Override
    public int compare(DBGroupEntity current, DBGroupEntity another) {
        boolean anotherStatus;
        boolean anotherTop;
        boolean top = current.getIsTopStick();
        boolean bl = anotherTop = another.getIsTopStick();
        if (top > anotherTop) {
            return -1;
        }
        if (top < anotherTop) {
            return 1;
        }
        boolean currentStatus = current.getStatus() > 0;
        boolean bl2 = anotherStatus = another.getStatus() > 0;
        if (currentStatus > anotherStatus) {
            return -1;
        }
        if (currentStatus < anotherStatus) {
            return 1;
        }
        if (current.getGroupType() < another.getGroupType()) {
            return -1;
        }
        if (current.getGroupType() > another.getGroupType()) {
            return 1;
        }
        if (current.getGroupType() == 0 && another.getGroupType() == 0) {
            return this.TimeCompare(current.getCreateTime(), another.getCreateTime());
        }
        if (current.getPinyin().equals("#") && !another.getPinyin().equals("#")) {
            return 1;
        }
        if (!current.getPinyin().equals("#") && another.getPinyin().equals("#")) {
            return -1;
        }
        return current.getPinyin().compareToIgnoreCase(another.getPinyin());
    }

    public int TimeCompare(String time1, String time2) {
        if (TextUtils.isEmpty((CharSequence)time1)) {
            return 1;
        }
        if (TextUtils.isEmpty((CharSequence)time2)) {
            return -1;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date1 = format.parse(time1);
            Date date2 = format.parse(time2);
            return date1.getTime() - date2.getTime() < 0L ? 1 : -1;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

