/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.content.Context;
import android.media.AudioRecord;
import android.text.TextUtils;
import android.util.Base64;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.utils.HMACSHA1;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class Utils {
    private static final String TAG = "Utils";
    public static String key = "xdja";
    public static long offset_localTime_serverTime = 0L;
    private static final int MIN_CLICK_DELAY_TIME = 500;
    private static long lastClickTime;

    public static String genToken(String encryptText) {
        try {
            LogUtils.DLog((String)"janus", (String)("constant offset of phoneTime with serverTime:" + offset_localTime_serverTime));
            long expiry_time = System.currentTimeMillis() / 1000L - offset_localTime_serverTime + 300L;
            String realm = "janus";
            StringBuilder sb = new StringBuilder();
            sb.append(expiry_time).append(",").append(realm).append(",").append("janus.plugin.pocroom").append(",").append(Utils.md5(encryptText));
            byte[] signature = HMACSHA1.HmacSHA1Encrypt(sb.toString(), key);
            String strBase64 = Base64.encodeToString((byte[])signature, (int)2);
            sb.append(":").append(strBase64);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string2.getBytes());
            StringBuilder result = new StringBuilder();
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result.append(temp);
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isFastClick(int duration) {
        boolean flag = false;
        long curClickTime = System.currentTimeMillis();
        if (curClickTime - lastClickTime >= (long)duration) {
            flag = true;
        }
        lastClickTime = curClickTime;
        return flag;
    }

    public static String fmatLongToString(long dateTime, String dateTimeFmat) {
        return new SimpleDateFormat(dateTimeFmat, Locale.CHINA).format(dateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean checkAudioPermission(Context context) {
        if (context == null) {
            LogUtils.ELog((String)TAG, (String)"checkAudioPermission: context is null");
            return true;
        }
        int bufferSizeInBytes = AudioRecord.getMinBufferSize((int)44100, (int)12, (int)2);
        AudioRecord audioRecord = new AudioRecord(1, 44100, 12, 2, bufferSizeInBytes);
        boolean startRecordingSuccess = false;
        try {
            audioRecord.startRecording();
            LogUtils.DLog((String)TAG, (String)"checkAudioPermission: start recording");
            startRecordingSuccess = true;
            boolean bl = audioRecord.getRecordingState() == 3;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (startRecordingSuccess) {
                    audioRecord.stop();
                }
            }
            finally {
                audioRecord.release();
                audioRecord = null;
                LogUtils.DLog((String)TAG, (String)"checkAudioPermission: release audioRecord");
            }
        }
        return false;
    }

    public static String transforUrl(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        String newPath = null;
        if (path.startsWith("http://72.32.18")) {
            if (path.length() > 18) {
                String endPath = path.substring(18);
                newPath = "http://192.168.2.213" + endPath;
            }
        } else if (path.startsWith("72.32.18")) {
            if (path.length() > 11) {
                String endPath = path.substring(11);
                newPath = "192.168.2.213" + endPath;
            } else {
                newPath = "192.168.2.213";
            }
        }
        if (TextUtils.isEmpty(newPath)) {
            newPath = path;
        }
        LogUtils.DLog((String)TAG, (String)("transforUrl path:" + newPath));
        return newPath;
    }
}

