/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils.glide;

import android.content.Context;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.utils.glide.OkHttpStreamFetcher;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class OkHttpUrlLoader
implements ModelLoader<GlideUrl, InputStream> {
    private final Call.Factory client;

    public OkHttpUrlLoader(Call.Factory client) {
        this.client = client;
    }

    public DataFetcher<InputStream> getResourceFetcher(GlideUrl model, int width, int height) {
        return new OkHttpStreamFetcher(this.client, model);
    }

    public static class Factory
    implements ModelLoaderFactory<GlideUrl, InputStream> {
        private static Call.Factory internalClient;
        private Call.Factory client;

        public Factory() {
            this(Factory.getInternalClient());
        }

        public Factory(Call.Factory client) {
            this.client = client;
        }

        private static synchronized Call.Factory getInternalClient() {
            if (internalClient == null) {
                internalClient = new OkHttpClient();
            }
            return internalClient;
        }

        public ModelLoader<GlideUrl, InputStream> build(Context context, GenericLoaderFactory factories) {
            return new OkHttpUrlLoader(this.client);
        }

        public void teardown() {
            LogUtils.DLog((String)Factory.class.getSimpleName(), (String)"teardown");
        }
    }
}

