package com.xdja.poc.sdk.greendao.manager;


import android.support.annotation.Keep;

import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.greendao.dao.DaoMaster;
import com.xdja.poc.sdk.greendao.dao.DaoSession;

import org.greenrobot.greendao.database.Database;

/**
 * Created by Administrator on 2018/2/5 10:17.
 */

@SuppressWarnings("ALL")
@Keep
public class GreenDaoManager {
    private static final String DB_NAME_SUFFIX = "_record.db";
    private static GreenDaoManager mInstance;
    private DaoMaster daoMaster;
    private DaoSession daoSession;
    private SQLiteOpenHelper mHelper;

    public static GreenDaoManager getInstance() {
        if (mInstance == null) {
            synchronized (GreenDaoManager.class) {
                if (mInstance == null) {
                    mInstance = new GreenDaoManager();
                }
            }
        }
        return mInstance;
    }

    private GreenDaoManager() {
        if (mInstance == null) {
            getDaoMaster();
        }
    }

    public DaoSession getDaoSession() {
        if (daoSession == null) {
            if (daoMaster == null) {
                daoMaster = getDaoMaster();
            }
            daoSession = daoMaster.newSession();
        }
        return daoSession;
    }

    public DaoMaster getDaoMaster() {
        if (daoMaster == null) {
            Database db;
            try {
                String account = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
                String DB_NAME = account + DB_NAME_SUFFIX;
                LogUtils.ELog(DB_NAME, DB_NAME);
                mHelper = new SQLiteOpenHelper(GlobalContext.getContext(), DB_NAME, null);
                //获取加密的数据库失败时,获取未加密的数据库
                db = mHelper.getWritableDb();
                daoMaster = new DaoMaster(db);
                return daoMaster;
            } catch (Exception e) {
                closeHelper();
                LogUtils.ELog(e);

            }
        }
        return daoMaster;
    }

    /**
     * 退出登录,重置对象
     */
    public void resetDaoMaster() {
        closeConnection();
        daoMaster = null;
    }

    /**
     * 关闭所有的操作,数据库开启后,使用完毕要关闭
     */
    public void closeConnection() {
        closeHelper();
        closeDaoSession();
    }

    public void closeHelper() {
        if (mHelper != null) {
            mHelper.close();
            mHelper = null;
        }
    }

    public void closeDaoSession() {
        if (daoSession != null) {
            daoSession.clear();
            daoSession = null;
        }
    }
}
