package com.xdja.poc.sdk.ui.main.fragment;


import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.jude.easyrecyclerview.decoration.DividerDecoration;
import com.xdja.poc.common.annotation.BindEventBus;
import com.xdja.poc.common.base.BaseFragment;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.view.EmptyView;
import com.xdja.poc.common.view.ISearchCallBack;
import com.xdja.poc.common.view.SearchEditView;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.POCHandlerService;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupListEvent;
import com.xdja.poc.sdk.event.GroupMemberAddEvent;
import com.xdja.poc.sdk.event.GroupRefreshAdapterEvent;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.event.RefreshGroupList;
import com.xdja.poc.sdk.event.ResetChannelStatus;
import com.xdja.poc.sdk.event.UpdateGroupDataUI;
import com.xdja.poc.sdk.event.UpdateMemberInfoEvent;
import com.xdja.poc.sdk.event.UpdateUserInfoEvent;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.main.holder.PocGroupListHolder;
import com.xdja.poc.sdk.ui.main.holder.PocSearchGroupListHolder;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListContract;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListPresenter;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.POCGroupOrderComparator;
import com.xdja.poc.sdk.utils.Utils;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;

/**
 * janus-gateway-android-master
 * 功能  频道列表
 * 描述
 * created by Administrator : 2018/8/27
 */
@SuppressWarnings("ALL")
@BindEventBus
public class POCRecentFragment extends BaseFragment implements SwipeRefreshLayout.OnRefreshListener,
        ISearchCallBack, View.OnClickListener, POCGroupListContract.IView {
    private String TAG = "POCRecentFragment";
    private SearchEditView mSearchView;
    private ProgressBar progressoLoading;
    public POCGroupListContract.IPresenter mPresenter;
    private EasyRecyclerView recyclerView;
    private RecyclerArrayAdapter<DBGroupEntity> adapter;
    private RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter;
    private static final int MSG_SEARCH_DELAY = 1;
    private String keyWords = "";
    private String mUserId;
    private long lastClickTime = 0L;
    private EmptyView emptyDataView;
    private EmptyView emptySearchView;
    //    private ProgressDialog mProgressDialog;
    private POCGroupOrderComparator groupOrderComparator;
    private Map<String, POCMemberInfo> userNameInfo = new HashMap<>();
    private List<DBGroupEntity> mList = new ArrayList<>();
    private String targetChannelId;
    private boolean isReconnectChannel = false;
    /**
     * 是否为执法仪
     */
    private boolean isZfy;

    //    private Map<String, Map<String, String>> mAccountToName = new HashMap<>();
    @Override
    protected int generateLayout() {
        return R.layout.poc_fragment_recent;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        PocNotificationService.isChange = true;
    }

    @Override
    protected void initView() {
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        groupOrderComparator = new POCGroupOrderComparator();
        mSearchView = $(R.id.searchView);
        mSearchView.setSHintText(getString(R.string.poc_hint_input_channel_name));
        recyclerView = $(R.id.recycleView);
        progressoLoading = $(R.id.poc_loading);
        mPresenter = new POCGroupListPresenter(this, getActivity());
        recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
        //设置分割线
        DividerDecoration decoration = new DividerDecoration(getActivity().getResources().getColor(R.color.common_item_divider_bg), 1, 0, 0);
        decoration.setDrawLastItem(true);
        recyclerView.addItemDecoration(decoration);
        recyclerView.getSwipeToRefresh().setColorSchemeResources(R.color.common_main_color);
        recyclerView.setEmptyView(createEmptyDataView());
        recyclerView.setErrorView(createLiveVideoErrorView());
        recyclerView.requestFocus();

        isZfy = getActivity().getPackageName().contains("zfy");
        LogUtils.DLog(TAG,"isZfy "+ isZfy);

        adapter = new RecyclerArrayAdapter<DBGroupEntity>(getActivity()) {
            @Override
            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                return new PocGroupListHolder(parent, mUserId,isZfy,new PocGroupListHolder.onViewClickListener() {
                    @Override
                    public void onClick(@IdRes int id, int position) {
                        if (id == R.id.iv_audio_switch) {
                            if (position < 0) {
                                adapter.notifyDataSetChanged();
                                return;
                            }
                            if (isDoubleClick()) return;
                            DBGroupEntity entity = adapter.getAllData().get(position);
                            if (entity != null) {
                                boolean isSilence = !entity.getIsSilence();
                                entity.setIsSilence(isSilence ? 1 : 0);
                                adapter.notifyItemChanged(position);
                                POCClient.muteAndNotifyUI(Long.valueOf(entity.getRooomId()), isSilence);
                            }
                        }
                    }
                });
            }
        };
        mSearchAdapter = new RecyclerArrayAdapter<DBGroupEntity>(getActivity()) {
            @Override
            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                return new PocSearchGroupListHolder(parent,mUserId, keyWords, isZfy,(id, position) -> {
                    if (id == R.id.iv_audio_switch) {
                        if (position < 0) {
                            mSearchAdapter.notifyDataSetChanged();
                            return;
                        }
                        if (isDoubleClick()) return;
                        DBGroupEntity entity = mSearchAdapter.getAllData().get(position);
                        if (entity != null) {
                            boolean isSilence = !entity.getIsSilence();
                            entity.setIsSilence(isSilence ? 1 : 0);
                            mSearchAdapter.notifyItemChanged(position);
                            POCClient.muteAndNotifyUI(Long.valueOf(entity.getRooomId()), isSilence);

                        }
                    }
                });
            }
        };
        recyclerView.setAdapter(adapter);
        //下拉刷新
        recyclerView.setRefreshListener(this);
        mPresenter.attatchAdapter(recyclerView, mSearchAdapter, adapter);
        recyclerView.getSwipeToRefresh().setRefreshing(false);
        userNameInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        progressoLoading.setVisibility(View.VISIBLE);
        onRefresh();
    }

    /**
     * 创建空数据view
     *
     * @return
     */
    private View createEmptyDataView() {
        if (emptyDataView == null) {
            emptyDataView = new EmptyView(getActivity());
            emptyDataView.init(new EmptyView.Configure.Builder()
                            .setContent(getString(R.string.poc_channel_empty))
                            .setClickColor(getResources().getColor(R.color.common_main_color))
                            .setClickContent("")
                            .setIconId(R.mipmap.poc_iv_list_empty)
                            .setSpanString("")
                            .setIconClickListener(new View.OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    AMnager.startCraeteChannelActivity(getActivity());
                                }
                            })
                            .build()
                    , new EmptyView.ISpanClickListener() {
                        @Override
                        public void onClick() {
                            AMnager.startPOCMemberListActivity(POCRecentFragment.this.getActivity(), GroupConfig.MEMBER_ACTIVITY_NORMAL_TYPE);
                        }
                    });
        }
        LinearLayout contentView = emptyDataView.getContentView();
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) contentView.getLayoutParams();
        layoutParams.bottomMargin = DisplayUtil.dip2px(getActivity(), 45);
        contentView.setLayoutParams(layoutParams);
        return emptyDataView;
    }

    /**
     * 创建空view
     *
     * @return
     */
    public View createEmptySearchView() {
        if (emptySearchView == null) {
            emptySearchView = new EmptyView(getActivity());
            emptySearchView.init(new EmptyView.Configure.Builder()
                    .setContent(getString(R.string.poc_search_result_empty))
                    .setIconId(R.drawable.poc_search_no_result)
                    .build(), null);
        }
        return emptySearchView;
    }

    @Override
    public void onResume() {
        super.onResume();
        isOnPause = false;
        recyclerView.requestFocus();
        Constants.isReject = false;
        Constants.isViewExist = true;
    }

    public void onStart() {
        super.onStart();
        isOnPause = false;
    }

    /**
     * 防止快速点击
     */
    private boolean isDoubleClick() {
        long currentClickTime = System.currentTimeMillis();
        int FAST_CLICK_DELAY_TIME = 300;
        if (System.currentTimeMillis() - lastClickTime < FAST_CLICK_DELAY_TIME) {
            return true;
        }
        lastClickTime = currentClickTime;
        return false;
    }

    private View createLiveVideoErrorView() {
        LayoutInflater inflater = getActivity().getLayoutInflater();
        View errorView = inflater.inflate(R.layout.poc_view_error, null);
        errorView.findViewById(R.id.mOpenReloading).setOnClickListener(v -> {
            onRefresh();
        });
        return errorView;
    }

    @Override
    protected void initEvent() {
        mSearchView.addTextChangeWatcher(this);
        adapter.setOnItemClickListener(position -> {
            mSearchView.closeKeyboard();
            if (position >= 0) {
                try {
                    DBGroupEntity pocGroup = adapter.getAllData().get(position);
                    if (pocGroup != null) {
                        if (pocGroup.getStatus() == GroupConfig.GROUP_HANGUP) {
                            //isNetConnected&&GroupUtils.isMaxRoomCount()||
                            if (checkMaxChannelCount()) {
                                Toast.makeText(getActivity(), GlobalContext.getContext().getString(R.string.poc_max_online_group), Toast.LENGTH_SHORT).show();
                                return;
                            }
                        }
                        sendReleaseBroadcast();
                        AMnager.startPOCConversionActivity(getActivity(), pocGroup, pocGroup.getRoomName(), position, false);
                    }
                } catch (Exception e) {
                    LogUtils.ELog(TAG, "" + e.getLocalizedMessage());
                }

            }
        });
        adapter.setOnItemLongClickListener(position -> {
            mSearchView.closeKeyboard();
            if (position >= 0) {
//                mPresenter.showMenuDialog(position);
                DBGroupEntity entity = adapter.getAllData().get(position);
                POCUiKitProxyImpl.getInstance().notifyChannelListItemLongClick(entity, position, getChannleName(entity));
            }
            return true;
        });
        mSearchAdapter.setOnItemLongClickListener(position -> {
            mSearchView.closeKeyboard();
            if (position >= 0) {
//                mPresenter.showMenuDialog(position);
                DBGroupEntity entity = mSearchAdapter.getAllData().get(position);
                POCUiKitProxyImpl.getInstance().notifyChannelListItemLongClick(entity, position, getChannleName(entity));
            }
            return true;
        });
        mSearchAdapter.setOnItemClickListener(position -> {
            mSearchView.closeKeyboard();
            if (position >= 0) {
                try {
                    DBGroupEntity pocGroup = mSearchAdapter.getAllData().get(position);
                    if (pocGroup != null) {
                        if (pocGroup.getStatus() == GroupConfig.GROUP_HANGUP) {
                            if (checkMaxChannelCount()) {
                                Toast.makeText(getActivity(), GlobalContext.getContext().getString(R.string.poc_max_online_group), Toast.LENGTH_SHORT).show();
                                return;
                            }
                        }
                        AMnager.startPOCConversionActivity(getActivity(), pocGroup, pocGroup.getRoomName(), position, false);
                    }
                } catch (Exception e) {
                    LogUtils.ELog(TAG, "" + e.getLocalizedMessage());
                }

            }
        });
        mSearchView.getEditText().setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                    String key = mSearchView.getEditText().getText().toString();
                    if (TextUtils.isEmpty(key) || StringUtils.isEmpty(key.trim())) {
                        ToastUtils.showToast("请输入搜索内容");
                        return true;
                    }
                    mSearchView.closeKeyboard();
                    return true;
                }
                return false;
            }

        });
    }

    /**
     * 发送释放广播(适用于执法仪)
     */
    private void sendReleaseBroadcast(){
        if (isZfy && !Utils.checkAudioPermission(getActivity())) {
            //释放相机广播
            sendBroadCast("android.intent.action.CAMERA_RELEASE");
            //发送停止录音广播
            sendBroadCast("android.intent.action.AUDIO_STOP_RECORD");
        }
    }
    private void sendBroadCast(String action){
        getActivity().sendBroadcast(new Intent(action));
    }

    private boolean checkMaxChannelCount() {
        int onLineCount = 0;
        for (DBGroupEntity entity : adapter.getAllData()) {
            if (entity.getStatus() == GroupConfig.GROUP_BUSY || entity.getStatus() == GroupConfig.GROUP_FREE) {
                onLineCount++;
            }
        }
        int maxChannelCount = PreferenceHelper.getInt(UserConfig.MAX_CHANNEL_COUNT, -1);
        return onLineCount >= maxChannelCount && (maxChannelCount > 1);
    }

    private int pageSatus = -1;

    @Override
    public void switchViewStatus(int status) {
        pageSatus = status;
        recyclerView.setAdapter(adapter);
        switch (status) {
            case UserConfig.VIEW_STTAUS_EMPTY:
                recyclerView.setEmptyView(emptyDataView);
                recyclerView.showEmpty();
                adapter.clear();
                break;
            case UserConfig.VIEW_STTAUS_ERROR:
                if (!isOnPause)
                    ToastUtils.showToast(getResources().getString(R.string.poc_conversation_network_not_available));
                if (adapter.getAllData() == null || adapter.getAllData().size() <= 0) {
                    recyclerView.showError();
                }
                break;
            case UserConfig.VIEW_STTAUS_NORMAL:
                recyclerView.showRecycler();
                break;
        }
    }

    @Override
    public void onRefreshList() {
        onRefresh();
    }

    @Override
    public void onSelfInComing(String roomId) {
        for (DBGroupEntity entity : adapter.getAllData()) {
            if (entity.getRooomId().equals(roomId)) {
                boolean isSilence = entity.getIsSilence();
                POCClient.muteAndNotifyUI(Long.valueOf(roomId), isSilence);
                break;
            }
        }
    }

    @Override
    public void resetFragment() {
        resetView(true);
    }

    @Override
    public void onGroupList(ArrayList<DBGroupEntity> mGroupList, int viewSttaus) {
        adapter.clear();
        recyclerView.setRefreshing(false);
        resetView(true);
        switchViewStatus(UserConfig.VIEW_STTAUS_NORMAL);
        if (mGroupList == null) {
            progressoLoading.setVisibility(View.GONE);
            switchViewStatus(UserConfig.VIEW_STTAUS_ERROR);
            reconnectChannel();
            return;
        } else if (mGroupList.size() == 0) {
//            dismissLoading();
            progressoLoading.setVisibility(View.GONE);
            switchViewStatus(UserConfig.VIEW_STTAUS_EMPTY);
            POCHandlerService.clearChannelInfo(getActivity(), mUserId);
            return;
        }
        mList.clear();
        mList.addAll(mGroupList);
//        currentPage++;
        Map<String, String> map = POCClient.getAllSpeakers();//频道号 —> 讲话人的userId
        for (DBGroupEntity entity : mList) {
            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(entity.getRooomId()));
            entity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
            boolean b = GroupUtils.resetGroupStatus(entity);
            entity.setStatus(b ? GroupConfig.GROUP_FREE : GroupConfig.GROUP_HANGUP);
            if (map != null && map.containsKey(entity.getRooomId())) {
                //1 说明当前频道在讲话中
                entity.setStatus(GroupConfig.GROUP_BUSY);
                //2 给speakName默认值为 account
                String speakName = map.containsKey(entity.getRooomId()) ? map.get(entity.getRooomId()) : "";
                //3 用户数据已缓存
                //5 取出该频道里的人员的缓存数据userId -> userName 缓存
                userNameInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                if (userNameInfo != null && userNameInfo.containsKey(map.get(entity.getRooomId()))) {
                    //6 如果频道里的人员的缓存数据不为空,则获取该频道讲话人的姓名
                    speakName = userNameInfo.get(map.get(entity.getRooomId())).getName();
                }
                entity.setSpeakerUserName(speakName);
            }
        }
        Collections.sort(mList, groupOrderComparator);
        adapter.addAll(mList);
        LogUtils.DLog(TAG,"onGroupListEvent talk list:"+mList.size());
        progressoLoading.setVisibility(View.GONE);
        if (!TextUtils.isEmpty(targetChannelId)) {
            for (DBGroupEntity entity : mList) {
                if (entity.getRooomId().equals(targetChannelId)) {
                    AMnager.startPOCConversionActivity(getActivity(), entity, entity.getRoomName(), -1, false);
                    targetChannelId = null;
                    break;
                }
            }
        }
        reconnectChannel();
//        dismissLoading();
//        initUserNames(mGroupList);

    }

    private void reconnectChannel() {
        if (isReconnectChannel) {
            POCClient.handleNetConnectSuccess();
        }
    }

    @Override
    public void showLoading(String content) {
//        if (mProgressDialog == null) {
//            mProgressDialog = new ProgressDialog(getActivity());
//            mProgressDialog.setIndeterminateDrawable(getResources().getDrawable(R.drawable.poc_progressbar));
//            mProgressDialog.setIndeterminate(true);
//            mProgressDialog.setCancelable(false);
//        }
//        mProgressDialog.setMessage(content);
//        if (mProgressDialog != null && !mProgressDialog.isShowing()) {
//            // 让ProgressDialog显示
//            mProgressDialog.show();
//        }

    }

    @Override
    public View getEmptyView() {
        return createEmptyDataView();
    }

    @Override
    public POCGroupOrderComparator getComparator() {
        return groupOrderComparator;
    }

    @Override
    public View getErrorView() {
        return createLiveVideoErrorView();
    }

    @Override
    public void dismissLoading() {
//        if (mProgressDialog != null) {
//            mProgressDialog.dismiss();
//        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        mPresenter.destroy();
        Constants.isViewExist = false;
    }

    private boolean isOnPause = false;

    @Override
    public void onStop() {
        super.onStop();
        isOnPause = true;
    }

    @Override
    public void onPause() {
        super.onPause();
        isOnPause = true;
        mSearchView.closeKeyboard();
    }

    @Override
    public void onRefresh() {
//        showLoading("正在加载,请稍后...");
        if (!NetUtils.isNetworkAvailable(getActivity())) {
            dismissLoading();
            recyclerView.getSwipeToRefresh().setRefreshing(false);
            progressoLoading.setVisibility(View.GONE);
            switchViewStatus(UserConfig.VIEW_STTAUS_ERROR);
            return;
        }
//        isLoadMore = false;
//        currentPage = 0;
        int REQUEST_PAGE_SIZE = 10;
        POCUiKitProxyImpl.getInstance().notifyRefreshGroupList(0, REQUEST_PAGE_SIZE, 1);
    }

    /**
     * 服务器频道数据和本地整合完成后的回调
     *
     * @param groupListEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupListEvent(GroupListEvent groupListEvent) {
        ArrayList<DBGroupEntity> groupArrayList = (ArrayList<DBGroupEntity>) groupListEvent.getT();
        LogUtils.DLog(TAG,"onGroupListEvent load groupArrayList："+(groupArrayList == null ? "is null.":groupArrayList.size()));
        onGroupList(groupArrayList, UserConfig.VIEW_STTAUS_NORMAL);
    }

    public static POCRecentFragment newInstance() {
        return new POCRecentFragment();
    }

    private SearchHandler mSearchHandler = new SearchHandler(this);

    @Override
    public void onStartSearch(String keyWord) {
        this.keyWords = keyWord;
        mSearchHandler.removeMessages(MSG_SEARCH_DELAY);
        mSearchHandler.sendEmptyMessageDelayed(MSG_SEARCH_DELAY, 100);
    }

    @Override
    public void onEndSearch() {
//        recyclerView.setEmptyView(emptyView);
        if (searchTask != null) {
            searchTask.cancel(true);
        }
        mSearchHandler.removeMessages(MSG_SEARCH_DELAY);
        recyclerView.setAdapter(adapter);
        adapter.notifyDataSetChanged();
        if (adapter.getAllData() == null || adapter.getAllData().size() <= 0) {
            switchViewStatus(UserConfig.VIEW_STTAUS_EMPTY);
        }
        mSearchAdapter.clear();
    }

    @Override
    public void onClick(View v) {
    }

    public void dispatchTouchEvent(MotionEvent ev) {
        if (mSearchView.getEditText().hasFocus()) {
            mSearchView.closeKeyboard();
        }
    }

    @SuppressWarnings("CanBeFinal")
    private static class SearchHandler extends Handler {
        private WeakReference<POCRecentFragment> mActivity;
        private List<DBGroupEntity> allData;

        SearchHandler(POCRecentFragment activity) {
            mActivity = new WeakReference<>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            final POCRecentFragment pocRecentFragment = mActivity.get();
            if (pocRecentFragment != null) {
                if ((!pocRecentFragment.isAdded()) || (pocRecentFragment.isRemoving())) {
                    return;
                }
                if (allData == null) {
                    allData = pocRecentFragment.adapter.getAllData();
                }
                switch (msg.what) {
                    case MSG_SEARCH_DELAY:
                        pocRecentFragment.doSearch();
                        break;
                }
            }
        }

    }

    private void doSearch() {
        if (searchTask != null) {
            searchTask.cancel(true);
        }
        searchTask = new SearchTask(this).executeOnExecutor(Executors.newScheduledThreadPool(20), keyWords);
    }

    private AsyncTask<String, Void, List<DBGroupEntity>> searchTask = new SearchTask(this);

    @SuppressWarnings("CanBeFinal")
    private static class SearchTask extends AsyncTask<String, Void, List<DBGroupEntity>> {
        private WeakReference<POCRecentFragment> mWefs;

        public SearchTask(POCRecentFragment chooseFriendsPresenter) {
            this.mWefs = new WeakReference<>(chooseFriendsPresenter);
        }

        @Override
        protected List<DBGroupEntity> doInBackground(String... strings) {
            if (mWefs != null && mWefs.get() != null) {
                POCRecentFragment recentFragment = mWefs.get();
                return GroupUtils.getPocGroupMatchKey(recentFragment.adapter.getAllData(), recentFragment.keyWords);
            }
            return null;
        }

        @Override
        protected void onPostExecute(List<DBGroupEntity> pocGroups) {
            super.onPostExecute(pocGroups);
            if (mWefs != null && mWefs.get() != null) {
                final POCRecentFragment recentFragment = mWefs.get();
                if (pocGroups == null || pocGroups.size() <= 0) {
                    recentFragment.recyclerView.setAdapter(recentFragment.mSearchAdapter);
                    recentFragment.recyclerView.setEmptyView(recentFragment.createEmptySearchView());
                    recentFragment.recyclerView.showEmpty();
                } else {
                    recentFragment.recyclerView.setAdapter(recentFragment.mSearchAdapter);
                    recentFragment.mSearchAdapter.clear();
                    recentFragment.mSearchAdapter.addAll(pocGroups);
                }
            }
        }
    }

    /**
     * 更新UI
     *
     * @param updateGroupDataUI
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUpdateGroupDataUI(UpdateGroupDataUI updateGroupDataUI) {
        ArrayList<DBGroupEntity> entities = (ArrayList<DBGroupEntity>) updateGroupDataUI.getT();
        onGroupList(entities, UserConfig.VIEW_STTAUS_NORMAL);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPOCMuteEvent(POCMuteEvent event) {
        String roomId = event.getRoomId();
        boolean silence = event.isSilence();
        LogUtils.DLog(TAG, "mute status " + " roomId: " + event.getRoomId() + "  : " + silence);
        int position = -1;
        for (DBGroupEntity pocGroup : adapter.getAllData()) {
            if (roomId.equalsIgnoreCase(pocGroup.getRooomId())) {
                pocGroup.setIsSilence(silence ? 1 : 0);
                position = adapter.getPosition(pocGroup);
                break;
            }
        }
        if (position != -1) {
            adapter.notifyItemChanged(position);
        }
        if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
            for (DBGroupEntity pocGroup : mSearchAdapter.getAllData()) {
                if (roomId.equalsIgnoreCase(pocGroup.getRooomId())) {
                    position = mSearchAdapter.getPosition(pocGroup);
                    pocGroup.setIsSilence(silence ? 1 : 0);
                    break;
                }
            }
            if (position != -1) {
                mSearchAdapter.notifyItemChanged(position);
            }
        }
    }

    @Override
    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
        super.onNetChanged(netWorkConnectEvent);
        isReconnectChannel = netWorkConnectEvent.isAvailable();
        if (!((boolean) netWorkConnectEvent.getT())) {
            if (pageSatus == UserConfig.VIEW_STTAUS_ERROR) {
                return;
            }
            if (pageSatus == UserConfig.VIEW_STTAUS_EMPTY) {
                return;
            }
            if (adapter.getAllData() == null && adapter.getCount() == 0) {
                return;
            }
            List<DBGroupEntity> allData = adapter.getAllData();
            for (DBGroupEntity entity : allData) {
                entity.setStatus(GroupConfig.GROUP_HANGUP);
                entity.setOnLineCount(0);
            }
            adapter.notifyDataSetChanged();
            if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
                for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                    entity.setStatus(GroupConfig.GROUP_HANGUP);
                    entity.setOnLineCount(0);
                }
                mSearchAdapter.notifyDataSetChanged();
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPOCGroupRefreshAdapter(GroupRefreshAdapterEvent event) {
        mPresenter.refreshAdapter(event.getRoomId());
    }

    /**
     * 统一更新频道列表本地数据
     *
     * @param pocGroupUpdateEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPOCGroupUpdateEvent(POCGroupUpdateEvent pocGroupUpdateEvent) {
        //modify by cga 只要有返回结果，progressoLoading都应该消失
        progressoLoading.setVisibility(View.GONE);
        if (pocGroupUpdateEvent.getViewType() == UserConfig.VIEW_STTAUS_EMPTY) {
            switchViewStatus(UserConfig.VIEW_STTAUS_EMPTY);
            POCHandlerService.clearChannelInfo(getActivity(), mUserId);
            return;
        }
        recyclerView.getSwipeToRefresh().setRefreshing(false);
        mPresenter.refreshGroupList(pocGroupUpdateEvent);
    }

//    @Subscribe(threadMode = ThreadMode.MAIN)
//    public void onGroupDeleteEvent(GroupDeleteEvent deleteEvent) {
//        DBGroupEntity entity = (DBGroupEntity) deleteEvent.getT();
//        mPresenter.deleteRoom(entity);
//    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onGroupMemberAddEvent(GroupMemberAddEvent addEvent) {
        String[] memberIds = addEvent.getMemberIds();
        String roomId = addEvent.getRoomId();
        if (memberIds != null && memberIds.length > 0) {
            List<POCMemberInfo> pocGroupUserInfos = POCUiKitProxyImpl.getInstance().getPOCGroupUserInfos(memberIds);
            for (DBGroupEntity entity : adapter.getAllData()) {
                if (roomId.equals(entity.getRooomId())) {
                    String memeberIds = entity.getMemeberIds();
                    List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(memeberIds);
                    allCountList.addAll(pocGroupUserInfos);
                    String s = POCClient.getInstance().generateListString(allCountList);
                    entity.setMemeberIds(s);
                    entity.setTotalCount(allCountList == null ? 0 : allCountList.size());
                    break;
                }
            }
            adapter.notifyDataSetChanged();
        }
    }

    private String getChannleName(DBGroupEntity entity) {
        String channelName = entity.getRoomName();
        String membersId = entity.getMemeberIds();
        if ((!StringUtils.isEmpty(channelName) && channelName.equals(UserConfig.UN_DEFINE)) || StringUtils.isEmpty(channelName)) {
            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
            channelName = GroupUtils.generateGroupMemberTempRoomName((ArrayList<POCMemberInfo>) memberInfoList);
        }
        return channelName;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUpdateUserInfoEvent(UpdateUserInfoEvent updateUserInfoEvent) {
        userNameInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        mPresenter.setUserCacheInfo(userNameInfo);
//        currentPage = 0;
//        POCUiKitProxyImpl.getInstance().notifyRefreshGroupList(currentPage, REQUEST_PAGE_SIZE, 1);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void refreshGroupListItem(RefreshGroupList refreshGroupList) {
        DBGroupEntity dbGroupEntity = refreshGroupList.getT();
        int position = -1;
        if (refreshGroupList.isExist()) {
            for (DBGroupEntity entity : adapter.getAllData()) {
                if (entity.getRooomId().equals(dbGroupEntity.getRooomId())) {
                    position = adapter.getPosition(entity);
                    entity.setRoomName(dbGroupEntity.getRoomName());
                    entity.setChannelPwdMode(dbGroupEntity.getChannelPwdMode() ? 1 : 0);
                    entity.setChannelPwd(dbGroupEntity.getChannelPwd());
                    entity.setMemeberIds(dbGroupEntity.getMemeberIds());
//                    entity.setIsSilence(dbGroupEntity.getIsSilence() ? 1 : 0);
                }
            }
            if (position != -1)
                adapter.notifyItemChanged(position);
        } else {
            for (DBGroupEntity entity : adapter.getAllData()) {
                if (entity.getRooomId().equals(dbGroupEntity.getRooomId())) {
                    position = adapter.getPosition(entity);
                }
            }
            if (position != -1)
                adapter.notifyItemRemoved(position);
        }
    }

    /**
     * @param memberInfoEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onUpdateMemberInfo(UpdateMemberInfoEvent memberInfoEvent) {
        if (memberInfoEvent.getT() == null) {
            LogUtils.ELog(TAG, "onUpdateMemberInfo: memberInfoEvent is null");
            return;
        }
        DBGroupEntity dbGroupEntity = memberInfoEvent.getT();
        int poisition = -1;
        if (!memberInfoEvent.isChannelExist()) {
            //频道不存在
            for (DBGroupEntity entity1 : adapter.getAllData()) {
                if (entity1.getRooomId().equals(dbGroupEntity.getRooomId())) {
                    poisition = adapter.getPosition(entity1);
                }
            }
            if (poisition != -1) {
                adapter.remove(poisition);
                adapter.notifyDataSetChanged();
                POCClient.leaveRoom(mUserId, dbGroupEntity.getRooomId());
                POCClient.deleteLocalRoomById(mUserId, dbGroupEntity.getRooomId());
            }
            return;
        }
        List<POCMemberInfo> pocMemberInfos = POCClient.getInstance().generateStringToList(dbGroupEntity.getMemeberIds());
        boolean isHas = false;
        List<DBGroupEntity> allData = adapter.getAllData();
        for (DBGroupEntity entity : allData) {
            poisition = adapter.getPosition(entity);
            if (entity.getRooomId().equals(dbGroupEntity.getRooomId())) {
                for (POCMemberInfo info : pocMemberInfos) {
                    if (info.getAccount().equals(mUserId)) {
                        isHas = true;
                        break;
                    }
                }
                if (!isHas) {
                    adapter.remove(poisition);
                    adapter.notifyDataSetChanged();
                    POCClient.leaveRoom(mUserId, dbGroupEntity.getRooomId());
                    POCClient.deleteLocalRoomById(mUserId, dbGroupEntity.getRooomId());
                    POCClient.removeFromReconnectCache(dbGroupEntity.getRooomId());
                } else {
                    entity.setRoomName(dbGroupEntity.getRoomName());
                    entity.setPinyin(PinyinUtil.getPingYin(dbGroupEntity.getRoomName()));
                    entity.setChannelPwdMode(dbGroupEntity.getChannelPwdMode() ? 1 : 0);
                    entity.setChannelPwd(dbGroupEntity.getChannelPwd());
                    entity.setMemeberIds(dbGroupEntity.getMemeberIds());
                    List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(entity.getMemeberIds());
                    entity.setTotalCount(memberInfoList == null ? 0 : memberInfoList.size());
//                    entity.setIsSilence(dbGroupEntity.getIsSilence() ? 1 : 0);
                }
            }
        }
        mList.clear();
        mList.addAll(allData);
        Collections.sort(mList, groupOrderComparator);
        adapter.clear();
        adapter.addAll(mList);
    }

    /**
     * 重置recycleView
     *
     * @param isInitView
     */
    public void resetView(boolean isInitView) {
        mSearchView.closeKeyboard();
        if (isInitView) {
            mSearchView.addTextChangeWatcher(new ISearchCallBack() {
                @Override
                public void onStartSearch(String s) {

                }

                @Override
                public void onEndSearch() {

                }
            });
            mSearchView.getEditText().setText("");
            mSearchView.addTextChangeWatcher(this);
            recyclerView.setAdapter(adapter);
            if (adapter.getAllData() == null || adapter.getAllData().size() <= 0) {
                switchViewStatus(UserConfig.VIEW_STTAUS_EMPTY);
            }
        }

    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void resetChannelStatus(ResetChannelStatus resetChannelStatus) {
        String channelId = resetChannelStatus.getT();
        if (TextUtils.isEmpty(channelId)) {
            return;
        }
        if (!NetUtils.isNetworkAvailable(getActivity())) {
            return;
        }
        int position = -1;
        for (DBGroupEntity entity : adapter.getAllData()) {
            if (entity.getRooomId().equals(channelId) && entity.getStatus() == GroupConfig.GROUP_BUSY) {
                position = adapter.getPosition(entity);
                entity.setStatus(GroupConfig.GROUP_FREE);
                break;
            }
        }
        if (position != -1) {
            adapter.notifyItemChanged(position);
            position = -1;
        }
        if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
            for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                if (entity.getRooomId().equals(channelId) && entity.getStatus() == GroupConfig.GROUP_BUSY) {
                    position = mSearchAdapter.getPosition(entity);
                    entity.setStatus(GroupConfig.GROUP_FREE);
                    break;
                }
            }
            if (position != -1) {
                mSearchAdapter.notifyItemChanged(position);
            }
        }
    }

    public void setTargetChannelId(String channelId) {
        this.targetChannelId = channelId;
    }
}
