/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.widget.RemoteViews;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.event.CancelNotification;
import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.event.UpdateNotification;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.ui.conversion.ConversionCallWaitingActivity;
import com.xdja.poc.sdk.utils.Utils;
import java.io.Serializable;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class PocNotificationService
extends Service {
    private static final String TAG = PocNotificationService.class.getSimpleName();
    private NotificationManager nm;
    private RemoteViews mRemoteViews;
    private PendingIntent pendingIntent;
    private Notification.Builder builder;
    Notification notification = null;
    private String roomId;
    private String userId;
    private int notifyId = 10012;
    private String title = "\u5b89\u901a\u5bf9\u8bb2";
    private String content = "\u901a\u77e5";
    private String channelId = "poc_channel";
    private static final String DATE_FORMAT = "HH:mm";
    public static boolean isChange = true;

    public void onCreate() {
        super.onCreate();
        EventBus.getDefault().register((Object)this);
        this.createNotification();
        MessageProxy.reBindService((Context)this);
        this.initEvent();
    }

    private void initEvent() {
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void createNotification() {
        this.initRemoteView();
        int resId = PreferenceHelper.getInt((String)"notification_icon", (int)-1);
        if (resId == -1) {
            resId = R.drawable.poc_notifiy_icon;
        }
        this.initNotification(resId);
        this.getApplication().registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                BaseActivity.isSelfActivity = true;
                MessageProxy.sendNotificationStaus(false);
            }

            public void onActivityPaused(Activity activity) {
                BaseActivity.isSelfActivity = false;
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
        if (this.nm != null) {
            this.nm.cancel(this.notifyId);
            if (Build.VERSION.SDK_INT >= 26) {
                this.nm.cancel(this.notifyId);
                this.nm.deleteNotificationChannel(this.channelId);
                LogUtils.ILog((String)TAG, (String)"onPocConversionStatusChanged notification cancel");
            }
            this.nm = null;
            this.notification = null;
        }
        try {
            if (!StringUtils.isEmpty((String)PreferenceHelper.getString((String)"login_account", (String)""))) {
                this.startService(new Intent((Context)this, PocNotificationService.class));
            }
        }
        catch (Exception ex) {
            LogUtils.ELog((String)TAG, (String)("ex:" + ex.getMessage()));
        }
    }

    private void initRemoteView() {
        this.mRemoteViews = new RemoteViews(this.getPackageName(), R.layout.poc_notification);
        this.updateUserInfo();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onNetWorkConnectEvent(NetWorkConnectEvent netWorkConnectEvent) {
        this.updateUserInfo();
        this.nm.notify(this.notifyId, this.notification);
    }

    private void updateUserInfo() {
        String userAccount = PreferenceHelper.getString((String)"login_account", (String)"");
        String userName = PreferenceHelper.getString((String)"pref_key_userinfo_name", (String)"");
        String pwd = PreferenceHelper.getString((String)"login_pwd", (String)"");
        String appName = PreferenceHelper.getString((String)"app_name", (String)"\u5b89\u901a\u5bf9\u8bb2");
        int resId = PreferenceHelper.getInt((String)"app_icon", (int)-1);
        this.mRemoteViews.setTextViewText(R.id.tv_app_name, (CharSequence)appName);
        this.mRemoteViews.setTextViewText(R.id.tv_login_tips, (CharSequence)(appName + "(\u8bf7\u767b\u5f55)"));
        if (resId != -1) {
            this.mRemoteViews.setImageViewResource(R.id.iv_logo, resId);
        } else {
            this.mRemoteViews.setImageViewResource(R.id.iv_logo, R.mipmap.poc_logo);
        }
        this.title = userAccount;
        boolean networkAvailable = NetUtils.isNetworkAvailable((Context)this);
        if (StringUtils.isEmpty((String)pwd)) {
            this.mRemoteViews.setViewVisibility(R.id.tv_login_tips, 0);
            this.mRemoteViews.setViewVisibility(R.id.ll_user_info, 8);
            this.mRemoteViews.setViewVisibility(R.id.tv_time, 8);
            Uri uri = Uri.parse((String)(AMnager.URI_STRING + this.getPackageName())).buildUpon().appendPath("login").build();
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            this.pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
            this.mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, this.pendingIntent);
        } else if (!StringUtils.isEmpty((String)pwd)) {
            this.mRemoteViews.setTextViewText(R.id.tv_user_name, (CharSequence)StringUtils.splitDisplayName((int)5, (String)userName));
            if (!networkAvailable) {
                this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_color_red));
                this.mRemoteViews.setTextViewText(R.id.tv_talk_status, (CharSequence)"\u79bb\u7ebf");
            } else if (isChange) {
                this.mRemoteViews.setTextViewText(R.id.tv_talk_status, (CharSequence)"\u5728\u7ebf");
                this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_conversation_free_or_talking));
            }
            this.mRemoteViews.setViewVisibility(R.id.tv_login_tips, 8);
            this.mRemoteViews.setViewVisibility(R.id.ll_user_info, 0);
            this.mRemoteViews.setViewVisibility(R.id.tv_time, 0);
            this.mRemoteViews.setTextViewText(R.id.tv_time, (CharSequence)Utils.fmatLongToString(System.currentTimeMillis(), DATE_FORMAT));
            Intent intent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
            this.pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
            this.mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, this.pendingIntent);
        }
    }

    private void initNotification(int drawableRes) {
        this.nm = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT < 16) {
            this.notification = new Notification();
            this.notification.tickerText = this.title;
            this.notification.when = System.currentTimeMillis();
            this.notification.icon = drawableRes;
            this.notification.flags = 16;
        } else if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 26) {
            this.notification = new Notification.Builder(this.getApplicationContext()).setContentIntent(this.pendingIntent).setContent(this.mRemoteViews).setPriority(0).setCategory("msg").setShowWhen(true).setOngoing(true).setSmallIcon(drawableRes).setWhen(System.currentTimeMillis()).setVisibility(1).build();
        } else if (Build.VERSION.SDK_INT >= 26) {
            String name = "\u5b89\u901a\u5bf9\u8bb2";
            int importance = 2;
            this.channelId = this.getPackageName();
            NotificationChannel mChannel = new NotificationChannel(this.channelId, (CharSequence)name, importance);
            mChannel.enableLights(false);
            mChannel.setSound(null, null);
            mChannel.setShowBadge(false);
            mChannel.setLockscreenVisibility(0);
            this.nm.createNotificationChannel(mChannel);
            this.notification = new Notification.Builder((Context)this, this.channelId).setContentTitle((CharSequence)"\u5b89\u901a\u5bf9\u8bb2").setContentIntent(this.pendingIntent).setContent(this.mRemoteViews).setCategory("msg").setShowWhen(true).setOngoing(true).setSmallIcon(R.drawable.poc_notifiy_icon).setWhen(System.currentTimeMillis()).setDefaults(-1).setVisibility(1).setPriority(0).setChannelId(this.channelId).setAutoCancel(false).setOnlyAlertOnce(true).build();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCancelNotification(CancelNotification cancelNotification) {
        boolean isShow = (Boolean)cancelNotification.getT();
        if (!isChange) {
            return;
        }
        if (this.nm == null || this.notification == null) {
            this.stopSelf();
            LogUtils.ILog((String)TAG, (String)"stop self ");
            return;
        }
        this.updateUserInfo();
        if (isShow) {
            this.nm.notify(this.notifyId, this.notification);
        } else {
            this.nm.cancel(this.notifyId);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateNotificationEvent(UpdateNotification event) {
        if (this.nm == null || this.notification == null) {
            this.stopSelf();
            return;
        }
        isChange = true;
        this.updateUserInfo();
        boolean isRing = (Boolean)event.getT();
        if (isRing) {
            isChange = false;
            String userName = event.getCallMessage().getUserName();
            this.mRemoteViews.setViewVisibility(R.id.ll_user_info, 0);
            this.mRemoteViews.setViewVisibility(R.id.tv_login_tips, 8);
            this.mRemoteViews.setTextViewText(R.id.tv_user_name, (CharSequence)StringUtils.splitDisplayName((int)5, (String)userName));
            this.mRemoteViews.setTextViewText(R.id.tv_talk_status, (CharSequence)" \u9080\u8bf7\u60a8\u52a0\u5165\u9891\u9053");
            this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_conversation_free_or_talking));
            this.mRemoteViews.setViewVisibility(R.id.tv_time, 0);
            this.mRemoteViews.setTextViewText(R.id.tv_time, (CharSequence)Utils.fmatLongToString(System.currentTimeMillis(), DATE_FORMAT));
            Intent intent = new Intent(this.getApplicationContext(), ConversionCallWaitingActivity.class);
            intent.putExtra("intent_key_call_waiting_data", (Serializable)event.getCallMessage());
            this.pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
            this.mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, this.pendingIntent);
            this.nm.notify(this.notifyId, this.notification);
        } else {
            boolean networkAvailable = NetUtils.isNetworkAvailable((Context)this);
            String pwd = PreferenceHelper.getString((String)"login_pwd", (String)"");
            if (StringUtils.isEmpty((String)pwd)) {
                this.nm.notify(this.notifyId, this.notification);
                return;
            }
            this.mRemoteViews.setViewVisibility(R.id.ll_user_info, 0);
            if (event.getCallType() == 0) {
                String userName = PreferenceHelper.getString((String)"pref_key_userinfo_name", (String)"");
                this.mRemoteViews.setTextViewText(R.id.tv_user_name, (CharSequence)StringUtils.splitDisplayName((int)5, (String)userName));
                if (networkAvailable) {
                    this.mRemoteViews.setTextViewText(R.id.tv_talk_status, (CharSequence)"\u5728\u7ebf");
                    this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_conversation_free_or_talking));
                } else {
                    this.mRemoteViews.setTextViewText(R.id.tv_talk_status, (CharSequence)"\u79bb\u7ebf");
                    this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_color_red));
                }
            } else if (event.getCallType() == 1) {
                isChange = false;
                this.mRemoteViews.setTextViewText(R.id.tv_user_name, (CharSequence)"\u60a8");
                this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_conversation_free_or_talking));
                this.mRemoteViews.setTextViewText(R.id.tv_talk_status, (CharSequence)" \u6b63\u5728\u547c\u53eb\u5bf9\u65b9");
            }
            this.mRemoteViews.setViewVisibility(R.id.tv_login_tips, 8);
            this.mRemoteViews.setTextColor(R.id.tv_talk_status, this.getResources().getColor(R.color.poc_conversation_free_or_talking));
            this.mRemoteViews.setViewVisibility(R.id.tv_time, 0);
            this.mRemoteViews.setTextViewText(R.id.tv_time, (CharSequence)Utils.fmatLongToString(System.currentTimeMillis(), DATE_FORMAT));
            Intent intent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
            this.pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
            this.mRemoteViews.setOnClickPendingIntent(R.id.rel_talk_status_and_people_count, this.pendingIntent);
            this.nm.notify(this.notifyId, this.notification);
        }
    }
}

