/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.ringplay;

import android.content.Context;
import android.media.MediaPlayer;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.ringplay.PlayConfig;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class RxAudioPlayer {
    private static final String TAG = "RxAudioPlayer";
    private MediaPlayer mPlayer;

    private RxAudioPlayer() {
    }

    public static RxAudioPlayer getInstance() {
        return RxAudioPlayerHolder.INSTANCE;
    }

    private MediaPlayer create(PlayConfig config) throws IOException {
        this.stopPlay();
        switch (config.mType) {
            case 4: {
                LogUtils.DLog((String)TAG, (String)("MediaPlayer to start play uri: " + config.mUri));
                MediaPlayer player = new MediaPlayer();
                player.setDataSource(config.mContext, config.mUri);
                return player;
            }
            case 1: {
                LogUtils.DLog((String)TAG, (String)("MediaPlayer to start play file: " + config.mAudioFile.getName()));
                MediaPlayer player = new MediaPlayer();
                player.setDataSource(config.mAudioFile.getAbsolutePath());
                return player;
            }
            case 2: {
                LogUtils.DLog((String)TAG, (String)("MediaPlayer to start play: " + config.mAudioResource));
                MediaPlayer player = MediaPlayer.create((Context)config.mContext, (int)config.mAudioResource);
                return player;
            }
            case 3: {
                LogUtils.DLog((String)TAG, (String)("MediaPlayer to start play: " + config.mUrl));
                MediaPlayer player = new MediaPlayer();
                player.setDataSource(config.mUrl);
                return player;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + config.mType);
    }

    public Observable<Boolean> play(@NonNull PlayConfig config) {
        if (!config.isArgumentValid()) {
            return Observable.error((Throwable)new IllegalArgumentException(""));
        }
        return Observable.create(emitter -> {
            if (this.mPlayer != null) {
                try {
                    this.mPlayer.stop();
                }
                catch (Exception e) {
                    LogUtils.DLog((String)TAG, (String)("msg:" + e.toString()));
                }
            }
            MediaPlayer player = this.create(config);
            this.setMediaPlayerListener(player, (ObservableEmitter<Boolean>)emitter);
            player.setVolume(config.mLeftVolume, config.mRightVolume);
            player.setAudioStreamType(config.mStreamType);
            player.setLooping(config.mLooping);
            if (config.needPrepare()) {
                player.prepare();
            }
            emitter.onNext((Object)true);
            player.start();
            this.mPlayer = player;
        }).doOnError(e -> this.stopPlay());
    }

    public Observable<Boolean> prepare(@NonNull PlayConfig config) {
        if (!config.isArgumentValid() || !config.isLocalSource()) {
            return Observable.error((Throwable)new IllegalArgumentException(""));
        }
        return Observable.create(emitter -> {
            MediaPlayer player = this.create(config);
            this.setMediaPlayerListener(player, (ObservableEmitter<Boolean>)emitter);
            player.setVolume(config.mLeftVolume, config.mRightVolume);
            player.setAudioStreamType(config.mStreamType);
            player.setLooping(config.mLooping);
            if (config.needPrepare()) {
                player.prepare();
            }
            emitter.onNext((Object)true);
            this.mPlayer = player;
        }).doOnError(e -> this.stopPlay());
    }

    public void pause() {
        this.mPlayer.pause();
    }

    public void resume() {
        this.mPlayer.start();
    }

    public boolean isPlaying() {
        if (this.mPlayer == null) {
            return false;
        }
        return this.mPlayer.isPlaying();
    }

    @WorkerThread
    public boolean playNonRxy(@NonNull PlayConfig config, MediaPlayer.OnCompletionListener onCompletionListener, MediaPlayer.OnErrorListener onErrorListener) {
        if (!config.isArgumentValid()) {
            return false;
        }
        try {
            if (this.mPlayer != null) {
                try {
                    this.mPlayer.stop();
                }
                catch (Exception e) {
                    LogUtils.DLog((String)TAG, (String)("msg:" + e.toString()));
                }
            }
            MediaPlayer player = this.create(config);
            this.setMediaPlayerListener(player, onCompletionListener, onErrorListener);
            player.setVolume(config.mLeftVolume, config.mRightVolume);
            player.setAudioStreamType(config.mStreamType);
            player.setLooping(config.mLooping);
            if (config.needPrepare()) {
                player.prepare();
            }
            player.start();
            this.mPlayer = player;
            return true;
        }
        catch (IOException | RuntimeException e) {
            LogUtils.ELog((String)TAG, (String)("startPlay fail, IllegalArgumentException: " + e.toString()));
            this.stopPlay();
            return false;
        }
    }

    public synchronized boolean stopPlay() {
        if (this.mPlayer == null) {
            return false;
        }
        this.mPlayer.setOnCompletionListener(null);
        this.mPlayer.setOnErrorListener(null);
        try {
            this.mPlayer.stop();
            this.mPlayer.reset();
            this.mPlayer.release();
        }
        catch (IllegalStateException e) {
            LogUtils.ELog((String)TAG, (String)("stopPlay fail, IllegalStateException: " + e.toString()));
        }
        this.mPlayer = null;
        return true;
    }

    public int progress() {
        if (this.mPlayer != null) {
            return this.mPlayer.getCurrentPosition() / 1000;
        }
        return 0;
    }

    public MediaPlayer getMediaPlayer() {
        return this.mPlayer;
    }

    private void setMediaPlayerListener(MediaPlayer player, ObservableEmitter<Boolean> emitter) {
        player.setOnCompletionListener(mp -> {
            LogUtils.DLog((String)TAG, (String)"OnCompletionListener::onCompletion");
            Observable.timer((long)50L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe(aLong -> {
                this.stopPlay();
                emitter.onComplete();
            }, arg_0 -> ((ObservableEmitter)emitter).onError(arg_0));
        });
        player.setOnErrorListener((mp, what, extra) -> {
            LogUtils.DLog((String)TAG, (String)("OnErrorListener::onError" + what + ", " + extra));
            emitter.onError(new Throwable("Player error: " + what + ", " + extra));
            this.stopPlay();
            return true;
        });
    }

    private void setMediaPlayerListener(MediaPlayer player, MediaPlayer.OnCompletionListener onCompletionListener, MediaPlayer.OnErrorListener onErrorListener) {
        player.setOnCompletionListener(mp -> {
            LogUtils.DLog((String)TAG, (String)"OnCompletionListener::onCompletion");
            Observable.timer((long)50L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe(aLong -> {
                this.stopPlay();
                onCompletionListener.onCompletion(mp);
            }, throwable -> LogUtils.DLog((String)TAG, (String)("OnCompletionListener::onError, " + throwable.toString())));
        });
        player.setOnErrorListener((mp, what, extra) -> {
            LogUtils.DLog((String)TAG, (String)("OnErrorListener::onError" + what + ", " + extra));
            onErrorListener.onError(mp, what, extra);
            this.stopPlay();
            return true;
        });
    }

    private static class RxAudioPlayerHolder {
        private static final RxAudioPlayer INSTANCE = new RxAudioPlayer();

        private RxAudioPlayerHolder() {
        }
    }
}

