/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.config;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.math.BigInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JaunsApi {
    public static final String REQUEST = "request";
    public static final String MESSAGE = "message";

    public static JSONObject createRoom(long roomId, String secret, String pin, String userName, String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"create");
            obj.put("room", roomId);
            if (!JaunsApi.isEmpty(description)) {
                obj.put("description", (Object)description);
            }
            if (!JaunsApi.isEmpty(secret)) {
                obj.put("secret", (Object)secret);
            }
            if (!JaunsApi.isEmpty(pin)) {
                obj.put("pin", (Object)pin);
            }
            if (!JaunsApi.isEmpty(userName)) {
                obj.put("display", (Object)userName);
            }
            if (!JaunsApi.isNull(permanent)) {
                obj.put("permanent", (Object)permanent);
            }
            if (!JaunsApi.isNull(isPrivate)) {
                obj.put("is_private", (Object)isPrivate);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject editRoom(long roomid, String secret, String newDescription, String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated, @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"edit");
            obj.put("room", roomid);
            obj.put("secret", (Object)secret);
            if (!JaunsApi.isEmpty(newDescription)) {
                obj.put("new_description", (Object)newDescription);
            }
            if (!JaunsApi.isEmpty(newSecret)) {
                obj.put("new_secret", (Object)newSecret);
            }
            if (!JaunsApi.isEmpty(newPin)) {
                obj.put("new_pin", (Object)newPin);
            }
            if (!JaunsApi.isNull(newIsPrivated)) {
                obj.put("new_is_private", (Object)newIsPrivated);
            }
            if (!JaunsApi.isNull(newRequirePrivated)) {
                obj.put("new_require_pvtid", (Object)newRequirePrivated);
            }
            if (!JaunsApi.isNull(newBitrate)) {
                obj.put("new_bitrate", (Object)newBitrate);
            }
            if (!JaunsApi.isNull(newFirFreq)) {
                obj.put("new_fir_freq", (Object)newFirFreq);
            }
            if (!JaunsApi.isNull(newPublishers)) {
                obj.put("new_publishers", (Object)newPublishers);
            }
            if (!JaunsApi.isNull(permanent)) {
                obj.put("permanent", (Object)permanent);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject destroyRoom(long roomId, String secret, @Nullable Boolean permanent) {
        JSONObject obj2 = new JSONObject();
        JSONObject msg2 = new JSONObject();
        try {
            obj2.put(REQUEST, (Object)"destroy");
            obj2.put("room", roomId);
            obj2.put("secret", (Object)secret);
            if (!JaunsApi.isNull(permanent)) {
                obj2.put("permanent", (Object)permanent);
            }
            msg2.put(MESSAGE, (Object)obj2);
            return msg2;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject existsRoom(long roomid) {
        JSONObject obj2 = new JSONObject();
        JSONObject msg2 = new JSONObject();
        try {
            obj2.put(REQUEST, (Object)"exists");
            obj2.put("room", roomid);
            msg2.put(MESSAGE, (Object)obj2);
            return msg2;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject allowedRoom(long roomid, int secret, String action, String[] alloweds) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            obj.put(REQUEST, (Object)"allowed");
            obj.put("secret", secret);
            obj.put("action", (Object)action);
            obj.put("room", roomid);
            for (String allow : alloweds) {
                jsonArray.put((Object)allow);
            }
            obj.put("allowed", (Object)jsonArray);
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject kickPerson(long roomId, int peopleId, String secret) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"kick");
            obj.put("secret", (Object)secret);
            obj.put("id", peopleId);
            obj.put("room", roomId);
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject listRooms() {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"list");
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject listParticipants(long roomId) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"listparticipants");
            obj.put("room", roomId);
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject join(long roomId, @Nullable Integer userId, @Nullable String userName, String pin, @Nullable String token) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"join");
            obj.put("ptype", (Object)"publisher");
            obj.put("room", roomId);
            if (!JaunsApi.isEmpty(pin)) {
                obj.put("pin", (Object)pin);
            }
            if (!JaunsApi.isNull(userId)) {
                obj.put("display", (Object)String.valueOf(userId));
            }
            if (!JaunsApi.isNull(userName)) {
                obj.put("display", (Object)userName);
            }
            if (!JaunsApi.isNull(token)) {
                obj.put("token", (Object)token);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject publish(@Nullable Boolean audio, @Nullable Boolean video, @Nullable Boolean data, String audioCode, String videoCode, @Nullable Integer bitrate, @Nullable Boolean record, String fileName, String display) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"publish");
            obj.put("audio", (Object)audio);
            obj.put("video", (Object)video);
            obj.put("data", (Object)data);
            if (!JaunsApi.isEmpty(audioCode)) {
                obj.put("audiocodec", (Object)audioCode);
            }
            if (!JaunsApi.isEmpty(videoCode)) {
                obj.put("videocodec", (Object)videoCode);
            }
            if (!JaunsApi.isNull(bitrate)) {
                obj.put("bitrate", (Object)bitrate);
            }
            if (!JaunsApi.isNull(record)) {
                obj.put("record", (Object)record);
            }
            if (!JaunsApi.isEmpty(fileName)) {
                obj.put("filename", (Object)fileName);
            }
            if (!JaunsApi.isEmpty(display)) {
                obj.put("display", (Object)display);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject unpublish() {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"unpublish");
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject configure(@Nullable Boolean audio, @Nullable Boolean video, @Nullable Boolean data, @Nullable Integer bitrate, @Nullable Boolean record, String fileName, String display) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"configure");
            obj.put("audio", (Object)audio);
            obj.put("video", (Object)video);
            obj.put("data", (Object)data);
            if (!JaunsApi.isNull(bitrate)) {
                obj.put("bitrate", (Object)bitrate);
            }
            if (!JaunsApi.isNull(record)) {
                obj.put("record", (Object)record);
            }
            if (!JaunsApi.isEmpty(fileName)) {
                obj.put("filename", (Object)fileName);
            }
            if (!JaunsApi.isEmpty(display)) {
                obj.put("display", (Object)display);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject listforwarders(long roomID, String secret) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"listforwarders");
            obj.put("room", roomID);
            obj.put("secret", (Object)secret);
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject leaveRoom() {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"leave");
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject subscriberJoin(long roomId, BigInteger feedId, String pin, @Nullable BigInteger privateId, @Nullable Boolean closePc, @Nullable Boolean audio, @Nullable Boolean video, @Nullable Boolean data, @Nullable Boolean offerAudio, @Nullable Boolean offerVideo, @Nullable Boolean offerData) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"join");
            obj.put("ptype", (Object)"subscriber");
            obj.put("room", roomId);
            obj.put("feed", (Object)feedId);
            if (!JaunsApi.isEmpty(pin)) {
                obj.put("pin", (Object)pin);
            }
            if (!JaunsApi.isNull(privateId)) {
                obj.put("private_id", (Object)privateId);
            }
            if (!JaunsApi.isNull(closePc)) {
                obj.put("close_pc", (Object)closePc);
            }
            if (!JaunsApi.isNull(audio)) {
                obj.put("audio", (Object)audio);
            }
            if (!JaunsApi.isNull(video)) {
                obj.put("video", (Object)video);
            }
            if (!JaunsApi.isNull(data)) {
                obj.put("data", (Object)data);
            }
            if (!JaunsApi.isNull(offerAudio)) {
                obj.put("offer_audio", (Object)offerAudio);
            }
            if (!JaunsApi.isNull(offerVideo)) {
                obj.put("offer_video", (Object)offerVideo);
            }
            if (!JaunsApi.isNull(offerData)) {
                obj.put("offer_data", (Object)offerData);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject startMedia(long roomId) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"start");
            obj.put("room", (Object)"roomId");
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject pauseMedia(long roomId) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"pause");
            obj.put("room", (Object)"roomId");
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject switchSubscriber(long feed, @Nullable Boolean audio, @Nullable Boolean video, @Nullable Boolean data) {
        JSONObject obj = new JSONObject();
        JSONObject msg = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"pause");
            obj.put("feed", feed);
            if (!JaunsApi.isNull(audio)) {
                obj.put("audio", (Object)audio);
            }
            if (!JaunsApi.isNull(video)) {
                obj.put("video", (Object)video);
            }
            if (!JaunsApi.isNull(data)) {
                obj.put("data", (Object)data);
            }
            msg.put(MESSAGE, (Object)obj);
            return msg;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject takenTBCP(long roomId, String transaction) {
        JSONObject obj = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"tbcp");
            obj.put("type", (Object)"requst");
            obj.put("room", roomId);
            if (!JaunsApi.isEmpty(transaction)) {
                obj.put("transaction", (Object)transaction);
            }
            return obj;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static JSONObject releaseTBCP(long roomId, String transaction) {
        JSONObject obj = new JSONObject();
        try {
            obj.put(REQUEST, (Object)"tbcp");
            obj.put("type", (Object)"release");
            obj.put("room", roomId);
            if (!JaunsApi.isEmpty(transaction)) {
                obj.put("transaction", (Object)transaction);
            }
            return obj;
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean isEmpty(String str) {
        return TextUtils.isEmpty((CharSequence)str);
    }

    private static boolean isNull(Object obj) {
        return obj == null;
    }
}

