/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.conversion;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.MotionEvent;
import android.view.View;
import com.xdja.poc.common.annotation.BindEventBus;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCAudioManager;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.conversion.BaseScreenActivity;
import com.xdja.poc.sdk.ui.main.fragment.POCConversationFragment;
import com.xdja.poc.sdk.utils.GroupUtils;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BindEventBus
@TitleViewAnnotation
public class POCConversionActivity
extends BaseScreenActivity {
    private String TAG = "POCConversionActivity";
    private FragmentManager fm;
    private POCConversationFragment pocConversationFragment;
    private AppRTCAudioManager audioManager;
    public DBGroupEntity group;
    private String mUserId;
    private String channelName;
    private boolean isCallMember = false;
    private Disposable mDisposable;
    public List<String> mCallUserIdList = new ArrayList<String>();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initView() {
        super.initView();
        this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.getTitleBarView().setTextSize(20);
        this.getTitleBarView().setBackgroundRecource(R.color.poc_bg_color_blue);
        this.getTitleBarView().setTitleColor(this.getResources().getColor(R.color.poc_btn_text_press));
        this.getTitleBarView().setLeftViewRecource(R.drawable.common_drawable_iv_tiltebar_left);
        this.getTitleBarView().setLeftViewClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                POCConversionActivity.this.onBackPressed();
            }
        });
        this.getTitleBarView().setRightText("\u8bbe\u7f6e");
        this.getTitleBarView().setRightTextColor(this.getResources().getColor(R.color.common_white_color));
        this.getTitleBarView().setRightTextSize(16.0f);
        this.group = (DBGroupEntity)this.getIntent().getSerializableExtra("group");
        this.isCallMember = this.getIntent().getBooleanExtra("isCallMember", false);
        this.channelName = this.getIntent().getStringExtra("channel_name");
        this.updateChannelName(this.channelName);
        this.pocConversationFragment = POCConversationFragment.newInstance();
        Bundle bundle = new Bundle();
        bundle.putSerializable("DBGroupEntity", (Serializable)this.group);
        this.pocConversationFragment.setArguments(bundle);
        this.fm = this.getSupportFragmentManager();
        this.fm.beginTransaction().add(R.id.content, (Fragment)this.pocConversationFragment).commit();
        this.pocConversationFragment.setUpdateListener(new POCConversationFragment.IUpdateGroupListener(){

            @Override
            public void onPttKey(boolean pttStatus) {
                if (POCConversionActivity.this.group != null) {
                    POCConversionActivity.this.group.setIsPttKey(pttStatus ? 1 : 0);
                }
            }

            @Override
            public void onUpdateName(String channelName1) {
                if (POCConversionActivity.this.group != null) {
                    POCConversionActivity.this.group.setRoomName(channelName1);
                }
                POCConversionActivity.this.channelName = channelName1;
                POCConversionActivity.this.getTitleBarView().setTile(POCConversionActivity.this.channelName);
            }

            @Override
            public void onUpdatePwd(String channelPwd) {
                if (POCConversionActivity.this.group != null) {
                    POCConversionActivity.this.group.setChannelPwd(channelPwd);
                }
            }

            @Override
            public void onUpdatePwdMode(boolean channelPwdMode) {
                if (POCConversionActivity.this.group != null) {
                    POCConversionActivity.this.group.setChannelPwdMode(channelPwdMode ? 1 : 0);
                }
            }
        });
        this.registerCallBack();
    }

    private void updateChannelName(String channelName) {
        if (channelName == null) {
            return;
        }
        if (channelName.equals("undefined")) {
            String strings;
            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(this.group.getMemeberIds());
            channelName = strings = GroupUtils.generateGroupMemberTempRoomName((ArrayList)memberInfoList);
        }
        this.channelName = channelName;
        this.group.setRoomName(channelName);
        this.getTitleBarView().setTile(channelName);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.init();
        this.group = (DBGroupEntity)intent.getSerializableExtra("group");
        this.channelName = intent.getStringExtra("channel_name");
        this.isCallMember = intent.getBooleanExtra("isCallMember", false);
        this.updateChannelName(this.channelName);
        this.pocConversationFragment.initData(this.group);
        this.registerCallBack();
    }

    private void registerCallBack() {
        this.pocConversationFragment.setCallBack(new ICallBack(){

            @Override
            public void onCallBack(DBGroupEntity entity) {
                int status = POCConversionActivity.this.group.getStatus();
                if (StringUtils.isEmpty((String)entity.getRoomName()) || entity.getRoomName().equals("undefined")) {
                    POCConversionActivity.this.channelName = POCConversionActivity.this.group.getRoomName();
                } else {
                    POCConversionActivity.this.channelName = entity.getRoomName();
                }
                POCConversionActivity.this.group = entity;
                POCConversionActivity.this.group.setStatus(status);
                POCConversionActivity.this.group.setRoomName(POCConversionActivity.this.channelName);
                POCConversionActivity.this.getTitleBarView().setTile(POCConversionActivity.this.channelName);
            }
        });
        if (this.isCallMember) {
            List<POCMemberInfo> memberInfoList;
            ArrayList<String> mTemp = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.group.getMemeberIds()) && (memberInfoList = POCClient.getInstance().generateStringToList(this.group.getMemeberIds())) != null && memberInfoList.size() > 0) {
                for (POCMemberInfo info : memberInfoList) {
                    mTemp.add(info.getAccount());
                }
            }
            this.handleCallMessage(this.isCallMember, mTemp, this.group.getRooomId());
        }
    }

    protected void initEvent() {
        this.getTitleBarView().setRightTVClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                POCUiKitProxyImpl.getInstance().notifyConversionViewMenuClick(POCConversionActivity.this.group, POCConversionActivity.this.channelName);
            }
        });
    }

    protected int generateLayout() {
        return R.layout.poc_conversation_activity;
    }

    public void onBackPressed() {
        super.onBackPressed();
        AMnager.startPOCMainActivity((Context)this, false);
        this.finish();
    }

    public void finish() {
        super.finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        LogUtils.ILog((String)"onPause....");
    }

    @Override
    protected void onResume() {
        super.onResume();
        LogUtils.ILog((String)"onResume....");
        if (Constants.isReject) {
            this.onBackPressed();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.pocConversationFragment.dispatchTouchEvent((Activity)this, ev);
        return super.dispatchTouchEvent(ev);
    }

    public void initAudio() {
        this.audioManager = AppRTCAudioManager.create((Context)this);
        this.audioManager.setDefaultAudioDevice(AppRTCAudioManager.AudioDevice.SPEAKER_PHONE);
        this.audioManager.start(new AppRTCAudioManager.AudioManagerEvents(){

            @Override
            public void onAudioDeviceChanged(AppRTCAudioManager.AudioDevice audioDevice, Set<AppRTCAudioManager.AudioDevice> availableAudioDevices) {
                LogUtils.DLog((String)POCConversionActivity.this.TAG, (String)("onAudioManagerDevicesChanged: " + availableAudioDevices + ", selected: " + (Object)((Object)audioDevice)));
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Constants.isScreenOn = false;
        this.release();
        LogUtils.ELog((String)"Zhangs", (String)"121 : activity onDestroy");
        this.cancel();
    }

    protected void onNetChanged(boolean status) {
        super.onNetChanged(status);
        if (status) {
            POCUiKitProxyImpl.getInstance().notifyRefreshChannelMembersInfo(this.group);
        } else {
            this.group.setStatus(0);
        }
    }

    public void removeFromCallList(String speakerId) {
        if (this.mCallUserIdList != null && this.mCallUserIdList.size() > 0) {
            Iterator<String> iterator = this.mCallUserIdList.iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    String userId = iterator.next();
                    if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)speakerId) || !speakerId.equals(userId)) continue;
                    iterator.remove();
                }
            }
            if (this.mCallUserIdList.size() <= 0) {
                this.mCallUserIdList.clear();
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    public void handleCallMessage(boolean isCall, final List<String> mUserIds, final String channelId) {
        if (isCall) {
            if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
                this.mDisposable.dispose();
            }
            if (mUserIds == null || mUserIds.size() <= 0) {
                return;
            }
            Iterator<String> iterator = mUserIds.iterator();
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (!next.equals(this.mUserId)) continue;
                iterator.remove();
                break;
            }
            this.mCallUserIdList.clear();
            this.mCallUserIdList.addAll(mUserIds);
            Observable.timer((long)PreferenceHelper.getInt((String)"poc_call_waiting_time", (int)30), (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Long>(){

                public void onSubscribe(@NonNull Disposable d) {
                    POCConversionActivity.this.mDisposable = d;
                }

                public void onNext(@NonNull Long aLong) {
                    if (POCConversionActivity.this.mCallUserIdList != null && POCConversionActivity.this.mCallUserIdList.size() > 0) {
                        Map<String, POCMemberInfo> map;
                        Map<String, POCMemberInfo> userInfos = POCConversionActivity.this.pocConversationFragment.getUserInfos();
                        String userId = POCConversionActivity.this.mCallUserIdList.get(POCConversionActivity.this.mCallUserIdList.size() - 1);
                        if (userId.equals(mUserIds)) {
                            POCConversionActivity.this.cancel();
                            return;
                        }
                        String userName = userId;
                        if (userInfos != null && userInfos.size() > 0 && userInfos.containsKey(userId)) {
                            userName = userInfos.get(userId).getName();
                        } else if (UserConfig.userNameMap != null && UserConfig.userNameMap.size() > 0 && UserConfig.userNameMap.containsKey(channelId) && (map = UserConfig.userNameMap.get(POCConversionActivity.this.group.getRooomId())) != null && map.size() > 0 && map.containsKey(userId)) {
                            userName = map.get(userId).getName();
                            userInfos.put(userId, map.get(userId));
                        }
                        POCConversionActivity.this.showMessage(userName + "\u4e0d\u5728,\u6682\u65f6\u65e0\u6cd5\u63a5\u901a");
                    }
                    POCConversionActivity.this.cancel();
                }

                public void onError(@NonNull Throwable e) {
                    POCConversionActivity.this.cancel();
                }

                public void onComplete() {
                    POCConversionActivity.this.cancel();
                }
            });
        }
    }

    private void cancel() {
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
        this.mDisposable = null;
    }

    public static interface ICallBack {
        public void onCallBack(DBGroupEntity var1);
    }
}

