/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.fragment;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.jude.easyrecyclerview.decoration.DividerDecoration;
import com.xdja.poc.common.annotation.BindEventBus;
import com.xdja.poc.common.base.BaseFragment;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.view.EmptyView;
import com.xdja.poc.common.view.ISearchCallBack;
import com.xdja.poc.common.view.SearchEditView;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.POCHandlerService;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupListEvent;
import com.xdja.poc.sdk.event.GroupMemberAddEvent;
import com.xdja.poc.sdk.event.GroupRefreshAdapterEvent;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.event.RefreshGroupList;
import com.xdja.poc.sdk.event.UpdateGroupDataUI;
import com.xdja.poc.sdk.event.UpdateMemberInfoEvent;
import com.xdja.poc.sdk.event.UpdateUserInfoEvent;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.main.holder.PocGroupListHolder;
import com.xdja.poc.sdk.ui.main.holder.PocSearchGroupListHolder;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListContract;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListPresenter;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.POCGroupOrderComparator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@BindEventBus
public class POCRecentFragment
extends BaseFragment
implements SwipeRefreshLayout.OnRefreshListener,
ISearchCallBack,
View.OnClickListener,
POCGroupListContract.IView {
    private String TAG = "POCRecentFragment";
    private SearchEditView mSearchView;
    private ProgressBar progressoLoading;
    public POCGroupListContract.IPresenter mPresenter;
    private EasyRecyclerView recyclerView;
    private RecyclerArrayAdapter<DBGroupEntity> adapter;
    private RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter;
    private static final int MSG_SEARCH_DELAY = 1;
    private String keyWords = "";
    private String mUserId;
    private long lastClickTime = 0L;
    private int FAST_CLICK_DELAY_TIME = 300;
    private EmptyView emptyDataView;
    private EmptyView emptySearchView;
    private POCGroupOrderComparator groupOrderComparator;
    private Map<String, POCMemberInfo> userNameInfo = new HashMap<String, POCMemberInfo>();
    private int REQUEST_PAGE_SIZE = 10;
    private List<DBGroupEntity> mList = new ArrayList<DBGroupEntity>();
    private SearchHandler mSearchHandler = new SearchHandler(this);
    private AsyncTask<String, Void, List<DBGroupEntity>> searchTask = new SearchTask(this);

    protected int generateLayout() {
        return R.layout.poc_fragment_recent;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void initView() {
        this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.groupOrderComparator = new POCGroupOrderComparator();
        this.mSearchView = (SearchEditView)this.$(R.id.searchView);
        this.mSearchView.setSHintText("\u8bf7\u8f93\u5165\u9891\u9053\u540d\u79f0");
        this.recyclerView = (EasyRecyclerView)this.$(R.id.recycleView);
        this.progressoLoading = (ProgressBar)this.$(R.id.poc_loading);
        this.mPresenter = new POCGroupListPresenter(this, (Context)this.getActivity());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        DividerDecoration decoration = new DividerDecoration(this.getActivity().getResources().getColor(R.color.common_item_divider_bg), 1, 0, 0);
        decoration.setDrawLastItem(true);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.recyclerView.getSwipeToRefresh().setColorSchemeResources(new int[]{R.color.common_main_color});
        this.recyclerView.setEmptyView(this.createEmptyDataView());
        this.recyclerView.setErrorView(this.createLiveVideoErrorView());
        this.recyclerView.requestFocus();
        this.adapter = new RecyclerArrayAdapter<DBGroupEntity>((Context)this.getActivity()){

            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                return new PocGroupListHolder(parent, new PocGroupListHolder.onViewClickListener(){

                    @Override
                    public void onClick(@IdRes int id2, int position) {
                        if (id2 == R.id.iv_audio_switch) {
                            if (position < 0) {
                                POCRecentFragment.this.adapter.notifyDataSetChanged();
                                return;
                            }
                            if (POCRecentFragment.this.isDoubleClick()) {
                                return;
                            }
                            DBGroupEntity entity = (DBGroupEntity)POCRecentFragment.this.adapter.getAllData().get(position);
                            if (entity != null) {
                                boolean isSilence = !entity.getIsSilence();
                                entity.setIsSilence(isSilence ? 1 : 0);
                                POCRecentFragment.this.adapter.notifyItemChanged(position);
                                POCClient.muteAndNotifyUI(Long.valueOf(entity.getRooomId()), isSilence);
                            }
                        }
                    }
                });
            }
        };
        this.mSearchAdapter = new RecyclerArrayAdapter<DBGroupEntity>((Context)this.getActivity()){

            public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
                return new PocSearchGroupListHolder(parent, POCRecentFragment.this.keyWords, (id2, position) -> {
                    if (id2 == R.id.iv_audio_switch) {
                        if (position < 0) {
                            POCRecentFragment.this.mSearchAdapter.notifyDataSetChanged();
                            return;
                        }
                        if (POCRecentFragment.this.isDoubleClick()) {
                            return;
                        }
                        DBGroupEntity entity = (DBGroupEntity)POCRecentFragment.this.mSearchAdapter.getAllData().get(position);
                        if (entity != null) {
                            boolean isSilence = !entity.getIsSilence();
                            entity.setIsSilence(isSilence ? 1 : 0);
                            POCRecentFragment.this.mSearchAdapter.notifyItemChanged(position);
                            POCClient.muteAndNotifyUI(Long.valueOf(entity.getRooomId()), isSilence);
                        }
                    }
                });
            }
        };
        this.recyclerView.setAdapter(this.adapter);
        this.recyclerView.setRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.mPresenter.attatchAdapter(this.recyclerView, this.mSearchAdapter, this.adapter);
        this.recyclerView.getSwipeToRefresh().setRefreshing(false);
        this.userNameInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        this.onRefresh();
        this.progressoLoading.setVisibility(0);
    }

    private View createEmptyDataView() {
        if (this.emptyDataView == null) {
            this.emptyDataView = new EmptyView((Context)this.getActivity());
            this.emptyDataView.init(new EmptyView.Configure.Builder().setContent("\u6ca1\u6709\u9891\u9053,\u8bf7\u70b9\u51fb").setClickColor(this.getResources().getColor(R.color.common_poc_red)).setClickContent("\u901a\u8baf\u5f55").setIconId(R.mipmap.poc_no_search_result).setSpanString("\u521b\u5efa").build(), () -> AMnager.startPOCMemberListActivity((Context)this.getActivity(), 1));
        }
        return this.emptyDataView;
    }

    public View createEmptySearchView() {
        if (this.emptySearchView == null) {
            this.emptySearchView = new EmptyView((Context)this.getActivity());
            this.emptySearchView.init(new EmptyView.Configure.Builder().setContent("\u6682\u65e0\u641c\u7d22\u7ed3\u679c").setIconId(R.drawable.poc_search_no_result).build(), null);
        }
        return this.emptySearchView;
    }

    public void onResume() {
        super.onResume();
        this.recyclerView.requestFocus();
        Constants.isReject = false;
    }

    private boolean isDoubleClick() {
        long currentClickTime = System.currentTimeMillis();
        if (System.currentTimeMillis() - this.lastClickTime < (long)this.FAST_CLICK_DELAY_TIME) {
            return true;
        }
        this.lastClickTime = currentClickTime;
        return false;
    }

    private View createLiveVideoErrorView() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View errorView = inflater.inflate(R.layout.poc_view_error, null);
        errorView.findViewById(R.id.mOpenReloading).setOnClickListener(v -> this.onRefresh());
        return errorView;
    }

    protected void initEvent() {
        this.mSearchView.addTextChangeWatcher((ISearchCallBack)this);
        this.adapter.setOnItemClickListener(position -> {
            this.mSearchView.closeKeyboard();
            if (position >= 0) {
                try {
                    DBGroupEntity pocGroup = (DBGroupEntity)this.adapter.getAllData().get(position);
                    if (pocGroup != null) {
                        if (pocGroup.getStatus() == 0 && this.checkMaxChannelCount()) {
                            Toast.makeText((Context)this.getActivity(), (CharSequence)GlobalContext.getContext().getString(R.string.poc_max_online_group), (int)0).show();
                            return;
                        }
                        AMnager.startPOCConversionActivity((Context)this.getActivity(), pocGroup, pocGroup.getRoomName(), position, false);
                    }
                }
                catch (Exception e) {
                    LogUtils.ELog((String)this.TAG, (String)("" + e.getLocalizedMessage()));
                }
            }
        });
        this.adapter.setOnItemLongClickListener(position -> {
            this.mSearchView.closeKeyboard();
            if (position >= 0) {
                DBGroupEntity entity = (DBGroupEntity)this.adapter.getAllData().get(position);
                POCUiKitProxyImpl.getInstance().notifyChannelListItemLongClick(entity, position, this.getChannleName(entity));
            }
            return true;
        });
        this.mSearchAdapter.setOnItemLongClickListener(position -> {
            this.mSearchView.closeKeyboard();
            if (position >= 0) {
                DBGroupEntity entity = (DBGroupEntity)this.mSearchAdapter.getAllData().get(position);
                POCUiKitProxyImpl.getInstance().notifyChannelListItemLongClick(entity, position, this.getChannleName(entity));
            }
            return true;
        });
        this.mSearchAdapter.setOnItemClickListener(position -> {
            this.mSearchView.closeKeyboard();
            if (position >= 0) {
                try {
                    DBGroupEntity pocGroup = (DBGroupEntity)this.mSearchAdapter.getAllData().get(position);
                    if (pocGroup != null) {
                        if (pocGroup.getStatus() == 0 && this.checkMaxChannelCount()) {
                            Toast.makeText((Context)this.getActivity(), (CharSequence)GlobalContext.getContext().getString(R.string.poc_max_online_group), (int)0).show();
                            return;
                        }
                        AMnager.startPOCConversionActivity((Context)this.getActivity(), pocGroup, pocGroup.getRoomName(), position, false);
                    }
                }
                catch (Exception e) {
                    LogUtils.ELog((String)this.TAG, (String)("" + e.getLocalizedMessage()));
                }
            }
        });
    }

    private boolean checkMaxChannelCount() {
        int onLineCount = 0;
        for (DBGroupEntity entity : this.adapter.getAllData()) {
            if (entity.getStatus() != 2 && entity.getStatus() != 1) continue;
            ++onLineCount;
        }
        return onLineCount >= PreferenceHelper.getInt((String)"max_channel_count", (int)5);
    }

    @Override
    public void switchViewStatus(int status) {
        this.recyclerView.setAdapter(this.adapter);
        switch (status) {
            case 1: {
                this.recyclerView.setEmptyView((View)this.emptyDataView);
                if (this.adapter.getAllData() != null && this.adapter.getAllData().size() > 0) break;
                this.recyclerView.showEmpty();
                break;
            }
            case 2: {
                ToastUtils.showToast((String)this.getResources().getString(R.string.poc_conversation_network_not_available));
                if (this.adapter.getAllData() != null && this.adapter.getAllData().size() > 0) break;
                this.recyclerView.showError();
                break;
            }
            case 0: {
                this.recyclerView.showRecycler();
            }
        }
    }

    @Override
    public void onRefreshList() {
        this.onRefresh();
    }

    @Override
    public void onSelfInComing(String roomId) {
        for (DBGroupEntity entity : this.adapter.getAllData()) {
            if (!entity.getRooomId().equals(roomId)) continue;
            boolean isSilence = entity.getIsSilence();
            POCClient.muteAndNotifyUI(Long.valueOf(roomId), isSilence);
            break;
        }
    }

    @Override
    public void resetFragment() {
        this.resetView(true);
    }

    @Override
    public void onGroupList(ArrayList<DBGroupEntity> mGroupList, int viewSttaus) {
        this.adapter.clear();
        this.recyclerView.setRefreshing(false);
        this.resetView(true);
        this.switchViewStatus(0);
        if (mGroupList == null) {
            this.progressoLoading.setVisibility(8);
            this.switchViewStatus(2);
            return;
        }
        if (mGroupList.size() == 0) {
            this.progressoLoading.setVisibility(8);
            this.switchViewStatus(1);
            POCHandlerService.clearChannelInfo((Context)this.getActivity(), this.mUserId);
            return;
        }
        this.mList.clear();
        this.mList.addAll(mGroupList);
        Map<String, String> map = POCClient.getAllSpeakers();
        Iterator<DBGroupEntity> iterator = this.mList.iterator();
        while (iterator.hasNext()) {
            DBGroupEntity entity;
            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong((entity = iterator.next()).getRooomId()));
            entity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
            boolean b = GroupUtils.resetGroupStatus(entity);
            entity.setStatus(b ? 1 : 0);
            if (map == null || !map.containsKey(entity.getRooomId())) continue;
            entity.setStatus(2);
            String speakName = map != null && map.containsKey(entity.getRooomId()) ? map.get(entity.getRooomId()) : "";
            this.userNameInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
            if (this.userNameInfo != null && this.userNameInfo.containsKey(map.get(entity.getRooomId()))) {
                speakName = this.userNameInfo.get(map.get(entity.getRooomId())).getName();
            }
            entity.setSpeakerUserName(speakName);
        }
        Collections.sort(this.mList, this.groupOrderComparator);
        this.adapter.addAll(this.mList);
        this.progressoLoading.setVisibility(8);
    }

    @Override
    public void showLoading(String content) {
    }

    @Override
    public View getEmptyView() {
        return this.createEmptyDataView();
    }

    @Override
    public POCGroupOrderComparator getComparator() {
        return this.groupOrderComparator;
    }

    @Override
    public View getErrorView() {
        return this.createLiveVideoErrorView();
    }

    @Override
    public void dismissLoading() {
    }

    public void onDestroy() {
        super.onDestroy();
        this.mPresenter.destroy();
    }

    public void onPause() {
        super.onPause();
        this.mSearchView.closeKeyboard();
    }

    public void onRefresh() {
        POCUiKitProxyImpl.getInstance().notifyRefreshGroupList(0, this.REQUEST_PAGE_SIZE, 1);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onGroupListEvent(GroupListEvent groupListEvent) {
        ArrayList groupArrayList = (ArrayList)groupListEvent.getT();
        this.onGroupList(groupArrayList, 0);
    }

    public static POCRecentFragment newInstance() {
        return new POCRecentFragment();
    }

    public void onStartSearch(String keyWord) {
        this.keyWords = keyWord;
        this.mSearchHandler.removeMessages(1);
        this.mSearchHandler.sendEmptyMessageDelayed(1, 100L);
    }

    public void onEndSearch() {
        if (this.searchTask != null) {
            this.searchTask.cancel(true);
        }
        this.mSearchHandler.removeMessages(1);
        this.recyclerView.setAdapter(this.adapter);
        this.adapter.notifyDataSetChanged();
        if (this.adapter.getAllData() == null || this.adapter.getAllData().size() <= 0) {
            this.switchViewStatus(1);
        }
        this.mSearchAdapter.clear();
    }

    public void onClick(View v) {
    }

    public void dispatchTouchEvent(MotionEvent ev) {
        if (this.mSearchView.getEditText().hasFocus()) {
            this.mSearchView.closeKeyboard();
        }
    }

    private void doSearch() {
        if (this.searchTask != null) {
            this.searchTask.cancel(true);
        }
        this.searchTask = new SearchTask(this).executeOnExecutor(Executors.newScheduledThreadPool(20), new String[]{this.keyWords});
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateGroupDataUI(UpdateGroupDataUI updateGroupDataUI) {
        ArrayList entities = (ArrayList)updateGroupDataUI.getT();
        this.onGroupList(entities, 0);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onPOCMuteEvent(POCMuteEvent event) {
        String roomId = event.getRoomId();
        boolean silence = event.isSilence();
        int position = -1;
        for (DBGroupEntity pocGroup : this.adapter.getAllData()) {
            if (!roomId.equalsIgnoreCase(pocGroup.getRooomId())) continue;
            pocGroup.setIsSilence(silence ? 1 : 0);
            position = this.adapter.getPosition((Object)pocGroup);
            break;
        }
        if (position != -1) {
            this.adapter.notifyItemChanged(position);
        }
        if (this.mSearchAdapter != null && this.mSearchAdapter.getAllData() != null && this.mSearchAdapter.getAllData().size() > 0) {
            for (DBGroupEntity pocGroup : this.mSearchAdapter.getAllData()) {
                if (!roomId.equalsIgnoreCase(pocGroup.getRooomId())) continue;
                position = this.mSearchAdapter.getPosition((Object)pocGroup);
                pocGroup.setIsSilence(silence ? 1 : 0);
                break;
            }
            if (position != -1) {
                this.mSearchAdapter.notifyItemChanged(position);
            }
        }
    }

    protected void onNetChanged(boolean status) {
        super.onNetChanged(status);
        if (!status) {
            if (this.adapter.getAllData() == null) {
                return;
            }
            List allData = this.adapter.getAllData();
            for (DBGroupEntity entity : allData) {
                entity.setStatus(0);
                entity.setOnLineCount(0);
            }
            this.adapter.notifyDataSetChanged();
            if (this.mSearchAdapter != null && this.mSearchAdapter.getAllData() != null && this.mSearchAdapter.getAllData().size() > 0) {
                for (DBGroupEntity entity : this.mSearchAdapter.getAllData()) {
                    entity.setStatus(0);
                    entity.setOnLineCount(0);
                }
                this.mSearchAdapter.notifyDataSetChanged();
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onPOCGroupRefreshAdapter(GroupRefreshAdapterEvent event) {
        this.mPresenter.refreshAdapter(event.getRoomId());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onPOCGroupUpdateEvent(POCGroupUpdateEvent pocGroupUpdateEvent) {
        this.recyclerView.getSwipeToRefresh().setRefreshing(false);
        this.mPresenter.refreshGroupList(pocGroupUpdateEvent);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onGroupMemberAddEvent(GroupMemberAddEvent addEvent) {
        String[] memberIds = addEvent.getMemberIds();
        String roomId = addEvent.getRoomId();
        if (memberIds != null && memberIds.length > 0) {
            List<POCMemberInfo> pocGroupUserInfos = POCUiKitProxyImpl.getInstance().getPOCGroupUserInfos(memberIds);
            for (DBGroupEntity entity : this.adapter.getAllData()) {
                if (!roomId.equals(entity.getRooomId())) continue;
                String memeberIds = entity.getMemeberIds();
                List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(memeberIds);
                for (POCMemberInfo info : pocGroupUserInfos) {
                    allCountList.add(info);
                }
                String s = POCClient.getInstance().generateListString(allCountList);
                entity.setMemeberIds(s);
                entity.setTotalCount(allCountList == null ? 0 : allCountList.size());
                break;
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    private String getChannleName(DBGroupEntity entity) {
        String channelName = entity.getRoomName();
        String membersId = entity.getMemeberIds();
        if (!StringUtils.isEmpty((String)channelName) && channelName.equals("undefined") || StringUtils.isEmpty((String)channelName)) {
            String strings;
            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(membersId);
            channelName = strings = GroupUtils.generateGroupMemberTempRoomName((ArrayList)memberInfoList);
        }
        return channelName;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateUserInfoEvent(UpdateUserInfoEvent updateUserInfoEvent) {
        this.userNameInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        this.mPresenter.setUserCacheInfo(this.userNameInfo);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshGroupListItem(RefreshGroupList refreshGroupList) {
        DBGroupEntity dbGroupEntity = (DBGroupEntity)refreshGroupList.getT();
        int position = -1;
        if (refreshGroupList.isExist()) {
            for (DBGroupEntity entity : this.adapter.getAllData()) {
                if (!entity.getRooomId().equals(dbGroupEntity.getRooomId())) continue;
                position = this.adapter.getPosition((Object)entity);
                entity.setRoomName(dbGroupEntity.getRoomName());
                entity.setChannelPwdMode(dbGroupEntity.getChannelPwdMode() ? 1 : 0);
                entity.setChannelPwd(dbGroupEntity.getChannelPwd());
                entity.setMemeberIds(dbGroupEntity.getMemeberIds());
            }
            if (position != -1) {
                this.adapter.notifyItemChanged(position);
            }
        } else {
            for (DBGroupEntity entity : this.adapter.getAllData()) {
                if (!entity.getRooomId().equals(dbGroupEntity.getRooomId())) continue;
                position = this.adapter.getPosition((Object)entity);
            }
            if (position != -1) {
                this.adapter.notifyItemRemoved(position);
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onUpdateMemberInfo(UpdateMemberInfoEvent memberInfoEvent) {
        if (memberInfoEvent.getT() == null) {
            LogUtils.ELog((String)this.TAG, (String)"onUpdateMemberInfo: memberInfoEvent is null");
            return;
        }
        DBGroupEntity dbGroupEntity = (DBGroupEntity)memberInfoEvent.getT();
        int poisition = -1;
        if (!memberInfoEvent.isChannelExist()) {
            for (DBGroupEntity entity1 : this.adapter.getAllData()) {
                if (!entity1.getRooomId().equals(dbGroupEntity.getRooomId())) continue;
                poisition = this.adapter.getPosition((Object)entity1);
            }
            if (poisition != -1) {
                this.adapter.remove(poisition);
                this.adapter.notifyDataSetChanged();
                POCClient.leaveRoom(this.mUserId, dbGroupEntity.getRooomId());
                POCClient.deleteLocalRoomById(this.mUserId, dbGroupEntity.getRooomId());
            }
            return;
        }
        List<POCMemberInfo> pocMemberInfos = POCClient.getInstance().generateStringToList(dbGroupEntity.getMemeberIds());
        boolean isHas = false;
        for (DBGroupEntity entity : this.adapter.getAllData()) {
            poisition = this.adapter.getPosition((Object)entity);
            if (!entity.getRooomId().equals(dbGroupEntity.getRooomId())) continue;
            for (POCMemberInfo info : pocMemberInfos) {
                if (!info.getAccount().equals(this.mUserId)) continue;
                isHas = true;
                break;
            }
            if (!isHas) {
                this.adapter.remove(poisition);
                this.adapter.notifyDataSetChanged();
                POCClient.leaveRoom(this.mUserId, dbGroupEntity.getRooomId());
                POCClient.deleteLocalRoomById(this.mUserId, dbGroupEntity.getRooomId());
                POCClient.removeFromReconnectCache(dbGroupEntity.getRooomId());
                continue;
            }
            entity.setRoomName(dbGroupEntity.getRoomName());
            entity.setPinyin(PinyinUtil.getPingYin((String)dbGroupEntity.getRoomName()));
            entity.setChannelPwdMode(dbGroupEntity.getChannelPwdMode() ? 1 : 0);
            entity.setChannelPwd(dbGroupEntity.getChannelPwd());
            entity.setMemeberIds(dbGroupEntity.getMemeberIds());
            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(entity.getMemeberIds());
            entity.setTotalCount(memberInfoList == null ? 0 : memberInfoList.size());
        }
        this.mList.clear();
        this.mList.addAll(this.adapter.getAllData());
        Collections.sort(this.mList, this.groupOrderComparator);
        this.adapter.clear();
        this.adapter.addAll(this.mList);
    }

    public void resetView(boolean isInitView) {
        this.mSearchView.closeKeyboard();
        if (isInitView) {
            this.mSearchView.addTextChangeWatcher(new ISearchCallBack(){

                public void onStartSearch(String s) {
                }

                public void onEndSearch() {
                }
            });
            this.mSearchView.getEditText().setText((CharSequence)"");
            this.mSearchView.addTextChangeWatcher((ISearchCallBack)this);
            this.recyclerView.setAdapter(this.adapter);
            if (this.adapter.getAllData() == null || this.adapter.getAllData().size() <= 0) {
                this.switchViewStatus(1);
            }
        }
    }

    private static class SearchTask
    extends AsyncTask<String, Void, List<DBGroupEntity>> {
        private WeakReference<POCRecentFragment> mWefs;

        public SearchTask(POCRecentFragment chooseFriendsPresenter) {
            this.mWefs = new WeakReference<POCRecentFragment>(chooseFriendsPresenter);
        }

        protected List<DBGroupEntity> doInBackground(String ... strings) {
            if (this.mWefs != null && this.mWefs.get() != null) {
                POCRecentFragment recentFragment = (POCRecentFragment)this.mWefs.get();
                List<DBGroupEntity> allData = GroupUtils.getPocGroupMatchKey(recentFragment.adapter.getAllData(), recentFragment.keyWords);
                return allData;
            }
            return null;
        }

        protected void onPostExecute(List<DBGroupEntity> pocGroups) {
            super.onPostExecute(pocGroups);
            if (this.mWefs != null && this.mWefs.get() != null) {
                POCRecentFragment recentFragment = (POCRecentFragment)this.mWefs.get();
                if (pocGroups == null || pocGroups.size() <= 0) {
                    recentFragment.recyclerView.setAdapter((RecyclerView.Adapter)recentFragment.mSearchAdapter);
                    recentFragment.recyclerView.setEmptyView(recentFragment.createEmptySearchView());
                    recentFragment.recyclerView.showEmpty();
                } else {
                    recentFragment.recyclerView.setAdapter((RecyclerView.Adapter)recentFragment.mSearchAdapter);
                    recentFragment.mSearchAdapter.clear();
                    recentFragment.mSearchAdapter.addAll(pocGroups);
                }
            }
        }
    }

    private static class SearchHandler
    extends Handler {
        private WeakReference<POCRecentFragment> mActivity;
        private List<DBGroupEntity> allData;

        SearchHandler(POCRecentFragment activity) {
            this.mActivity = new WeakReference<POCRecentFragment>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            POCRecentFragment pocRecentFragment = (POCRecentFragment)this.mActivity.get();
            if (pocRecentFragment != null) {
                if (!pocRecentFragment.isAdded() || pocRecentFragment.isRemoving()) {
                    return;
                }
                if (this.allData == null) {
                    this.allData = pocRecentFragment.adapter.getAllData();
                }
                switch (msg.what) {
                    case 1: {
                        pocRecentFragment.doSearch();
                    }
                }
            }
        }
    }
}

