/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.mvp;

import android.content.Context;
import com.google.gson.Gson;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.POCHandlerService;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.proxy.IPOCAbstractRoomEventCallBack;
import com.xdja.poc.sdk.proxy.IPOCChannelInfoCallBack;
import com.xdja.poc.sdk.proxy.IPOCRoomEventCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.main.mvp.POCGroupListContract;
import com.xdja.poc.sdk.utils.GroupUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;

public class POCGroupListPresenter
implements POCGroupListContract.IPresenter {
    private POCGroupListContract.IView mView;
    private Context mContext;
    private RecyclerArrayAdapter<DBGroupEntity> mAdapter;
    private RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter;
    private EasyRecyclerView recyclerView;
    private String mUserId;
    private Gson gson;
    private IPOCRoomEventCallBack roomEventCallBack;
    private boolean isDeleteRoom = false;
    private boolean isSelfOwner = false;
    private Map<String, Boolean> currentSpeakCache = new HashMap<String, Boolean>();
    private Map<String, POCMemberInfo> mAccountToName = new HashMap<String, POCMemberInfo>();
    private IPOCChannelInfoCallBack pttEventCallBack = new IPOCChannelInfoCallBack(){

        @Override
        public void onPttKeyEvent(String channelId, boolean pttStatus) {
            POCHandlerService.updateGroupPttKey(POCGroupListPresenter.this.mContext, (ArrayList)POCGroupListPresenter.this.mAdapter.getAllData(), POCGroupListPresenter.this.mUserId, channelId, pttStatus);
            for (DBGroupEntity entity : POCGroupListPresenter.this.mAdapter.getAllData()) {
                entity.setIsPttKey(0);
                if (!entity.getRooomId().equals(channelId)) continue;
                entity.setIsPttKey(pttStatus ? 1 : 0);
            }
            POCGroupListPresenter.this.mAdapter.notifyDataSetChanged();
            if (POCGroupListPresenter.this.mSearchAdapter != null && POCGroupListPresenter.this.mSearchAdapter.getAllData().size() > 0) {
                POCHandlerService.updateGroupPttKey(POCGroupListPresenter.this.mContext, (ArrayList)POCGroupListPresenter.this.mSearchAdapter.getAllData(), POCGroupListPresenter.this.mUserId, channelId, pttStatus);
                for (DBGroupEntity entity : POCGroupListPresenter.this.mSearchAdapter.getAllData()) {
                    entity.setIsPttKey(0);
                    if (!entity.getRooomId().equals(channelId)) continue;
                    entity.setIsPttKey(pttStatus ? 1 : 0);
                }
                POCGroupListPresenter.this.mSearchAdapter.notifyDataSetChanged();
            }
        }

        @Override
        public void onChannelNameEvent(String channelId, String channelName) {
            POCHandlerService.updateGroupName(POCGroupListPresenter.this.mContext, POCGroupListPresenter.this.mUserId, channelId, channelName);
            int position = -1;
            for (DBGroupEntity entity : POCGroupListPresenter.this.mAdapter.getAllData()) {
                if (!entity.getRooomId().equals(channelId)) continue;
                position = POCGroupListPresenter.this.mAdapter.getPosition((Object)entity);
                entity.setRoomName(channelName);
                break;
            }
            if (position != -1) {
                POCGroupListPresenter.this.mAdapter.notifyItemChanged(position);
                Collections.sort(POCGroupListPresenter.this.mAdapter.getAllData(), POCGroupListPresenter.this.mView.getComparator());
            }
            if (POCGroupListPresenter.this.mSearchAdapter != null && POCGroupListPresenter.this.mSearchAdapter.getAllData().size() > 0) {
                int position1 = -1;
                for (DBGroupEntity entity : POCGroupListPresenter.this.mSearchAdapter.getAllData()) {
                    if (!entity.getRooomId().equals(channelId)) continue;
                    position1 = POCGroupListPresenter.this.mSearchAdapter.getPosition((Object)entity);
                    entity.setRoomName(channelName);
                    break;
                }
                if (position1 != -1) {
                    POCGroupListPresenter.this.mSearchAdapter.notifyItemChanged(position1);
                }
            }
        }

        @Override
        public void onChannelPwdEvent(String channelId, String channelPwd) {
            POCHandlerService.updateGroupPwd(POCGroupListPresenter.this.mContext, POCGroupListPresenter.this.mUserId, channelId, channelPwd);
            int position = -1;
            for (DBGroupEntity entity : POCGroupListPresenter.this.mAdapter.getAllData()) {
                if (!entity.getRooomId().equals(channelId)) continue;
                position = POCGroupListPresenter.this.mAdapter.getPosition((Object)entity);
                entity.setChannelPwd(channelPwd);
                break;
            }
            if (position != -1) {
                POCGroupListPresenter.this.mAdapter.notifyItemChanged(position);
            }
            if (POCGroupListPresenter.this.mSearchAdapter != null && POCGroupListPresenter.this.mSearchAdapter.getAllData().size() > 0) {
                int position1 = -1;
                for (DBGroupEntity entity : POCGroupListPresenter.this.mSearchAdapter.getAllData()) {
                    if (!entity.getRooomId().equals(channelId)) continue;
                    position1 = POCGroupListPresenter.this.mSearchAdapter.getPosition((Object)entity);
                    entity.setChannelPwd(channelPwd);
                    break;
                }
                if (position1 != -1) {
                    POCGroupListPresenter.this.mSearchAdapter.notifyItemChanged(position1);
                }
            }
        }

        @Override
        public void onChannelPwdModeEvent(String channelId, boolean channelPwdMode) {
            POCHandlerService.updateGroupPwdMode(POCGroupListPresenter.this.mContext, POCGroupListPresenter.this.mUserId, channelId, channelPwdMode);
            int position = -1;
            for (DBGroupEntity entity : POCGroupListPresenter.this.mAdapter.getAllData()) {
                if (!entity.getRooomId().equals(channelId)) continue;
                position = POCGroupListPresenter.this.mAdapter.getPosition((Object)entity);
                entity.setChannelPwdMode(channelPwdMode ? 1 : 0);
                break;
            }
            if (position != -1) {
                POCGroupListPresenter.this.mAdapter.notifyItemChanged(position);
            }
            if (POCGroupListPresenter.this.mSearchAdapter != null && POCGroupListPresenter.this.mSearchAdapter.getAllData().size() > 0) {
                int position1 = -1;
                for (DBGroupEntity entity : POCGroupListPresenter.this.mSearchAdapter.getAllData()) {
                    if (!entity.getRooomId().equals(channelId)) continue;
                    position1 = POCGroupListPresenter.this.mSearchAdapter.getPosition((Object)entity);
                    entity.setChannelPwdMode(channelPwdMode ? 1 : 0);
                    break;
                }
                if (position1 != -1) {
                    POCGroupListPresenter.this.mSearchAdapter.notifyItemChanged(position1);
                }
            }
        }
    };

    public POCGroupListPresenter(POCGroupListContract.IView mView, Context context) {
        this.mView = mView;
        this.mContext = context;
        this.gson = new Gson();
        this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
        this.initEvent();
    }

    private void initEvent() {
        this.roomEventCallBack = new IPOCAbstractRoomEventCallBack(){

            @Override
            public void onMemberEventCallBack(POCMemberEvent memberEvent) {
                super.onMemberEventCallBack(memberEvent);
                String roomId = memberEvent.getRoomId();
                List allData = POCGroupListPresenter.this.mAdapter.getAllData();
                Map<String, String> map = POCClient.getAllSpeakers();
                for (DBGroupEntity group : allData) {
                    if (!group.getRooomId().equalsIgnoreCase(roomId)) continue;
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(group.getRooomId()));
                    group.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    boolean b = GroupUtils.resetGroupStatus(group);
                    group.setStatus(b ? 1 : 0);
                    if (map != null && map.containsKey(group.getRooomId())) {
                        group.setStatus(2);
                        String speakUserId = map.get(group.getRooomId());
                        if (speakUserId.equals(POCGroupListPresenter.this.mUserId)) {
                            group.setStatus(1);
                        } else {
                            String speakName = speakUserId;
                            POCGroupListPresenter.this.mAccountToName = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                            if (POCGroupListPresenter.this.mAccountToName != null && POCGroupListPresenter.this.mAccountToName.containsKey(speakUserId)) {
                                speakName = ((POCMemberInfo)POCGroupListPresenter.this.mAccountToName.get(speakUserId)).getName();
                            } else {
                                if (POCGroupListPresenter.this.mAccountToName == null) {
                                    POCGroupListPresenter.this.mAccountToName = new HashMap();
                                }
                                if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId) && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(speakUserId)) {
                                    POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(speakUserId);
                                    speakName = info.getName();
                                    POCGroupListPresenter.this.mAccountToName.put(speakUserId, info);
                                }
                            }
                            group.setSpeakerUserName(speakName);
                        }
                    }
                    Collections.sort(allData, POCGroupListPresenter.this.mView.getComparator());
                    POCGroupListPresenter.this.mAdapter.clear();
                    POCGroupListPresenter.this.mAdapter.addAll((Collection)allData);
                    if (POCGroupListPresenter.this.mSearchAdapter == null || POCGroupListPresenter.this.mSearchAdapter.getAllData() == null || POCGroupListPresenter.this.mSearchAdapter.getAllData().size() <= 0) break;
                    List allData1 = POCGroupListPresenter.this.mSearchAdapter.getAllData();
                    for (DBGroupEntity entity : allData1) {
                        if (!entity.getRooomId().equals(roomId)) continue;
                        entity.setStatus(group.getStatus());
                        entity.setOnLineCount(group.getOnLineCount());
                        entity.setSpeakerUserName(group.getSpeakerUserName());
                        break;
                    }
                    POCGroupListPresenter.this.mSearchAdapter.notifyDataSetChanged();
                    break;
                }
            }

            @Override
            public void onMeIncomeRoomCallBack(POCConversationMeIncomeRoom meIncomeRoom) {
                super.onMeIncomeRoomCallBack(meIncomeRoom);
                POCGroupListPresenter.this.mView.onSelfInComing(meIncomeRoom.getRoomId());
            }

            @Override
            public void onSelfLeaveRoomCallBack(POCSelfLeaveEvent selfLeaveEvent) {
                super.onSelfLeaveRoomCallBack(selfLeaveEvent);
                String roomId = selfLeaveEvent.getRoomId();
                List allData = POCGroupListPresenter.this.mAdapter.getAllData();
                int dataPosition = -1;
                for (DBGroupEntity group : allData) {
                    if (!group.getRooomId().equalsIgnoreCase(roomId)) continue;
                    dataPosition = POCGroupListPresenter.this.mAdapter.getPosition((Object)group);
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(group.getRooomId()));
                    group.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    group.setStatus(0);
                    if (POCGroupListPresenter.this.isDeleteRoom) {
                        POCGroupListPresenter.this.isDeleteRoom = false;
                        if (group.getGroupType() == 1) {
                            POCGroupListPresenter.this.checkAdapterData((RecyclerArrayAdapter<DBGroupEntity>)POCGroupListPresenter.this.mAdapter, roomId, false);
                            POCGroupListPresenter.this.checkSearchAdapter(roomId, false);
                            break;
                        }
                        if (group.getGroupType() != 0) break;
                        if (group.getOwnerId() != null && group.getOwnerId().equalsIgnoreCase(POCGroupListPresenter.this.mUserId)) {
                            POCUiKitProxyImpl.getInstance().doDeleteServerRoom(roomId);
                            break;
                        }
                        POCUiKitProxyImpl.getInstance().doRemoveMembersFromRoom(roomId, POCGroupListPresenter.this.mUserId);
                        break;
                    }
                    if (group.getGroupType() != 1) break;
                    POCGroupListPresenter.this.checkAdapterData((RecyclerArrayAdapter<DBGroupEntity>)POCGroupListPresenter.this.mAdapter, roomId, true);
                    POCGroupListPresenter.this.checkSearchAdapter(roomId, false);
                    break;
                }
            }

            @Override
            public void onDeleteServerRoomCallBack(GroupEvent event, boolean status) {
                super.onDeleteServerRoomCallBack(event, status);
                if (status) {
                    POCGroupListPresenter.this.checkAdapterData((RecyclerArrayAdapter<DBGroupEntity>)POCGroupListPresenter.this.mAdapter, event.getRoomId(), false);
                    POCGroupListPresenter.this.checkSearchAdapter(event.getRoomId(), false);
                    POCClient.destroyRoom(POCGroupListPresenter.this.mUserId, event.getRoomId());
                } else if (POCGroupListPresenter.this.mView != null) {
                    POCGroupListPresenter.this.mView.dismissLoading();
                }
            }

            @Override
            public void onRemoveMembersCallBack(GroupEvent event, boolean status) {
                super.onRemoveMembersCallBack(event, status);
                List allData = POCGroupListPresenter.this.mAdapter.getAllData();
                int position = -1;
                if (event.getMembers().equals(POCGroupListPresenter.this.mUserId)) {
                    POCGroupListPresenter.this.checkAdapterData((RecyclerArrayAdapter<DBGroupEntity>)POCGroupListPresenter.this.mAdapter, event.getRoomId(), false);
                } else {
                    for (DBGroupEntity entity : allData) {
                        Iterator<POCMemberInfo> iterator;
                        if (!entity.getRooomId().equals(event.getRoomId())) continue;
                        position = POCGroupListPresenter.this.mAdapter.getPosition((Object)entity);
                        String memeberIds = entity.getMemeberIds();
                        List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                        if (memberInfoList == null || (iterator = memberInfoList.iterator()) == null) break;
                        while (iterator.hasNext()) {
                            POCMemberInfo next = iterator.next();
                            if (!next.getAccount().equals(event.getMembers())) continue;
                            iterator.remove();
                        }
                        entity.setMemeberIds(POCClient.getInstance().generateListString(memberInfoList));
                        break;
                    }
                    if (position != -1) {
                        POCGroupListPresenter.this.mAdapter.notifyItemChanged(position);
                    }
                    if (POCGroupListPresenter.this.mSearchAdapter != null && POCGroupListPresenter.this.mSearchAdapter.getAllData() != null && POCGroupListPresenter.this.mSearchAdapter.getAllData().size() > 0) {
                        int mPosition = -1;
                        for (DBGroupEntity entity : POCGroupListPresenter.this.mSearchAdapter.getAllData()) {
                            Iterator<POCMemberInfo> iterator;
                            if (!entity.getRooomId().equals(event.getRoomId())) continue;
                            mPosition = POCGroupListPresenter.this.mSearchAdapter.getPosition((Object)entity);
                            String memeberIds = entity.getMemeberIds();
                            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                            if (memberInfoList == null || (iterator = memberInfoList.iterator()) == null) continue;
                            while (iterator.hasNext()) {
                                POCMemberInfo next = iterator.next();
                                if (!next.getAccount().equals(event.getMembers())) continue;
                                iterator.remove();
                            }
                            entity.setMemeberIds(POCClient.getInstance().generateListString(memberInfoList));
                        }
                        if (mPosition != -1) {
                            POCGroupListPresenter.this.mSearchAdapter.notifyItemChanged(mPosition);
                        }
                    }
                }
            }

            @Override
            public void onTBCPEventCallBack(POCConverationTbcpStatusEvent tbcpStatusEvent) {
                super.onTBCPEventCallBack(tbcpStatusEvent);
                String userId = tbcpStatusEvent.getUserId();
                String roomId = tbcpStatusEvent.getRoomId();
                List allData = POCGroupListPresenter.this.mAdapter.getAllData();
                switch (tbcpStatusEvent.getUserBehavior()) {
                    case 2: {
                        POCGroupListPresenter.this.currentSpeakCache.put(roomId, true);
                        break;
                    }
                    case 1008: {
                        if (!POCGroupListPresenter.this.currentSpeakCache.containsKey(roomId) || ((Boolean)POCGroupListPresenter.this.currentSpeakCache.get(roomId)).booleanValue()) break;
                        POCGroupListPresenter.this.currentSpeakCache.put(roomId, false);
                        break;
                    }
                    case 1007: {
                        POCGroupListPresenter.this.currentSpeakCache.put(roomId, false);
                        break;
                    }
                    case 1005: {
                        POCGroupListPresenter.this.currentSpeakCache.put(roomId, false);
                        break;
                    }
                    case 1006: {
                        POCGroupListPresenter.this.currentSpeakCache.put(roomId, false);
                        break;
                    }
                    case 1: {
                        POCGroupListPresenter.this.currentSpeakCache.put(roomId, false);
                    }
                }
                for (DBGroupEntity pocGroup : allData) {
                    if (!pocGroup.getRooomId().equalsIgnoreCase(roomId)) continue;
                    if (userId.equals(POCGroupListPresenter.this.mUserId)) {
                        pocGroup.setStatus(1);
                    } else {
                        String speakName = StringUtils.isEmpty((String)pocGroup.getSpeakerUserName()) ? userId : pocGroup.getSpeakerUserName();
                        POCGroupListPresenter.this.mAccountToName = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                        if (POCGroupListPresenter.this.mAccountToName != null && POCGroupListPresenter.this.mAccountToName.containsKey(userId)) {
                            speakName = ((POCMemberInfo)POCGroupListPresenter.this.mAccountToName.get(userId)).getName();
                        } else {
                            if (POCGroupListPresenter.this.mAccountToName == null) {
                                POCGroupListPresenter.this.mAccountToName = new HashMap();
                            }
                            if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId) && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(userId)) {
                                POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(userId);
                                speakName = info.getName();
                                POCGroupListPresenter.this.mAccountToName.put(userId, info);
                            }
                        }
                        if (POCGroupListPresenter.this.currentSpeakCache.containsKey(roomId) && ((Boolean)POCGroupListPresenter.this.currentSpeakCache.get(roomId)).booleanValue()) {
                            pocGroup.setStatus(2);
                            pocGroup.setSpeakerUserName(speakName);
                        } else {
                            pocGroup.setStatus(tbcpStatusEvent.getStatus());
                            pocGroup.setSpeakerUserName(speakName);
                        }
                    }
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(pocGroup.getRooomId()));
                    pocGroup.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(pocGroup.getMemeberIds());
                    pocGroup.setTotalCount(allCountList == null ? 0 : allCountList.size());
                }
                Collections.sort(allData, POCGroupListPresenter.this.mView.getComparator());
                POCGroupListPresenter.this.mAdapter.notifyDataSetChanged();
                if (POCGroupListPresenter.this.mSearchAdapter != null && POCGroupListPresenter.this.mSearchAdapter.getAllData() != null && POCGroupListPresenter.this.mSearchAdapter.getAllData().size() > 0) {
                    List allData1 = POCGroupListPresenter.this.mSearchAdapter.getAllData();
                    for (DBGroupEntity entity : allData1) {
                        if (!entity.getRooomId().equals(roomId)) continue;
                        if (POCGroupListPresenter.this.currentSpeakCache.containsKey(roomId) && ((Boolean)POCGroupListPresenter.this.currentSpeakCache.get(roomId)).booleanValue()) {
                            entity.setStatus(2);
                            entity.setSpeakerUserName(entity.getSpeakerUserName());
                        } else {
                            entity.setStatus(tbcpStatusEvent.getStatus());
                            String speakName = userId;
                            POCGroupListPresenter.this.mAccountToName = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                            if (POCGroupListPresenter.this.mAccountToName != null && POCGroupListPresenter.this.mAccountToName.containsKey(userId)) {
                                speakName = ((POCMemberInfo)POCGroupListPresenter.this.mAccountToName.get(userId)).getName();
                            } else {
                                if (POCGroupListPresenter.this.mAccountToName == null) {
                                    POCGroupListPresenter.this.mAccountToName = new HashMap();
                                }
                                if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId) && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(userId)) {
                                    POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(userId);
                                    speakName = info.getName();
                                    POCGroupListPresenter.this.mAccountToName.put(userId, info);
                                }
                            }
                            entity.setSpeakerUserName(speakName);
                        }
                        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(entity.getRooomId()));
                        entity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    }
                    POCGroupListPresenter.this.mSearchAdapter.notifyDataSetChanged();
                }
            }

            @Override
            public void onDeleteTempRoomCallBack(GroupEvent event, boolean status) {
                super.onDeleteTempRoomCallBack(event, status);
                if (status) {
                    POCGroupListPresenter.this.checkAdapterData((RecyclerArrayAdapter<DBGroupEntity>)POCGroupListPresenter.this.mAdapter, event.getRoomId(), false);
                    POCGroupListPresenter.this.checkSearchAdapter(event.getRoomId(), false);
                    POCClient.destroyRoom(POCGroupListPresenter.this.mUserId, event.getRoomId());
                } else {
                    if (POCGroupListPresenter.this.mView != null) {
                        POCGroupListPresenter.this.mView.dismissLoading();
                    }
                    ToastUtils.showToast((String)"\u7f51\u7edc\u5f02\u5e38,\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e");
                }
            }

            @Override
            public void onAddMembersCallBack(GroupEvent event, boolean status) {
                super.onAddMembersCallBack(event, status);
                String members = event.getMembers();
                DBGroupEntity entity = new DBGroupEntity();
                entity.setRooomId(event.getRoomId());
                entity.setRoomName(event.getGroupName());
                POCUiKitProxyImpl.getInstance().notifyRefreshChannelMembersInfo(entity);
            }
        };
        POCUiKitProxyImpl.getInstance().addRoomEventCallBack(this.roomEventCallBack);
        POCUiKitProxyImpl.getInstance().addPttKeyEventCallBack(this.pttEventCallBack);
    }

    @Override
    public void showMenuDialog(int position) {
    }

    @Override
    public void deleteRoom(DBGroupEntity groupEntity) {
        if (!NetUtils.isNetworkAvailable((Context)this.mContext)) {
            ToastUtils.showToast((String)this.mContext.getResources().getString(R.string.common_net_failed));
            return;
        }
        if (!NetUtils.isNetworkAvailable((Context)this.mContext)) {
            ToastUtils.showToast((String)this.mContext.getResources().getString(R.string.common_net_failed));
            return;
        }
        if (groupEntity.getStatus() == 0) {
            if (groupEntity.getGroupType() == 0) {
                if (groupEntity.getOwnerId().equalsIgnoreCase(this.mUserId)) {
                    POCUiKitProxyImpl.getInstance().doDeleteServerRoom(groupEntity.getRooomId());
                } else {
                    POCUiKitProxyImpl.getInstance().doRemoveMembersFromRoom(groupEntity.getRooomId(), this.mUserId);
                }
            } else if (groupEntity.getGroupType() == 1) {
                EventBus.getDefault().post(null);
            }
        } else {
            this.isDeleteRoom = true;
            POCClient.leaveRoom(this.mUserId, groupEntity.getRooomId());
        }
    }

    @Override
    public void attatchAdapter(EasyRecyclerView mRecycleView, RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter, RecyclerArrayAdapter<DBGroupEntity> adapter) {
        this.recyclerView = mRecycleView;
        this.mAdapter = adapter;
        this.mSearchAdapter = mSearchAdapter;
    }

    @Override
    public void refreshGroupList(POCGroupUpdateEvent pocGroupUpdateEvent) {
        Object t = pocGroupUpdateEvent.getT();
        ArrayList mList = new ArrayList();
        if (t != null) {
            mList = (ArrayList)t;
        }
        POCHandlerService.insertOrReplaceGroupData(this.mContext, mList);
    }

    @Override
    public void destroy() {
        this.mView = null;
        POCUiKitProxyImpl.getInstance().removeRoomEventCallBack(this.roomEventCallBack);
        POCUiKitProxyImpl.getInstance().removePttKeyEventCallBack(this.pttEventCallBack);
        this.currentSpeakCache.clear();
        this.currentSpeakCache = null;
    }

    @Override
    public void setUserCacheInfo(Map<String, POCMemberInfo> mapMap) {
        this.mAccountToName = mapMap;
    }

    public void onMenu(int menuPosition, int dataPosition, boolean b) {
    }

    private void removeRoom(String roomId) {
        for (DBGroupEntity entity : this.mAdapter.getAllData()) {
            if (!entity.getRooomId().equalsIgnoreCase(roomId)) continue;
            POCClient.leaveRoom(this.mUserId, roomId);
            break;
        }
        this.checkAdapterData(this.mAdapter, roomId, false);
        this.checkSearchAdapter(roomId, false);
    }

    @Override
    public void refreshAdapter(String roomId) {
        this.checkAdapterData(this.mAdapter, roomId, true);
        this.checkSearchAdapter(roomId, false);
    }

    private void checkSearchAdapter(String roomId, boolean isSort) {
        if (this.mSearchAdapter != null && this.mSearchAdapter.getAllData() != null && this.mSearchAdapter.getAllData().size() > 0) {
            this.checkAdapterData(this.mSearchAdapter, roomId, isSort);
        }
    }

    private void checkAdapterData(RecyclerArrayAdapter<DBGroupEntity> adapter, String roomId, boolean isSort) {
        if (this.mView != null) {
            this.mView.dismissLoading();
        }
        boolean isRemove = false;
        int position = -1;
        for (DBGroupEntity groupEntity : adapter.getAllData()) {
            if (!roomId.equalsIgnoreCase(groupEntity.getRooomId())) continue;
            position = adapter.getPosition((Object)groupEntity);
            POCClient.deleteLocalRoomById(this.mUserId, roomId);
            POCClient.leaveRoom(this.mUserId, roomId);
            POCClient.removeFromReconnectCache(roomId);
            adapter.remove((Object)groupEntity);
            isRemove = true;
            break;
        }
        if (adapter.getAllData() == null || adapter.getAllData().size() <= 0) {
            this.mView.switchViewStatus(1);
        } else if (isSort) {
            Collections.sort(adapter.getAllData(), this.mView.getComparator());
        } else if (position != -1) {
            adapter.notifyDataSetChanged();
        }
        if (isRemove && this.mSearchAdapter != null && this.mSearchAdapter.getAllData() != null && this.mSearchAdapter.getAllData().size() > 0) {
            this.mView.resetFragment();
        }
    }
}

