/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.os.Handler;
import android.os.Looper;
import com.xdja.poc.common.utils.LogUtils;
import de.tavendo.autobahn.SSLFactorys;
import de.tavendo.autobahn.WebSocketOptions;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import javax.net.SocketFactory;

public class SocketThread
extends Thread {
    private static final String WS_CONNECTOR = "WebSocketConnector";
    private static final String WS_URI_SCHEME = "ws";
    private static final String WSS_URI_SCHEME = "wss";
    private static final String WS_WRITER = "WebSocketWriter";
    private static final String WS_READER = "WebSocketReader";
    private final URI mWebSocketURI;
    private Socket mSocket = null;
    private String mFailureMessage = null;
    private Handler mHandler;
    private Context mContext;

    public SocketThread(URI uri, WebSocketOptions options) {
        this.setName(WS_CONNECTOR);
        this.mWebSocketURI = uri;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        LogUtils.DLog((String)"SocketThread", (String)"SocketThread run...");
        this.mHandler = new Handler();
        SocketThread socketThread = this;
        synchronized (socketThread) {
            this.notifyAll();
        }
        Looper.loop();
        this.mHandler = null;
        LogUtils.DLog((String)"SocketThread", (String)"SocketThread exited.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnection() {
        try {
            String host = this.mWebSocketURI.getHost();
            int port = this.mWebSocketURI.getPort();
            if (port == -1) {
                port = this.mWebSocketURI.getScheme().equals(WSS_URI_SCHEME) ? 443 : 80;
            }
            SocketFactory factory = null;
            if (this.mWebSocketURI.getScheme().equalsIgnoreCase(WSS_URI_SCHEME)) {
                SSLFactorys sslFactorys = new SSLFactorys(this.mContext);
                factory = sslFactorys.getSocketFactory();
                if (factory == null) {
                    factory = SSLCertificateSocketFactory.getDefault();
                    LogUtils.ELog((String)"socketThread", (String)"get factory failed,get default factory");
                } else {
                    LogUtils.DLog((String)"socketThread", (String)"get factory success");
                }
            } else {
                factory = SocketFactory.getDefault();
            }
            this.mSocket = factory.createSocket(host, port);
        }
        catch (IOException var5) {
            this.mFailureMessage = var5.getLocalizedMessage();
        }
        SocketThread socketThread = this;
        synchronized (socketThread) {
            this.notifyAll();
        }
    }

    public void stopConnection() {
        try {
            this.mSocket.close();
            this.mSocket = null;
        }
        catch (IOException var2) {
            this.mFailureMessage = var2.getLocalizedMessage();
        }
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public Socket getSocket() {
        return this.mSocket;
    }

    public String getFailureMessage() {
        return this.mFailureMessage;
    }
}

