package com.xdja.poc.sdk.business;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.plugincallback.JanusCreateRoomPluginCallbacks;
import com.xdja.poc.sdk.business.plugincallback.JanusPublisherPluginCallbacks;
import com.xdja.poc.sdk.business.plugincallback.JaunsUnassociationRoomPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusAttachSuccessCallBack;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusGatewayCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.ui.conversion.POCWarningToneCompleteCallBack;
import com.xdja.poc.sdk.utils.MusicHelper;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;

import static com.xdja.poc.sdk.config.Constants.ROOM_TBCP_REQUEST_FAILED;
import static com.xdja.poc.sdk.config.Constants.ROOM_TBCP_REQUEST_SUCCESS;


//TODO create message classes unique to this plugin

/**
 * Created by ben.trent on 7/24/2015.
 */
@SuppressWarnings("ALL")
public class POCRoom implements IJanusGatewayCallbacks {
    public static final String TAG = "POCRoom";

    private volatile RoomStatus mRoomStatus;
    private IJanusAttachSuccessCallBack attachSuccessCallBack;
    private String serverUrl;
    private long roomId;
    private String userName;
    private int bCreateFlg = 0;
    private RoomEvent roomEvent;
    private HashMap<BigInteger, ProxyVideoSink> remoteRenderers = new HashMap<>();
    private ProxyVideoSink remoteProxyRenderer = null;
    private ProxyVideoSink localProxyVideoSink = null;
    private Context mContext;
    private volatile int currTBCPStatus = 0;
    private String currTBCPUser;
    private volatile boolean bAttached;//
    private volatile boolean muteState = false;
    private boolean mBWaitTakenTBCPResult = false;
    //for plugin
    JanusPublisherPluginCallbacks mJanusPublisherPluginCallbacks = null;
    JanusCreateRoomPluginCallbacks mJanusCreateRoomPluginCallbacks = null;
    JaunsUnassociationRoomPluginCallbacks mJaunsUnassociationCallBacks = null;
    PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;

    public POCRoom(String serverUrl, long roomId, String userName, int bCreateFlg, RoomEvent event, Context context) {
        this.serverUrl = serverUrl;
        this.roomId = roomId;
        this.userName = userName;
        this.bCreateFlg = bCreateFlg;
        this.roomEvent = event;
        this.mRoomStatus = new RoomStatus(false, false, false, false, false, false);
        this.mContext = context;

        //first add callback.
        getJanusServer().addCallback(this);
    }

    //for video constructor
    public POCRoom(ProxyVideoSink localRender, ProxyVideoSink[] remoteRenders, int roomId) {
        this.localProxyVideoSink = localRender;
        for (ProxyVideoSink remoteRender : remoteRenders) {
            Deque<ProxyVideoSink> availableRemoteRenderers = new ArrayDeque<>();
            availableRemoteRenderers.push(remoteRender);
        }
        this.roomId = roomId;

        remoteProxyRenderer = remoteRenders[0];
    }

    private JanusServer getJanusServer() {
        return JanusServer.getJanusServer(serverUrl);
    }

    public int getCurrTBCPStatus() {
        return currTBCPStatus;
    }

    public String getCurrTBCPUser() {
        return currTBCPUser;
    }

    public void setPlayerStatus(boolean status) {
        AudioManager audioManager = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);
        assert audioManager != null;
        LogUtils.ELog(TAG, "getMode:" + audioManager.getMode() + ", isSpeakerphoneOn:" + audioManager.isSpeakerphoneOn());
        if (status && audioManager.getMode() != AudioManager.MODE_NORMAL) {
            int oldMode = audioManager.getMode();
            audioManager.setMode(AudioManager.MODE_NORMAL);
            LogUtils.ELog(TAG, "after set oldMode:" + oldMode + ", set currrent MODE_NORMAL");
        }
        LogUtils.DLog(TAG, "setPlayerStatus status: " + status);
//        if (mJanusCreateRoomPluginCallbacks != null && mJanusCreateRoomPluginCallbacks.getHandler() != null) {
//            if (mJanusCreateRoomPluginCallbacks.getHandler().getHandler() != null) {
//                mJanusCreateRoomPluginCallbacks.getHandler().getHandler().startPlayer(status);
//            }
//        }
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.startPlayer(status);
        }
    }

    public void resetCurrTBCPUser() {
        currTBCPUser = "";
        LogUtils.DLog(TAG, "");
    }

    public boolean ismBWaitTakenTBCPResult() {
        return mBWaitTakenTBCPResult;
    }

    public synchronized void handleTBCP(boolean bWaitTBCPResult, JSONObject obj, String currTransaction, final JanusPluginHandleWithWebrtc handle, final JanusPluginHandleWithWebrtc listenHandle) {
        mBWaitTakenTBCPResult = bWaitTBCPResult;
        String owner_name = "";
        try {
            if (obj.has("tbcp_request_userid")) {
                owner_name = obj.getString("tbcp_request_userid");
            }
        } catch (JSONException e) {
            try {
                if (obj.has("tbcp_owner")) {
                    owner_name = obj.getString("tbcp_owner");
                }
            } catch (JSONException exx) {
                exx.printStackTrace();
            }
            //e.printStackTrace();
        }
        if (obj.has("transaction")) {
            try {
                String transaction = obj.getString("transaction");
                LogUtils.DLog(JanusServer.class.toString(), "tbcp bWaitTakenTBCPResult:" + bWaitTBCPResult + ", owner_name:" + owner_name + ", transaction:" + transaction + ", currTransaction:" + currTransaction);
                if (transaction != null && (currTransaction != null && transaction.equals(currTransaction))) {
                    owner_name = userName;
                    if (!bWaitTBCPResult) {
                        bWaitTBCPResult = true;
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        LogUtils.DLog(TAG, "handleTBCP bWaitTakenTBCPResult: " + bWaitTBCPResult);


        if (bWaitTBCPResult && owner_name.equals(userName)) {
            try {
                int result_code = obj.getInt("result_code");
                switch (result_code) {
                    case Constants.TBCP_REQUEST_FAILED:
                        currTBCPStatus = ROOM_TBCP_REQUEST_FAILED;
                        currTBCPUser = "";
                        playBGM(MusicHelper.TYPE_END_GO, ROOM_TBCP_REQUEST_FAILED, userName, null);
                        break;
                    case Constants.TBCP_REQUEST_SUCCESS:
                        currTBCPStatus = ROOM_TBCP_REQUEST_SUCCESS;
                        currTBCPUser = userName;

                        //mHandler.sendEmptyMessage(BACKGROUND_START);
//                        if (listenHandle != null) {
//                            LogUtils.ILog("ROOM_TBCP_REQUEST_SUCCESS:" + obj.toString());
//                            listenHandle.startPlayer(false);
//                        }
                        playBGM(MusicHelper.TYPE_READY_GO, ROOM_TBCP_REQUEST_SUCCESS, userName, handle);
                        break;
                    case Constants.TBCP_RELEASE_SUCCESS_SILENCE:
                    case Constants.TBCP_RELEASE_SUCCESS:
                        currTBCPStatus = Constants.ROOM_TBCP_RELEASE_SUCCESS;
                        currTBCPUser = "";
                        playBGM(MusicHelper.TYPE_END_GO, Constants.ROOM_TBCP_RELEASE_SUCCESS, userName, null);
                        break;
                    case Constants.TBCP_RELEASE_FAILED:
                        currTBCPStatus = Constants.ROOM_TBCP_RELEASE_FAILED;
                        currTBCPUser = "";
                        playBGM(MusicHelper.TYPE_END_GO, Constants.ROOM_TBCP_RELEASE_FAILED, userName, null);

                        break;
                    case Constants.TBCP_REQUEST_TAKEN:
                        if (handle != null) {
                            handle.startPlayer(false);
                        }
                        currTBCPStatus = ROOM_TBCP_REQUEST_SUCCESS;
                        currTBCPUser = userName;
                        playBGM(MusicHelper.TYPE_READY_GO, ROOM_TBCP_REQUEST_SUCCESS, userName, handle);
                        break;
                    default:
                        break;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            if (obj.has("result")) {
                try {
                    String result = obj.getString("result");
                    if (result.equals("tbcp")) {
                        int result_code = obj.getInt("result_code");
                        switch (result_code) {
                            case Constants.TBCP_REQUEST_SUCCESS: {
                                final String tbcp_owner = obj.getString("tbcp_owner_name");
//                                if (listenHandle != null) {
//                                    listenHandle.startPlayer(true);
//                                }
                                currTBCPStatus = Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS;
                                currTBCPUser = tbcp_owner;
                                if (getMemberList() != null && !getMemberList().contains(currTBCPUser)) {
                                    getMemberList().add(currTBCPUser);
                                }
                                playBGM(MusicHelper.TYPE_READY_GO, Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS, tbcp_owner, null);
                            }
                            break;
                            case Constants.TBCP_RELEASE_SUCCESS:
                                final String tbcp_owner = obj.getString("tbcp_old_owner");
//                                if (listenHandle != null) {
//                                    LogUtils.ILog("ROOM_OTHER_TBCP_RELEASE_SUCCESS:" + obj.toString());
//                                    listenHandle.startPlayer(false);
//                                     TODO: 2018/10/10 获取当前在线频道的是否有人在讲话中,
//                                     TODO: 2018/10/10 没有则startPlayer(false),否则不
//                                }
                                currTBCPStatus = Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS;
                                currTBCPUser = "";
                                playBGM(MusicHelper.TYPE_END_GO, Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS, tbcp_owner, null);
                                break;
                            case Constants.TBCP_RELEASE_SUCCESS_SILENCE:
                                //说话的人释放的时候,通知其他人成功了,但是通知说话人自己的时候失败了,这样,其他人的状态都已经是空闲了,
                                // 这个时候超时次数达到了三次,说话的人发送的TBCP还是没有收到ACK,他自己可能掉线了,又通知其他用户,这样其他人会感觉手机自己有响了,很奇怪。
                                final String tbcp_owner1 = obj.getString("tbcp_old_owner");
//                                if (listenHandle != null) {
//                                    LogUtils.ILog("ROOM_OTHER_TBCP_RELEASE_SUCCESS:" + obj.toString());
//                                    listenHandle.startPlayer(false);
//                                     TODO: 2018/10/10 获取当前在线频道的是否有人在讲话中,
//                                     TODO: 2018/10/10 没有则startPlayer(false),否则不
//                                }
                                currTBCPStatus = Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS;
                                currTBCPUser = "";
                                roomEvent.onTBCP(Constants.ROOM_OTHER_TBCP_RELEASE_SUCCESS, tbcp_owner1);
                                break;

                            case Constants.TBCP_REQUEST_TAKEN:
                                if (handle != null) {
                                    handle.releaseTBCP();
                                    handle.startPlayer(true);
                                }

                                final String tbcp_old_owner = obj.getString("tbcp_old_owner");
                                String tbcp_owners = obj.getString("tbcp_request_userid");
                                if (currTBCPUser.equals(tbcp_old_owner)) {
                                    //playBGM(MusicHelper.TYPE_END_GO, Constants.ROOM_TBCP_RELEASE_SUCCESS, userName, null);
                                    roomEvent.onTBCP(Constants.ROOM_TBCP_RELEASE_SUCCESS, userName);
                                    //是否还要在
                                    playBGM(MusicHelper.TYPE_READY_GO, Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS, tbcp_owners, null);
                                } else {
                                    playBGM(MusicHelper.TYPE_READY_GO, Constants.ROOM_OTHER_TBCP_REQUEST_SUCCESS, tbcp_owners, null);
                                }
                                currTBCPUser = tbcp_owners;
                                break;
                            case Constants.CUSTOM_TBCP_SAVE_MP3_RECORD:
                                LogUtils.ELog(TAG, "handleTBCP: 106");
                                String mp3RecordUri = obj.getString("mp3_record_uri");
                                roomEvent.onRecord(mp3RecordUri);
                                break;
                        }
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void takenTBCP(int isForce) {
        currTBCPStatus = 0;//reset
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.takenTBCP(isForce);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.takenTBCP();
        }
    }

    public synchronized void releaseTBCP() {
        currTBCPStatus = 0;//reset
        currTBCPUser = "";
        LogUtils.DLog(TAG, "PocRoom  releaseTBCP");
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.releaseTBCP();
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.releaseTBCP();
        }
    }

    public void sendMsg(String msg) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.sendMsgToRoom(msg);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.sendMsgToRoom(msg);
        }
    }

    public List<String> getMemberList() {
        if (mJanusCreateRoomPluginCallbacks != null) {
            return mJanusCreateRoomPluginCallbacks.getMemberList();
        }
        return null;
    }

    public synchronized void leaveRoom() {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.leaveRoom();
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.leaveRoom();
        }
    }

    //createPlugin
    public synchronized void destroyRoom(long roomId, String secret, @Nullable Boolean permanent) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.destoryRoom(secret, permanent);
        }
    }

    //create join plugin
    public synchronized boolean newJoinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        if (!getJanusServer().isConnected()) {
            return startConnectServer();
        }
        if (mRoomStatus.isCreated() && mRoomStatus.isJoined()) {
            LogUtils.ELog(JanusServer.class.toString(), "mRoomStatus:" + mRoomStatus.toString());
            roomEvent.onRoom(roomId, Constants.ROOM_CREATE_SUCCESS, null);
            return true;
        }
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.joinRoom(roomId, -1, userName, pin, token);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.registerUsername(roomId, userId, userName, pin, token);
        }
        return true;
    }

    //CreatePlugin
    public synchronized boolean newCreateRoom(long roomId, String secret, String pin, String userId, String userName,
                                              String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        if (!getJanusServer().isConnected()) {
            return false;
        }


        if (mRoomStatus.isCreated() && mRoomStatus.isJoined()) {
            LogUtils.ELog(JanusServer.class.toString(), "mRoomStatus:" + mRoomStatus.toString());
            return false;
        }
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.createRoom(roomId, secret, pin, userId, userName,
                    description, permanent, isPrivate);
        }
        return true;
    }

    //create plugin
    public synchronized void editRoom(long roomId, String secret, String newDescription, String newSecret,
                                      String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated,
                                      @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.editroom(roomId, secret, newDescription, newSecret,
                    newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
        }
    }

    //unassociation plugin
    public void existsRoom(long roomId) {
        if (mJaunsUnassociationCallBacks != null) {
            mJaunsUnassociationCallBacks.existRoom(roomId);
        }
    }

    //create plugin
    public void kickPerson(long roomID, int personId, String secret) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.kickPerson(roomID, personId, secret);
        }
    }

    //unassociation plugin
    public void listRooms() {
        if (mJaunsUnassociationCallBacks != null) {
            mJaunsUnassociationCallBacks.listRooms();
        }
    }

    //unassociation plugin
    public void listParticipants(long roomId) {
        if (mJaunsUnassociationCallBacks != null) {
            mJaunsUnassociationCallBacks.listParticipants(roomId);
        }
    }

    //join create plugin
    public void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode,
                        int bitrate, boolean record, String fileName, String display) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
        }

    }

    //join create plugin
    public void unpublish(long roomId) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.unpublish(roomId);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.unpublish(roomId);
        }
    }

    //create plugin
    public void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.configure(roomId, audio, video, data, bitrate, record, fileName, display);
        }
    }

    //join plugin
    public void subscriberJoin(long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc,
                               boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
        }
    }

    //join create plugin
    public void startMedia(long roomId) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.startMedia(roomId);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.startMedia(roomId);
        }
    }

    public void mute(boolean enable) {
        muteState = enable;
        LogUtils.ELog(TAG, "muteState: " + muteState + " address: " + System.identityHashCode(muteState));
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.mute(enable);
        }
//        if (mJanusPublisherPluginCallbacks != null) {
//            mJanusPublisherPluginCallbacks.mute(enable);
//        }
    }

    /**
     * 获取mute状态
     */
    public boolean getMuteState() {
        if (mJanusCreateRoomPluginCallbacks != null) {
            return mJanusCreateRoomPluginCallbacks.getMuteState();
        }
        return mJanusPublisherPluginCallbacks == null || mJanusPublisherPluginCallbacks.getMuteState();
    }

    //join create plugin
    private void pauseMedia(long roomId) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.pauseMedia(roomId);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.pauseMedia(roomId);
        }
    }

    //join plugin
    private void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) {
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.switchSubscriber(roomId, feed, audio, video, data);
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.switchSubscriber(roomId, feed, audio, video, data);
        }
    }

    //unassociation plugin
    public void listforwarders(long roomID, String secret) {
        if (mJaunsUnassociationCallBacks != null) {
            mJaunsUnassociationCallBacks.listforwarders(roomID, secret);
        }
    }

    private boolean createAttachCallback() {
        if (!getJanusServer().peerConnectionFactoryInitialized()) {
            initializeMediaContext(mContext, true, true, true, peerConnectionParameters, null);
        }
        if (bAttached) {
            LogUtils.ELog(JanusServer.class.toString(), "createAttachCallback bAttached, just call attachSuccess().");
            attachSuccess();
            return true;
        }
        bAttached = true;
        if (bCreateFlg == Constants.ROOM_STATUS_CREATE) {
            mJanusCreateRoomPluginCallbacks = new JanusCreateRoomPluginCallbacks(roomId, userName, this);
            getJanusServer().Attach(mJanusCreateRoomPluginCallbacks, true);
        } else if (bCreateFlg == Constants.ROOM_STATUS_JOIN) {
            mJanusPublisherPluginCallbacks = new JanusPublisherPluginCallbacks(roomId, userName, this);
            getJanusServer().Attach(mJanusPublisherPluginCallbacks, true);
        } else {
            if (mJaunsUnassociationCallBacks == null) {
                mJaunsUnassociationCallBacks = new JaunsUnassociationRoomPluginCallbacks(roomId, userName, this);
            }
            getJanusServer().Attach(mJaunsUnassociationCallBacks, false);
        }
        return true;
    }

    @Override
    public void onSuccess() {
        createAttachCallback();
    }

    @Override
    public void onDestroy() {
        if (bCreateFlg == Constants.ROOM_STATUS_CREATE) {
            mJanusCreateRoomPluginCallbacks = null;
        } else if (bCreateFlg == Constants.ROOM_STATUS_JOIN) {
            mJanusPublisherPluginCallbacks = null;
        } else {
            mJaunsUnassociationCallBacks = null;
        }
        getJanusServer().removeCallback(this);
        LogUtils.DLog("zlq", "poc room onDestroy removeCallback");
    }

    @Override
    public void onCallbackError(String error) {
        if (!TextUtils.isEmpty(error) && JanusServer.TOKEN_ERROR.equals(error)){
            roomEvent.onRoom(roomId, Constants.ROOM_SERVER_TOKEN_ERROR, error);
        }else if (!TextUtils.isEmpty(error) && JanusServer.SESSION_ERROR.equals(error)){
            LogUtils.ELog(TAG,"onCallbackError session error "+error);
            roomEvent.onRoom(roomId, Constants.ROOM_SEVER_DISCONNECT, error);
        }else {
//        if (mRoomStatus.isJoined()) {
            roomEvent.onRoom(roomId, Constants.ROOM_SEVER_DISCONNECT, error);
//        } else {
//            roomEvent.onRoom(roomId, Constants.ROOM_SEVER_CONNECT_FAILED, error);
//        }
        }

        leaveRoom();

        //connect failed
        if (mRoomStatus != null) {
            mRoomStatus.setJoined(false);
            mRoomStatus.setCreated(false);
            mRoomStatus.setCreating(false);
        }

        if (getJanusServer() != null) {
            LogUtils.DLog("zlq", "poc room onCallbackError removeCallback");
            getJanusServer().removeCallback(this);
        }
    }

    public void registAttachSuccessCallBack(IJanusAttachSuccessCallBack callBack) {
        attachSuccessCallBack = callBack;
    }

    public void unRegistAttachSuccessCallBack() {
        attachSuccessCallBack = null;
    }

    public boolean initializeMediaContext(Context context, boolean audio, boolean video, boolean videoHwAcceleration, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters, EglBase eglBase) {
        this.peerConnectionParameters = peerConnectionParameters;
        return getJanusServer().initializeMediaContext(context, localProxyVideoSink, remoteProxyRenderer, eglBase, peerConnectionParameters);
    }

    public boolean startConnectServer() {
        if (mRoomStatus.isJoined()) {
            LogUtils.DLog(TAG, "the room:" + roomId + " has already running.");
            return false;
        }
        if (!getJanusServer().isConnected()) {
            if (!getJanusServer().connect()) {
                //connect failed.
                LogUtils.DLog(TAG, "the room server connect failed.");
                return false;
            }
            return true;
        }
        //if has been connected, just attach callback.
        return createAttachCallback();
    }

    public synchronized void hangupPeerConnection() {
//        disconnectServer();
        if (mJanusCreateRoomPluginCallbacks != null) {
            mJanusCreateRoomPluginCallbacks.hangup();
        }
        if (mJanusPublisherPluginCallbacks != null) {
            mJanusPublisherPluginCallbacks.hangup();
        }
        LogUtils.DLog("zlq", "poc room is hangupPeerConnection==removeCallback");
        getJanusServer().removeCallback(this);
    }

    public static void disconnectServer() {
        JanusServer.disconnectServer();
    }

    public interface RoomEvent {
        void onRoom(long roomId, int status, String desc);

        void onTBCP(int status, String ownerUser);

        void onRecord(String mp3RecordUri);
    }


    public static class ProxyVideoSink implements VideoSink {
        private VideoSink target;

        @Override
        synchronized public void onFrame(VideoFrame frame) {
            if (target == null) {
                Logging.d(TAG, "Dropping frame in proxy because target is null.");
                return;
            }

            target.onFrame(frame);
        }

        synchronized public void setTarget(VideoSink target) {
            this.target = target;
        }
    }

    public void setCreated(boolean value) {
        if (mRoomStatus != null) {
            mRoomStatus.setCreated(value);
        }
    }

    public boolean isCreating() {
        return mRoomStatus != null && mRoomStatus.isCreating();
    }

    public boolean isCreated() {
        return mRoomStatus != null && mRoomStatus.isCreated();
    }

    public void setCreating(boolean value) {
        if (mRoomStatus != null) {
            mRoomStatus.setCreating(value);
        }
    }

    public void setJoining(boolean value) {
        if (mRoomStatus != null) {
            mRoomStatus.setJoining(value);
        }
    }

    public void setJoined(boolean value) {
        if (mRoomStatus != null) {
            mRoomStatus.setJoined(value);
        }
    }

    public void setDestroy(boolean value) {
        if (mRoomStatus != null) {
            mRoomStatus.setDestroy(value);
        }
    }

    public void setLeave(boolean value) {
        if (mRoomStatus != null) {
            mRoomStatus.setLeave(value);
        }
    }

    public void updateForceInsert(boolean isForceInsert) {
        if (mRoomStatus != null) {
            mRoomStatus.setForceInsert(isForceInsert);
        }
    }

    public boolean getForceInsertStatus() {
        return mRoomStatus != null && mRoomStatus.isForceInsert();
    }

    public boolean isJoined() {
        return mRoomStatus != null && mRoomStatus.isJoined();
    }

    public void attach(IJanusPluginCallbacks callback) {
        getJanusServer().Attach(callback, true);
    }

    public void attachSuccess() {
        if (attachSuccessCallBack != null) {
            attachSuccessCallBack.createSessionAndAttachSuccess();
        }
    }

    public void onRoomStatus(long roomID, int value, String error) {
        roomEvent.onRoom(roomID, value, error);
    }

    public void onTBCP(int status, String ownerUser) {
        currTBCPStatus = status;
        currTBCPUser = ownerUser;
        roomEvent.onTBCP(status, ownerUser);
    }

    private void playBGM(int musicType, int type, String userName, JanusPluginHandleWithWebrtc handle) {
//        boolean muteState = getMuteState();
        //may be the onTBCP not post
        LogUtils.ELog(TAG, "playBGM: muteState: " + muteState + " address: " + System.identityHashCode(muteState) + "  pocRoom: " + this);
        if (muteState) {
            //静音
            LogUtils.DLog(JanusServer.class.toString(), "playBGM mute state");
            if (handle != null) {
                handle.takenTBCP();
            }
            roomEvent.onTBCP(type, userName);
        } else {
            MusicHelper.MusicPlayer musicPlayer = new MusicHelper(mContext).playMusic(musicType, false);
            musicPlayer.setCompleteListener(new POCWarningToneCompleteCallBack() {
                @Override
                public void completeCallBack() {
                    LogUtils.DLog(JanusServer.class.toString(), "playBGM completeCallBack, currTBCPStatus:" + currTBCPStatus);
                    if (handle != null && currTBCPStatus == ROOM_TBCP_REQUEST_SUCCESS) {
                        handle.takenTBCP();
                    }
                }
            });
            roomEvent.onTBCP(type, userName);
        }
    }

    public void removeCallbackFromJanusServer() {
        getJanusServer().removeCallback(this);
        LogUtils.DLog("zlq", "poc room is removeCallbackFromJanusServer");
    }
}
