package com.xdja.poc.sdk.ui.main.holder;

import android.annotation.SuppressLint;
import android.support.annotation.IdRes;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;

import java.util.List;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/30
 */

@SuppressWarnings({"Convert2Lambda", "CanBeFinal"})
public class PocGroupListHeaderHolder extends BaseViewHolder<DBGroupEntity> {
    private final String mUserId;
    private TextView tvGroupName;
    private TextView tvMemberStatus;
    private ImageView ivAudioSwitch;
    private TextView tvMemberCount;
    private onViewClickListener mListener;
    private onLongClickListener mLongClickListener;
    private ImageView ivGroupAvatar;
    private TextView tvPttView,tvZFYFixed;
    private RelativeLayout itemRootView;
    private boolean isZfy;
    private LinearLayout headerItemView;
    private RelativeLayout otherChannelView;
    private CheckedTextView otherChannelTipView;

    public PocGroupListHeaderHolder(ViewGroup itemView, String mUserId, boolean isZfy, boolean isListExpansion,
                                    onViewClickListener listener, onLongClickListener longClickListener) {
        super(itemView, R.layout.poc_fragment_group_header_item);
        this.mListener = listener;
        this.mLongClickListener = longClickListener;
        this.mUserId = mUserId;
        this.isZfy = isZfy;
        tvGroupName = $(R.id.tv_group_name);
        tvMemberStatus = $(R.id.tv_member_status);
        ivAudioSwitch = $(R.id.iv_audio_switch);
        tvMemberCount = $(R.id.tv_member_count);
        ivGroupAvatar = $(R.id.iv_group_avatar);
        tvPttView = $(R.id.iv_ptt_view);
        itemRootView = $(R.id.rl_item_root);
        tvZFYFixed = $(R.id.tv_zfy_fixed);
        otherChannelView = $(R.id.other_channel_view);
        otherChannelTipView = $(R.id.other_channel_tip_view);

        otherChannelTipView.setChecked(isListExpansion);
        otherChannelTipView.setText(isListExpansion ? "收起" : "展开");
        otherChannelTipView.setChecked(isListExpansion);

        otherChannelView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                boolean isChecked = !otherChannelTipView.isChecked();
                otherChannelTipView.setText(isChecked ? "收起" : "展开");
                otherChannelTipView.setChecked(isChecked);
                mListener.onClick(v.getId(), 0, isChecked);
            }
        });
        itemRootView.setOnClickListener(new View.OnClickListener(){
            @Override
            public void onClick(View v) {
                mListener.onClick(v.getId(), 0, false);
            }
        });
        itemRootView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return mLongClickListener.onLongClick(v);
            }
        });
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void setData(final DBGroupEntity data) {
        super.setData(data);
//        itemView.setBackgroundColor(data.getIsTopStick() ?
//                getContext().getResources().getColor(R.color.poc_item_bg) :
//                getContext().getResources().getColor(R.color.common_white_color));
        if (data.getIsSilence()) {
            ivAudioSwitch.setImageResource(R.drawable.poc_audio_off);
        } else {
            ivAudioSwitch.setImageResource(R.drawable.poc_audio_on);
        }
        if (data.getIsPttKey() && POCClient.getInstance().getPttCode(mUserId) != 0) {
            tvPttView.setVisibility(View.VISIBLE);
        } else {
            tvPttView.setVisibility(View.GONE);
        }
        if (data.getGroupType() == GroupConfig.GROUP_TYPE_FIXED) {
            ivGroupAvatar.setBackgroundResource(R.mipmap.poc_iv_fixed_group_avatar);
            tvZFYFixed.setVisibility(isZfy ? View.VISIBLE:View.GONE);
        } else if (data.getGroupType() == GroupConfig.GROUP_TYPE_COMMON ||
                data.getGroupType() == GroupConfig.GROUP_TYPE_TEMP) {
            ivGroupAvatar.setBackgroundResource(R.mipmap.poc_iv_temp_group_avatar);
            tvZFYFixed.setVisibility(View.GONE);
        }
        tvGroupName.setText(StringUtils.generateContent(data.getRoomName() + ""));
        String memberStatus;
        String memeberIds = data.getMemeberIds();
        List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(memeberIds);
        int[] memberOnLineCount = new int[2];
        memberOnLineCount[0] = data.getOnLineCount();
        memberOnLineCount[1] = allCountList == null ? 0 : allCountList.size();
        String memberOnLineCountStatus = getContext().getResources().getString(R.string.poc_member_online_count_status);
        if (memberOnLineCount[0] <= 0 || data.getStatus() == GroupConfig.GROUP_HANGUP) {
            memberOnLineCount[0] = 0;
            data.setStatus(0);
        }
//        itemView.setBackgroundColor(getContext().getResources().getColor(R.color.common_white_color));
        if (data.getStatus() == GroupConfig.GROUP_HANGUP) {
            tvMemberStatus.setText(R.string.poc_channel_hanup);
//            itemView.setBackgroundColor(getContext().getResources().getColor(R.color.poc_item_bg));
            itemRootView.setBackground(getContext().getDrawable(R.drawable.poc_list_select_off_bg));
            tvMemberStatus.setBackgroundResource(R.drawable.poc_drawable_bg_red);
            tvMemberStatus.setTextColor(getContext().getResources().getColor(R.color.poc_red));
        } else if (data.getStatus() == PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS
                || data.getStatus() == PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS
                || data.getStatus() == PocBroadReceiver.ROOM_RELEASE_TBCP_FAILED
                || data.getStatus() == GroupConfig.GROUP_FREE) {//lyz@xdja.com add for bug.
            itemRootView.setBackground(getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            tvMemberStatus.setText(R.string.poc_channel_free);
            tvMemberStatus.setBackgroundResource(R.drawable.poc_bg_green);
            tvMemberStatus.setTextColor(getContext().getResources().getColor(R.color.poc_green));
        } else if (data.getStatus() == GroupConfig.GROUP_BUSY) {
            itemRootView.setBackground(getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            if (!TextUtils.isEmpty(data.getSpeakerUserName())) {
                if (data.getSpeakerUserName().contains("其他设备")) {
                    tvMemberStatus.setText("您正在其他设备讲话");
                } else {
                    tvMemberStatus.setText(StringUtils.splitDisplayName(3, data.getSpeakerUserName()) + "  正在讲话");
                }
            }

            tvMemberStatus.setBackgroundResource(R.drawable.poc_bg_green);
            tvMemberStatus.setTextColor(getContext().getResources().getColor(R.color.poc_green));
        }
        if (memberOnLineCount[0] > memberOnLineCount[1]) {
            memberOnLineCount[0] = memberOnLineCount[1];
        }
        memberStatus = "<font color='#808080'>" + memberOnLineCountStatus + "</font> " + "<font color='#7eb606'><strong>" + memberOnLineCount[0] + "</strong></font> / " + "<font color='#808080'>" + memberOnLineCount[1] + "</font>";
        tvMemberCount.setText(Html.fromHtml(memberStatus));
        ivAudioSwitch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onClick(v.getId(), getAdapterPosition(), false);
            }
        });
    }

    public interface onViewClickListener {
        void onClick(@IdRes int id, int position, boolean checked);
    }

    public interface onLongClickListener{
        boolean onLongClick(View v);
    }
}
