/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xdja.poc.POCMediaAidlInterface;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.common.utils.UiUtils;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.POCService;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.business.PocNotificationService;
import com.xdja.poc.sdk.config.POCConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.db.manager.PocDaoGroupManager;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.proxy.IPOCGroupLongClickCallBack;
import com.xdja.poc.sdk.proxy.IPOCGroupRefreshCallBack;
import com.xdja.poc.sdk.proxy.IPOCMemberInfoCallBack;
import com.xdja.poc.sdk.proxy.IPOCPushMessageCallBack;
import com.xdja.poc.sdk.proxy.IPOCUserCacheCallBack;
import com.xdja.poc.sdk.proxy.IPOCUserClickCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.receiver.HomeKeyReceiver;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class POCClient {
    private static String TAG = "POCClient";
    private WeakHashMap<Context, ServiceBinder> mConnectionMap;
    public POCMediaAidlInterface mService = null;
    private Gson gson;
    private Context mContext;
    private volatile boolean isInited = false;
    private static boolean isBinding = false;
    private ServiceToken serviceToken;

    private POCClient() {
    }

    public static POCClient getInstance() {
        return SingletonHolder.sInstance;
    }

    public POCClient initSDK(Context context, POCConfig.Configuration pocConfig) {
        GlobalContext.setContext((Context)context);
        this.mConnectionMap = new WeakHashMap();
        this.mContext = context.getApplicationContext();
        ToastUtils.initToast();
        if (pocConfig != null) {
            LogUtils.isOpen = pocConfig.isDebug();
            PreferenceHelper.setInt((String)"poc_call_waiting_time", (int)pocConfig.callWaitTime);
            PreferenceHelper.setInt((String)"max_channel_count", (int)pocConfig.maxChannelCount);
            PreferenceHelper.setInt((String)"max_member_count", (int)pocConfig.maxMeberCount);
            PreferenceHelper.setInt((String)"app_icon", (int)pocConfig.iconId);
            PreferenceHelper.setInt((String)"notification_icon", (int)pocConfig.notificationId);
            if (TextUtils.isEmpty((CharSequence)pocConfig.routerScheme)) {
                throw new IllegalArgumentException("the way of initSDK , routerScheme cant null");
            }
            PreferenceHelper.setString((String)"router_scheme", (String)pocConfig.routerScheme);
            PreferenceHelper.setString((String)"app_name", (String)pocConfig.appName);
            PreferenceHelper.setBoolean((String)"is_show_notification", (boolean)pocConfig.isShowNotification);
            PreferenceHelper.setBoolean((String)"is_show_home_toast", (boolean)pocConfig.isShowHomeToast);
            PreferenceHelper.setString((String)"toast_talking_desc", (String)pocConfig.toastTalkingDesc);
        } else {
            LogUtils.isOpen = false;
        }
        if (PreferenceHelper.getBoolean((String)"is_show_notification", (boolean)true)) {
            Intent intent = new Intent(this.mContext, PocNotificationService.class);
            this.mContext.startService(intent);
        }
        HomeKeyReceiver.registerHomeReceiver();
        this.gson = new Gson();
        return this;
    }

    public void initConfig() {
        if (this.isInited) {
            return;
        }
        this.isInited = true;
        LogUtils.ILog((String)TAG, (String)("Thread.currentThread().getName(): " + UiUtils.getCurrentProcessName((Context)this.mContext)));
        PocBroadReceiver.registerPushReceiver(this.mContext);
        User userInfo = POCUiKitProxyImpl.getInstance().getUserInfo();
        if (userInfo != null) {
            PreferenceHelper.setString((String)"login_account", (String)userInfo.getAccount());
            PreferenceHelper.setString((String)"pref_key_userinfo_name", (String)userInfo.getName());
            PreferenceHelper.setString((String)"pref_key_token", (String)userInfo.getToken());
            PreferenceHelper.getString((String)"companyCode", (String)userInfo.getCompanyCode());
        }
    }

    private ServiceToken bindToService(Context context) {
        if (this.mConnectionMap.size() > 0 && this.serviceToken != null) {
            return this.serviceToken;
        }
        ContextWrapper contextWrapper = new ContextWrapper(context);
        contextWrapper.startService(new Intent((Context)contextWrapper, POCService.class));
        ServiceBinder binder = new ServiceBinder();
        if (contextWrapper.bindService(new Intent().setClass((Context)contextWrapper, POCService.class), (ServiceConnection)binder, 1)) {
            this.mConnectionMap.put((Context)contextWrapper, binder);
            return new ServiceToken(contextWrapper);
        }
        return null;
    }

    public void bindService() {
        this.mContext = GlobalContext.getContext();
        this.initConfig();
        this.serviceToken = this.bindToService(this.mContext);
    }

    public void unbindFromService() {
        this.isInited = false;
        this.unbindFromService(this.serviceToken);
        PocDaoGroupManager.getInstance(GlobalContext.getContext()).close();
    }

    private void unbindFromService(ServiceToken token) {
        this.isInited = false;
        POCClient.destroyAllRoom();
        if (token == null) {
            return;
        }
        ContextWrapper mContextWrapper = token.mWrappedContext;
        ServiceBinder mBinder = this.mConnectionMap.remove(mContextWrapper);
        if (mBinder == null) {
            return;
        }
        if (this.mConnectionMap.isEmpty()) {
            this.mService = null;
        }
        this.mConnectionMap.clear();
        this.serviceToken = null;
        mContextWrapper.unbindService((ServiceConnection)mBinder);
        this.mContext.stopService(new Intent(this.mContext, POCService.class));
    }

    public static void leaveRoom(String userId, String roomId) {
        POCClient.getInstance()._leaveRoom(userId, roomId);
    }

    private void _leaveRoom(String userId, String roomId) {
        try {
            if (this.mService != null) {
                this.mService.leaveRoom(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"leaveRoom: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void removeFromReconnectCache(String roomId) {
        POCClient.getInstance()._removeFromReconnectCache(roomId);
    }

    public void _removeFromReconnectCache(String roomId) {
        try {
            if (this.mService != null) {
                this.mService.removeFromReconnectCache(roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"removeFromReconnectCache: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void destroyRoom(String userId, String roomId) {
        POCClient.getInstance()._destroyRoom(userId, roomId);
    }

    public void _destroyRoom(String userId, String roomId) {
        try {
            if (this.mService != null) {
                this.mService.destroyRoom(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"destroyRoom: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void destroyAllRoom() {
        POCClient.getInstance()._destroyAllRoom();
    }

    public void _destroyAllRoom() {
        try {
            if (this.mService != null) {
                this.mService.destroyAllRoom();
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"destroyRoom: service is null");
            }
            PocBroadReceiver.unregisterPushReceiver(GlobalContext.getContext());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void deleteLocalRoomById(String userId, String roomId) {
        POCClient.getInstance()._deleteLocalRoomById(userId, roomId);
    }

    public void _deleteLocalRoomById(String userId, String roomId) {
        try {
            if (this.mService != null) {
                this.mService.deleteRoomByRoomId(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"destroyRoom: service is null");
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    public static void releaseTBCP(String roomId) {
        POCClient.getInstance()._releaseTBCP(roomId);
    }

    public void _releaseTBCP(String roomId) {
        try {
            if (this.mService != null) {
                this.mService.releaseTBCP(roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"releaseTBCP: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void takenTBCP(String roomId) {
        POCClient.getInstance()._takenTBCP(roomId);
    }

    public void _takenTBCP(String roomId) {
        try {
            if (this.mService != null) {
                this.mService.takenTBCP(roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                POCMemberEvent pocMemberEvent = new POCMemberEvent();
                pocMemberEvent.setMemberInfos(null);
                pocMemberEvent.setRoomId(roomId);
                pocMemberEvent.setStatus(0);
                pocMemberEvent.setUserBehavior(9000);
                POCUiKitProxyImpl.getInstance().notifyMemberEvent(pocMemberEvent);
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"takenTBCP: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void joinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        POCClient.getInstance()._joinRoom(roomId, userId, userName, pin, token);
    }

    public void _joinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        try {
            if (this.mService != null) {
                this.mService.joinRoom(roomId, userId, userName, pin, token);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"joinRoom: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void createRoom(long roomId, String secret, String pin, String userId, String userName, String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        POCClient.getInstance()._createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
    }

    public void _createRoom(long roomId, String secret, String pin, String userId, String userName, String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        try {
            if (this.mService != null) {
                this.mService.createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"createRoom: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void mute(long roomId, boolean enable) {
        POCClient.getInstance()._mute(roomId, enable);
    }

    public void _mute(long roomId, boolean enable) {
        try {
            if (this.mService != null) {
                this.mService.mute(roomId, enable);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"_mute: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void muteAndNotifyUI(long roomId, boolean enable) {
        POCClient.getInstance()._muteAndNotifyUI(roomId, enable);
    }

    public void _muteAndNotifyUI(long roomId, boolean enable) {
        try {
            if (this.mService != null) {
                this.mService.muteAndNotifyUI(roomId, enable);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"muteAndNotifyUI: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static void reMuteLastStatus() {
        POCClient.getInstance()._reMuteLastStatus();
    }

    public void _reMuteLastStatus() {
        try {
            if (this.mService != null) {
                this.mService.reMuteLastStatus();
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"_reMuteLastStatus: service is null");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void muteAllRoomStatus(boolean enable, String channelId) {
        POCClient.getInstance()._muteAllRoomStatus(enable, channelId);
    }

    public void _muteAllRoomStatus(boolean enable, String channelId) {
        try {
            if (this.mService != null) {
                this.mService.muteAllRoomStatus(enable, channelId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"_muteAllRoomStatus: service is null");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void handleNetConnectFailed() {
        POCClient.getInstance()._handleNetConnectFailed();
    }

    public void _handleNetConnectFailed() {
        try {
            if (this.mService != null) {
                this.mService.handleNetConnectFailed();
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"_muteAllRoomStatus: service is null");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void handleNetConnectSuccess() {
        POCClient.getInstance()._handleNetConnectSuccess();
    }

    public void _handleNetConnectSuccess() {
        try {
            if (this.mService != null) {
                this.mService.handleNetConnectSuccess();
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"handleNetConnectSuccess: service is null");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getOnLineMemberList(long roomId) {
        return POCClient.getInstance()._getOnLineMemberList(roomId);
    }

    public List<String> _getOnLineMemberList(long roomId) {
        try {
            if (this.mService != null) {
                return this.mService.getMemberList(roomId);
            }
            if (isBinding) {
                return null;
            }
            isBinding = true;
            this.mConnectionMap.clear();
            POCClient.getInstance().bindService();
            LogUtils.ELog((String)TAG, (String)"getOnLineMemberList: service is null");
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
        return null;
    }

    @Deprecated
    public void removeRoomFromCache(String userId, String roomId) {
        try {
            if (this.mService != null) {
                this.mService.removeRoomFromCache(userId, roomId);
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"removeRoomFromCache: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    @Deprecated
    public void removeRommListFromCache() {
        try {
            if (this.mService != null) {
                this.mService.removeRoomListFromCache();
            } else {
                if (isBinding) {
                    return;
                }
                isBinding = true;
                this.mConnectionMap.clear();
                POCClient.getInstance().bindService();
                LogUtils.ELog((String)TAG, (String)"removeRommListFromCache: service is null");
            }
        }
        catch (RemoteException ignored) {
            LogUtils.ELog((String)TAG, (String)ignored.getMessage());
        }
    }

    public static List<String> getOnLineRoom() {
        return POCClient.getInstance()._getOnLineRoom();
    }

    public List<String> _getOnLineRoom() {
        try {
            if (this.mService != null) {
                return this.mService.getOnLineRoom();
            }
            if (isBinding) {
                return null;
            }
            isBinding = true;
            this.mConnectionMap.clear();
            POCClient.getInstance().bindService();
            LogUtils.ELog((String)TAG, (String)"_getOnLineRoom: service is null");
            return null;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getReconnectRoom() {
        return POCClient.getInstance()._getReconnectRoom();
    }

    public List<String> _getReconnectRoom() {
        try {
            if (this.mService != null) {
                return this.mService.getReconnectRoom();
            }
            if (isBinding) {
                return null;
            }
            isBinding = true;
            this.mConnectionMap.clear();
            POCClient.getInstance().bindService();
            LogUtils.ELog((String)TAG, (String)"_getReconnectRoom: service is null");
            return null;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> String generateListString(List<T> mList) {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        if (mList == null || mList.size() <= 0) {
            return "";
        }
        return this.gson.toJson(mList);
    }

    public List<POCMemberInfo> generateStringToList(String content) {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        return (List)this.gson.fromJson(content, new TypeToken<List<POCMemberInfo>>(){}.getType());
    }

    public static Map<String, String> getAllSpeakers() {
        return POCClient.getInstance()._getAllSpeakers();
    }

    public Map<String, String> _getAllSpeakers() {
        if (this.mService != null) {
            try {
                return this.mService.getAllSpeakers();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        } else {
            if (isBinding) {
                return null;
            }
            isBinding = true;
            this.mConnectionMap.clear();
            POCClient.getInstance().bindService();
            LogUtils.ELog((String)TAG, (String)"getAllSpeakers: service is null");
        }
        return null;
    }

    public List<String> generateStringToListString(String content) {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        return (List)this.gson.fromJson(content, new TypeToken<List<String>>(){}.getType());
    }

    public static List<DBGroupEntity> getAllChannel(Context context, String userId) {
        return PocDaoGroupManager.getInstance(context).getAllPocGroup(userId);
    }

    public static DBGroupEntity getChannelInfoByChannelId(Context context, String channelId) {
        return PocDaoGroupManager.getInstance(context).getChannelInfoByChannelId(channelId);
    }

    public static void registerPOCUserCacheCallBack(IPOCUserCacheCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setUserCacheCallBack(callBack);
    }

    public static void unregisterPOCUserCacheCallBack(IPOCUserCacheCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removeUserCacheCallBack(callBack);
    }

    @Deprecated
    public static void registerPOCMemberInfoCallBack(IPOCMemberInfoCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setMemberInfoCallBack(callBack);
    }

    @Deprecated
    public static void unregisterPOCMemberInfoCallBack(IPOCMemberInfoCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removeMemberInfoCallBack(callBack);
    }

    public static void registerPOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setPOCGroupRefreshCallBack(callBack);
    }

    public static void unregisterPOCGroupRefreshCallBack(IPOCGroupRefreshCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removePOCGroupRefreshCallBack(callBack);
    }

    public static void registerUserClickCallBack(IPOCUserClickCallBack clickCallBack) {
        POCUiKitProxyImpl.getInstance().addUserClickCallBack(clickCallBack);
    }

    public static void unregisterUserClickCallBack(IPOCUserClickCallBack clickCallBack) {
        POCUiKitProxyImpl.getInstance().removeUserClickCallBack(clickCallBack);
    }

    public static void registerPOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setPOCGroupItemLongClickCallBack(callBack);
    }

    public static void unregisterPOCGroupItemLongClickCallBack(IPOCGroupLongClickCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removePOCGroupItemLongClickCallBack(callBack);
    }

    public static void registerPushMessageCallBack(IPOCPushMessageCallBack callBack) {
        POCUiKitProxyImpl.getInstance().setPushMessageCallBack(callBack);
    }

    public static void unregisterPushMessageCallBack(IPOCPushMessageCallBack callBack) {
        POCUiKitProxyImpl.getInstance().removePushMessageCallBack(callBack);
    }

    public static final class ServiceToken {
        public final ContextWrapper mWrappedContext;

        public ServiceToken(ContextWrapper context) {
            this.mWrappedContext = context;
        }
    }

    public class ServiceBinder
    implements ServiceConnection {
        public void onServiceConnected(ComponentName name, IBinder service) {
            POCClient.this.mService = POCMediaAidlInterface.Stub.asInterface(service);
            try {
                isBinding = false;
                POCClient.this.mService.initParams();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            isBinding = false;
            POCClient.this.mService = null;
        }
    }

    private static class SingletonHolder {
        static final POCClient sInstance = new POCClient();

        private SingletonHolder() {
        }
    }
}

