package com.xdja.poc.sdk.business;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Intent;
import android.util.Log;

import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;

import java.math.BigInteger;
import java.util.HashMap;

/**
 * Created by john on 2019/1/14.
 */

public class JobSchedulerService extends JobService {
    private static final String LOG_TAG = "MyJobService";
    public static final String SERVER_URI = "SERVER_URI";
    public static final String ACTION_CHECK_JANUS_SCHEDULE="ACTION_CHECK_JANUS_SCHEDULE";

    @Override
    public void onCreate() {
        super.onCreate();
        LogUtils.ILog(LOG_TAG, "JobSchedulerService created");
    }
    @Override
    public void onDestroy() {
        super.onDestroy();
        LogUtils.ILog(LOG_TAG, "JobSchedulerService destroyed");
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        LogUtils.ILog(LOG_TAG, "JobSchedulerService onStartJob");
        String server_uri = params.getExtras().getString(SERVER_URI);
        if (server_uri != null){
            Intent intent = new Intent();
            intent.setAction(ACTION_CHECK_JANUS_SCHEDULE);
            intent.putExtra(SERVER_URI, server_uri);
            intent.setPackage(GlobalContext.getContext().getPackageName());
            GlobalContext.getContext().sendBroadcast(intent);
//          JanusServer.getJanusServer(server_uri).doSchedule(server_uri);
//          JanusServer.doAllSchedule();
        }
        return false;
    }

    @Override
    public boolean onStopJob(JobParameters jobParameters) {
        return false;
    }

}
