package com.xdja.poc.sdk.business.plugincallback;

import android.support.annotation.Nullable;
import android.util.Log;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusMediaConstraints;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.PluginHandleWebRTCCallbacks;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.JaunsApi;

import org.json.JSONArray;
import org.json.JSONObject;
import org.webrtc.MediaStream;
import org.webrtc.VideoSink;

import java.math.BigInteger;

/**
 * Created by john on 2018/9/6.
 */


public class JanusPublisherPluginCallbacks implements IJanusPluginCallbacks {
    private final String TAG = "JanusPublisher";
    private JanusListenerAttachCallbacks listenerAttachCallbacks = null;
    private JanusPluginHandleWithWebrtc handle = null;
    private BigInteger privateId;

    private long roomId;
    private String userName;
    private POCRoom pocRoom;

    boolean bWaitTakenTBCPResult = false;
    String currTransaction;

    public JanusPublisherPluginCallbacks(long roomId, String userName, POCRoom pocRoom){
        this.roomId = roomId;
        this.userName = userName;
        this.pocRoom = pocRoom;
    }

    public void subscriberJoin(final long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc,
                                boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "subscriberJoin 990 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_JOIN_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_JOIN_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {
                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    pocRoom.onRoomStatus(roomId, Constants.ROOM_JOIN_FAILED, error);
                }
            });
        }
    }

    public void startMedia(final long roomId) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.startMedia(roomId);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "startMedia 1016 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_STARTMEDIA_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_STARTMEDIA_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void pauseMedia(final long roomId) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.pauseMedia(roomId);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "pauseMedia 1042 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_PAUSEMEDIA_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_PAUSEMEDIA_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void switchSubscriber(final long roomId, int feed, boolean audio, boolean video, boolean data) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.switchSubscriber(feed, audio, video, data);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "switchSubscriber 1068 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_SWITCH_SUBSCRIBER_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_SWITCH_SUBSCRIBER_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void publish(final long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode,
                         int bitrate, boolean record, String fileName, String display) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.publish(audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "publish 911 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_PUBLISH_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_PUBLISH_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void unpublish(final long roomID) {
        if (handle != null) {
            final JSONObject jsonObject = JaunsApi.unpublish();
            handle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "unpublish 937 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_UNPUBLISH_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_UNPUBLISH_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void publishOwnFeed() {
        if (handle != null) {
            handle.createOffer(new IPluginHandleWebRTCCallbacks() {
                @Override
                public void onSuccess(JSONObject obj) {
                    try {
                        JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put(Constants.REQUEST, "configure");
                        body.put("audio", true);
                        body.put("video", false);//data
                        body.put("data", true);//data
                        msg.put(Constants.MESSAGE, body);
                        msg.put("jsep", obj);
                        handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));
                    } catch (Exception ex) {

                    }
                }

                @Override
                public JSONObject getJsep() {
                    return null;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints cons = new JanusMediaConstraints();
                    cons.setRecvAudio(false);
                    cons.setRecvVideo(false);
                    cons.setSendAudio(true);
                    return cons;
                }

                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public VideoSink getRemoteSink() {
                    return null;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void registerUsername(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        if (handle != null) {
            JSONObject join = JaunsApi.join(roomId, userId, userName, pin, token);
            handle.sendMessage(new PluginHandleSendMessageCallbacks(join));
        }
    }

    public void newRemoteFeed(BigInteger id) { //todo attach the plugin as a listener
        /*POCRoom.ProxyVideoSink myrenderer = null;
        if (remoteRenderers != null && !remoteRenderers.containsKey(id)) {
            if (!availableRemoteRenderers.isEmpty()) {
                remoteRenderers.put(id, availableRemoteRenderers.pop());
            }
            myrenderer = remoteRenderers.get(id);
        }
        listenerAttachCallbacks = new JanusListenerAttachCallbacks(id, myrenderer);*/
        listenerAttachCallbacks = new JanusListenerAttachCallbacks(roomId, privateId, id, null, pocRoom, false);
        pocRoom.attach(listenerAttachCallbacks);
    }


    @Override
    public void success(JanusPluginHandleWithWebrtc handle1) {
        handle = handle1;
        pocRoom.attachSuccess();
    }

    public void hangup(){
        if (handle != null) {
            handle.hangUp();
        }
    }

    public void leaveRoom() {
        if (listenerAttachCallbacks != null) {
            listenerAttachCallbacks.leaveRoom();
        }

        unPublishRoom();
        if (handle != null) {
            JSONObject obj = new JSONObject();
            final JSONObject msg = new JSONObject();
            try {
                obj.put(Constants.REQUEST, "leave");
                msg.put(Constants.MESSAGE, obj);
            } catch (Exception ex) {
                LogUtils.DLog(TAG, ex.getMessage());
            }
            handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));

            handle.hangUp();
            //after later need detach the server.
            //handle.detatch();
        }
    }

    /*
    {
    "request" : "tbcp",
    "type" : "requst"/"release"
    "room" : <unique ID of the room to join>,
    "transaction": random string,
    "token" : "<invitation token, in case the room has an ACL; optional>"
    }
    */
    public void mute(boolean enable){
        if(listenerAttachCallbacks != null){
            listenerAttachCallbacks.mute(enable);
        }
    }

    public boolean getMuteState() {
        if (listenerAttachCallbacks != null)
            return listenerAttachCallbacks.getMuteState();
        return true;
    }
    public void takenTBCP() {
        bWaitTakenTBCPResult = true;
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        currTransaction = stringGenerator.randomString(12);
        JSONObject obj = new JSONObject();
        try {
            obj.put(Constants.REQUEST, "tbcp");
            obj.put("type", "requst");
            obj.put("room", roomId);
            obj.put("transaction", currTransaction);
            if (handle != null) {
                handle.sendMsgOverDataChannel(obj.toString());
            }
        } catch (Exception ex) {

        }
    }

    public void releaseTBCP() {
        JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
        currTransaction = stringGenerator.randomString(12);
        JSONObject obj = new JSONObject();
        try {
            obj.put(Constants.REQUEST, "tbcp");
            obj.put("type", "release");
            obj.put("room", roomId);
            obj.put("transaction", currTransaction);
            if (handle != null) {
                handle.sendMsgOverDataChannel(obj.toString());
            }
        } catch (Exception ex) {

        }
        if (handle != null) {
            handle.releaseTBCP();
        }
    }

    public void sendMsgToRoom(String msg) {
        if (handle != null) {
            handle.sendMsgOverDataChannel(msg);
        }
        if (listenerAttachCallbacks != null) {
            listenerAttachCallbacks.sendMsgToRoom(msg);
        }
    }

    private void unPublishRoom() {
        if (handle != null) {
            JSONObject obj = new JSONObject();
            final JSONObject msg = new JSONObject();
            try {
                obj.put(Constants.REQUEST, "unpublish");
                msg.put(Constants.MESSAGE, obj);
            } catch (Exception ex) {

            }
            handle.sendMessage(new PluginHandleSendMessageCallbacks(msg));

        }
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsepLocal) {
        try {
            String event = msg.getString("videoroom");
            if (event.equals("joined")) {
                if (msg.has("privateId")) {
                    privateId = new BigInteger(msg.getString("private_id"));
                } else {
                    privateId = new BigInteger(msg.getString("id"));
                }
                publishOwnFeed(); //lyz del
                if (msg.has(Constants.PUBLISHERS)) {
                    JSONArray pubs = msg.getJSONArray(Constants.PUBLISHERS);
                    for (int i = 0; i < pubs.length(); i++) {
                        JSONObject pub = pubs.getJSONObject(i);
                        BigInteger tehId = new BigInteger(pub.getString("id"));
                        newRemoteFeed(tehId);
                    }
                }
            } else if (event.equals("destroyed")) {
                pocRoom.onRoomStatus(roomId, Constants.ROOM_STATUS_DESTORYED, event);
                //if (janusServer != null) {
                //    janusServer.destroy();//no need left.
                //}
                //after later need detach the server.
                handle.detach();
            } else if (event.equals("event")) {
                if (msg.has(Constants.PUBLISHERS)) {
                    JSONArray pubs = msg.getJSONArray(Constants.PUBLISHERS);
                    for (int i = 0; i < pubs.length(); i++) {
                        JSONObject pub = pubs.getJSONObject(i);
                        if (listenerAttachCallbacks == null) {
                            newRemoteFeed(new BigInteger(pub.getString("id")));
                        } else {
                            if (pub.has("display")) {
                                String user = pub.getString("display");
                                pocRoom.onRoomStatus(roomId, Constants.ROOM_OTHER_USER_INCOMING, user);
                            }
                        }
                    }
                } else if (msg.has("leaving")) {
                    String leaving_user = msg.getString("leaving");
                    if (leaving_user != null && !leaving_user.equals(userName)) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_OTHER_USER_LEFT, msg.getString("leaving"));
                    }
                } else if (msg.has("unpublished")) {
//                        handle.detach();//unpublished

                    String user = msg.getString("unpublished");
                    if (user != null && user.equals(userName)) {
                        handle.detach();
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_LEAVE_SUCCESS, user);
                    } else {
                        //other unpublished.
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_OTHER_USER_LEFT, user);
                    }
                } else if (msg.has("error_code")) {
                        /*
                           "videoroom": "event",
                           "error_code": 426,
                           "error": "No such room (3636)"
                         */
                    int error_code = msg.getInt("error_code");
                    if (error_code == 426) {
                        String error = msg.getString("error");
                        pocRoom.setJoined(false);
                        pocRoom.setJoining(false);
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_STATUS_JOIN_FAILED_FOR_NO_ROOM, error);
                    }
                }
                //todo error
                if (jsepLocal != null) {
                    handle.handleRemoteJsep(new PluginHandleWebRTCCallbacks(null, jsepLocal, false));
                }
            }
        } catch (Exception ex) {

        }
    }

    @Override
    public void onLocalStream(MediaStream stream) {
    }

    @Override
    public void onRemoteStream(MediaStream stream) {

    }

    @Override
    public void onDataOpen(Object data) {

    }

    @Override
    public void onData(Object data) {
        boolean ret = true;
        if (data instanceof JSONObject) {
            ret = false;
        }
        if (ret) {
            return;
        }


        if(!bWaitTakenTBCPResult){
            ack(data);
        }
        pocRoom.handleTBCP(bWaitTakenTBCPResult, (JSONObject) data, currTransaction, handle, /*listenerAttachCallbacks.getHandler()*/null);
        if (bWaitTakenTBCPResult) {
            bWaitTakenTBCPResult = false;
            currTransaction = "";
        }
    }
    private void ack(Object data) {
        try {
              /*  JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
                currTransaction = stringGenerator.randomString(12);*/
            JSONObject obj=new JSONObject();
            obj.put("request", "tbcp");
            obj.put("type", "ack");
            obj.put("room", roomId);
            // obj.put("transaction",currTransaction);
            if(handle!=null){
                handle.sendMsgOverDataChannel(obj.toString());
            }

        } catch (Exception ex) {

        }
    }

    @Override
    public void onCleanup() {

    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }

    @Override
    public void onCallbackError(String error) {

    }

    @Override
    public void onDetached() {
        handle = null;

    }
}