package com.xdja.poc.sdk.config;

/**
 * POC-Sdk
 * 功能
 * 描述
 * created by Wwq : 2018/10/29
 */

public class POCConfig {
    public static class Configuration {
        public boolean isDebug = true;
        public int callWaitTime = 30;
        public int maxChannelCount = 5;
        public int maxMeberCount = 30;
        public String appName = "安通对讲";
        public int iconId = -1;
        public int notificationId = -1;
        public boolean isShowNotification = false;//是否显示通知栏
        public boolean isShowHomeToast = false;
        public String toastTalkingDesc;
        public String routerScheme;
        public boolean isInterceptVolumKey=false;
        public boolean isSaveRecord=true;
        public boolean isShowHistoryRecord=true;
        public String selfSpeakingTips;
        public Configuration(boolean isDebug, int callWaitTime, int maxChannelCount, String appName,
                             int iconId, int notificationId, int maxMeberCount,
                             boolean isShowNotification, boolean isShowHomeToast, String toastTalkingDesc
                ,   String routerScheme,boolean isInterceptVolumKey,boolean isSaveRecord,boolean isShowHistoryRecord
                ,String selfSpeakingTips) {
            this.isDebug = isDebug;
            this.callWaitTime = callWaitTime;
            this.maxChannelCount = maxChannelCount;
            this.maxMeberCount = maxMeberCount;
            this.appName = appName;
            this.iconId = iconId;
            this.notificationId = notificationId;
            this.isShowNotification = isShowNotification;
            this.isShowHomeToast = isShowHomeToast;
            this.toastTalkingDesc = toastTalkingDesc;
            this.routerScheme = routerScheme;
            this.isInterceptVolumKey=isInterceptVolumKey;
            this.isSaveRecord=isSaveRecord;
            this.isShowHistoryRecord=isShowHistoryRecord;
            this.selfSpeakingTips=selfSpeakingTips;
        }

        public boolean isDebug() {
            return this.isDebug;
        }

        public static class Builder {
            private boolean isDebug = true;
            private int callWaitTime = 30;
            public int maxChannelCount = 5;
            public int maxMeberCount = 30;
            public String appName = "安通对讲";
            public int iconId = -1;
            public int notificationId = -1;
            public boolean isShowNotification = false;
            public boolean isShowHomeToast = false;
            public String toastTalkingDesc;
            public String routerScheme;
            public boolean isInterceptVolumKey=false;
            public boolean isSaveRecord;
            public boolean isShowHistoryRecord;
            public String selfSpeakingTips;
            public Configuration build() {
                return new Configuration(isDebug, callWaitTime, maxChannelCount, appName, iconId, notificationId,
                        maxMeberCount, isShowNotification, isShowHomeToast, toastTalkingDesc
                        ,  routerScheme,isInterceptVolumKey,isSaveRecord,isShowHistoryRecord,selfSpeakingTips);
            }

            public Builder setCallWaitTime(int callWaitTime) {
                this.callWaitTime = callWaitTime;
                return this;
            }

            public Builder setMaxChannelCount(int maxChannelCount) {
                this.maxChannelCount = maxChannelCount;
                return this;
            }

            public Builder isDebug(boolean isDebug) {
                this.isDebug = isDebug;
                return this;
            }

            public Builder setAppName(String appName) {
                this.appName = appName;
                return this;
            }

            public Builder setIconId(int iconId) {
                this.iconId = iconId;
                return this;
            }

            public Builder setNotificationId(int notificationId) {
                this.notificationId = notificationId;
                return this;
            }

            public Builder setMaxMeberCount(int maxMeberCount) {
                this.maxMeberCount = maxMeberCount;
                return this;
            }

            public Builder isShowNotification(boolean isShowNotification) {
                this.isShowNotification = isShowNotification;
                return this;
            }

            public Builder isShowHomeToast(boolean isShowHomeToast) {
                this.isShowHomeToast = isShowHomeToast;
                return this;
            }

            public Builder setToastTalkingDesc(String toastTalkingDesc) {
                this.toastTalkingDesc = toastTalkingDesc;
                return this;
            }
            public Builder setRouterScheme(String routerScheme) {
                this.routerScheme = routerScheme;
                return this;
            }

            public Builder setInterceptVolumKey(boolean interceptVolumKey) {
                isInterceptVolumKey = interceptVolumKey;
                return this;
            }

            public Builder setSaveRecord(boolean saveRecord) {
                isSaveRecord = saveRecord;
                return this;
            }

            public Builder setShowHistoryRecord(boolean showHistoryRecord) {
                isShowHistoryRecord = showHistoryRecord;
                return this;
            }

            public Builder setSelfSpeakingTips(String selfSpeakingTips) {
                this.selfSpeakingTips = selfSpeakingTips;
                return this;
            }
        }
    }
}
