package com.xdja.poc.sdk.greendao;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.greendao.dao.POCHistoryMessageDao;
import com.xdja.poc.sdk.greendao.manager.GreenDaoManager;
import com.xdja.poc.sdk.record.RecordMessage;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * Created by xdjaxa on 2019/1/11.
 */

public class HistoryMessageDBHelper {

    private static final String TAG = HistoryMessageDBHelper.class.getSimpleName();
    private final GreenDaoManager daoManager;
    private static HistoryMessageDBHelper dbHelper;
    private static final int MAX_CACHE_MESSAGE_SIZE = 3000;

    private HistoryMessageDBHelper() {
        daoManager = GreenDaoManager.getInstance();
    }

    public static HistoryMessageDBHelper getInstance() {
        if (dbHelper == null) {
            synchronized (HistoryMessageDBHelper.class) {
                if (dbHelper == null) {
                    dbHelper = new HistoryMessageDBHelper();
                }
            }
        }
        return dbHelper;
    }

    public synchronized void insertOrUpdate(List<POCHistoryMessage> datas) {
        delete();
        getPocHistoryMessageDao().insertOrReplaceInTx(datas);
        LogUtils.DLog(TAG, "insert success");
    }

    public synchronized List<POCHistoryMessage> query(String room, int pageSize, long time) {
        List<POCHistoryMessage> result = null;
        if (time == 0) {
            result = getPocHistoryMessageDao().queryBuilder()
                    .where(POCHistoryMessageDao.Properties.GroupUri.eq(room))
                    .orderDesc(POCHistoryMessageDao.Properties.SyncTime)
                    .limit(pageSize)
                    .build()
                    .list();
        } else {
            result = getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.SyncTime.lt(time),
                    POCHistoryMessageDao.Properties.GroupUri.eq(room))
                    .orderAsc(POCHistoryMessageDao.Properties.SyncTime)
                    .limit(pageSize)
                    .build()
                    .list();
        }
        Collections.sort(result, new Comparator<POCHistoryMessage>() {
            @Override
            public int compare(POCHistoryMessage o1, POCHistoryMessage o2) {
                return o1.getSyncTime().compareTo(o2.getSyncTime());
            }
        });
        LogUtils.DLog(TAG, "query success");
        return result;
    }

    public synchronized void delete() {
        if (getPocHistoryMessageDao().count() >= MAX_CACHE_MESSAGE_SIZE) {
            List<POCHistoryMessage> result = getPocHistoryMessageDao().queryBuilder()
                    .orderAsc(POCHistoryMessageDao.Properties.SyncTime)
                    .limit(200)
                    .build()
                    .list();
            if (result != null) {
                getPocHistoryMessageDao().deleteInTx(result);
            }
            LogUtils.DLog(TAG, "delete success");
        }
    }

    public long count(String room) {
        return getPocHistoryMessageDao()
                .queryBuilder()
                .where(POCHistoryMessageDao.Properties.GroupUri.eq(room))
                .build()
                .list()
                .size();
    }

    private POCHistoryMessageDao getPocHistoryMessageDao() {
        return daoManager.getDaoSession().getPOCHistoryMessageDao();
    }
}
