package com.xdja.poc.sdk.manager;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;

import static android.content.Context.KEYGUARD_SERVICE;

/**
 * Created by Administrator on 2018/8/27.
 */

public class AMnager {
    public static String TAG = "AManager";
    public static String URI_END =  "://";
    public static final String INTENT_KEY_CALL_WAITING_DATE = "intent_key_call_waiting_data";

    /**
     * 启动对讲会话界面
     *
     * @param context  上下文
     * @param position
     */
    public static void startPOCConversionActivity(Context context, DBGroupEntity group, String channelName, int position, boolean isCallMember) {
        try {
            if (context == null) {
                LogUtils.ELog(TAG, "startPOCChatActivity context can't null");
                return;
            }
            if(TextUtils.isEmpty(PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,""))){
                Log.e("poc","pocSDK,routerSchem cant null");
            }
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+URI_END;
            Uri uri = Uri.parse(URI_STRING + context.getPackageName()).buildUpon().appendPath("pocConversion").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            intent.putExtra("group", group);
            intent.putExtra("isCallMember", isCallMember);
            intent.putExtra(GroupConfig.GROUP_UI_POSITION, position);
            intent.putExtra(GroupConfig.CHANNEL_NAME, channelName);
            context.startActivity(intent);
        } catch (Throwable e) {
            LogUtils.ELog(e);
        }
    }

    /**
     * 启动POC 主界面
     *
     * @param context 上下文
     */
    public static void startPOCMainActivity(Context context, boolean isInitView,String channelId) {
        try {
            if (context == null) {
                LogUtils.ELog(TAG, "startPOCMainActivity context can't null");
                return;
            }
            if(TextUtils.isEmpty(PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,""))){
                Log.e("poc","pocSDK,routerSchem cant null");
            }
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+URI_END;
            Uri uri = Uri.parse(URI_STRING + context.getPackageName()).buildUpon().appendPath("pocMain").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            intent.putExtra("isInitView", isInitView);
            intent.putExtra("channelId",channelId);
            context.startActivity(intent);
        } catch (Throwable e) {
            LogUtils.ELog(e);
        }
    }


    /**
     * 启动POC 通讯录页面
     *
     * @param context
     */
    public static void startPOCMemberListActivity(Context context, int type) {
        try {
            if (context == null) {
                LogUtils.ELog(TAG, "startPOCMainActivity context can't null");
                return;
            }
            if(TextUtils.isEmpty(PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,""))){
                Log.e("poc","pocSDK,routerSchem cant null");
            }
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+URI_END;
            Uri uri = Uri.parse(URI_STRING + context.getPackageName()).buildUpon().appendPath("pocFriendList").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            intent.putExtra(GroupConfig.MEMBER_ACTIVITY_TYPE, type);
            context.startActivity(intent);
        } catch (Throwable e) {
            LogUtils.ELog(e);
        }
    }

    /**
     * 启动设置
     *
     * @param context
     */
    public static void startPOCSettingActivity(Context context) {
        try {
            if (context == null) {
                LogUtils.ELog(TAG, "context can't null");
                return;
            }
            if(TextUtils.isEmpty(PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,""))){
                Log.e("poc","pocSDK,routerSchem cant null");
            }
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+URI_END;
            Uri uri = Uri.parse(URI_STRING + context.getPackageName()).buildUpon().appendPath("setting").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            context.startActivity(intent);
        } catch (Exception e) {
            LogUtils.ELog(e);
        }
    }

    /**
     * 启动设置
     *
     * @param context
     */
    public static void startLogin(Context context) {
        try {
            if (context == null) {
                LogUtils.ELog(TAG, "context can't null");
                return;
            }
            if(TextUtils.isEmpty(PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,""))){
                Log.e("poc","pocSDK,routerSchem cant null");
            }
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+URI_END;
            Uri uri = Uri.parse(URI_STRING + context.getPackageName()).buildUpon().appendPath("login").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } catch (Exception e) {
            LogUtils.ELog(e);
        }

    }

    /**
     * 启动呼叫等待界面
     *
     * @param context
     */
    public static void startPOCCallWaitingActivity(Context context, POCCallMessage callMessage) {
        try {
            if (context == null) {
                LogUtils.ELog(TAG, "context can't null");
                return;
            }
            // 屏幕解锁
            KeyguardManager keyguardManager = (KeyguardManager) context
                    .getSystemService(KEYGUARD_SERVICE);
            KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock("unLock");
            // 屏幕锁定
            keyguardLock.reenableKeyguard();
            keyguardLock.disableKeyguard(); // 解锁
            if(TextUtils.isEmpty(PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,""))){
                Log.e("poc","pocSDK,routerSchem cant null");
            }
            String URI_STRING= PreferenceHelper.getString(UserConfig.ROUTER_SCHEME,"xdja")+URI_END;
            Uri uri = Uri.parse(URI_STRING + context.getPackageName()).buildUpon().appendPath("pocCallWaiting").build();
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            intent.putExtra(INTENT_KEY_CALL_WAITING_DATE, callMessage);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } catch (Exception e) {
            LogUtils.ELog(e);
        }
    }

}
