package com.xdja.poc.sdk.record.http;

import java.util.Map;

import okhttp3.Callback;
import okhttp3.Request;

/**
 * Created by gouhao on 5/29/2018.
 */

public class HttpClientProxy implements IHttpClient {
    private static final String HTTPS_PREFIX = "https";

    private IHttpClient httpClient;
    private IHttpClient httpsClient;

    HttpClientProxy() {
    }

    @Override
    public int exec(String url, Map<String, Object> params, Map<String, String> headers, Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().exec(url, params, headers, callback);
        } else {
            return getHttpClient().exec(url, params, headers, callback);
        }
    }

    @Override
    public int exec(String methodType, String url, Object body, Map<String, String> headers, Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().exec(methodType, url, body, headers, callback);
        } else {
            return getHttpClient().exec(methodType, url, body, headers, callback);
        }
    }

    @Override
    public int execFormData(String url, Map<String, String> params, Map<String, String> headers, Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().execFormData(url, params, headers, callback);
        } else {
            return getHttpClient().execFormData(url, params, headers, callback);
        }
    }

    @Override
    public int execGet(String url, Map<String, String> headers, Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().execGet(url, headers, callback);
        } else {
            return getHttpClient().execGet(url, headers, callback);
        }
    }

    @Override
    public int request(HttpRequest request, Callback callback) {
        if (request.getUrl().startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().request(request, callback);
        } else {
            return getHttpClient().request(request, callback);
        }
    }

    @Override
    public int uploadFile(HttpUploadFileRequest request, UploadFileCallback callback) {
        if (request.getUrl().startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().uploadFile(request, callback);
        } else {
            return getHttpClient().uploadFile(request, callback);
        }
    }

    @Override
    public void cancelRequest(int requestId) {
        if (httpClient != null) {
            httpClient.cancelRequest(requestId);
        }
        if (httpsClient != null) {
            httpsClient.cancelRequest(requestId);
        }
    }

    /**
     * 延迟获取HttpClient，httpsClient
     * <p>
     * 这个两个方法必须加锁，否则会生成两个client，会出现相同的requestId，导致用户层程序出错
     * 详见：BUG-46612
     */

    private synchronized IHttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = new HttpClient();
        }
        return httpClient;
    }

    private synchronized IHttpClient getHttpsClient() {
        if (httpsClient == null) {
            httpsClient = new HttpsClient();
        }
        return httpsClient;
    }

    @Override
    public int downloadFile(Request request, okhttp3.Callback callback) {
        if (request.url().toString().startsWith(HTTPS_PREFIX)) {
            return getHttpsClient().downloadFile(request, callback);
        } else {
            return getHttpClient().downloadFile(request, callback);
        }
    }
}
