package com.xdja.poc.sdk.record.http;

import android.support.annotation.Keep;

import com.google.gson.Gson;

import java.util.Map;

/**
 * Created by gouhao on 10/25/2018.
 */
@Keep
public class HttpRequest {
    private String url;
    private Map<String, String> headers;
    private String requestType = BaseHttpClient.DEFAULT_CONTENT_TYPE;
    private String method = IHttpClient.METHOD_TYPE_POST;
    private Object param;

    public HttpRequest(String url) {
        this(url, null);
    }

    public HttpRequest(String url, Object param) {
        this.url = url;
        this.param = param;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getRequestType() {
        return requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getParamJsonString(){
        if(param == null){
            return "{}";
        }
        if(param instanceof String){
            return (String) param;
        }
        return new Gson().toJson(param);
    }

    public void setParam(Object param) {
        this.param = param;
    }


}
