package com.xdja.poc.sdk.ui.conversion;

import android.app.ProgressDialog;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.poc.common.event.NetWorkConnectEvent;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ViewUtils;
import com.xdja.poc.common.view.CircleImageView;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.event.DimissDialogEvent;
import com.xdja.poc.sdk.event.HomeOrRecentEvent;
import com.xdja.poc.sdk.event.POCChannelInfoResult;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.IPHost;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.Map;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/9/5
 */

public class ConversionCallWaitingActivity extends BaseScreenActivity implements View.OnClickListener {
    private LinearLayout llReject, llAgree;
    private TextView tvUserName, tvCallDesc;
    private String mUserId;
    private POCCallMessage callMessage;
    private String senderUserId;
    private String roomId;
    private String ownerId;
    private String groupName;
    private String userName;
    private String memberIds;
    private Disposable mDisposable;
    public static int CALL_DELAY = 30;//延时30秒
    private ProgressDialog mProgressDialog;
    private CircleImageView circleImageView;

    @Override
    protected int getTranslucentStatusBarColor() {
        return getResources().getColor(R.color.common_main_color);
    }

    @Override
    protected void initView() {
        super.initView();
        Constants.isReject=false;
        Constants.isScreenOn=true;
        CALL_DELAY = PreferenceHelper.getInt(UserConfig.CALL_WAITING_TIME, 30);
        llReject = $(R.id.ll_reject);
        llAgree = $(R.id.ll_accept);
        tvUserName = $(R.id.tv_user_name);
        tvCallDesc = $(R.id.tv_call_desc);
        circleImageView = $(R.id.tv_user_avatar);
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        userName = mUserId;//自己的用户名
        callMessage = (POCCallMessage) getIntent().getSerializableExtra(AMnager.INTENT_KEY_CALL_WAITING_DATE);
        String icon = callMessage.getIcon();
        Map<String, POCMemberInfo> userInfo = POCUiKitProxyImpl.getInstance().getUserInfosCache();
        if (userInfo != null && userInfo.size() > 0 && userInfo.containsKey(callMessage.getUserId()) && !StringUtils.isEmpty(userInfo.get(callMessage.getUserId()).getName())) {
            callMessage.setUserName(userInfo.get(callMessage.getUserId()).getName());
            if (StringUtils.isEmpty(icon)) {
                icon = userInfo.get(callMessage.getUserId()).getIcon();
            }
            if (!StringUtils.isEmpty(icon)) {
                // TODO: 2018/11/13
                if (!icon.startsWith("http")) {
                    icon = IPHost.getMisServer() + icon;
                }
                ViewUtils.intoView(this, circleImageView, icon);
            }
        }
        senderUserId = callMessage.getUserId();
        ownerId = callMessage.getOwnerId();
        roomId = callMessage.getRoomId();
        memberIds = callMessage.getMemberIds();
        groupName = callMessage.getGroupName();
        tvUserName.setText(callMessage.getUserName());
        tvCallDesc.setText("正在发起呼叫");
        RingPlayer.getInstance(this).playIncomingRing(true, true);
        MessageProxy.sendSwitchMuteStatus(true);
        MessageProxy.updateNotificationCallMessage(this, callMessage, true);
        EventBus.getDefault().post(new DimissDialogEvent());
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void onScreenOn() {
        super.onScreenOn();
    }

    @Override
    protected void initEvent() {
        llReject.setOnClickListener(this);
        llAgree.setOnClickListener(this);
        initPresenter();
        timerDelay(CALL_DELAY);
    }

    private void initPresenter() {
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected int generateLayout() {
        return R.layout.poc_activity_call_waiting;
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.ll_reject) {
            // TODO: 2018/10/19 SDK: 拒绝成员
            Constants.isReject=true;
            POCUiKitProxyImpl.getInstance().notifyUserReject(senderUserId, roomId);
            finish();
//            POCClient.sendPocRejectCall(PushProxy.generateRejectCallJson(mUserId, roomId), senderUserId,roomId);
        } else if (v.getId() == R.id.ll_accept) {
            // TODO: 2018/10/19 SDK: 同意接听
            showloading("正在获取频道信息,请稍后...");
            POCUiKitProxyImpl.getInstance().notifyUserAccepet(senderUserId, roomId, groupName);
            cancel();
            timerDelay(15);
//            startNewConversionActivity();
        }

    }

    private void showloading(String message) {
        if (mProgressDialog == null) {
            mProgressDialog = new ProgressDialog(this);
            mProgressDialog.setIndeterminateDrawable(getResources().getDrawable(com.xdja.poc.sdk.R.drawable.poc_progressbar));
            mProgressDialog.setIndeterminate(true);
            mProgressDialog.setCancelable(false);
        }
        mProgressDialog.setMessage(message);
        if (mProgressDialog != null && !mProgressDialog.isShowing()) {
            // 让ProgressDialog显示
            mProgressDialog.show();
        }
    }

    public void hideLoading() {
        try {
            if (mProgressDialog != null && mProgressDialog.isShowing()) {
                mProgressDialog.dismiss();
            }
        } catch (Exception e) {
            LogUtils.ELog(e);
        }
    }

//    /**
//     * 启动对讲界面
//     */
//    private void startNewConversionActivity() {
//        String memberInfos = GroupUtils.generateMemberInfosListring(memberIds, roomId);
//        DBGroupEntity entity = GroupUtils.generateTempGroupEntity(mUserId, roomId, memberInfos, groupName, senderUserId);
//        AMnager.startPOCConversionActivity(ConversionCallWaitingActivity.this, entity, -1);
//    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MessageProxy.sendSwitchMuteStatus(false);
        cancel();
    }

    protected void onNetChanged(NetWorkConnectEvent netWorkConnectEvent) {
        super.onNetChanged(netWorkConnectEvent);
        if (!(boolean) netWorkConnectEvent.getT()) {//断网
            ToastUtils.showToast(getResources().getString(R.string.common_net_failed));
            finish();
        } else {
            //网络可用
        }
    }

    /**
     * 延时操作
     */
    private void timerDelay(int delay) {
        Observable.timer(delay, TimeUnit.SECONDS)
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Observer<Long>() {
                    @Override
                    public void onSubscribe(@io.reactivex.annotations.NonNull Disposable d) {
                        mDisposable = d;
                    }

                    @Override
                    public void onNext(@io.reactivex.annotations.NonNull Long aLong) {
                        // TODO: 2018/10/19 SDK: 发送延迟推送
                        POCUiKitProxyImpl.getInstance().notifyUserNoResponse(senderUserId, roomId);
//                        POCClient.sendPocDelayCall(PushProxy.generateCallDelayJson(mUserId, userName), senderUserId, roomId);
                    }

                    @Override
                    public void onError(@io.reactivex.annotations.NonNull Throwable e) {
                        hideLoading();
                        cancel();
                        finish();
                    }

                    @Override
                    public void onComplete() {
                        hideLoading();
                        cancel();
                        finish();
                    }
                });
    }

    /**
     * 处理强制退出
     */
    public void dealForceQuit(){
        POCUiKitProxyImpl.getInstance().notifyUserNoResponse(senderUserId, roomId);
        cancel();
    }

    /**
     * 取消
     */
    private void cancel() {
        if (mDisposable != null && !mDisposable.isDisposed()) {
            mDisposable.dispose();
        }
        RingPlayer.getInstance(this).release();
        MessageProxy.updateNotificationCallMessage(this, callMessage, false);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onHomeKeyOrRecentKetEvent(HomeOrRecentEvent event) {
        MessageProxy.updateNotificationCallMessage(this, callMessage, true);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onChnnelInfoEvent(POCChannelInfoResult channelInfoResult) {
        hideLoading();
        if (channelInfoResult != null && channelInfoResult.getT() != null && channelInfoResult.getT().booleanValue()) {
            finish();
        }
    }
}
