package com.xdja.poc.sdk.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;

import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.config.UserConfig;

/**
 * POC-Sdk
 * 功能
 * 描述
 * created by Wwq : 2018/11/19
 */

public class ChannelDeletedTipDialog extends Dialog {
    private TextView tvConfirm, tvDesc;
    private onConfirmClickListener confirmClickListener;

    public ChannelDeletedTipDialog(@NonNull Context context) {
        super(context);
        getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        View view = LayoutInflater.from(context).inflate(R.layout.poc_view_channel_deleted_tips, null);
        int screenWidth = DisplayUtil.getScreenWidth(context);
        setContentView(view);
        int itemHeight = DisplayUtil.dip2px(context, 200);
        getWindow().setLayout(screenWidth * 5 / 6, itemHeight);
        tvConfirm = view.findViewById(R.id.tv_confirm);
        tvDesc = view.findViewById(R.id.tv_desc_content);
        tvConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (confirmClickListener != null) {
                    confirmClickListener.onConfirm();
                }
            }
        });
    }

    public void setConfirmClickListener(onConfirmClickListener confirmClickListener) {
        this.confirmClickListener = confirmClickListener;
    }

    public void showD(String content) {
        tvDesc.setText(content);
        show();
    }

    public interface onConfirmClickListener {
        void onConfirm();
    }
}
