package com.xdja.poc.sdk.ui.history;

import android.support.annotation.Keep;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;

import java.io.Serializable;

import org.greenrobot.greendao.annotation.Generated;

/**
 * 历史消息
 * Created by xdjaxa on 2019/1/10.
 */

@Keep
@Entity(nameInDb = "remote_message_table")
public class POCHistoryMessage implements Serializable {

    private static final long serialVersionUID = 536871200L;

    @Id
    String id; //主键
    String groupUri; //群组地址
    String owner; //归属
    String type; //类型 1文本2图片3语音
    String content; //文本内容
    String fileUrl; //文件路径
    String fileType; //文件扩展名
    String fileSize; //文件大小（bit）/语音时长(秒)
    String isCancel; //是否撤回
    String key; //备注
    String syncTime; //消息时间戳
    String status; //状态 Y 已启用 N 已禁用
    String createTime; //记录消息时间
    String creator; //记录人
    String updateTime; //更新时间
    String updator; //操作人

    @Generated(hash = 1126113079)
    public POCHistoryMessage(String id, String groupUri, String owner, String type,
                             String content, String fileUrl, String fileType, String fileSize,
                             String isCancel, String key, String syncTime, String status,
                             String createTime, String creator, String updateTime, String updator) {
        this.id = id;
        this.groupUri = groupUri;
        this.owner = owner;
        this.type = type;
        this.content = content;
        this.fileUrl = fileUrl;
        this.fileType = fileType;
        this.fileSize = fileSize;
        this.isCancel = isCancel;
        this.key = key;
        this.syncTime = syncTime;
        this.status = status;
        this.createTime = createTime;
        this.creator = creator;
        this.updateTime = updateTime;
        this.updator = updator;
    }

    @Generated(hash = 1118291285)
    public POCHistoryMessage() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupUri() {
        return groupUri;
    }

    public void setGroupUri(String groupUri) {
        this.groupUri = groupUri;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getIsCancel() {
        return isCancel;
    }

    public void setIsCancel(String isCancel) {
        this.isCancel = isCancel;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSyncTime() {
        return syncTime;
    }

    public void setSyncTime(String syncTime) {
        this.syncTime = syncTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdator() {
        return updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }
}
