package com.xdja.poc.sdk.ui.main.holder;

import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.support.annotation.IdRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ViewUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.config.UserConfig;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/30
 */

public class PocMemberInfoListHolder extends BaseViewHolder<POCMemberInfo> {
    private TextView mTvName, mTvPart, mTvId;
    private ImageView mImgHeadIcon, mImgIsSelected;
    private View mRelItemRoot;
    private IHolderClickLinstener mListener;
    private final String mUserId;

    public PocMemberInfoListHolder(ViewGroup itemView, IHolderClickLinstener listener) {
        super(itemView, R.layout.poc_conversation_list_item_layout);
        this.mListener = listener;
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        mRelItemRoot = $(R.id.rel_item_root);
        mImgHeadIcon = $(R.id.img_head_icon);
        mTvName = $(R.id.tv_name);
        mTvPart = $(R.id.tv_part);
        mTvId = $(R.id.tv_small_text);
        mImgIsSelected = $(R.id.img_is_select);

    }

    @Override
    public void setData(POCMemberInfo data) {
        super.setData(data);
//        if (!TextUtils.isEmpty(data.getIcon())) {
//            GlideUtils.setImageUseNetWithCircle(getContext(), data.getIcon(), mImgHeadIcon);
//        } else {
        ColorMatrix cm = new ColorMatrix();
        if (data.isOnLine()) {
            mImgHeadIcon.setColorFilter(null);
            if (!StringUtils.isEmpty(data.getIcon())) {
                Glide.with(getContext()).load(data.getIcon()).placeholder(R.drawable.poc_icon_default_avatar).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).into(mImgHeadIcon);
            } else {
                mImgHeadIcon.setImageResource(R.drawable.poc_icon_default_avatar);
            }
            mRelItemRoot.setBackgroundColor(getContext().getResources().getColor(R.color.poc_btn_text_press));
        } else {
            if (!StringUtils.isEmpty(data.getIcon())) {
                Glide.with(getContext()).load(data.getIcon()).placeholder(R.drawable.poc_icon_default_offline_avatar).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).into(mImgHeadIcon);
                cm.setSaturation(0); // 设置饱和度
                ColorMatrixColorFilter grayColorFilter = new ColorMatrixColorFilter(cm);
                mImgHeadIcon.setColorFilter(grayColorFilter);
            } else {
                mImgHeadIcon.setImageResource(R.drawable.poc_icon_default_offline_avatar);
            }
            mRelItemRoot.setBackgroundColor(getContext().getResources().getColor(R.color.poc_conversation_item_selected));
        }
        //}
        mTvName.setText(data.getName());
        if (!TextUtils.isEmpty(data.getAccount()) && data.getAccount().equals(mUserId)) {
            mTvName.setText("我");
        }
        if (!TextUtils.isEmpty(data.getDeptName())) {
            mTvPart.setText(data.getDeptName());
            mTvPart.setVisibility(View.VISIBLE);
        } else {
            mTvPart.setVisibility(View.GONE);
        }
        if (!TextUtils.isEmpty(data.getAccount())) {
            mTvId.setText("ID: " + data.getAccount());
        }
        mImgIsSelected.setVisibility(View.INVISIBLE);
        mImgHeadIcon.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null)
                    mListener.OnClick(v.getId(), getAdapterPosition());
            }
        });
        if (data.isChecked()) {
            mImgIsSelected.setImageDrawable(getContext().getDrawable(R.drawable.poc_member_selected));
        } else {
            mImgIsSelected.setImageDrawable(getContext().getDrawable(R.drawable.poc_member_noselect));
        }
    }

    public interface IHolderClickLinstener {
        void OnClick(@IdRes int id, int position);
    }

}
