/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.db.manager.PocDaoGroupManager;
import com.xdja.poc.sdk.event.POCMuteEvent;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.IPHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class POCHandlerService
extends IntentService {
    private static final String INSERT_OR_REPLACE_GROUP_DATA_LIST = "insert_or_replace_group_data_list";
    private static final String INSERT_OR_REPLACE_SINGLE_DATA = "insert_or_replace_single_data";
    private static final String UPDATE_MEMBER_INFOS = "update_member_infos";
    private static final String GET_ALL_POC_ROOM = "get_all_poc_room";
    private static final String UPDATE_GROUP_IS_SILENCE = "update_group_is_silence";
    public static final String UPDATE_GROUP_IS_TOP_STICK = "update_group_is_top_stick";
    private static final String DELETE_ROOM_BY_KEY = "delete_room_by_key";
    private static final String GROUP_TEMP_ENTITY = "group_temp_entity";
    private static final String DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI = "delete_room_by_key_with_notify_ui";
    private static final String OWNERID = "owner_id";
    private static final String GROUP_DB_KEY = "group_db_key";
    private static final String GROUP_UI_POSITION = "group_ui_position";
    private static final String GROUP_SERVER_LIST = "group_server_list";
    private static final String DB_GROUP_LIST = "db_group_list";
    private static final String IS_PTT = "is_ptt";
    private static final String UPDATE_GROUP_IS_PTT = "update_group_is_ptt";
    private static final String UPDATE_GROUP_NAME = "update_group_name";
    private static final String GROUP_PWD = "group_pwd";
    private static final String UPDATE_GROUP_PWD = "update_group_pwd";
    private static final String GROUP_PWD_MODE = "group_pwd_mode";
    private static final String UPDATE_GROUP_PWD_MODE = "update_group_pwd_mode";
    private static final String INTENT_DB_CLEAR_CHANNEL_INFO = "intent_db_clear_channel_info";
    private static String TAG = "POCHandlerService";
    private static String USERID = "userId";
    private static String ROOMID = "roomId";
    private static String GROUP_NAME = "group_name";
    private static String IS_SILENCE = "isSilence";
    private static String IS_TOP_STICK = "is_top_stick";
    private static String GROUP = "group";
    private static String GROUP_JSON = "group_json";
    private static String MEMBER_INFOS = "member_infos";
    private static String MEMBER_INFOS_STRING = "member_infos_string";

    public POCHandlerService() {
        super("DBHandlerService");
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        if (StringUtils.isEmpty((String)intent.getAction())) {
            return;
        }
        String userId = PreferenceHelper.getString((String)"login_account", (String)"");
        String roomId = intent.getStringExtra(ROOMID);
        POCMemberInfo memberInfo = (POCMemberInfo)intent.getSerializableExtra(MEMBER_INFOS);
        switch (intent.getAction()) {
            case "insert_or_replace_single_data": {
                String groupJson = intent.getStringExtra(GROUP_JSON);
                DBGroupEntity entity1 = (DBGroupEntity)new Gson().fromJson(groupJson, DBGroupEntity.class);
                break;
            }
            case "insert_or_replace_group_data_list": {
                Object s;
                ArrayList severData = (ArrayList)intent.getSerializableExtra(GROUP_SERVER_LIST);
                ArrayList<POCMemberInfo> memberInfoListTemp = new ArrayList<POCMemberInfo>();
                List<Object> mLocalList = new ArrayList();
                ArrayList<DBGroupEntity> mDbEntity = new ArrayList<DBGroupEntity>();
                mLocalList = PocDaoGroupManager.getInstance((Context)this).getAllPocGroup(userId);
                String mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
                if (severData != null && severData.size() > 0) {
                    for (Iterator<Object> groupData : severData) {
                        memberInfoListTemp.clear();
                        DBGroupEntity dBGroupEntity = new DBGroupEntity();
                        dBGroupEntity.setUserId(userId);
                        String roomId_ = ((GroupList.GroupData)((Object)groupData)).getGroupUri();
                        dBGroupEntity.setRooomId(roomId_);
                        dBGroupEntity.setIsSilence(0);
                        dBGroupEntity.setGroupType(0);
                        dBGroupEntity.setOnLineCount(0);
                        dBGroupEntity.setMaxInviteMembersCount(StringUtils.isEmpty((String)((GroupList.GroupData)((Object)groupData)).getMaxInviteMembersCount()) ? 0 : Integer.valueOf(((GroupList.GroupData)((Object)groupData)).getMaxInviteMembersCount()));
                        dBGroupEntity.setChannelPwdMode(((GroupList.GroupData)((Object)groupData)).getIsPassword().equals("Y") ? 1 : 0);
                        dBGroupEntity.setChannelPwd(StringUtils.generateContent((String)((GroupList.GroupData)((Object)groupData)).getPassword()));
                        dBGroupEntity.setKey(GroupUtils.generatePOCGroupDbKey(userId, roomId_));
                        dBGroupEntity.setOwnerId(((GroupList.GroupData)((Object)groupData)).getOwner());
                        DBGroupEntity localEntity = null;
                        if (mLocalList != null && mLocalList.size() > 0) {
                            for (DBGroupEntity dBGroupEntity2 : mLocalList) {
                                if (!dBGroupEntity2.getRooomId().equals(dBGroupEntity.getRooomId())) continue;
                                localEntity = dBGroupEntity2;
                            }
                        }
                        if (localEntity != null) {
                            dBGroupEntity.setIsSilence(localEntity.getIsSilence() ? 1 : 0);
                            dBGroupEntity.setTopStickTime(localEntity.getTopStickTime());
                            dBGroupEntity.setIsTopStick(localEntity.getIsTopStick() ? 1 : 0);
                            dBGroupEntity.setStatus(localEntity.getStatus());
                            dBGroupEntity.setIsPttKey(localEntity.getIsPttKey() ? 1 : 0);
                        }
                        for (GroupList.GroupMember groupMember : ((GroupList.GroupData)((Object)groupData)).getTalkGroupMembers()) {
                            POCMemberInfo memberInfo_ = new POCMemberInfo();
                            memberInfo_.setId(groupMember.getMember());
                            memberInfo_.setOnLine(false);
                            memberInfo_.setRoomId(roomId_);
                            memberInfo_.setName(groupMember.getName());
                            memberInfo_.setAccount(groupMember.getMember());
                            memberInfo_.setRealName(groupMember.getName());
                            if (!TextUtils.isEmpty((CharSequence)groupMember.getIcon())) {
                                if (groupMember.getIcon().startsWith("http")) {
                                    memberInfo_.setIcon(groupMember.getIcon());
                                } else {
                                    memberInfo_.setIcon(IPHost.getMisServer() + groupMember.getIcon());
                                }
                            } else {
                                memberInfo_.setIcon("");
                            }
                            memberInfoListTemp.add(memberInfo_);
                        }
                        dBGroupEntity.setRoomName(GroupUtils.convertString(((GroupList.GroupData)((Object)groupData)).getDisplayName()));
                        if (memberInfoListTemp != null && memberInfoListTemp.size() > 0) {
                            s = POCClient.getInstance().generateListString(memberInfoListTemp);
                            dBGroupEntity.setMemeberIds((String)s);
                        }
                        mDbEntity.add(dBGroupEntity);
                    }
                } else {
                    List<Object> allPocGroup = mLocalList;
                    if (allPocGroup != null && allPocGroup.size() > 0) {
                        mDbEntity = (ArrayList<DBGroupEntity>)allPocGroup;
                    }
                }
                HashMap<String, POCMemberInfo> memberNameMaps = new HashMap<String, POCMemberInfo>();
                if (mDbEntity == null) {
                    mDbEntity = new ArrayList<DBGroupEntity>();
                }
                for (DBGroupEntity dBGroupEntity : mDbEntity) {
                    String memeberIds = dBGroupEntity.getMemeberIds();
                    List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                    s = memberInfoList.iterator();
                    while (s.hasNext()) {
                        POCMemberInfo pOCMemberInfo = s.next();
                        memberNameMaps.put(pOCMemberInfo.getAccount(), pOCMemberInfo);
                    }
                    UserConfig.userNameMap.put(dBGroupEntity.getRooomId(), memberNameMaps);
                    dBGroupEntity.setUserNames("");
                    dBGroupEntity.setPinyin(GroupUtils.generatePinYin(dBGroupEntity));
                    List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(dBGroupEntity.getRooomId()));
                    dBGroupEntity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                    boolean bl = GroupUtils.resetGroupStatus(dBGroupEntity);
                    dBGroupEntity.setStatus(bl ? 1 : 0);
                }
                MessageProxy.sendGetPocAllRoom(mDbEntity);
                if (mLocalList != null && mLocalList.size() > 0) {
                    for (DBGroupEntity dBGroupEntity : mLocalList) {
                        boolean isDelete = true;
                        for (DBGroupEntity _entity : mDbEntity) {
                            if (!_entity.getRooomId().equals(dBGroupEntity.getRooomId())) continue;
                            isDelete = false;
                        }
                        if (!isDelete) continue;
                        mDbEntity.remove(dBGroupEntity);
                        PocDaoGroupManager.getInstance((Context)this).deleteGroup(dBGroupEntity.getKey());
                        POCClient.removeFromReconnectCache(roomId);
                        POCClient.leaveRoom(mUserId, dBGroupEntity.getRooomId());
                    }
                }
                if (mDbEntity != null && mDbEntity.size() > 0) {
                    PocDaoGroupManager.getInstance((Context)this).insertOrReplaceGroup(mDbEntity);
                }
                POCUiKitProxyImpl.getInstance().notifySubscribeTopic(mDbEntity);
                break;
            }
            case "update_member_infos": {
                break;
            }
            case "delete_room_by_key": {
                String key1 = intent.getStringExtra(GROUP_DB_KEY);
                PocDaoGroupManager.getInstance((Context)this).deleteGroup(key1);
                break;
            }
            case "delete_room_by_key_with_notify_ui": {
                break;
            }
            case "get_all_poc_room": {
                break;
            }
            case "update_group_is_silence": {
                boolean bl = intent.getBooleanExtra(IS_SILENCE, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupIsSilence(userId, roomId, bl);
                POCMuteEvent pocMuteEvent = new POCMuteEvent();
                pocMuteEvent.setRoomId(roomId);
                pocMuteEvent.setSilence(bl);
                EventBus.getDefault().post((Object)pocMuteEvent);
                break;
            }
            case "update_group_is_ptt": {
                ArrayList entities = (ArrayList)intent.getSerializableExtra(DB_GROUP_LIST);
                boolean isPtt = intent.getBooleanExtra(IS_PTT, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupIsPttKey(entities, userId, roomId, isPtt);
                break;
            }
            case "update_group_is_top_stick": {
                boolean bl = intent.getBooleanExtra(IS_TOP_STICK, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupIsTopStick(userId, roomId, bl);
                break;
            }
            case "update_group_name": {
                String groupName = intent.getStringExtra(GROUP_NAME);
                PocDaoGroupManager.getInstance((Context)this).updateGroupNanme(userId, roomId, groupName);
                break;
            }
            case "update_group_pwd": {
                String pwd = intent.getStringExtra(GROUP_PWD);
                PocDaoGroupManager.getInstance((Context)this).updateGroupPwd(userId, roomId, pwd);
                break;
            }
            case "update_group_pwd_mode": {
                boolean channelPwdMode = intent.getBooleanExtra(GROUP_PWD_MODE, false);
                PocDaoGroupManager.getInstance((Context)this).updateGroupPwdMode(userId, roomId, channelPwdMode);
                break;
            }
            case "intent_db_clear_channel_info": {
                PocDaoGroupManager.getInstance((Context)this).clearChannelInfo(userId);
            }
        }
    }

    public static void insertOrReplaceGroupData(Context context, String json) {
        LogUtils.ILog((String)TAG, (String)"\u542f\u52a8 insertOrReplaceGroupData service");
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(INSERT_OR_REPLACE_SINGLE_DATA);
        intent.putExtra(GROUP_JSON, json);
        context.startService(intent);
    }

    public static void insertOrReplaceGroupData(Context context, ArrayList<GroupList.GroupData> groupEntities) {
        LogUtils.ILog((String)TAG, (String)"\u542f\u52a8 insertOrReplaceGroupData service");
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(INSERT_OR_REPLACE_GROUP_DATA_LIST);
        intent.putExtra(GROUP_SERVER_LIST, groupEntities);
        context.startService(intent);
    }

    public static void updateMemberInfos(Context context, String mUserId, String roomId, String memberInfos) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_MEMBER_INFOS);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, roomId);
        intent.putExtra(MEMBER_INFOS_STRING, memberInfos);
        context.startService(intent);
    }

    public static void getAllPocRoom(Context context, String mUserId) {
    }

    public static void updateGroupIsSilence(Context mContext, String mUserId, String rooomId, boolean isSilence) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_SILENCE);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, rooomId);
        intent.putExtra(IS_SILENCE, isSilence);
        mContext.startService(intent);
    }

    public static void updateGroupPttKey(Context mContext, ArrayList<DBGroupEntity> entityList, String mUserId, String channelId, boolean isPtt) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_PTT);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(DB_GROUP_LIST, entityList);
        intent.putExtra(ROOMID, channelId);
        intent.putExtra(IS_PTT, isPtt);
        mContext.startService(intent);
    }

    public static void updateGroupIsTopStick(Context mContext, String mUserId, String rooomId, boolean isStick) {
        Intent intent = new Intent(mContext.getApplicationContext(), POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_IS_TOP_STICK);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(ROOMID, rooomId);
        intent.putExtra(IS_TOP_STICK, isStick);
        mContext.startService(intent);
    }

    public static void deleteRoomByRoomId(Context context, String key) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(DELETE_ROOM_BY_KEY);
        intent.putExtra(GROUP_DB_KEY, key);
        context.startService(intent);
    }

    public static void deleteRoomByIdWithNotifyUI(Context context, String userId, String roomId, int position) {
        Intent intent = new Intent(context.getApplicationContext(), POCHandlerService.class);
        intent.setAction(DELETE_ROOM_BY_KEY_WITH_NOTIFY_UI);
        intent.putExtra(GROUP_DB_KEY, GroupUtils.generatePOCGroupDbKey(userId, roomId));
        intent.putExtra(ROOMID, roomId);
        intent.putExtra(GROUP_UI_POSITION, position);
        context.startService(intent);
    }

    public static void updateGroupName(Context mContext, String mUserId, String channelId, String channelName) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_NAME);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_NAME, channelName);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void updateGroupPwd(Context mContext, String mUserId, String channelId, String channelPwd) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_PWD);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_PWD, channelPwd);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void updateGroupPwdMode(Context mContext, String mUserId, String channelId, boolean channelPwdMode) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(UPDATE_GROUP_PWD_MODE);
        intent.putExtra(USERID, mUserId);
        intent.putExtra(GROUP_PWD_MODE, channelPwdMode);
        intent.putExtra(ROOMID, channelId);
        mContext.startService(intent);
    }

    public static void clearChannelInfo(Context mContext, String mUserId) {
        Intent intent = new Intent(mContext, POCHandlerService.class);
        intent.setAction(INTENT_DB_CLEAR_CHANNEL_INFO);
        intent.putExtra(USERID, mUserId);
        mContext.startService(intent);
    }
}

