/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.Nullable;
import android.util.Log;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.RoomStatus;
import com.xdja.poc.sdk.business.plugincallback.JanusCreateRoomPluginCallbacks;
import com.xdja.poc.sdk.business.plugincallback.JanusPublisherPluginCallbacks;
import com.xdja.poc.sdk.business.plugincallback.JaunsUnassociationRoomPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusAttachSuccessCallBack;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusGatewayCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.ui.conversion.POCWarningToneCompleteCallBack;
import com.xdja.poc.sdk.utils.MusicHelper;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class POCRoom
implements IJanusGatewayCallbacks {
    public static final String TAG = "POCRoom";
    private volatile RoomStatus mRoomStatus;
    private IJanusAttachSuccessCallBack attachSuccessCallBack;
    private String serverUrl;
    private long roomId;
    private String userName;
    private int bCreateFlg = 0;
    private RoomEvent roomEvent;
    private Deque<ProxyVideoSink> availableRemoteRenderers = new ArrayDeque<ProxyVideoSink>();
    private HashMap<BigInteger, ProxyVideoSink> remoteRenderers = new HashMap();
    private ProxyVideoSink remoteProxyRenderer = null;
    private ProxyVideoSink localProxyVideoSink = null;
    private Context mContext;
    private volatile int currTBCPStatus = 0;
    private String currTBCPUser;
    private volatile boolean bAttached;
    private String lastTransaction = "";
    private volatile boolean muteState = false;
    JanusPublisherPluginCallbacks mJanusPublisherPluginCallbacks = null;
    JanusCreateRoomPluginCallbacks mJanusCreateRoomPluginCallbacks = null;
    JaunsUnassociationRoomPluginCallbacks mJaunsUnassociationCallBacks = null;
    PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;

    public POCRoom(String serverUrl, long roomId, String userName, int bCreateFlg, RoomEvent event, Context context) {
        this.serverUrl = serverUrl;
        this.roomId = roomId;
        this.userName = userName;
        this.bCreateFlg = bCreateFlg;
        this.roomEvent = event;
        this.mRoomStatus = new RoomStatus(false, false, false, false, false, false);
        this.mContext = context;
        this.getJanusServer().addCallback(this);
    }

    public POCRoom(ProxyVideoSink localRender, ProxyVideoSink[] remoteRenders, int roomId) {
        this.localProxyVideoSink = localRender;
        for (int i = 0; i < remoteRenders.length; ++i) {
            this.availableRemoteRenderers.push(remoteRenders[i]);
        }
        this.roomId = roomId;
        this.remoteProxyRenderer = remoteRenders[0];
    }

    private JanusServer getJanusServer() {
        return JanusServer.getJanusServer(this.serverUrl);
    }

    public int getCurrTBCPStatus() {
        return this.currTBCPStatus;
    }

    public String getCurrTBCPUser() {
        return this.currTBCPUser;
    }

    public void setPlayerStatus(boolean status) {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        LogUtils.ELog((String)TAG, (String)("getMode:" + audioManager.getMode() + ", isSpeakerphoneOn:" + audioManager.isSpeakerphoneOn()));
        if (status && audioManager.getMode() != 0) {
            int oldMode = audioManager.getMode();
            audioManager.setMode(0);
            LogUtils.ELog((String)TAG, (String)("after set oldMode:" + oldMode + ", set currrent MODE_NORMAL"));
        }
        LogUtils.DLog((String)TAG, (String)("setPlayerStatus status: " + status));
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.startPlayer(status);
        }
    }

    public void resetCurrTBCPUser() {
        this.currTBCPUser = "";
    }

    public synchronized void handleTBCP(boolean bWaitTakenTBCPResult, JSONObject obj, String currTransaction, JanusPluginHandleWithWebrtc handle, JanusPluginHandleWithWebrtc listenHandle) {
        String owner_name = "";
        try {
            if (obj.has("tbcp_request_userid")) {
                owner_name = obj.getString("tbcp_request_userid");
            }
        }
        catch (JSONException e) {
            try {
                if (obj.has("tbcp_owner")) {
                    owner_name = obj.getString("tbcp_owner");
                }
            }
            catch (JSONException exx) {
                exx.printStackTrace();
            }
        }
        if (obj.has("transaction")) {
            try {
                String transaction = obj.getString("transaction");
                Log.v((String)JanusServer.class.toString(), (String)("tbcp bWaitTakenTBCPResult:" + bWaitTakenTBCPResult + ", owner_name:" + owner_name + ", transaction:" + transaction + ", currTransaction:" + currTransaction));
                if (transaction != null && currTransaction != null && transaction.equals(currTransaction)) {
                    owner_name = this.userName;
                }
                if (this.lastTransaction != null && this.lastTransaction.equals(transaction)) {
                    Log.v((String)JanusServer.class.toString(), (String)"the message has been handled.");
                    return;
                }
                if (!"ACK___ABC".equals(obj.getString("transaction"))) {
                    this.lastTransaction = transaction;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (owner_name.equals(this.userName)) {
            try {
                int result_code = obj.getInt("result_code");
                switch (result_code) {
                    case 102: {
                        this.currTBCPStatus = 9011;
                        this.currTBCPUser = "";
                        this.playBGM(1, 9011, this.userName, null);
                        break;
                    }
                    case 101: {
                        this.currTBCPStatus = 9010;
                        this.currTBCPUser = this.userName;
                        this.playBGM(2, 9010, this.userName, handle);
                        break;
                    }
                    case 103: 
                    case 1031: {
                        this.currTBCPStatus = 9012;
                        this.currTBCPUser = "";
                        this.playBGM(1, 9012, this.userName, null);
                        break;
                    }
                    case 104: {
                        this.currTBCPStatus = 9013;
                        this.currTBCPUser = "";
                        this.playBGM(1, 9013, this.userName, null);
                        break;
                    }
                    case 105: {
                        if (handle != null) {
                            handle.startPlayer(false);
                        }
                        this.currTBCPStatus = 9010;
                        this.currTBCPUser = this.userName;
                        this.playBGM(2, 9010, this.userName, handle);
                        break;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (obj.has("result")) {
            try {
                String result = obj.getString("result");
                if (result.equals("tbcp")) {
                    int result_code = obj.getInt("result_code");
                    switch (result_code) {
                        case 101: {
                            String tbcp_owner = obj.getString("tbcp_owner_name");
                            this.currTBCPStatus = 9014;
                            this.currTBCPUser = tbcp_owner;
                            if (this.getMemberList() != null && !this.getMemberList().contains(this.currTBCPUser)) {
                                this.getMemberList().add(this.currTBCPUser);
                            }
                            this.playBGM(2, 9014, tbcp_owner, null);
                            break;
                        }
                        case 103: {
                            String tbcp_owner = obj.getString("tbcp_old_owner");
                            this.currTBCPStatus = 9015;
                            this.currTBCPUser = "";
                            this.playBGM(1, 9015, tbcp_owner, null);
                            break;
                        }
                        case 1031: {
                            String tbcp_owner1 = obj.getString("tbcp_old_owner");
                            this.currTBCPStatus = 9015;
                            this.currTBCPUser = "";
                            this.roomEvent.onTBCP(9015, tbcp_owner1);
                            break;
                        }
                        case 105: {
                            if (handle != null) {
                                handle.releaseTBCP();
                                handle.startPlayer(true);
                            }
                            String tbcp_old_owner = obj.getString("tbcp_old_owner");
                            String tbcp_owners = obj.getString("tbcp_request_userid");
                            if (this.currTBCPUser.equals(tbcp_old_owner)) {
                                this.roomEvent.onTBCP(9012, this.userName);
                                this.playBGM(2, 9014, tbcp_owners, null);
                            } else {
                                this.playBGM(2, 9014, tbcp_owners, null);
                            }
                            this.currTBCPUser = tbcp_owners;
                            break;
                        }
                        case 106: {
                            LogUtils.ELog((String)TAG, (String)"handleTBCP: 106");
                            String mp3RecordUri = obj.getString("mp3_record_uri");
                            this.roomEvent.onRecord(mp3RecordUri);
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void takenTBCP(int isForce) {
        this.currTBCPStatus = 0;
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.takenTBCP(isForce);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.takenTBCP();
        }
    }

    public synchronized void releaseTBCP() {
        this.currTBCPStatus = 0;
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.releaseTBCP();
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.releaseTBCP();
        }
    }

    public void sendMsg(String msg) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.sendMsgToRoom(msg);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.sendMsgToRoom(msg);
        }
    }

    public List<String> getMemberList() {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            return this.mJanusCreateRoomPluginCallbacks.getMemberList();
        }
        return null;
    }

    public synchronized void leaveRoom() {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.leaveRoom();
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.leaveRoom();
        }
    }

    public synchronized void destroyRoom(long roomId, String secret, @Nullable Boolean permanent) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.destoryRoom(secret, permanent);
        }
    }

    public synchronized boolean newJoinRoom(long roomId, @Nullable Integer userId, String userName, String pin, String token) {
        if (!this.getJanusServer().isConnected()) {
            return this.startConnectServer();
        }
        if (this.mRoomStatus.isCreated() && this.mRoomStatus.isJoined()) {
            Log.e((String)JanusServer.class.toString(), (String)("mRoomStatus:" + this.mRoomStatus.toString()));
            this.roomEvent.onRoom(roomId, 9001, null);
            return true;
        }
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.joinRoom(roomId, -1, userName, pin, token);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.registerUsername(roomId, userId, userName, pin, token);
        }
        return true;
    }

    public synchronized boolean newCreateRoom(long roomId, String secret, String pin, String userId, String userName, String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        if (!this.getJanusServer().isConnected()) {
            return false;
        }
        if (this.mRoomStatus.isCreated() && this.mRoomStatus.isJoined()) {
            Log.e((String)JanusServer.class.toString(), (String)("mRoomStatus:" + this.mRoomStatus.toString()));
            return false;
        }
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
        }
        return true;
    }

    public synchronized void editRoom(long roomId, String secret, String newDescription, String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated, @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.editroom(roomId, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
        }
    }

    public void existsRoom(long roomId) {
        if (this.mJaunsUnassociationCallBacks != null) {
            this.mJaunsUnassociationCallBacks.existRoom(roomId);
        }
    }

    public void kickPerson(long roomID, int personId, String secret) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.kickPerson(roomID, personId, secret);
        }
    }

    public void listRooms() {
        if (this.mJaunsUnassociationCallBacks != null) {
            this.mJaunsUnassociationCallBacks.listRooms();
        }
    }

    public void listParticipants(long roomId) {
        if (this.mJaunsUnassociationCallBacks != null) {
            this.mJaunsUnassociationCallBacks.listParticipants(roomId);
        }
    }

    public void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode, int bitrate, boolean record, String fileName, String display) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
        }
    }

    public void unpublish(long roomId) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.unpublish(roomId);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.unpublish(roomId);
        }
    }

    public void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.configure(roomId, audio, video, data, bitrate, record, fileName, display);
        }
    }

    public void subscriberJoin(long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc, boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
        }
    }

    public void startMedia(long roomId) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.startMedia(roomId);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.startMedia(roomId);
        }
    }

    public void mute(boolean enable) {
        this.muteState = enable;
        LogUtils.ELog((String)TAG, (String)("muteState: " + this.muteState + " address: " + System.identityHashCode(this.muteState)));
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.mute(enable);
        }
    }

    public boolean getMuteState() {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            return this.mJanusCreateRoomPluginCallbacks.getMuteState();
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            return this.mJanusPublisherPluginCallbacks.getMuteState();
        }
        return true;
    }

    private void pauseMedia(long roomId) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.pauseMedia(roomId);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.pauseMedia(roomId);
        }
    }

    private void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.switchSubscriber(roomId, feed, audio, video, data);
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.switchSubscriber(roomId, feed, audio, video, data);
        }
    }

    public void listforwarders(long roomID, String secret) {
        if (this.mJaunsUnassociationCallBacks != null) {
            this.mJaunsUnassociationCallBacks.listforwarders(roomID, secret);
        }
    }

    private boolean createAttachCallback() {
        if (!this.getJanusServer().peerConnectionFactoryInitialized()) {
            this.initializeMediaContext(this.mContext, true, true, true, this.peerConnectionParameters, null);
        }
        if (this.bAttached) {
            Log.e((String)JanusServer.class.toString(), (String)"createAttachCallback bAttached, just call attachSuccess().");
            this.attachSuccess();
            return true;
        }
        this.bAttached = true;
        if (this.bCreateFlg == 9020) {
            this.mJanusCreateRoomPluginCallbacks = new JanusCreateRoomPluginCallbacks(this.roomId, this.userName, this);
            this.getJanusServer().Attach(this.mJanusCreateRoomPluginCallbacks, true);
        } else if (this.bCreateFlg == 9021) {
            this.mJanusPublisherPluginCallbacks = new JanusPublisherPluginCallbacks(this.roomId, this.userName, this);
            this.getJanusServer().Attach(this.mJanusPublisherPluginCallbacks, true);
        } else {
            if (this.mJaunsUnassociationCallBacks == null) {
                this.mJaunsUnassociationCallBacks = new JaunsUnassociationRoomPluginCallbacks(this.roomId, this.userName, this);
            }
            this.getJanusServer().Attach(this.mJaunsUnassociationCallBacks, false);
        }
        return true;
    }

    @Override
    public void onSuccess() {
        this.createAttachCallback();
    }

    @Override
    public void onDestroy() {
        if (this.bCreateFlg == 9020) {
            this.mJanusCreateRoomPluginCallbacks = null;
        } else if (this.bCreateFlg == 9021) {
            this.mJanusPublisherPluginCallbacks = null;
        } else {
            this.mJaunsUnassociationCallBacks = null;
        }
        this.getJanusServer().removeCallback(this);
        Log.d((String)"zlq", (String)"poc room onDestroy removeCallback");
    }

    @Override
    public void onCallbackError(String error) {
        this.roomEvent.onRoom(this.roomId, 9100, error);
        this.leaveRoom();
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setJoined(false);
            this.mRoomStatus.setCreated(false);
            this.mRoomStatus.setCreating(false);
        }
        if (this.getJanusServer() != null) {
            Log.d((String)"zlq", (String)"poc room onCallbackError removeCallback");
            this.getJanusServer().removeCallback(this);
        }
    }

    public void registAttachSuccessCallBack(IJanusAttachSuccessCallBack callBack) {
        this.attachSuccessCallBack = callBack;
    }

    public void unRegistAttachSuccessCallBack() {
        this.attachSuccessCallBack = null;
    }

    public boolean initializeMediaContext(Context context, boolean audio, boolean video, boolean videoHwAcceleration, PeerConnectionClient.PeerConnectionParameters peerConnectionParameters, EglBase eglBase) {
        this.peerConnectionParameters = peerConnectionParameters;
        return this.getJanusServer().initializeMediaContext(context, this.localProxyVideoSink, this.remoteProxyRenderer, eglBase, peerConnectionParameters);
    }

    public boolean startConnectServer() {
        if (this.mRoomStatus.isJoined()) {
            Log.d((String)TAG, (String)("the room:" + this.roomId + " has already running."));
            return false;
        }
        if (!this.getJanusServer().isConnected()) {
            if (!this.getJanusServer().connect()) {
                Log.d((String)TAG, (String)"the room server connect failed.");
                return false;
            }
            return true;
        }
        return this.createAttachCallback();
    }

    public synchronized void hangupPeerConnection() {
        if (this.mJanusCreateRoomPluginCallbacks != null) {
            this.mJanusCreateRoomPluginCallbacks.hangup();
        }
        if (this.mJanusPublisherPluginCallbacks != null) {
            this.mJanusPublisherPluginCallbacks.hangup();
        }
        Log.d((String)"zlq", (String)"poc room is hangupPeerConnection==removeCallback");
        this.getJanusServer().removeCallback(this);
    }

    public static void disconnectServer() {
        JanusServer.disconnectServer();
    }

    public void setCreated(boolean value) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setCreated(value);
        }
    }

    public boolean isCreating() {
        if (this.mRoomStatus != null) {
            return this.mRoomStatus.isCreating();
        }
        return false;
    }

    public boolean isCreated() {
        if (this.mRoomStatus != null) {
            return this.mRoomStatus.isCreated();
        }
        return false;
    }

    public void setCreating(boolean value) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setCreating(value);
        }
    }

    public void setJoining(boolean value) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setJoining(value);
        }
    }

    public void setJoined(boolean value) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setJoined(value);
        }
    }

    public void setDestroy(boolean value) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setDestroy(value);
        }
    }

    public void setLeave(boolean value) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setLeave(value);
        }
    }

    public void updateForceInsert(boolean isForceInsert) {
        if (this.mRoomStatus != null) {
            this.mRoomStatus.setForceInsert(isForceInsert);
        }
    }

    public boolean getForceInsertStatus() {
        if (this.mRoomStatus != null) {
            return this.mRoomStatus.isForceInsert();
        }
        return false;
    }

    public boolean isJoined() {
        return this.mRoomStatus != null && this.mRoomStatus.isJoined();
    }

    public void attach(IJanusPluginCallbacks callback) {
        this.getJanusServer().Attach(callback, true);
    }

    public void attachSuccess() {
        if (this.attachSuccessCallBack != null) {
            this.attachSuccessCallBack.createSessionAndAttachSuccess();
        }
    }

    public void onRoomStatus(long roomID, int value, String error) {
        this.roomEvent.onRoom(roomID, value, error);
    }

    public void onTBCP(int status, String ownerUser) {
        this.currTBCPStatus = status;
        this.currTBCPUser = ownerUser;
        this.roomEvent.onTBCP(status, ownerUser);
    }

    private void playBGM(int musicType, int type, String userName, final JanusPluginHandleWithWebrtc handle) {
        LogUtils.ELog((String)TAG, (String)("playBGM: muteState: " + this.muteState + " address: " + System.identityHashCode(this.muteState) + "  pocRoom: " + this));
        if (this.muteState) {
            Log.d((String)JanusServer.class.toString(), (String)"playBGM mute state");
            if (handle != null) {
                handle.takenTBCP();
            }
            this.roomEvent.onTBCP(type, userName);
        } else {
            MusicHelper.MusicPlayer musicPlayer = MusicHelper.getInstance(this.mContext).playMusic(musicType, false);
            musicPlayer.setCompleteListener(new POCWarningToneCompleteCallBack(){

                @Override
                public void completeCallBack() {
                    Log.d((String)JanusServer.class.toString(), (String)("playBGM completeCallBack, currTBCPStatus:" + POCRoom.this.currTBCPStatus));
                    if (handle != null && POCRoom.this.currTBCPStatus == 9010) {
                        handle.takenTBCP();
                    }
                }
            });
            this.roomEvent.onTBCP(type, userName);
        }
    }

    public void removeCallbackFromJanusServer() {
        this.getJanusServer().removeCallback(this);
        Log.d((String)"zlq", (String)"poc room is removeCallbackFromJanusServer");
    }

    public static class ProxyVideoSink
    implements VideoSink {
        private VideoSink target;

        public synchronized void onFrame(VideoFrame frame) {
            if (this.target == null) {
                Logging.d((String)POCRoom.TAG, (String)"Dropping frame in proxy because target is null.");
                return;
            }
            this.target.onFrame(frame);
        }

        public synchronized void setTarget(VideoSink target) {
            this.target = target;
        }
    }

    public static interface RoomEvent {
        public void onRoom(long var1, int var3, String var4);

        public void onTBCP(int var1, String var2);

        public void onRecord(String var1);
    }
}

