/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business.webrtc.apprtc;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.util.Log;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.RecordedAudioToFileController;
import com.xdja.poc.sdk.business.webrtc.apprtc.RtcEventLog;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.StatsObserver;
import org.webrtc.StatsReport;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.LegacyAudioDeviceModule;
import org.webrtc.voiceengine.WebRtcAudioManager;
import org.webrtc.voiceengine.WebRtcAudioRecord;
import org.webrtc.voiceengine.WebRtcAudioTrack;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class PeerConnectionClient {
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    public static final String VIDEO_TRACK_TYPE = "video";
    private static final String TAG = "PCRTCClient";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    private static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String AUDIO_CODEC_ILBC = "ILBC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-startConnectServer-bitrate";
    private static final String VIDEO_FLEXFEC_FIELDTRIAL = "WebRTC-FlexFEC-03-Advertised/Enabled/WebRTC-FlexFEC-03/Enabled/";
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    private static final String VIDEO_H264_HIGH_PROFILE_FIELDTRIAL = "WebRTC-H264HighProfile/Enabled/";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 1280;
    private static final int HD_VIDEO_HEIGHT = 720;
    private static final int BPS_IN_KBPS = 1000;
    private static final String RTCEVENTLOG_OUTPUT_DIR_NAME = "rtc_event_log";
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private final PCObserver pcObserver = new PCObserver();
    private final SDPObserver sdpObserver = new SDPObserver();
    private final Timer statsTimer = new Timer();
    private final EglBase rootEglBase;
    private final Context appContext;
    private final PeerConnectionParameters peerConnectionParameters;
    private final PeerConnectionEvents events;
    private static volatile PeerConnectionFactory factory;
    private static volatile AudioDeviceModule adm;
    private static volatile PeerConnectionClient currRecorderClient;
    private static volatile int peerconnectionCounts;
    private PeerConnection peerConnection;
    private AudioSource audioSource;
    private VideoSource videoSource;
    private boolean preferIsac;
    private boolean preferIlbc;
    private boolean videoCapturerStopped;
    private boolean isError;
    private VideoSink localRender;
    private List<VideoSink> remoteSinks;
    private AppRTCClient.SignalingParameters signalingParameters;
    private int videoWidth;
    private int videoHeight;
    private int videoFps;
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    private List<IceCandidate> queuedRemoteCandidates;
    private boolean isInitiator;
    private SessionDescription localSdp;
    private VideoCapturer videoCapturer;
    private boolean renderVideo = true;
    private boolean localRenderVideo = true;
    private VideoTrack localVideoTrack;
    private VideoTrack remoteVideoTrack;
    private RtpSender localVideoSender;
    private volatile boolean enableAudio = true;
    private volatile boolean lastEnableAudio = false;
    private static volatile boolean enableAudioPlayout;
    private volatile boolean enableMute = false;
    private AudioTrack localAudioTrack;
    private DataChannel dataChannel;
    private final boolean dataChannelEnabled;
    private RtcEventLog rtcEventLog;
    private RecordedAudioToFileController saveRecordedAudioToFile = null;
    private WifiManager mWifiManager;
    private WifiManager.WifiLock mWifiLock;
    private String mConnetedSSID;
    private boolean mAcquired;
    private boolean bVideoRecvFlag = false;
    private boolean bAudioRecvFlag = false;
    private boolean bVideoSendFlag = false;
    private boolean bAudioSendFlag = false;

    public PeerConnectionClient(Context appContext, EglBase eglBase, final PeerConnectionParameters peerConnectionParameters, PeerConnectionEvents events) {
        this.rootEglBase = eglBase;
        this.appContext = appContext;
        this.events = events;
        this.peerConnectionParameters = peerConnectionParameters;
        this.dataChannelEnabled = peerConnectionParameters.dataChannelParameters != null;
        LogUtils.DLog((String)TAG, (String)("Preferred video codec: " + PeerConnectionClient.getSdpVideoCodecName(peerConnectionParameters)));
        final String fieldTrials = PeerConnectionClient.getFieldTrials(peerConnectionParameters);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Initialize WebRTC. Field trials: " + fieldTrials + " Enable video HW acceleration: " + peerConnectionParameters.videoCodecHwAcceleration));
                PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)PeerConnectionClient.this.appContext).setFieldTrials(fieldTrials).setEnableVideoHwAcceleration(peerConnectionParameters.videoCodecHwAcceleration).setEnableInternalTracer(true).createInitializationOptions());
            }
        });
    }

    public static void resetPlayerStatus() {
        enableAudioPlayout = true;
    }

    public void createPeerConnectionFactory(final PeerConnectionFactory.Options options) {
        if (factory != null) {
            Log.i((String)TAG, (String)"factory has been created.");
            return;
        }
        Log.i((String)TAG, (String)"createPeerConnectionFactory recreate executor.");
        if (executor == null) {
            executor = Executors.newSingleThreadExecutor();
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerConnectionClient.this.createPeerConnectionFactoryInternal(options);
            }
        });
    }

    public void createPeerConnection(VideoSink localRender, VideoSink remoteSink, VideoCapturer videoCapturer, AppRTCClient.SignalingParameters signalingParameters) {
        if (this.peerConnectionParameters.videoCallEnabled && videoCapturer == null) {
            Log.w((String)TAG, (String)"Video call enabled but no video capturer provided.");
        }
        this.createPeerConnection(localRender, Collections.singletonList(remoteSink), videoCapturer, signalingParameters);
    }

    public void createPeerConnection(VideoSink localRender, List<VideoSink> remoteSinks, VideoCapturer videoCapturer, AppRTCClient.SignalingParameters signalingParameters) {
        if (this.peerConnectionParameters == null) {
            Log.e((String)TAG, (String)"Creating peer connection without initializing factory.");
            return;
        }
        this.localRender = localRender;
        this.remoteSinks = remoteSinks;
        this.videoCapturer = videoCapturer;
        this.signalingParameters = signalingParameters;
        Log.v((String)TAG, (String)("executor:" + executor.toString() + ", " + executor.isTerminated()));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PeerConnectionClient.this.createMediaConstraintsInternal();
                    PeerConnectionClient.this.createPeerConnectionInternal();
                    PeerConnectionClient.this.maybeCreateAndStartRtcEventLog();
                    peerconnectionCounts++;
                }
                catch (Exception e) {
                    PeerConnectionClient.this.reportError("Failed to create peer connection: " + e.getMessage());
                    throw e;
                }
            }
        });
    }

    public void close() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PeerConnectionClient.this.closeInternal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setAudioRecvFlag(boolean bFlag) {
        this.bAudioRecvFlag = bFlag;
    }

    public void setVideoRecvFlag(boolean bFlag) {
        this.bVideoRecvFlag = bFlag;
    }

    public void setAudioSendFlag(boolean bFlag) {
        this.bAudioSendFlag = bFlag;
    }

    public void setVideoSendOnly(boolean bFlag) {
        this.bVideoSendFlag = bFlag;
    }

    private boolean isVideoCallEnabled() {
        return this.peerConnectionParameters.videoCallEnabled && this.videoCapturer != null;
    }

    private void createPeerConnectionFactoryInternal(PeerConnectionFactory.Options options) {
        SoftwareVideoDecoderFactory decoderFactory;
        SoftwareVideoEncoderFactory encoderFactory;
        this.isError = false;
        if (this.peerConnectionParameters.tracing) {
            PeerConnectionFactory.startInternalTracingCapture((String)(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "webrtc-trace.txt"));
        }
        this.preferIsac = this.peerConnectionParameters.audioCodec != null && this.peerConnectionParameters.audioCodec.equals(AUDIO_CODEC_ISAC);
        boolean bl = this.preferIlbc = this.peerConnectionParameters.audioCodec != null && this.peerConnectionParameters.audioCodec.equals(AUDIO_CODEC_ILBC);
        if (this.peerConnectionParameters.saveInputAudioToFile && PreferenceHelper.getBoolean((String)"poc_is_save_record", (boolean)true)) {
            if (!this.peerConnectionParameters.useOpenSLES) {
                LogUtils.DLog((String)TAG, (String)"Enable recording of microphone input audio to file");
                this.saveRecordedAudioToFile = new RecordedAudioToFileController(executor, new RecordedAudioToFileController.OnSaveRecordCallBack(){
                    String recordFileUri;

                    @Override
                    public void onStartSave(String recordFileUri) {
                        this.recordFileUri = recordFileUri;
                        Log.e((String)PeerConnectionClient.TAG, (String)("onStartSave: " + recordFileUri));
                    }

                    @Override
                    public void onEndSave() {
                        String msg = "{\"result\": \"tbcp\",\n      \"result_code\": 106,\n      \"message\": \"save mp3 record finished\",\n      \"mp3_record_uri\": \"" + this.recordFileUri + "\"\n      }";
                        if (currRecorderClient != null) {
                            currRecorderClient.events.onDataChannelRcvData(msg);
                        }
                        LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("onEndSave: " + msg));
                    }
                });
            } else {
                Log.e((String)TAG, (String)"Recording of input audio is not supported for OpenSL ES");
            }
        }
        AudioDeviceModule audioDeviceModule = adm = this.peerConnectionParameters.useLegacyAudioDevice ? this.createLegacyAudioDevice() : this.createJavaAudioDevice();
        if (options != null) {
            LogUtils.DLog((String)TAG, (String)("Factory networkIgnoreMask option: " + options.networkIgnoreMask));
        }
        boolean enableH264HighProfile = VIDEO_CODEC_H264_HIGH.equals(this.peerConnectionParameters.videoCodec);
        if (this.rootEglBase != null && this.peerConnectionParameters.videoCodecHwAcceleration) {
            encoderFactory = new DefaultVideoEncoderFactory(this.rootEglBase.getEglBaseContext(), true, enableH264HighProfile);
            decoderFactory = new DefaultVideoDecoderFactory(this.rootEglBase.getEglBaseContext());
        } else {
            encoderFactory = new SoftwareVideoEncoderFactory();
            decoderFactory = new SoftwareVideoDecoderFactory();
        }
        try {
            this.acquireWifi();
        }
        catch (Exception ex) {
            LogUtils.ELog((String)TAG, (String)("acquireWifi exception:" + ex.getMessage()));
        }
        factory = PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(adm).setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).createPeerConnectionFactory();
        LogUtils.DLog((String)TAG, (String)"Peer connection factory created.");
    }

    AudioDeviceModule createLegacyAudioDevice() {
        if (!this.peerConnectionParameters.useOpenSLES) {
            LogUtils.DLog((String)TAG, (String)"Disable OpenSL ES audio even if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)true);
        } else {
            LogUtils.DLog((String)TAG, (String)"Allow OpenSL ES audio if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInAEC) {
            LogUtils.DLog((String)TAG, (String)"Disable built-in AEC even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)true);
        } else {
            LogUtils.DLog((String)TAG, (String)"Enable built-in AEC if device supports it");
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)false);
        }
        if (this.peerConnectionParameters.disableBuiltInNS) {
            LogUtils.DLog((String)TAG, (String)"Disable built-in NS even if device supports it");
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)true);
        } else {
            LogUtils.DLog((String)TAG, (String)"Enable built-in NS if device supports it");
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)false);
        }
        WebRtcAudioRecord.setOnAudioSamplesReady((WebRtcAudioRecord.WebRtcAudioRecordSamplesReadyCallback)this.saveRecordedAudioToFile);
        WebRtcAudioRecord.setErrorCallback((WebRtcAudioRecord.WebRtcAudioRecordErrorCallback)new WebRtcAudioRecord.WebRtcAudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordInitError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordStartError(WebRtcAudioRecord.AudioRecordStartErrorCode errorCode, String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordStartError: " + errorCode + ". " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }
        });
        WebRtcAudioTrack.setErrorCallback((WebRtcAudioTrack.ErrorCallback)new WebRtcAudioTrack.ErrorCallback(){

            public void onWebRtcAudioTrackInitError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackInitError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackStartError(WebRtcAudioTrack.AudioTrackStartErrorCode errorCode, String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackStartError: " + errorCode + ". " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }
        });
        return new LegacyAudioDeviceModule();
    }

    AudioDeviceModule createJavaAudioDevice() {
        if (this.peerConnectionParameters.useOpenSLES) {
            Log.v((String)TAG, (String)"Allow OpenSL ES audio if device supports it");
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)false);
        }
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordInitError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordStartError: " + errorCode + ". " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackInitError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackStartError: " + errorCode + ". " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }
        };
        return JavaAudioDeviceModule.builder((Context)this.appContext).setSamplesReadyCallback((JavaAudioDeviceModule.SamplesReadyCallback)this.saveRecordedAudioToFile).setUseHardwareAcousticEchoCanceler(!this.peerConnectionParameters.disableBuiltInAEC).setUseHardwareNoiseSuppressor(!this.peerConnectionParameters.disableBuiltInNS).setAudioRecordErrorCallback(audioRecordErrorCallback).setAudioTrackErrorCallback(audioTrackErrorCallback).createAudioDeviceModule();
    }

    private void createMediaConstraintsInternal() {
        if (this.isVideoCallEnabled()) {
            this.videoWidth = this.peerConnectionParameters.videoWidth;
            this.videoHeight = this.peerConnectionParameters.videoHeight;
            this.videoFps = this.peerConnectionParameters.videoFps;
            if (this.videoWidth == 0 || this.videoHeight == 0) {
                this.videoWidth = 1280;
                this.videoHeight = 720;
            }
            if (this.videoFps == 0) {
                this.videoFps = 30;
            }
            Logging.d((String)TAG, (String)("Capturing format: " + this.videoWidth + "x" + this.videoHeight + "@" + this.videoFps));
        }
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            LogUtils.DLog((String)TAG, (String)"Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        if (this.bVideoRecvFlag) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", Boolean.toString(this.isVideoCallEnabled())));
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
        }
    }

    private void createPeerConnectionInternal() {
        if (factory == null || this.isError) {
            Log.e((String)TAG, (String)"Peerconnection factory is not created");
            return;
        }
        LogUtils.DLog((String)TAG, (String)"Create peer connection.");
        this.queuedRemoteCandidates = null;
        if (this.isVideoCallEnabled()) {
            factory.setVideoHwAccelerationOptions(this.rootEglBase.getEglBaseContext(), this.rootEglBase.getEglBaseContext());
        }
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.signalingParameters.iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.ENABLED;
        rtcConfig.disableIPv6OnWifi = true;
        rtcConfig.disableIpv6 = true;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_ONCE;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        rtcConfig.enableDtlsSrtp = true;
        rtcConfig.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
        rtcConfig.enableRtpDataChannel = this.dataChannelEnabled;
        this.peerConnection = factory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this.pcObserver);
        if (this.dataChannelEnabled) {
            DataChannel.Init init = new DataChannel.Init();
            init.ordered = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.ordered;
            init.negotiated = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.negotiated;
            init.maxRetransmits = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.maxRetransmits;
            init.maxRetransmitTimeMs = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.maxRetransmitTimeMs;
            init.id = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.id;
            init.protocol = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.protocol;
            this.dataChannel = this.peerConnection.createDataChannel("datachannel", init);
            this.dataChannel.registerObserver(new DataChannel.Observer(){

                public void onBufferedAmountChange(long previousAmount) {
                    Log.v((String)PeerConnectionClient.TAG, (String)("Data channel buffered amount changed: " + PeerConnectionClient.this.dataChannel.label() + ": " + PeerConnectionClient.this.dataChannel.state()));
                }

                public void onStateChange() {
                    if (PeerConnectionClient.this.dataChannel != null) {
                        DataChannel.State value = PeerConnectionClient.this.dataChannel.state();
                        Log.v((String)PeerConnectionClient.TAG, (String)("Data channel state changed: " + PeerConnectionClient.this.dataChannel.label() + ": " + PeerConnectionClient.this.dataChannel.state()));
                    }
                }

                public void onMessage(DataChannel.Buffer buffer) {
                    if (buffer.binary) {
                        LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Received binary msg over " + PeerConnectionClient.this.dataChannel + ",buffer.data:" + buffer.data.toString()));
                        return;
                    }
                    ByteBuffer data = buffer.data;
                    byte[] bytes = new byte[data.capacity()];
                    data.get(bytes);
                    final String strData = new String(bytes, Charset.forName("UTF-8"));
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("zlq Got msg: " + strData + " over " + PeerConnectionClient.this.dataChannel));
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            Log.e((String)PeerConnectionClient.TAG, (String)("onMessage --" + PeerConnectionClient.this.events));
                            PeerConnectionClient.this.events.onDataChannelRcvData(strData);
                        }
                    });
                }
            });
        }
        this.isInitiator = false;
        Logging.enableLogToDebugOutput((Logging.Severity)Logging.Severity.LS_SENSITIVE);
        EnumSet<Logging.TraceLevel> levels = EnumSet.of(Logging.TraceLevel.TRACE_ALL);
        List<String> mediaStreamLabels = Collections.singletonList("ARDAMS");
        if (this.isVideoCallEnabled()) {
            if (this.videoCapturer != null) {
                this.peerConnection.addTrack((MediaStreamTrack)this.createVideoTrack(this.videoCapturer), mediaStreamLabels);
            }
            this.remoteVideoTrack = this.getRemoteVideoTrack();
            this.remoteVideoTrack.setEnabled(this.renderVideo);
            Log.e((String)TAG, (String)"Add remote sink");
            for (VideoSink remoteSink : this.remoteSinks) {
                this.remoteVideoTrack.addSink(remoteSink);
            }
        }
        this.peerConnection.addTrack((MediaStreamTrack)this.createAudioTrack(), mediaStreamLabels);
        if (this.isVideoCallEnabled()) {
            this.findVideoSender();
        }
        if (this.peerConnectionParameters.aecDump) {
            try {
                ParcelFileDescriptor aecDumpFileDescriptor = ParcelFileDescriptor.open((File)new File(Environment.getExternalStorageDirectory().getPath() + File.separator + "Download/audio.aecdump"), (int)0x3C000000);
                factory.startAecDump(aecDumpFileDescriptor.detachFd(), -1);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Can not open aecdump file", (Throwable)e);
            }
        }
        LogUtils.DLog((String)TAG, (String)"Peer connection created.");
    }

    private void parserTBCPMsg(String strData) {
        JSONObject obj = null;
        try {
            obj = new JSONObject(strData);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (obj == null) {
            return;
        }
        if (obj.has("result")) {
            try {
                String result = obj.getString("result");
                if (result.equals("tbcp")) {
                    int result_code = obj.getInt("result_code");
                    switch (result_code) {
                        case 101: {
                            if (this.saveRecordedAudioToFile == null) break;
                            this.saveRecordedAudioToFile.start();
                            break;
                        }
                        case 103: {
                            if (this.saveRecordedAudioToFile == null) break;
                            this.saveRecordedAudioToFile.stop();
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private File createRtcEventLogOutputFile() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_hhmm_ss", Locale.getDefault());
        Date date = new Date();
        String outputFileName = "event_log_" + dateFormat.format(date) + ".log";
        return new File(this.appContext.getDir(RTCEVENTLOG_OUTPUT_DIR_NAME, 0), outputFileName);
    }

    private void maybeCreateAndStartRtcEventLog() {
        if (this.appContext == null || this.peerConnection == null) {
            return;
        }
        if (!this.peerConnectionParameters.enableRtcEventLog) {
            LogUtils.DLog((String)TAG, (String)"RtcEventLog is disabled.");
            return;
        }
        this.rtcEventLog = new RtcEventLog(this.peerConnection);
        this.rtcEventLog.start(this.createRtcEventLogOutputFile());
    }

    private void closeInternal() {
        if (factory != null && this.peerConnectionParameters.aecDump) {
            factory.stopAecDump();
        }
        LogUtils.DLog((String)TAG, (String)("Closing peer connection:" + --peerconnectionCounts));
        this.statsTimer.cancel();
        if (this.dataChannel != null) {
            this.dataChannel.dispose();
            this.dataChannel = null;
        }
        if (this.rtcEventLog != null) {
            this.rtcEventLog.stop();
            this.rtcEventLog = null;
        }
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        LogUtils.DLog((String)TAG, (String)"Closing audio source.");
        if (this.audioSource != null) {
            this.audioSource.dispose();
            this.audioSource = null;
        }
        LogUtils.DLog((String)TAG, (String)"Stopping capture.");
        if (this.videoCapturer != null) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.videoCapturerStopped = true;
            this.videoCapturer.dispose();
            this.videoCapturer = null;
        }
        LogUtils.DLog((String)TAG, (String)"Closing video source.");
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        if (this.saveRecordedAudioToFile != null) {
            LogUtils.DLog((String)TAG, (String)"Closing audio file for recorded input audio.");
            this.saveRecordedAudioToFile.stop();
            this.saveRecordedAudioToFile = null;
        }
        this.localRender = null;
        this.remoteSinks = null;
        LogUtils.DLog((String)TAG, (String)("Closing peer connection factory, peerconnectionCounts:" + peerconnectionCounts));
        if (peerconnectionCounts == 0 && factory != null) {
            factory.dispose();
            enableAudioPlayout = true;
            factory = null;
            currRecorderClient = null;
            executor = Executors.newSingleThreadExecutor();
            this.releaseWifi();
        }
        if (this.rootEglBase != null) {
            this.rootEglBase.release();
        }
        LogUtils.DLog((String)TAG, (String)"Closing peer connection done.");
        this.events.onPeerConnectionClosed();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
    }

    public boolean isHDVideo() {
        return this.isVideoCallEnabled() && this.videoWidth * this.videoHeight >= 921600;
    }

    private void getStats() {
        if (this.peerConnection == null || this.isError) {
            return;
        }
        boolean success = this.peerConnection.getStats(new StatsObserver(){

            public void onComplete(StatsReport[] reports) {
                PeerConnectionClient.this.events.onPeerConnectionStatsReady(reports);
            }
        }, null);
        if (!success) {
            Log.e((String)TAG, (String)"getStats() returns false!");
        }
    }

    public void enableStatsEvents(boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                PeerConnectionClient.this.getStats();
                            }
                        });
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Can not schedule statistics timer", (Throwable)e);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public boolean getMuteState() {
        return this.enableMute;
    }

    public void startPlayOut(final boolean enable) {
        enableAudioPlayout = enable;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null) {
                    LogUtils.ILog((String)("PCRTCClient,startPlayOut:" + enable));
                    PeerConnectionClient.this.peerConnection.setAudioPlayout(enable);
                }
            }
        });
    }

    public void mute(final boolean enable) {
        this.enableMute = enable;
        LogUtils.ILog((String)("PCRTCClient, mute enableMute:" + this.enableMute + ", enableAudioPlayout:" + enableAudioPlayout));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null) {
                    if (enable && PeerConnectionClient.this.peerConnection.isMute() || !enable && !PeerConnectionClient.this.peerConnection.isMute()) {
                        LogUtils.ILog((String)("PCRTCClient,mute the current sate is same, no need call native function, peerConnection.isMute():" + PeerConnectionClient.this.peerConnection.isMute()));
                        return;
                    }
                    LogUtils.ILog((String)("PCRTCClient,mute startPlayOut2:" + enable));
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("pre setMute " + PeerConnectionClient.this.peerConnection.isMute()));
                    PeerConnectionClient.this.peerConnection.setMute(enable);
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("after setMute " + PeerConnectionClient.this.peerConnection.isMute()));
                }
            }
        });
    }

    public synchronized void setAudioEnabled(final boolean enable) {
        Log.i((String)TAG, (String)("setAudioEnabled :enableAudio value is :" + this.enableAudio + ",SetRecording enable:" + enable + ",lastEnableAudio:" + this.lastEnableAudio));
        if (this.lastEnableAudio && enable || !this.lastEnableAudio && !enable) {
            return;
        }
        this.enableAudio = enable;
        this.lastEnableAudio = enable;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!enable && PeerConnectionClient.this.enableAudio || enable && !PeerConnectionClient.this.enableAudio) {
                    Log.i((String)PeerConnectionClient.TAG, (String)("setAudioEnabled:the value is not same SetRecording enableAudio:" + PeerConnectionClient.this.enableAudio + ", enable:" + enable + ", lastEnableAudio:" + PeerConnectionClient.this.lastEnableAudio));
                    return;
                }
                Log.i((String)PeerConnectionClient.TAG, (String)("setAudioEnabled:the value is SetRecording enableAudio:" + PeerConnectionClient.this.enableAudio + ", enable:" + enable + ", lastEnableAudio:" + PeerConnectionClient.this.lastEnableAudio));
                if (PeerConnectionClient.this.peerConnection != null) {
                    if (enable) {
                        currRecorderClient = PeerConnectionClient.this;
                    }
                    PeerConnectionClient.this.peerConnection.setAudioRecording(enable);
                }
                if (PeerConnectionClient.this.localAudioTrack != null) {
                    PeerConnectionClient.this.localAudioTrack.setEnabled(enable);
                }
            }
        });
    }

    public void setRemoteVideoEnabled(boolean enable) {
        this.renderVideo = enable;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.remoteVideoTrack != null) {
                    PeerConnectionClient.this.remoteVideoTrack.setEnabled(PeerConnectionClient.this.renderVideo);
                }
            }
        });
    }

    public void setVideoEnabled(boolean enable) {
        this.localRenderVideo = enable;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.localVideoTrack != null) {
                    PeerConnectionClient.this.localVideoTrack.setEnabled(PeerConnectionClient.this.localRenderVideo);
                }
            }
        });
    }

    public void createOffer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"PC Create OFFER");
                    PeerConnectionClient.this.isInitiator = true;
                    PeerConnectionClient.this.peerConnection.createOffer((SdpObserver)PeerConnectionClient.this.sdpObserver, PeerConnectionClient.this.sdpMediaConstraints);
                }
            }
        });
    }

    public void createAnswer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"PC create ANSWER");
                    PeerConnectionClient.this.isInitiator = false;
                    PeerConnectionClient.this.peerConnection.createAnswer((SdpObserver)PeerConnectionClient.this.sdpObserver, PeerConnectionClient.this.sdpMediaConstraints);
                }
            }
        });
    }

    public void addRemoteIceCandidate(final IceCandidate candidate) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    if (PeerConnectionClient.this.queuedRemoteCandidates != null) {
                        PeerConnectionClient.this.queuedRemoteCandidates.add(candidate);
                    } else {
                        PeerConnectionClient.this.peerConnection.addIceCandidate(candidate);
                    }
                }
            }
        });
    }

    public void removeRemoteIceCandidates(final IceCandidate[] candidates) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                    return;
                }
                PeerConnectionClient.this.drainCandidates();
                PeerConnectionClient.this.peerConnection.removeIceCandidates(candidates);
            }
        });
    }

    public void setAudioCodec(String type) {
        if (!type.equalsIgnoreCase(AUDIO_CODEC_OPUS) && !type.equalsIgnoreCase(AUDIO_CODEC_ILBC)) {
            Log.e((String)TAG, (String)("++setAudioCodec type:" + type));
            return;
        }
        Log.v((String)TAG, (String)("--setAudioCodec type:" + type));
        this.peerConnectionParameters.audioCodec = type;
        this.preferIsac = type.equalsIgnoreCase(AUDIO_CODEC_ISAC);
        this.preferIlbc = type.equalsIgnoreCase(AUDIO_CODEC_ILBC);
    }

    public void setRemoteDescription(final SessionDescription sdp) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                    return;
                }
                String sdpDescription = sdp.description;
                if (PeerConnectionClient.this.preferIsac) {
                    sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ISAC, true);
                } else if (PeerConnectionClient.this.preferIlbc) {
                    sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ILBC, true);
                } else if (((PeerConnectionClient)PeerConnectionClient.this).peerConnectionParameters.audioStartBitrate > 0) {
                    sdpDescription = PeerConnectionClient.setStartBitrate(PeerConnectionClient.AUDIO_CODEC_OPUS, false, sdpDescription, ((PeerConnectionClient)PeerConnectionClient.this).peerConnectionParameters.audioStartBitrate);
                }
                if (PeerConnectionClient.this.isVideoCallEnabled()) {
                    sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.getSdpVideoCodecName(PeerConnectionClient.this.peerConnectionParameters), false);
                }
                LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Set remote SDP:" + sdpDescription));
                SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
                PeerConnectionClient.this.peerConnection.setRemoteDescription((SdpObserver)PeerConnectionClient.this.sdpObserver, sdpRemote);
                if (PeerConnectionClient.this.queuedRemoteCandidates != null) {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Add " + PeerConnectionClient.this.queuedRemoteCandidates.size() + " remote candidates"));
                    for (IceCandidate candidate : PeerConnectionClient.this.queuedRemoteCandidates) {
                        Log.i((String)PeerConnectionClient.TAG, (String)("candidate:" + candidate.toString()));
                        PeerConnectionClient.this.peerConnection.addIceCandidate(candidate);
                    }
                }
            }
        });
    }

    public void stopVideoSource() {
        if (!this.isVideoCallEnabled()) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.videoCapturer != null && !PeerConnectionClient.this.videoCapturerStopped) {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"Stop video source.");
                    try {
                        PeerConnectionClient.this.videoCapturer.stopCapture();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    PeerConnectionClient.this.videoCapturerStopped = true;
                }
            }
        });
    }

    public void startVideoSource() {
        if (!this.isVideoCallEnabled()) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"Restart video source.");
                PeerConnectionClient.this.videoCapturer.startCapture(PeerConnectionClient.this.videoWidth, PeerConnectionClient.this.videoHeight, PeerConnectionClient.this.videoFps);
                PeerConnectionClient.this.videoCapturerStopped = false;
            }
        });
    }

    public void setVideoMaxBitrate(final Integer maxBitrateKbps) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.localVideoSender == null || PeerConnectionClient.this.isError) {
                    return;
                }
                LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Requested max video bitrate: " + maxBitrateKbps));
                if (PeerConnectionClient.this.localVideoSender == null) {
                    Log.w((String)PeerConnectionClient.TAG, (String)"Sender is not ready.");
                    return;
                }
                RtpParameters parameters = PeerConnectionClient.this.localVideoSender.getParameters();
                if (parameters.encodings.size() == 0) {
                    Log.w((String)PeerConnectionClient.TAG, (String)"RtpParameters are not ready.");
                    return;
                }
                for (RtpParameters.Encoding encoding : parameters.encodings) {
                    encoding.maxBitrateBps = maxBitrateKbps == null ? null : Integer.valueOf(maxBitrateKbps * 1000);
                }
                if (!PeerConnectionClient.this.localVideoSender.setParameters(parameters)) {
                    Log.e((String)PeerConnectionClient.TAG, (String)"RtpSender.setParameters failed.");
                }
                LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Configured max video bitrate to: " + maxBitrateKbps));
            }
        });
    }

    private void reportError(final String errorMessage) {
        Log.e((String)TAG, (String)("Peerconnection error: " + errorMessage));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!PeerConnectionClient.this.isError) {
                    PeerConnectionClient.this.events.onPeerConnectionError(errorMessage);
                    PeerConnectionClient.this.isError = true;
                }
            }
        });
    }

    private AudioTrack createAudioTrack() {
        this.audioSource = factory.createAudioSource(this.audioConstraints);
        this.localAudioTrack = factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
        this.localAudioTrack.setEnabled(this.enableAudio);
        return this.localAudioTrack;
    }

    private VideoTrack createVideoTrack(VideoCapturer capturer) {
        this.videoSource = factory.createVideoSource(capturer);
        this.localVideoTrack = factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
        this.localVideoTrack.setEnabled(this.renderVideo);
        this.localVideoTrack.addSink(this.localRender);
        return this.localVideoTrack;
    }

    private void findVideoSender() {
        for (RtpSender sender : this.peerConnection.getSenders()) {
            String trackType;
            if (sender.track() == null || !(trackType = sender.track().kind()).equals(VIDEO_TRACK_TYPE)) continue;
            LogUtils.DLog((String)TAG, (String)"Found video sender.");
            this.localVideoSender = sender;
        }
    }

    private VideoTrack getRemoteVideoTrack() {
        for (RtpTransceiver transceiver : this.peerConnection.getTransceivers()) {
            MediaStreamTrack track = transceiver.getReceiver().track();
            if (!(track instanceof VideoTrack)) continue;
            return (VideoTrack)track;
        }
        return null;
    }

    private static String getSdpVideoCodecName(PeerConnectionParameters parameters) {
        switch (parameters.videoCodec) {
            case "VP8": {
                return VIDEO_CODEC_VP8;
            }
            case "VP9": {
                return VIDEO_CODEC_VP9;
            }
            case "H264 High": 
            case "H264 Baseline": {
                return VIDEO_CODEC_H264;
            }
        }
        return VIDEO_CODEC_VP8;
    }

    private static String getFieldTrials(PeerConnectionParameters peerConnectionParameters) {
        String fieldTrials = "";
        if (peerConnectionParameters.videoFlexfecEnabled) {
            fieldTrials = fieldTrials + VIDEO_FLEXFEC_FIELDTRIAL;
            LogUtils.DLog((String)TAG, (String)"Enable FlexFEC field trial.");
        }
        fieldTrials = fieldTrials + VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL;
        if (peerConnectionParameters.disableWebRtcAGCAndHPF) {
            fieldTrials = fieldTrials + DISABLE_WEBRTC_AGC_FIELDTRIAL;
            LogUtils.DLog((String)TAG, (String)"Disable WebRTC AGC field trial.");
        }
        if (VIDEO_CODEC_H264_HIGH.equals(peerConnectionParameters.videoCodec)) {
            fieldTrials = fieldTrials + VIDEO_H264_HIGH_PROFILE_FIELDTRIAL;
        }
        return fieldTrials;
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + codec + " codec"));
            return sdpDescription;
        }
        LogUtils.DLog((String)TAG, (String)("Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]));
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            LogUtils.DLog((String)TAG, (String)("Found " + codec + " " + lines[i]));
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-startConnectServer-bitrate=" + bitrateKbps;
            } else {
                int n = i;
                lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            LogUtils.DLog((String)TAG, (String)("Update remote SDP line: " + lines[i]));
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            LogUtils.DLog((String)TAG, (String)("Add remote SDP line: " + bitrateSet));
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            Log.e((String)TAG, (String)("Wrong SDP media description format: " + mLine));
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return PeerConnectionClient.joinString(newLineParts, " ", false);
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = PeerConnectionClient.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            Log.w((String)TAG, (String)("No mediaDescription line, so can't prefer " + codec));
            return sdpDescription;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (String line : lines) {
            Matcher codecMatcher = codecPattern.matcher(line);
            if (!codecMatcher.matches()) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            Log.w((String)TAG, (String)("No payload types with name " + codec));
            return sdpDescription;
        }
        String newMLine = PeerConnectionClient.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }
        LogUtils.DLog((String)TAG, (String)("Change media description from: " + lines[mLineIndex] + " to " + newMLine));
        lines[mLineIndex] = newMLine;
        return PeerConnectionClient.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private void drainCandidates() {
        if (this.queuedRemoteCandidates != null) {
            LogUtils.DLog((String)TAG, (String)("Add " + this.queuedRemoteCandidates.size() + " remote candidates"));
            for (IceCandidate candidate : this.queuedRemoteCandidates) {
                this.peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    private void switchCameraInternal() {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            if (!this.isVideoCallEnabled() || this.isError) {
                Log.e((String)TAG, (String)("Failed to switch camera. Video: " + this.isVideoCallEnabled() + ". Error : " + this.isError));
                return;
            }
            LogUtils.DLog((String)TAG, (String)"Switch camera");
            CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
            cameraVideoCapturer.switchCamera(null);
        } else {
            LogUtils.DLog((String)TAG, (String)"Will not switch camera, video caputurer is not a camera");
        }
    }

    public void switchCamera() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerConnectionClient.this.switchCameraInternal();
            }
        });
    }

    public void changeCaptureFormat(final int width, final int height, final int framerate) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerConnectionClient.this.changeCaptureFormatInternal(width, height, framerate);
            }
        });
    }

    private void changeCaptureFormatInternal(int width, int height, int framerate) {
        if (!this.isVideoCallEnabled() || this.isError || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.isVideoCallEnabled() + ". Error : " + this.isError));
            return;
        }
        LogUtils.DLog((String)TAG, (String)("changeCaptureFormat: " + width + "x" + height + "@" + framerate));
        this.videoSource.adaptOutputFormat(width, height, framerate);
    }

    public void sendDataWithChannel(final String msg) {
        if (!this.dataChannelEnabled) {
            return;
        }
        if (this.dataChannel == null) {
            return;
        }
        LogUtils.DLog((String)"zlq", (String)("send tbcp==" + msg));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                DataChannel.Buffer buf = new DataChannel.Buffer(ByteBuffer.wrap(msg.getBytes()), false);
                LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("len:" + msg.length() + ", buf:" + buf.data.toString()));
                PeerConnectionClient.this.dataChannel.send(buf);
            }
        });
    }

    public boolean acquireWifi() {
        if (this.mAcquired) {
            return true;
        }
        if (this.mWifiManager == null) {
            this.mWifiManager = (WifiManager)this.appContext.getSystemService("wifi");
        }
        Log.d((String)TAG, (String)"wifi lock acquireNetworkLock()");
        boolean connected = false;
        ConnectivityManager sConnectivityManager = (ConnectivityManager)this.appContext.getSystemService("connectivity");
        NetworkInfo networkInfo = sConnectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        int netType = networkInfo.getType();
        if (netType == 1 && this.mWifiLock == null) {
            if (this.mWifiManager != null && this.mWifiManager.isWifiEnabled()) {
                NetworkInfo.DetailedState detailedState;
                this.mWifiLock = this.mWifiManager.createWifiLock(3, TAG);
                WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                if (wifiInfo != null && this.mWifiLock != null && ((detailedState = WifiInfo.getDetailedStateOf((SupplicantState)wifiInfo.getSupplicantState())) == NetworkInfo.DetailedState.CONNECTED || detailedState == NetworkInfo.DetailedState.CONNECTING || detailedState == NetworkInfo.DetailedState.OBTAINING_IPADDR)) {
                    this.mWifiLock.acquire();
                    this.mConnetedSSID = wifiInfo.getSSID();
                    connected = true;
                }
            } else {
                Log.d((String)TAG, (String)"wifi lock  not enabled");
            }
        } else if (netType == 0 || netType == 6) {
            connected = true;
        } else if (netType == 9) {
            connected = true;
        }
        if (!connected) {
            Log.e((String)TAG, (String)"wifi lock  active network");
            return false;
        }
        PowerManager pm = (PowerManager)this.appContext.getSystemService("power");
        PowerManager.WakeLock wl = pm.newWakeLock(6, TAG);
        wl.acquire();
        Log.i((String)TAG, (String)"wifi lock power Acquired()");
        this.mAcquired = true;
        return true;
    }

    public boolean releaseWifi() {
        if (this.mWifiLock != null) {
            try {
                if (this.mWifiLock.isHeld()) {
                    Log.d((String)TAG, (String)"releaseNetworkLock()");
                    this.mWifiLock.release();
                }
            }
            catch (Exception ex) {
                Log.d((String)TAG, (String)("releaseNetworkLock:" + ex.getMessage()));
            }
            this.mWifiLock = null;
        }
        PowerManager pm = (PowerManager)this.appContext.getSystemService("power");
        PowerManager.WakeLock wl = pm.newWakeLock(6, TAG);
        try {
            Log.d((String)TAG, (String)"release dim_wake_Lock()");
            wl.release();
        }
        catch (Exception ex) {
            Log.d((String)TAG, (String)("releaseNetworkLock:" + ex.getMessage()));
        }
        this.mAcquired = false;
        return true;
    }

    static {
        peerconnectionCounts = 0;
        enableAudioPlayout = true;
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        public void onCreateSuccess(SessionDescription origSdp) {
            if (PeerConnectionClient.this.localSdp != null) {
                PeerConnectionClient.this.reportError("Multiple SDP create.");
                return;
            }
            String sdpDescription = origSdp.description;
            if (PeerConnectionClient.this.preferIsac) {
                sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ISAC, true);
            } else if (PeerConnectionClient.this.preferIlbc) {
                sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ILBC, true);
            }
            if (PeerConnectionClient.this.isVideoCallEnabled()) {
                sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.getSdpVideoCodecName(PeerConnectionClient.this.peerConnectionParameters), false);
            }
            final SessionDescription sdp = new SessionDescription(origSdp.type, sdpDescription);
            PeerConnectionClient.this.localSdp = sdp;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                        LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Set local SDP from " + sdp.type + ", sdpdescription:" + sdp.description));
                        PeerConnectionClient.this.peerConnection.setLocalDescription((SdpObserver)PeerConnectionClient.this.sdpObserver, sdp);
                    }
                }
            });
        }

        public void onSetSuccess() {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                        return;
                    }
                    if (PeerConnectionClient.this.isInitiator) {
                        if (PeerConnectionClient.this.peerConnection.getRemoteDescription() == null) {
                            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"Local SDP set succesfully");
                            PeerConnectionClient.this.events.onLocalDescription(PeerConnectionClient.this.localSdp);
                        } else {
                            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"Remote SDP set succesfully");
                            PeerConnectionClient.this.drainCandidates();
                        }
                    } else if (PeerConnectionClient.this.peerConnection.getLocalDescription() != null) {
                        LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"Local SDP set succesfully");
                        PeerConnectionClient.this.events.onLocalDescription(PeerConnectionClient.this.localSdp);
                        PeerConnectionClient.this.drainCandidates();
                    } else {
                        LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"Remote SDP set succesfully");
                        PeerConnectionClient.this.events.onSetRemoteDescriptionSuccess();
                    }
                }
            });
        }

        public void onCreateFailure(String error) {
            PeerConnectionClient.this.reportError("createSDP error: " + error);
        }

        public void onSetFailure(String error) {
            PeerConnectionClient.this.reportError("setSDP error: " + error);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        public void onIceCandidate(final IceCandidate candidate) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PeerConnectionClient.this.events.onIceCandidate(candidate);
                }
            });
        }

        public void onIceCandidatesRemoved(final IceCandidate[] candidates) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PeerConnectionClient.this.events.onIceCandidatesRemoved(candidates);
                }
            });
        }

        public void onSignalingChange(PeerConnection.SignalingState newState) {
            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("SignalingState: " + newState));
        }

        public void onIceConnectionChange(final PeerConnection.IceConnectionState newState) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("IceConnectionState: " + newState));
                    if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                        PeerConnectionClient.this.events.onIceConnected();
                    } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED || newState == PeerConnection.IceConnectionState.CLOSED) {
                        PeerConnectionClient.this.events.onIceDisconnected();
                    } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                        PeerConnectionClient.this.events.onPeerConnectionError("ICE connection failed");
                    }
                }
            });
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("IceGatheringState: " + newState));
        }

        public void onIceConnectionReceivingChange(boolean receiving) {
            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("IceConnectionReceiving changed to " + receiving));
        }

        public void onAddStream(MediaStream stream) {
        }

        public void onRemoveStream(MediaStream stream) {
        }

        public void onDataChannel(final DataChannel dc) {
            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("New Data channel " + dc.label()));
            if (!PeerConnectionClient.this.dataChannelEnabled) {
                return;
            }
            dc.registerObserver(new DataChannel.Observer(){

                public void onBufferedAmountChange(long previousAmount) {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("--Data channel buffered amount changed: " + dc.label() + ": " + dc.state()));
                }

                public void onStateChange() {
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("--Data channel state changed: " + dc.label() + ": " + dc.state()));
                }

                public void onMessage(DataChannel.Buffer buffer) {
                    if (buffer.binary) {
                        LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("--Received binary msg over " + dc));
                        return;
                    }
                    ByteBuffer data = buffer.data;
                    byte[] bytes = new byte[data.capacity()];
                    data.get(bytes);
                    final String strData = new String(bytes, Charset.forName("UTF-8"));
                    LogUtils.DLog((String)PeerConnectionClient.TAG, (String)("Got msg: " + strData + " over " + dc));
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            Log.e((String)PeerConnectionClient.TAG, (String)("onDataChannel onMessage --" + PeerConnectionClient.this.events));
                            PeerConnectionClient.this.events.onDataChannelRcvData(strData);
                        }
                    });
                }
            });
        }

        public void onRenegotiationNeeded() {
            LogUtils.DLog((String)PeerConnectionClient.TAG, (String)"onRenegotiationNeeded");
        }

        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
        }
    }

    public static interface PeerConnectionEvents {
        public void onLocalDescription(SessionDescription var1);

        public void onSetRemoteDescriptionSuccess();

        public void onIceCandidate(IceCandidate var1);

        public void onIceCandidatesRemoved(IceCandidate[] var1);

        public void onIceConnected();

        public void onIceDisconnected();

        public void onPeerConnectionClosed();

        public void onPeerConnectionStatsReady(StatsReport[] var1);

        public void onPeerConnectionError(String var1);

        public void onDataChannelRcvData(String var1);
    }

    public static class PeerConnectionParameters {
        public final boolean videoCallEnabled;
        public final boolean loopback;
        public final boolean tracing;
        public final int videoWidth;
        public final int videoHeight;
        public final int videoFps;
        public final int videoMaxBitrate;
        public final String videoCodec;
        public final boolean videoCodecHwAcceleration;
        public final boolean videoFlexfecEnabled;
        public final int audioStartBitrate;
        public String audioCodec;
        public final boolean noAudioProcessing;
        public final boolean aecDump;
        public final boolean saveInputAudioToFile;
        public final boolean useOpenSLES;
        public final boolean disableBuiltInAEC;
        public final boolean disableBuiltInAGC;
        public final boolean disableBuiltInNS;
        public final boolean disableWebRtcAGCAndHPF;
        public final boolean enableRtcEventLog;
        public final boolean useLegacyAudioDevice;
        private final DataChannelParameters dataChannelParameters;

        public PeerConnectionParameters(boolean videoCallEnabled, boolean loopback, boolean tracing, int videoWidth, int videoHeight, int videoFps, int videoMaxBitrate, String videoCodec, boolean videoCodecHwAcceleration, boolean videoFlexfecEnabled, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean aecDump, boolean saveInputAudioToFile, boolean useOpenSLES, boolean disableBuiltInAEC, boolean disableBuiltInAGC, boolean disableBuiltInNS, boolean disableWebRtcAGCAndHPF, boolean enableRtcEventLog, boolean useLegacyAudioDevice, DataChannelParameters dataChannelParameters) {
            this.videoCallEnabled = videoCallEnabled;
            this.loopback = loopback;
            this.tracing = tracing;
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.videoFps = videoFps;
            this.videoMaxBitrate = videoMaxBitrate;
            this.videoCodec = videoCodec;
            this.videoFlexfecEnabled = videoFlexfecEnabled;
            this.videoCodecHwAcceleration = videoCodecHwAcceleration;
            this.audioStartBitrate = audioStartBitrate;
            this.audioCodec = audioCodec;
            this.noAudioProcessing = noAudioProcessing;
            this.aecDump = aecDump;
            this.saveInputAudioToFile = saveInputAudioToFile;
            this.useOpenSLES = useOpenSLES;
            this.disableBuiltInAEC = disableBuiltInAEC;
            this.disableBuiltInAGC = disableBuiltInAGC;
            this.disableBuiltInNS = disableBuiltInNS;
            this.disableWebRtcAGCAndHPF = disableWebRtcAGCAndHPF;
            this.enableRtcEventLog = enableRtcEventLog;
            this.useLegacyAudioDevice = useLegacyAudioDevice;
            this.dataChannelParameters = dataChannelParameters;
        }
    }

    public static class DataChannelParameters {
        public final boolean ordered;
        public final int maxRetransmitTimeMs;
        public final int maxRetransmits;
        public final String protocol;
        public final boolean negotiated;
        public final int id;

        public DataChannelParameters(boolean ordered, int maxRetransmitTimeMs, int maxRetransmits, String protocol, boolean negotiated, int id2) {
            this.ordered = ordered;
            this.maxRetransmitTimeMs = maxRetransmitTimeMs;
            this.maxRetransmits = maxRetransmits;
            this.protocol = protocol;
            this.negotiated = negotiated;
            this.id = id2;
        }
    }
}

