/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.greendao;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.greendao.dao.POCHistoryMessageDao;
import com.xdja.poc.sdk.greendao.manager.GreenDaoManager;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.query.WhereCondition;

public class HistoryMessageDBHelper {
    private static final String TAG = HistoryMessageDBHelper.class.getSimpleName();
    private final GreenDaoManager daoManager = GreenDaoManager.getInstance();
    private static HistoryMessageDBHelper dbHelper;
    private static final int MAX_CACHE_MESSAGE_SIZE = 3000;

    private HistoryMessageDBHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HistoryMessageDBHelper getInstance() {
        if (dbHelper != null) return dbHelper;
        Class<HistoryMessageDBHelper> clazz = HistoryMessageDBHelper.class;
        synchronized (HistoryMessageDBHelper.class) {
            if (dbHelper != null) return dbHelper;
            dbHelper = new HistoryMessageDBHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbHelper;
        }
    }

    public synchronized void insertOrUpdate(List<POCHistoryMessage> datas) {
        this.delete();
        this.getPocHistoryMessageDao().insertOrReplaceInTx(datas);
        LogUtils.DLog((String)TAG, (String)"insert success");
    }

    public synchronized List<POCHistoryMessage> query(String room, int pageSize, long time) {
        List result = null;
        result = time == 0L ? this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.GroupUri.eq((Object)room), new WhereCondition[0]).orderDesc(new Property[]{POCHistoryMessageDao.Properties.SyncTime}).limit(pageSize).build().list() : this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.SyncTime.lt((Object)time), new WhereCondition[]{POCHistoryMessageDao.Properties.GroupUri.eq((Object)room)}).orderAsc(new Property[]{POCHistoryMessageDao.Properties.SyncTime}).limit(pageSize).build().list();
        Collections.sort(result, new Comparator<POCHistoryMessage>(){

            @Override
            public int compare(POCHistoryMessage o1, POCHistoryMessage o2) {
                return o1.getSyncTime().compareTo(o2.getSyncTime());
            }
        });
        LogUtils.DLog((String)TAG, (String)"query success");
        return result;
    }

    public synchronized void delete() {
        if (this.getPocHistoryMessageDao().count() >= 3000L) {
            List result = this.getPocHistoryMessageDao().queryBuilder().orderAsc(new Property[]{POCHistoryMessageDao.Properties.SyncTime}).limit(200).build().list();
            if (result != null) {
                this.getPocHistoryMessageDao().deleteInTx(result);
            }
            LogUtils.DLog((String)TAG, (String)"delete success");
        }
    }

    public long count(String room) {
        return this.getPocHistoryMessageDao().queryBuilder().where(POCHistoryMessageDao.Properties.GroupUri.eq((Object)room), new WhereCondition[0]).build().list().size();
    }

    private POCHistoryMessageDao getPocHistoryMessageDao() {
        return this.daoManager.getDaoSession().getPOCHistoryMessageDao();
    }
}

