/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.greendao.dao;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.xdja.poc.sdk.greendao.dao.DaoSession;
import com.xdja.poc.sdk.greendao.dao.POCHistoryMessageDao;
import com.xdja.poc.sdk.greendao.dao.RecordMessageDao;
import org.greenrobot.greendao.AbstractDaoMaster;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseOpenHelper;
import org.greenrobot.greendao.database.StandardDatabase;
import org.greenrobot.greendao.identityscope.IdentityScopeType;

public class DaoMaster
extends AbstractDaoMaster {
    public static final int SCHEMA_VERSION = 6;

    public static void createAllTables(Database db, boolean ifNotExists) {
        RecordMessageDao.createTable(db, ifNotExists);
        POCHistoryMessageDao.createTable(db, ifNotExists);
    }

    public static void dropAllTables(Database db, boolean ifExists) {
        RecordMessageDao.dropTable(db, ifExists);
        POCHistoryMessageDao.dropTable(db, ifExists);
    }

    public static DaoSession newDevSession(Context context, String name) {
        Database db = new DevOpenHelper(context, name).getWritableDb();
        DaoMaster daoMaster = new DaoMaster(db);
        return daoMaster.newSession();
    }

    public DaoMaster(SQLiteDatabase db) {
        this((Database)new StandardDatabase(db));
    }

    public DaoMaster(Database db) {
        super(db, 6);
        this.registerDaoClass(RecordMessageDao.class);
        this.registerDaoClass(POCHistoryMessageDao.class);
    }

    public DaoSession newSession() {
        return new DaoSession(this.db, IdentityScopeType.Session, this.daoConfigMap);
    }

    public DaoSession newSession(IdentityScopeType type) {
        return new DaoSession(this.db, type, this.daoConfigMap);
    }

    public static class DevOpenHelper
    extends OpenHelper {
        public DevOpenHelper(Context context, String name) {
            super(context, name);
        }

        public DevOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory);
        }

        public void onUpgrade(Database db, int oldVersion, int newVersion) {
            Log.i((String)"greenDAO", (String)("Upgrading schema from version " + oldVersion + " to " + newVersion + " by dropping all tables"));
            DaoMaster.dropAllTables(db, true);
            this.onCreate(db);
        }
    }

    public static abstract class OpenHelper
    extends DatabaseOpenHelper {
        public OpenHelper(Context context, String name) {
            super(context, name, 6);
        }

        public OpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory, 6);
        }

        public void onCreate(Database db) {
            Log.i((String)"greenDAO", (String)"Creating tables for schema version 6");
            DaoMaster.createAllTables(db, false);
        }
    }
}

