/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.record.fdfs.FdfsService;
import com.xdja.poc.sdk.record.fdfs.IFdfsService;
import com.xdja.poc.sdk.record.fdfs.ThreadPoolManager;

public class UploadRecordHelper {
    private static final String TAG = UploadRecordHelper.class.getSimpleName();
    private IFdfsService fdfsService;
    private long uploadId;
    private String waitUploadUri;
    private UploadRecordCallBack uploadRecordCallBack;
    private static final UploadRecordHelper instance = new UploadRecordHelper();

    private UploadRecordHelper() {
    }

    public static UploadRecordHelper getInstance() {
        ThreadPoolManager.getInstance().init();
        return instance;
    }

    public void startUploadRecord(String recordUri) {
        this.waitUploadUri = recordUri;
        if (this.fdfsService == null) {
            FdfsService fdfsService = new FdfsService();
            fdfsService.onCreate();
            this.fdfsService = (IFdfsService)fdfsService.getBinder();
        }
        if (this.fdfsService == null) {
            return;
        }
        this.uploadId = 1000L;
        LogUtils.ELog((String)TAG, (String)Thread.currentThread().getName());
        this.fdfsService.upload(this.uploadId, recordUri, null, new FdfsService.UploadCallback(){

            @Override
            public void onProgress(long uploadId, long uploadSize, long totalSize) {
                LogUtils.DLog((String)TAG, (String)("\u4e0a\u4f20\u5f55\u97f3onProgress: " + uploadId + "-" + uploadSize + "-" + totalSize));
            }

            @Override
            public void onSuccess(long uploadId, String fileId) {
                LogUtils.DLog((String)TAG, (String)("\u4e0a\u4f20\u5f55\u97f3onSuccess: " + uploadId + "-" + fileId));
                if (UploadRecordHelper.this.uploadRecordCallBack != null) {
                    UploadRecordHelper.this.uploadRecordCallBack.onUploadRecordSuccess(fileId, UploadRecordHelper.this.waitUploadUri);
                }
            }

            @Override
            public void onError(long uploadId, int errorCode) {
                LogUtils.DLog((String)TAG, (String)("\u4e0a\u4f20\u5f55\u97f3onError: " + uploadId + "-" + errorCode));
                if (UploadRecordHelper.this.uploadRecordCallBack != null) {
                    UploadRecordHelper.this.uploadRecordCallBack.onUploadRecordFailed(errorCode, UploadRecordHelper.this.waitUploadUri);
                }
            }
        });
    }

    public void stopUploadRecord() {
        if (this.fdfsService != null) {
            this.fdfsService.stopUpload(this.uploadId);
            this.fdfsService = null;
        }
        ThreadPoolManager.getInstance().shutDown();
        this.waitUploadUri = null;
    }

    public void setUploadRecordCallBack(UploadRecordCallBack uploadRecordCallBack) {
        this.uploadRecordCallBack = uploadRecordCallBack;
    }

    public static interface UploadRecordCallBack {
        public void onUploadRecordSuccess(String var1, String var2);

        public void onUploadRecordFailed(int var1, String var2);
    }
}

