/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.http;

import android.text.TextUtils;
import android.util.SparseArray;
import com.google.gson.Gson;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.record.http.HttpRequest;
import com.xdja.poc.sdk.record.http.HttpUploadFileRequest;
import com.xdja.poc.sdk.record.http.IHttpClient;
import com.xdja.poc.sdk.record.http.UploadFileRequestBody;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class BaseHttpClient
implements IHttpClient {
    protected String TAG = this.getClass().getSimpleName();
    protected static final int DEFAULT_HTTP_TIMEOUT = 5;
    protected static final String DEFAULT_CONTENT_TYPE = "application/json";
    protected static final String CONTENT_TYPE_FORM = "multipart/form-data";
    protected static final String TYPE_UPLOAD_FILE = "application/octet-stream";
    protected static final int HTTP_RESPONSE_OK = 200;
    protected OkHttpClient httpClient;
    private int requestCounter = 0;
    private SparseArray<Call> requestCallMap = new SparseArray();
    private SparseArray<UploadFileRequestBody> uploadRequestBodyMap = new SparseArray();

    @Override
    public int request(HttpRequest request, IHttpClient.Callback callback) {
        this.checkNotNull(request);
        return this.dealRequest(request.getMethod(), request.getUrl(), request.getParamJsonString(), request.getHeaders(), callback);
    }

    protected void checkNotNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("checkNotNull: obj is null");
        }
    }

    @Override
    public int exec(String url, Map<String, Object> params, Map<String, String> headers, IHttpClient.Callback callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            LogUtils.ELog((String)this.TAG, (String)"url is null");
            throw new NullPointerException("url is null");
        }
        return this.exec("POST", url, params, headers, callback);
    }

    @Override
    public int exec(String methodType, String url, Object body, Map<String, String> headers, IHttpClient.Callback callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            LogUtils.ELog((String)this.TAG, (String)"url is null");
            throw new NullPointerException("url is null");
        }
        return this.dealRequest(methodType, url, body, headers, callback);
    }

    @Override
    public int execFormData(String url, Map<String, String> params, Map<String, String> headers, IHttpClient.Callback callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            LogUtils.ELog((String)this.TAG, (String)"url is null");
            throw new NullPointerException("url is null");
        }
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        LogUtils.DLog((String)this.TAG, (String)("execFormData: url: " + url));
        if (headers != null && !headers.isEmpty()) {
            LogUtils.DLog((String)this.TAG, (String)("execFormData: headers:" + headers.toString()));
            this.addHeader(builder, headers);
        }
        RequestBody requestBody = null;
        if (params != null && !params.isEmpty()) {
            requestBody = this.createRequestBody(params);
        }
        builder.post(requestBody);
        int requestId = this.getRequestId();
        this.realRequest(requestId, builder.build(), callback);
        return requestId;
    }

    private RequestBody createRequestBody(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            builder.addFormDataPart(key, value);
        }
        return builder.build();
    }

    @Override
    public int execGet(String url, Map<String, String> headers, IHttpClient.Callback callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            LogUtils.ELog((String)this.TAG, (String)"url is null");
            throw new NullPointerException("url is null");
        }
        return this.exec("GET", url, null, headers, callback);
    }

    private int dealRequest(String methodType, String url, Object obj, Map<String, String> headers, IHttpClient.Callback callback) {
        Object params;
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        LogUtils.DLog((String)this.TAG, (String)("exec: url: " + url));
        if (headers != null && !headers.isEmpty()) {
            LogUtils.DLog((String)this.TAG, (String)("exec: headers:" + headers.toString()));
            this.addHeader(builder, headers);
        }
        String requestJson = "{}";
        if (obj instanceof String) {
            String body = (String)obj;
            if (!TextUtils.isEmpty((CharSequence)body)) {
                requestJson = body;
                LogUtils.DLog((String)this.TAG, (String)("exec: request: " + requestJson));
            }
        } else if (obj instanceof Map && (params = (Map)obj) != null && !params.isEmpty()) {
            requestJson = new Gson().toJson(params);
            LogUtils.DLog((String)this.TAG, (String)("exec: request: " + requestJson));
        }
        switch (methodType) {
            case "POST": {
                builder.post(RequestBody.create((MediaType)MediaType.parse((String)DEFAULT_CONTENT_TYPE), (String)requestJson));
                break;
            }
            case "GET": {
                builder.get();
                break;
            }
            case "PUT": {
                builder.put(RequestBody.create((MediaType)MediaType.parse((String)DEFAULT_CONTENT_TYPE), (String)requestJson));
                break;
            }
            case "DELETE": {
                builder.delete(RequestBody.create((MediaType)MediaType.parse((String)DEFAULT_CONTENT_TYPE), (String)requestJson));
                break;
            }
            case "PATCH": {
                builder.patch(RequestBody.create((MediaType)MediaType.parse((String)DEFAULT_CONTENT_TYPE), (String)requestJson));
                break;
            }
        }
        Request request = builder.build();
        int requestId = this.getRequestId();
        this.realRequest(requestId, request, callback);
        return requestId;
    }

    private int realRequest(final int requestId, Request request, final IHttpClient.Callback callback) {
        Call call = this.httpClient.newCall(request);
        this.requestCallMap.put(requestId, (Object)call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                LogUtils.ELog((String)BaseHttpClient.this.TAG, (String)("exec: onFailure: " + e.toString()));
                BaseHttpClient.this.requestCallMap.delete(requestId);
                if (callback != null) {
                    callback.onFailed(requestId, -1, e.toString());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                BaseHttpClient.this.requestCallMap.delete(requestId);
                BaseHttpClient.this.dealOnResponse(requestId, response, callback);
            }
        });
        return requestId;
    }

    private synchronized int getRequestId() {
        return ++this.requestCounter;
    }

    @Override
    public void cancelRequest(int requestId) {
        Call call = (Call)this.requestCallMap.get(requestId);
        if (call != null) {
            UploadFileRequestBody uploadFileRequestBody = (UploadFileRequestBody)((Object)this.uploadRequestBodyMap.get(requestId));
            LogUtils.DLog((String)this.TAG, (String)("cancelRequest: requestId: " + requestId));
            if (uploadFileRequestBody != null) {
                LogUtils.DLog((String)this.TAG, (String)"cancelRequest: cancel upload");
                uploadFileRequestBody.setCanceled(true);
            } else {
                call.cancel();
                this.requestCallMap.delete(requestId);
            }
        }
    }

    private void dealOnResponse(int requestId, Response response, IHttpClient.Callback callback) {
        block8: {
            if (response == null || response.body() == null) {
                LogUtils.ELog((String)this.TAG, (String)"exec: response: response is null");
                if (callback != null) {
                    callback.onFailed(requestId, -2, "response is null");
                }
                return;
            }
            try {
                byte[] responseBytes = response.body().bytes();
                String responseBody = new String(responseBytes);
                int responseCode = response.code();
                LogUtils.DLog((String)this.TAG, (String)("exec: response: responseCode: " + responseCode + ", responseBody: " + responseBody));
                if (responseCode == 200) {
                    if (callback != null) {
                        callback.onSuccess(requestId, responseBody);
                    }
                } else if (callback != null) {
                    callback.onFailed(requestId, responseCode, responseBody);
                }
            }
            catch (Exception e) {
                LogUtils.ELog((String)this.TAG, (String)("dealOnResponse: error: " + e));
                if (callback == null) break block8;
                callback.onFailed(requestId, -2, "unknown error: " + e.toString());
            }
        }
    }

    private void addHeader(Request.Builder builder, Map<String, String> headers) {
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            builder.addHeader(key, value);
        }
    }

    @Override
    public int uploadFile(HttpUploadFileRequest uploadFileRequest, IHttpClient.UploadFileCallback callback) {
        this.checkNotNull(uploadFileRequest);
        Request.Builder builder = new Request.Builder();
        String url = uploadFileRequest.getUrl();
        builder.url(url);
        LogUtils.DLog((String)this.TAG, (String)("exec: url: " + url));
        Map<String, String> headers = uploadFileRequest.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            LogUtils.DLog((String)this.TAG, (String)("exec: headers:" + headers.toString()));
            this.addHeader(builder, headers);
        }
        File file = new File(uploadFileRequest.getFilePath());
        int requestId = this.getRequestId();
        UploadFileRequestBody body = new UploadFileRequestBody(requestId, file, uploadFileRequest.getLastUploadSize(), uploadFileRequest.getBlockSize(), callback);
        builder.post((RequestBody)body);
        Request request = builder.build();
        this.realRequest(requestId, request, callback);
        this.uploadRequestBodyMap.put(requestId, (Object)body);
        return requestId;
    }

    @Override
    public int downloadFile(Request request, Callback callback) {
        this.httpClient.newCall(request).enqueue(callback);
        return 0;
    }
}

