/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.history;

import android.media.MediaPlayer;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.record.http.HttpClientFactory;
import com.xdja.poc.sdk.record.http.IHttpClient;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

public class HistoryVoicePlayer {
    private MediaPlayer mediaPlayer;
    private PlayVoiceCallBack playVoiceCallBack;
    private String upVoiceUrl = "";
    private IHttpClient client;
    private boolean downloading = false;
    private static HistoryVoicePlayer instance = null;

    private HistoryVoicePlayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HistoryVoicePlayer getInstance() {
        if (instance != null) return instance;
        Class<HistoryVoicePlayer> clazz = HistoryVoicePlayer.class;
        synchronized (HistoryVoicePlayer.class) {
            if (instance != null) return instance;
            instance = new HistoryVoicePlayer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void startPlay(POCHistoryMessage message, PlayVoiceCallBack voiceCallBack) {
        if (this.downloading) {
            return;
        }
        if (this.upVoiceUrl.equals(message.getFileUrl()) && this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.releasePlay();
            if (this.playVoiceCallBack != null) {
                this.playVoiceCallBack.onPlayStop();
            }
            return;
        }
        this.releasePlay();
        this.upVoiceUrl = message.getFileUrl();
        this.playVoiceCallBack = voiceCallBack;
        if (this.playVoiceCallBack != null) {
            this.playVoiceCallBack.onPlayStart();
        }
        if (new File(Constants.HISTORY_RECORD_DOWNLOAD_PATH + message.id + "." + message.fileType).exists()) {
            this.realPlay(Constants.HISTORY_RECORD_DOWNLOAD_PATH + message.id + "." + message.fileType);
            return;
        }
        this.downloadFile(message);
    }

    public void releasePlay() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
        }
        this.mediaPlayer = null;
    }

    private void realPlay(String fileUri) {
        block3: {
            if (this.mediaPlayer == null) {
                this.mediaPlayer = new MediaPlayer();
            }
            try {
                this.mediaPlayer.setDataSource(fileUri);
                this.mediaPlayer.setLooping(false);
                this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        HistoryVoicePlayer.this.releasePlay();
                        if (HistoryVoicePlayer.this.playVoiceCallBack != null) {
                            HistoryVoicePlayer.this.playVoiceCallBack.onPlayFailed();
                        }
                        return false;
                    }
                });
                this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        HistoryVoicePlayer.this.releasePlay();
                        if (HistoryVoicePlayer.this.playVoiceCallBack != null) {
                            HistoryVoicePlayer.this.playVoiceCallBack.onPlayStop();
                        }
                    }
                });
                this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        HistoryVoicePlayer.this.mediaPlayer.start();
                    }
                });
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.releasePlay();
                if (this.playVoiceCallBack == null) break block3;
                this.playVoiceCallBack.onPlayFailed();
            }
        }
    }

    private void downloadFile(POCHistoryMessage message) {
        this.downloading = true;
        final POCHistoryMessage currMessage = message;
        this.client = HttpClientFactory.createHttpClient();
        Request request = new Request.Builder().url(currMessage.fileUrl).build();
        this.client.downloadFile(request, new Callback(){

            public void onFailure(Call call, IOException e) {
                HistoryVoicePlayer.this.downloading = false;
                if (HistoryVoicePlayer.this.playVoiceCallBack != null) {
                    HistoryVoicePlayer.this.playVoiceCallBack.onPlayFailed();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                InputStream is = null;
                byte[] buff = new byte[1024];
                int len = 0;
                FileOutputStream fos = null;
                File dir = new File(Constants.HISTORY_RECORD_DOWNLOAD_PATH);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(dir, currMessage.id + "." + currMessage.fileType);
                try {
                    is = response.body().byteStream();
                    fos = new FileOutputStream(file);
                    while ((len = is.read(buff)) != -1) {
                        fos.write(buff);
                    }
                    fos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (HistoryVoicePlayer.this.playVoiceCallBack != null) {
                        HistoryVoicePlayer.this.playVoiceCallBack.onPlayFailed();
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                HistoryVoicePlayer.this.downloading = false;
                if (!HistoryVoicePlayer.this.upVoiceUrl.equals(currMessage.getFileUrl())) {
                    return;
                }
                HistoryVoicePlayer.this.realPlay(file.getAbsolutePath());
            }
        });
    }

    public static interface PlayVoiceCallBack {
        public void onPlayStart();

        public void onPlayStop();

        public void onPlayFailed();
    }
}

