/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.history;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.db.entity.User;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import com.xdja.poc.sdk.utils.GlideUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class POCHistoryMessageAdapter
extends RecyclerArrayAdapter<POCHistoryMessage> {
    private AnimationDrawable drawable;
    private Map<String, POCMemberInfo> mCacheUserinfoMap = POCUiKitProxyImpl.getInstance().getUserInfosCache();
    private User mCacheUserinfo = POCUiKitProxyImpl.getInstance().getUserInfo();
    private String upMessageTime;
    private static final int MAX_MESSAGE_TIME_INTERVAL = 30000;

    public POCHistoryMessageAdapter(Context context) {
        super(context);
    }

    public BaseViewHolder OnCreateViewHolder(ViewGroup parent, int viewType) {
        return new MessageViewHolder(parent);
    }

    public void OnBindViewHolder(final BaseViewHolder holder, int position) {
        super.OnBindViewHolder(holder, position);
        if (holder instanceof MessageViewHolder) {
            ((MessageViewHolder)holder).mMineVoiceLayout.setOnClickListener(v -> HistoryVoicePlayer.getInstance().startPlay((POCHistoryMessage)this.getAllData().get(position), new HistoryVoicePlayer.PlayVoiceCallBack(){

                @Override
                public void onPlayFailed() {
                    ToastUtils.showToast((String)"\u64ad\u653e\u5f02\u5e38");
                    POCHistoryMessageAdapter.this.stopAnim();
                    ((MessageViewHolder)holder).mOtherVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                }

                @Override
                public void onPlayStart() {
                    POCHistoryMessageAdapter.this.stopAnim();
                    POCHistoryMessageAdapter.this.drawable = (AnimationDrawable)((MessageViewHolder)holder).mMineVoice.getBackground();
                    POCHistoryMessageAdapter.this.drawable.start();
                }

                @Override
                public void onPlayStop() {
                    POCHistoryMessageAdapter.this.stopAnim();
                    ((MessageViewHolder)holder).mMineVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_white));
                }
            }));
            ((MessageViewHolder)holder).mOtherVoiceLayout.setOnClickListener(v -> HistoryVoicePlayer.getInstance().startPlay((POCHistoryMessage)this.getAllData().get(position), new HistoryVoicePlayer.PlayVoiceCallBack(){

                @Override
                public void onPlayFailed() {
                    ToastUtils.showToast((String)"\u64ad\u653e\u5f02\u5e38");
                    POCHistoryMessageAdapter.this.stopAnim();
                    ((MessageViewHolder)holder).mOtherVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                }

                @Override
                public void onPlayStart() {
                    POCHistoryMessageAdapter.this.stopAnim();
                    POCHistoryMessageAdapter.this.drawable = (AnimationDrawable)((MessageViewHolder)holder).mOtherVoice.getBackground();
                    POCHistoryMessageAdapter.this.drawable.start();
                }

                @Override
                public void onPlayStop() {
                    POCHistoryMessageAdapter.this.stopAnim();
                    ((MessageViewHolder)holder).mOtherVoice.setBackground(POCHistoryMessageAdapter.this.getContext().getDrawable(R.drawable.poc_anim_history_record_voice_blue));
                }
            }));
        }
    }

    private int computeVoiceTime(POCHistoryMessage message) {
        return Integer.valueOf(message.getFileSize()) / 1000 + 1;
    }

    private int computeLayoutWidth(int voiceTime) {
        return DisplayUtil.dip2px((Context)this.getContext(), (float)(64 + (voiceTime < 10 ? voiceTime * 3 : (voiceTime < 20 ? voiceTime * 2 : voiceTime / 2))));
    }

    private boolean computeMessageTimeInterval(String currMsgTime) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date currMsgDate = sourceFormat.parse(currMsgTime);
            Date upMsgDate = sourceFormat.parse(this.upMessageTime);
            if (currMsgDate.getTime() - upMsgDate.getTime() > 30000L) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    private POCMemberInfo transation(String messageAccount) {
        if (this.mCacheUserinfoMap == null) {
            return null;
        }
        return this.mCacheUserinfoMap.get(messageAccount);
    }

    private String formatTime(String sourceTime) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat destFormat = new SimpleDateFormat("HH:mm");
        try {
            Date date = sourceFormat.parse(sourceTime);
            return this.getAppendTime(date) + destFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return sourceTime;
        }
    }

    private String getAppendTime(Date messageDate) throws ParseException {
        String append;
        SimpleDateFormat msgDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String msgDateStr = msgDateFormat.format(messageDate);
        Date msgResultDate = msgDateFormat.parse(msgDateStr);
        Date phoneDate = new Date();
        String phoneDateStr = msgDateFormat.format(phoneDate);
        Date phoneResultDate = msgDateFormat.parse(phoneDateStr);
        if (phoneResultDate.getTime() - msgResultDate.getTime() == 0L) {
            append = "";
        } else if (phoneResultDate.getTime() - msgResultDate.getTime() <= 86400000L) {
            append = "\u6628\u5929 ";
        } else {
            SimpleDateFormat resultFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            append = resultFormat.format(msgResultDate) + " ";
        }
        return append;
    }

    public void stopAnim() {
        if (this.drawable != null) {
            this.drawable.stop();
        }
    }

    public class MessageViewHolder
    extends BaseViewHolder<POCHistoryMessage> {
        ImageView mMineIcon;
        ImageView mOtherIcon;
        TextView mMineTime;
        TextView mOtherTime;
        TextView mMineName;
        TextView mOtherName;
        RelativeLayout mMineLayout;
        RelativeLayout mOtherLayout;
        TextView mNotSupportLayout;
        TextView mTime;
        RelativeLayout mMineVoiceLayout;
        RelativeLayout mOtherVoiceLayout;
        ImageView mMineVoice;
        ImageView mOtherVoice;

        public MessageViewHolder(ViewGroup group) {
            super(group, R.layout.poc_item_history_message);
            this.mMineIcon = (ImageView)this.$(R.id.iv_mine_message_icon);
            this.mMineLayout = (RelativeLayout)this.$(R.id.rl_mine);
            this.mMineTime = (TextView)this.$(R.id.tv_mine_message_time);
            this.mMineName = (TextView)this.$(R.id.tv_mine_name);
            this.mMineVoiceLayout = (RelativeLayout)this.$(R.id.rl_mine_voice_bg);
            this.mMineVoice = (ImageView)this.$(R.id.iv_mine_voice);
            this.mOtherIcon = (ImageView)this.$(R.id.iv_other_message_icon);
            this.mOtherLayout = (RelativeLayout)this.$(R.id.rl_other);
            this.mOtherTime = (TextView)this.$(R.id.tv_other_message_time);
            this.mOtherName = (TextView)this.$(R.id.tv_other_name);
            this.mOtherVoiceLayout = (RelativeLayout)this.$(R.id.rl_other_voice_bg);
            this.mOtherVoice = (ImageView)this.$(R.id.iv_other_voice);
            this.mNotSupportLayout = (TextView)this.$(R.id.tv_not_support);
            this.mTime = (TextView)this.$(R.id.iv_interval_time);
        }

        public void setData(POCHistoryMessage message) {
            POCHistoryMessageAdapter.this.upMessageTime = ((POCHistoryMessage)POCHistoryMessageAdapter.this.getItem(this.getDataPosition() > 0 ? this.getDataPosition() - 1 : this.getDataPosition())).getCreateTime();
            String userAccount = POCHistoryMessageAdapter.this.mCacheUserinfo != null ? POCHistoryMessageAdapter.this.mCacheUserinfo.getAccount() : "";
            String messageAccount = message.owner;
            if (StringUtils.isEmpty((String)messageAccount) || StringUtils.isEmpty((String)userAccount)) {
                this.mNotSupportLayout.setVisibility(0);
                this.mOtherLayout.setVisibility(8);
                this.mMineLayout.setVisibility(8);
                return;
            }
            this.mTime.setText((CharSequence)POCHistoryMessageAdapter.this.formatTime(message.createTime));
            this.mTime.setVisibility(POCHistoryMessageAdapter.this.computeMessageTimeInterval(message.createTime) || this.getDataPosition() == 0 ? 0 : 8);
            if (userAccount.equals(messageAccount)) {
                this.mOtherLayout.setVisibility(8);
                this.mNotSupportLayout.setVisibility(8);
                this.mMineLayout.setVisibility(0);
                this.mMineName.setText((CharSequence)(POCHistoryMessageAdapter.this.transation(messageAccount) == null ? messageAccount : POCHistoryMessageAdapter.this.transation(messageAccount).getName()));
                int voiceTime = POCHistoryMessageAdapter.this.computeVoiceTime(message);
                this.mMineTime.setText((CharSequence)String.format(this.getContext().getString(R.string.poc_history_record_format_time), voiceTime + ""));
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mMineVoiceLayout.getLayoutParams();
                params.width = POCHistoryMessageAdapter.this.computeLayoutWidth(voiceTime);
                this.mMineVoiceLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                GlideUtils.setImageUseNetWithCircle(this.getContext(), POCHistoryMessageAdapter.this.transation(messageAccount) == null ? "" : POCHistoryMessageAdapter.this.transation(messageAccount).getIcon(), this.mMineIcon);
                return;
            }
            this.mMineLayout.setVisibility(8);
            this.mNotSupportLayout.setVisibility(8);
            this.mOtherLayout.setVisibility(0);
            this.mOtherName.setText((CharSequence)(POCHistoryMessageAdapter.this.transation(messageAccount) == null ? messageAccount : POCHistoryMessageAdapter.this.transation(messageAccount).getName()));
            int voiceTime = POCHistoryMessageAdapter.this.computeVoiceTime(message);
            this.mOtherTime.setText((CharSequence)String.format(this.getContext().getString(R.string.poc_history_record_format_time), voiceTime + ""));
            this.mOtherVoiceLayout.setMinimumWidth(POCHistoryMessageAdapter.this.computeLayoutWidth(voiceTime));
            GlideUtils.setImageUseNetWithCircle(this.getContext(), POCHistoryMessageAdapter.this.transation(messageAccount) == null ? "" : POCHistoryMessageAdapter.this.transation(messageAccount).getIcon(), this.mOtherIcon);
        }
    }
}

