/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.utils;

import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.xdja.poc.sdk.R;
import java.io.File;

public class GlideUtils {
    public static void setImageUseFile(Context context, String fileUri, ImageView view) {
        Glide.with((Context)context).load(new File(fileUri)).error(R.drawable.poc_icon_default_avatar).placeholder(R.drawable.poc_icon_default_avatar).into(view);
    }

    public static void setImageUseNetWithCircle(Context context, String NetUri, ImageView view) {
        Glide.with((Context)context).load(NetUri).bitmapTransform(new Transformation[]{new GlideCircleTransform(context)}).error(R.drawable.poc_icon_default_avatar).placeholder(R.drawable.poc_icon_default_avatar).into(view);
    }

    public static void setImageUseNet(Fragment context, String NetUri, ImageView view) {
        Glide.with((Fragment)context).load(NetUri).error(R.drawable.poc_icon_default_avatar).placeholder(R.drawable.poc_icon_default_avatar).diskCacheStrategy(DiskCacheStrategy.NONE).into(view);
    }

    private static class GlideCircleTransform
    extends BitmapTransformation {
        GlideCircleTransform(Context context) {
            super(context);
        }

        protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
            return this.circleCrop(pool, toTransform);
        }

        private Bitmap circleCrop(BitmapPool pool, Bitmap source) {
            if (source == null) {
                return null;
            }
            int size = Math.min(source.getWidth(), source.getHeight());
            int x = (source.getWidth() - size) / 2;
            int y = (source.getHeight() - size) / 2;
            Bitmap squared = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)size, (int)size);
            Bitmap result = pool.get(size, size, Bitmap.Config.ARGB_8888);
            if (result == null) {
                result = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            Canvas canvas = new Canvas(result);
            Paint paint = new Paint();
            paint.setShader((Shader)new BitmapShader(squared, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            paint.setAntiAlias(true);
            float r = (float)size / 2.0f;
            canvas.drawCircle(r, r, r, paint);
            return result;
        }

        public String getId() {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
}

