/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.business;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.czt.mp3recorder.util.RecordFileUtils;
import com.xdja.net.RetrofitUtil;
import com.xdja.net.observer.CommonObserver;
import com.xdja.net.throwable.HttpThrowable;
import com.xdja.poc.POCMediaAidlInterface;
import com.xdja.poc.common.utils.GlobalContext;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.WorkHandler;
import com.xdja.poc.sdk.business.MessageProxy;
import com.xdja.poc.sdk.business.POCHandlerService;
import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.business.PocNotificationService;
import com.xdja.poc.sdk.business.RoomStatus;
import com.xdja.poc.sdk.business.bean.POCCallMessage;
import com.xdja.poc.sdk.business.ringplay.RingPlayer;
import com.xdja.poc.sdk.business.webrtc.apprtc.AppRTCAudioManager;
import com.xdja.poc.sdk.business.webrtc.apprtc.PeerConnectionClient;
import com.xdja.poc.sdk.business.webrtc.apprtc.util.AsyncHttpURLConnection;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusAttachSuccessCallBack;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusServer;
import com.xdja.poc.sdk.greendao.LocalRecordDBHelper;
import com.xdja.poc.sdk.manager.AMnager;
import com.xdja.poc.sdk.record.RecordMessage;
import com.xdja.poc.sdk.record.UploadRecordHelper;
import com.xdja.poc.sdk.record.api.RecordBusiness;
import com.xdja.poc.sdk.record.api.bean.BaseRecordResponse;
import com.xdja.poc.sdk.record.api.bean.CreateMessageRequest;
import com.xdja.poc.sdk.utils.GroupUtils;
import com.xdja.poc.sdk.utils.IPHost;
import com.xdja.poc.sdk.utils.Utils;
import io.reactivex.Observer;
import java.io.File;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class POCService
extends Service {
    private static String TAG = "POCService";
    public static final String ACTIOON_STOP_SELF = "action_stop_self";
    public static final String ACTION_POC_ALL_ROOM = "action_poc_all_room";
    public static final String ACTION_POC_SWITCH_MUTE_STATUS = "action_poc_switch_mute_status";
    public static final String ACTION_POC_START_WAITING_ACTIVITY = "action_poc_start_waiting_activity";
    private final JanusServer.RandomString stringGenerator = new JanusServer.RandomString();
    private final IBinder mBinder = new ServiceStub(this);
    private int mServiceStartId = -1;
    private Map<String, POCRoom> pocRoomCache = new ConcurrentHashMap<String, POCRoom>();
    private Map<Long, String> roomIdAndUrLCache = new ConcurrentHashMap<Long, String>();
    private List<String> mCacheReConnectRoomId = new ArrayList<String>();
    public Map<String, Boolean> lastMuteStatus = new HashMap<String, Boolean>();
    private WorkHandler workHandler;
    private PeerConnectionClient.PeerConnectionParameters peerConnectionParameters;
    private String mUserId;
    private SubProgressReceiver subProgressReceiver;
    private HandlerThread workThread;
    private boolean isRinging = false;
    private ConcurrentHashMap<String, RoomStatus> roomStatusMap = new ConcurrentHashMap();
    private int reconnectTimes = 0;
    private boolean isReConnect = false;

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        LogUtils.DLog((String)"POCService", (String)"onUnBind");
        this.stopSelf(this.mServiceStartId);
        return true;
    }

    public void onCreate() {
        super.onCreate();
        this.pocRoomCache = new ConcurrentHashMap<String, POCRoom>();
        this.roomIdAndUrLCache = new ConcurrentHashMap<Long, String>();
        this.mCacheReConnectRoomId = new ArrayList<String>();
        this.lastMuteStatus = new HashMap<String, Boolean>();
    }

    private void initReceiver() {
        this.subProgressReceiver = new SubProgressReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_POC_ALL_ROOM);
        filter.addAction(ACTIOON_STOP_SELF);
        filter.addAction(ACTION_POC_START_WAITING_ACTIVITY);
        filter.addAction(ACTION_POC_SWITCH_MUTE_STATUS);
        filter.addAction("ACTION_CHECK_JANUS_SCHEDULE");
        filter.addAction("update_poc_group_list");
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.HEADSET_PLUG");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        GlobalContext.getContext().registerReceiver((BroadcastReceiver)this.subProgressReceiver, filter);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mServiceStartId = startId;
        LogUtils.ILog((String)"POCService", (String)"onStartCommand");
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mServiceStartId = -1;
        LogUtils.ELog((String)"POCService", (String)"onDestroy");
        if (this.subProgressReceiver != null) {
            GlobalContext.getContext().unregisterReceiver((BroadcastReceiver)this.subProgressReceiver);
        }
        if (this.pocRoomCache != null) {
            this.pocRoomCache.clear();
            this.pocRoomCache = null;
        }
        if (this.peerConnectionParameters != null) {
            this.peerConnectionParameters = null;
        }
        if (this.lastMuteStatus != null) {
            this.lastMuteStatus.clear();
            this.lastMuteStatus = null;
        }
        if (!StringUtils.isEmpty((String)PreferenceHelper.getString((String)"login_account", (String)"")) && PreferenceHelper.getBoolean((String)"is_show_notification", (boolean)true)) {
            this.startService(new Intent(GlobalContext.getContext(), PocNotificationService.class));
        }
        if (this.workThread != null && this.workThread.isAlive()) {
            this.workThread.getLooper().quit();
        }
        UploadRecordHelper.getInstance().stopUploadRecord();
    }

    private boolean getRoomForceInsertStatus(String roomId) {
        POCRoom pocRoom;
        if (this.isRoomCacheContains(roomId) && (pocRoom = this.pocRoomCache.get(roomId)) != null) {
            return pocRoom.getForceInsertStatus();
        }
        return false;
    }

    private void updateForceInsert(String roomId, boolean isForceInsert) {
        POCRoom pocRoom;
        if (this.isRoomCacheContains(roomId) && (pocRoom = this.pocRoomCache.get(roomId)) != null) {
            pocRoom.updateForceInsert(isForceInsert);
        }
    }

    private void hangUpRoom(String roomId) {
        POCRoom pocRoom;
        if (this.isRoomCacheContains(roomId) && (pocRoom = this.pocRoomCache.get(roomId)) != null) {
            pocRoom.hangupPeerConnection();
        }
    }

    private void removeFromReconnectCache(String roomId) {
        if (this.mCacheReConnectRoomId != null && this.mCacheReConnectRoomId.size() > 0) {
            LogUtils.ILog((String)("removeFromReconnectCache: remove  from reconnectList: " + roomId));
            this.mCacheReConnectRoomId.remove(roomId);
        } else {
            LogUtils.ELog((String)TAG, (String)("removeFromReconnectCache:mCacheReConnectRoomId.size()= " + (this.mCacheReConnectRoomId != null ? this.mCacheReConnectRoomId.size() : 0)));
        }
    }

    private List<String> getReconnectRoom() {
        return this.mCacheReConnectRoomId;
    }

    private boolean insertStickGroupData(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return false;
        }
        POCHandlerService.insertOrReplaceGroupData((Context)this, json);
        return true;
    }

    private Map<String, String> getAllSpeakers() {
        HashMap<String, String> mSpeakers = null;
        try {
            if (this.pocRoomCache != null && this.pocRoomCache.size() > 0) {
                mSpeakers = new HashMap<String, String>();
                for (String roomId : this.pocRoomCache.keySet()) {
                    if (this.pocRoomCache.containsKey(roomId) && this.pocRoomCache.get(roomId) == null) {
                        this.pocRoomCache.remove(roomId);
                        this.removeRoomStatusCache(roomId);
                        continue;
                    }
                    String currTBCPUser = this.pocRoomCache.get(roomId).getCurrTBCPUser();
                    if (StringUtils.isEmpty((String)currTBCPUser)) continue;
                    mSpeakers.put(roomId, currTBCPUser);
                }
            }
        }
        catch (Exception e) {
            LogUtils.ELog((String)TAG, (String)("getAllSpeakers: " + e.getMessage()));
        }
        LogUtils.ILog((String)("mSpeakers: " + (mSpeakers == null ? 0 : mSpeakers.size())));
        return mSpeakers;
    }

    private List<String> getOnLineRoom() {
        String roomId;
        List<String> memberList;
        ArrayList<String> mList = new ArrayList<String>();
        if (this.pocRoomCache == null || this.pocRoomCache.size() <= 0) {
            LogUtils.ILog((String)"OnLineRoomCount: 0");
            return mList;
        }
        int count = 0;
        Iterator<String> iterator = this.pocRoomCache.keySet().iterator();
        while (iterator.hasNext() && (memberList = this.getMemberList(Long.valueOf(roomId = iterator.next()))) != null && memberList.size() > 0) {
            mList.add(roomId);
        }
        LogUtils.ILog((String)("OnLineRoomCount: " + count));
        return mList;
    }

    private void sendPocDelayCall(String json, String senderUserId, String roomId) {
    }

    private void updateGroupMuteStatus(String userId, String roomId, boolean status) {
        POCHandlerService.updateGroupIsSilence((Context)this, userId, roomId, status);
    }

    private void deleteRoomByIdWithNotifyUI(String userId, String roomId, int position) {
        POCHandlerService.deleteRoomByIdWithNotifyUI((Context)this, userId, roomId, position);
    }

    private void insertTempGroupData(String roomId, String roomName, String memberInfoList, String ownerId) {
    }

    private void sendPocCallMember(String json, String imeiArray, String roomId) {
    }

    private void sendPocUserBusy(String json, String senderUserId, String roomId) {
    }

    private void sendPocRejectCall(String json, String senderUserId, String roomId) {
    }

    private void sendPocAcceptCall(String json, String senderUserId, String roomId) {
    }

    private void removeRommListFromCache() {
        try {
            if (this.pocRoomCache != null && this.pocRoomCache.size() > 0) {
                Set<String> strings = this.pocRoomCache.keySet();
                for (String id2 : strings) {
                    if (!this.isRoomCacheContains(id2)) continue;
                    POCRoom pocRoom = this.pocRoomCache.get(id2);
                    if (pocRoom != null) {
                        if (pocRoom.isCreated() && pocRoom.isJoined()) continue;
                        this.pocRoomCache.remove(id2);
                        this.removeRoomStatusCache(id2);
                        continue;
                    }
                    this.pocRoomCache.remove(id2);
                }
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("removeRommListFromCache:" + throwable.getLocalizedMessage()));
        }
    }

    private void destroyAllRoom() {
        this.workHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtils.DLog((String)TAG, (String)"start destroyAllRoom");
                    POCService.this.mCacheReConnectRoomId.clear();
                    if (POCService.this.pocRoomCache == null) {
                        LogUtils.DLog((String)TAG, (String)"destroyAllRoom, pocRoomCache is null");
                        return;
                    }
                    if (POCService.this.pocRoomCache.size() > 0) {
                        for (String roomId : POCService.this.pocRoomCache.keySet()) {
                            if (!POCService.this.pocRoomCache.containsKey(roomId)) continue;
                            ((POCRoom)POCService.this.pocRoomCache.get(roomId)).leaveRoom();
                        }
                    }
                    POCRoom.disconnectServer();
                    POCService.this.pocRoomCache.clear();
                }
                catch (Throwable e) {
                    LogUtils.ELog((String)TAG, (String)("destroyAllRoom: " + e.getLocalizedMessage()));
                }
            }
        });
    }

    private void releaseTBCP(String roomId) {
        try {
            if (this.isRoomCacheContains(roomId)) {
                POCRoom pocRoom = this.pocRoomCache.get(roomId);
                if (pocRoom != null) {
                    pocRoom.releaseTBCP();
                } else {
                    LogUtils.ELog((String)TAG, (String)("releaseTBCP: pocRoomCache contains " + roomId + " but pocRoom is null"));
                }
            } else {
                LogUtils.ELog((String)TAG, (String)("releaseTBCP: pocRoomCache not contains " + roomId));
                MessageProxy.sendUserChanged((Context)this, String.valueOf(roomId), null, 9100);
            }
        }
        catch (Throwable e) {
            LogUtils.ELog((String)TAG, (String)("releaseTBCP: " + e.getLocalizedMessage()));
        }
    }

    private void takenTBCP(String roomId, int isForce) {
        try {
            if (this.isRoomCacheContains(roomId)) {
                POCRoom pocRoom = this.pocRoomCache.get(roomId);
                if (pocRoom != null) {
                    pocRoom.takenTBCP(isForce);
                } else {
                    LogUtils.ELog((String)TAG, (String)("takenTBCP: pocRoomCache contains " + roomId + " but pocRoom is null"));
                }
            } else {
                LogUtils.ELog((String)TAG, (String)("takenTBCP: pocRoomCache not contains " + roomId));
                MessageProxy.sendUserChanged((Context)this, String.valueOf(roomId), null, 9100);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    private void leaveRoom(String userId, String roomId) {
        LogUtils.ILog((String)TAG, (String)("leavedRoom: " + roomId));
        try {
            if (this.isRoomCacheContains(roomId)) {
                POCRoom pocRoom = this.pocRoomCache.get(roomId);
                if (pocRoom != null) {
                    pocRoom.leaveRoom();
                    pocRoom.hangupPeerConnection();
                    this.pocRoomCache.remove(roomId);
                    this.removeRoomStatusCache(roomId);
                    LogUtils.ILog((String)"pocRoomCache leaveRoom");
                } else {
                    LogUtils.ELog((String)TAG, (String)("leaveRoom: pocRoomCache contains " + roomId + " but pocRoom is null"));
                }
            } else {
                LogUtils.ELog((String)TAG, (String)("leaveRoom: pocRoomCache not contains " + roomId + " but pocRoom is null"));
                ArrayList<String> strings = new ArrayList<String>();
                strings.add("\u7f13\u5b58\u4e2d\u6ca1\u6709\u5f53\u524d\u9891\u9053");
                this.removeRoomStatusCache(roomId);
                MessageProxy.sendUserChanged((Context)this, String.valueOf(roomId), strings, 9005);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("leaveRoom: " + throwable.getLocalizedMessage()));
            this.removeRoomStatusCache(roomId);
        }
    }

    private void destroyRoom(String roomId, String secret) {
        LogUtils.ILog((String)TAG, (String)("destroyRoom: " + roomId));
        try {
            if (this.netTips()) {
                return;
            }
            if (this.isRoomCacheContains(roomId)) {
                POCRoom pocRoom = this.pocRoomCache.get(roomId);
                if (pocRoom != null) {
                    this.removeRoomStatusCache(String.valueOf(roomId));
                    pocRoom.leaveRoom();
                    pocRoom.hangupPeerConnection();
                    this.pocRoomCache.remove(roomId);
                    LogUtils.ILog((String)"pocRoomCache destroyRoom");
                } else {
                    LogUtils.ELog((String)TAG, (String)("destroyRoom: pocRoomCache contains " + roomId + " but pocRoom is null"));
                }
            } else {
                LogUtils.ELog((String)TAG, (String)("destroyRoom: pocRoomCache not contains " + roomId));
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("destroyRoom: " + throwable.getLocalizedMessage()));
        }
    }

    private void forceQuitRoom(String userId, String targetId, String roomId) {
        LogUtils.ILog((String)TAG, (String)("forceQuitRoom: " + roomId));
        try {
            POCRoom pocRoom;
            if (this.netTips()) {
                return;
            }
            if (this.isRoomCacheContains(roomId) && (pocRoom = this.pocRoomCache.get(roomId)) != null) {
                pocRoom.leaveRoom();
                this.pocRoomCache.remove(roomId);
                this.removeRoomStatusCache(String.valueOf(roomId));
                LogUtils.ILog((String)"pocRoomCache forceQuitRoom");
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("forceQuitRoom: " + throwable.getLocalizedMessage()));
        }
    }

    private void deletePocRoomFromServer(String userId, String roomId) {
        LogUtils.ILog((String)TAG, (String)("deletePocRoomFromServer: " + roomId));
        try {
            POCRoom pocRoom;
            if (this.netTips()) {
                return;
            }
            if (this.isRoomCacheContains(roomId) && (pocRoom = this.pocRoomCache.get(roomId)) != null) {
                pocRoom.leaveRoom();
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("deletePocRoomFromServer: " + throwable.getLocalizedMessage()));
        }
    }

    private void controlRoomStatus(String roomId, boolean isSilence) {
    }

    private void deleteRoomByRoomId(String userId, String roomId) {
        LogUtils.ILog((String)TAG, (String)("deleteRoomByRoomId: " + roomId));
        try {
            POCHandlerService.deleteRoomByRoomId((Context)this, GroupUtils.generatePOCGroupDbKey(userId, roomId));
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)throwable.getLocalizedMessage());
        }
    }

    private void showToast(final String msg) {
        this.workHandler.post(new Runnable(){

            @Override
            public void run() {
                LogUtils.ILog((String)msg);
            }
        });
    }

    private synchronized void joinRoom(long roomId, Integer userId, String userName, String pin, String token) {
    }

    private void realUploadRecord(String recordUri) {
        UploadRecordHelper.getInstance().startUploadRecord(recordUri);
        UploadRecordHelper.getInstance().setUploadRecordCallBack(new UploadRecordHelper.UploadRecordCallBack(){

            @Override
            public void onUploadRecordSuccess(String fileId, String fileUri) {
                MessageProxy.sendUploadRecordResultBroadcast((Context)POCService.this, fileId, fileUri, 0);
                RecordMessage recordMessage = LocalRecordDBHelper.getInstance().update(fileUri, IPHost.getFastDfsUrl() + File.separator + fileId);
                if (recordMessage == null) {
                    return;
                }
                POCService.this.commitMessageRecord(recordMessage);
            }

            @Override
            public void onUploadRecordFailed(int errorCode, String fileUri) {
                MessageProxy.sendUploadRecordResultBroadcast((Context)POCService.this, null, fileUri, errorCode);
            }
        });
    }

    private void commitMessageRecord(final RecordMessage recordMessage) {
        CreateMessageRequest request = new CreateMessageRequest();
        request.setType("3");
        request.setGroupUri(recordMessage.getRecordRoom());
        request.setFileUrl(recordMessage.getRecordRemoteUrl());
        request.setFileSize(Integer.valueOf(recordMessage.getRecordTimeLen()));
        RetrofitUtil.request(RecordBusiness.createTalkGroupMessage(request), (Observer)new CommonObserver<BaseRecordResponse<String>>(){

            public void onResult(BaseRecordResponse<String> result) {
                if ("success".equals(result.getResult())) {
                    LogUtils.DLog((String)TAG, (String)"\u5f55\u97f3\u8bb0\u5f55\u63d0\u4ea4\u6210\u529f\uff0c\u5220\u9664\u672c\u5730\u5f55\u97f3");
                    LocalRecordDBHelper.getInstance().delete(recordMessage.getRecordUri());
                    if (new File(recordMessage.getRecordUri()).exists()) {
                        new File(recordMessage.getRecordUri()).delete();
                    }
                    MessageProxy.sendCommitRecordResultBroadcast((Context)POCService.this, recordMessage.getRecordUri(), 0);
                }
                LogUtils.DLog((String)TAG, (String)("commitMessageRecord_onResult: " + result));
                POCService.this.uploadNextRecord();
            }

            public void onError(HttpThrowable httpThrowable) {
                LogUtils.DLog((String)TAG, (String)("commitMessageRecord_onError: " + httpThrowable.message));
                MessageProxy.sendCommitRecordResultBroadcast((Context)POCService.this, recordMessage.getRecordUri(), -1);
            }
        });
    }

    private void uploadNextRecord() {
        LogUtils.DLog((String)TAG, (String)"\u67e5\u627e\u4e0b\u4e00\u672a\u4e0a\u4f20\u5f55\u97f3");
        RecordMessage waitUploadMessage = LocalRecordDBHelper.getInstance().queryNoUploadRecord();
        if (waitUploadMessage == null) {
            LogUtils.DLog((String)TAG, (String)"\u65e0\u672a\u4e0a\u4f20\u5f55\u97f3\uff0c\u5220\u9664\u6240\u6709\u672c\u5730\u5f55\u97f3");
            return;
        }
        if (!StringUtils.isEmpty((String)waitUploadMessage.getRecordRemoteUrl())) {
            this.commitMessageRecord(waitUploadMessage);
            LogUtils.DLog((String)TAG, (String)"\u5f55\u97f3\u5df2\u4e0a\u4f20fastdfs\uff0c\u76f4\u63a5\u63d0\u4ea4\u8bb0\u5f55");
            return;
        }
        LogUtils.DLog((String)TAG, (String)"\u5f55\u97f3\u4e0a\u4f20fastdfs");
        this.realUploadRecord(waitUploadMessage.getRecordUri());
    }

    private synchronized void createSessionAndAttach(final long roomId, final String userId, final String secret, final String pin, final String userName, String token, int flag) {
        block8: {
            try {
                RoomStatus roomStatus;
                if (this.isRoomCacheContains(String.valueOf(roomId))) {
                    POCRoom pocRoom = this.pocRoomCache.get(roomId);
                    if (pocRoom != null && flag == 9020 && pocRoom.isJoined() && pocRoom.isCreated()) {
                        MessageProxy.sendUserChanged((Context)this, String.valueOf(roomId), pocRoom.getMemberList(), 9003);
                        return;
                    }
                    if (pocRoom != null) {
                        pocRoom.hangupPeerConnection();
                    } else {
                        LogUtils.ELog((String)TAG, (String)"createSessionAndAttach: pocRoomCache contains roomId but  pocRoom is null ");
                    }
                    this.pocRoomCache.remove(String.valueOf(roomId));
                    this.removeRoomStatusCache(String.valueOf(roomId));
                }
                if ((roomStatus = this.getRoomStatus(String.valueOf(roomId))) != null && roomStatus.isCreating()) {
                    LogUtils.ELog((String)TAG, (String)("the room " + roomId + " is creating"));
                    return;
                }
                this.setRoomStatusCreating(String.valueOf(roomId));
                this.getPocRoom(roomId, userId, flag, new PocRoomGetCallback(){

                    @Override
                    public void onSuccess(final POCRoom pocRoom, boolean isCache) {
                        if (POCService.this.handleExceptionChannel(roomId)) {
                            return;
                        }
                        if (POCService.this.pocRoomCache.containsKey(String.valueOf(roomId)) && POCService.this.pocRoomCache.get(String.valueOf(roomId)) != null) {
                            LogUtils.ELog((String)TAG, (String)("pocRoomCache has :" + roomId));
                            POCService.this.removeRoomStatusCache(String.valueOf(roomId));
                            return;
                        }
                        if (pocRoom != null) {
                            POCService.this.pocRoomCache.put(String.valueOf(roomId), pocRoom);
                            pocRoom.initializeMediaContext((Context)POCService.this, true, true, true, POCService.this.peerConnectionParameters, null);
                            pocRoom.registAttachSuccessCallBack(new IJanusAttachSuccessCallBack(){

                                @Override
                                public void createSessionAndAttachSuccess() {
                                    if (!pocRoom.newCreateRoom(roomId, secret, pin, userId, userName, "", Boolean.FALSE, Boolean.FALSE)) {
                                        LogUtils.ILog((String)"newCreateRoom failed.");
                                        MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), 9002);
                                    }
                                }
                            });
                            if (!pocRoom.startConnectServer()) {
                                LogUtils.ILog((String)"getPocRoom onSuccess: connect room server failed.");
                                MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), 9002);
                            } else {
                                LogUtils.ELog((String)TAG, (String)"createSessionAndAttach: getPocRoom onSuccess, pocRoom.startConnectServer() is true");
                                MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), 9002);
                                POCService.this.removeRoomStatusCache(String.valueOf(roomId));
                            }
                        } else {
                            LogUtils.ELog((String)TAG, (String)"createSessionAndAttach: getPocRoom onSuccess, but pocRoom is null ");
                            MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), pocRoom.getMemberList(), 9002);
                            POCService.this.removeRoomStatusCache(String.valueOf(roomId));
                        }
                    }

                    @Override
                    public void onFail(String msg) {
                        if (POCService.this.handleExceptionChannel(roomId)) {
                            return;
                        }
                        LogUtils.ELog((String)TAG, (String)("createSessionAndAttach: getPocRoom onFail:  " + msg));
                        POCService.this.removeRoomStatusCache(String.valueOf(roomId));
                        MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), null, 9102);
                        if (!POCService.this.mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
                            POCService.this.mCacheReConnectRoomId.add(String.valueOf(roomId));
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                if (this.handleExceptionChannel(roomId)) {
                    return;
                }
                LogUtils.ELog((String)TAG, (String)("createSessionAndAttach: " + throwable.getLocalizedMessage()));
                this.removeRoomStatusCache(String.valueOf(roomId));
                MessageProxy.sendUserChanged((Context)this, String.valueOf(roomId), null, 9002);
                if (this.mCacheReConnectRoomId.contains(String.valueOf(roomId))) break block8;
                this.mCacheReConnectRoomId.add(String.valueOf(roomId));
            }
        }
    }

    private boolean handleExceptionChannel(long roomId) {
        if (this.mCacheReConnectRoomId != null && this.mCacheReConnectRoomId.size() > 0 && !this.mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
            this.removeRoomStatusCache(String.valueOf(roomId));
            return true;
        }
        return false;
    }

    private synchronized void createRoom(long roomId, String secret, String pin, String userId, String userName, String description, @Nullable Boolean permanent, @Nullable Boolean isPrivate) {
        LogUtils.ELog((String)TAG, (String)("createRoom: " + roomId));
        try {
            this.createSessionAndAttach(roomId, userId, secret, pin, userName, "", 9020);
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("createRoom: " + throwable.getLocalizedMessage()));
            this.removeRoomStatusCache(String.valueOf(roomId));
        }
    }

    private void setRoomStatusCreating(String roomId) {
        RoomStatus roomStatus = new RoomStatus();
        roomStatus.setCreating(true);
        this.roomStatusMap.put(roomId, roomStatus);
    }

    private void setRoomStatusCreated(String roomId) {
        RoomStatus roomStatus = new RoomStatus();
        roomStatus.setCreated(true);
        this.roomStatusMap.put(roomId, roomStatus);
    }

    private void setRoomStatusDestroyed(String roomId) {
        RoomStatus roomStatus = new RoomStatus();
        roomStatus.setDestroy(true);
        this.roomStatusMap.put(roomId, roomStatus);
    }

    private void removeRoomStatusCache(String roomId) {
        this.roomStatusMap.remove(roomId);
    }

    private RoomStatus getRoomStatus(String roomId) {
        RoomStatus status = this.roomStatusMap.get(roomId);
        if (status != null) {
            LogUtils.ILog((String)TAG, (String)("status:" + status.toString()));
        }
        return status;
    }

    private void getPocRoomServer(final long roomId, final GetJanusUrlCallback getJanusUrlCallback) {
        LogUtils.ELog((String)TAG, (String)("getPocRoomServer: " + roomId));
        try {
            JSONObject object = new JSONObject();
            object.put("janus", (Object)"query_valid_server");
            object.put("transaction", (Object)this.stringGenerator.randomString(12));
            object.put("admin_secret", (Object)"xdja_api_abc_admin");
            object.put("room_id", roomId);
            AsyncHttpURLConnection httpConnection = new AsyncHttpURLConnection("POST", IPHost.getLoadBalanceServer(), object.toString(), new AsyncHttpURLConnection.AsyncHttpEvents(){

                @Override
                public void onHttpError(String errorMessage) {
                    LogUtils.ELog((String)TAG, (String)("getPocRoomServer: onHttpError," + errorMessage));
                    getJanusUrlCallback.onFail(errorMessage);
                }

                @Override
                public void onHttpComplete(String response) {
                    LogUtils.ELog((String)TAG, (String)("getPocRoomServer: onHttpComplete," + response));
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        String success = jsonObject.getString("janus");
                        if (jsonObject.has("ip") && jsonObject.has("balance_ip") || "success".equals(success)) {
                            jsonObject.getString("transaction");
                            String ip = jsonObject.getString("ip");
                            String port = jsonObject.getString("port");
                            String balance_ip = jsonObject.getString("balance_ip");
                            String balance_port = jsonObject.getString("balance_port");
                            String balance_ts = jsonObject.getString("balance_ts");
                            Utils.offset_localTime_serverTime = System.currentTimeMillis() / 1000L - Long.parseLong(balance_ts) / 1000L;
                            LogUtils.DLog((String)"zlq", (String)("balance_ip==" + balance_ip + "balance_port==" + balance_port + "balance_ts==" + balance_ts + "offset==" + Utils.offset_localTime_serverTime));
                            String janusUrl = "ws://" + ip + ":" + port;
                            POCService.this.roomIdAndUrLCache.put(roomId, janusUrl);
                            getJanusUrlCallback.onSuccess(janusUrl);
                        } else {
                            getJanusUrlCallback.onFail("error onHttpComplete fail");
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        getJanusUrlCallback.onFail(e.getMessage());
                    }
                }
            });
            httpConnection.send();
        }
        catch (JSONException e) {
            LogUtils.ELog((String)TAG, (String)("getPocRoomServer: " + e.getLocalizedMessage()));
            getJanusUrlCallback.onFail(e.getMessage());
        }
    }

    private synchronized void editRoom(long roomid, String secret, String newDescription, String newSecret, String newPin, @Nullable Boolean newIsPrivated, @Nullable Boolean newRequirePrivated, @Nullable Integer newBitrate, @Nullable Integer newFirFreq, @Nullable Integer newPublishers, @Nullable Boolean permanent) {
        LogUtils.ELog((String)TAG, (String)("editRoom: " + roomid));
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomid)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomid))) != null) {
                pocRoom.editRoom(roomid, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("editRoom: " + throwable.getLocalizedMessage()));
        }
    }

    private void existsRoom(long roomId) {
        LogUtils.ELog((String)TAG, (String)("existsRoom: " + roomId));
    }

    private void listRoom(long roomId) {
    }

    private void listParticipants(long roomId) {
    }

    private void listforwarders(long roomID, String secret) {
    }

    private void kickPerson(long roomId, int userId, String secret) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                pocRoom.kickPerson(roomId, userId, secret);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    private void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode, int bitrate, boolean record, String fileName, String display) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                pocRoom.publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    private void unpublish(long roomId) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                pocRoom.unpublish(roomId);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    private void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                pocRoom.configure(roomId, audio, video, data, bitrate, record, fileName, display);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    private void subscriberJoin(long roomId, BigInteger feedId, String pin, BigInteger privateId, boolean closePc, boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                pocRoom.subscriberJoin(roomId, feedId, pin, privateId, closePc, audio, video, data, offerAudio, offerVideo, offerData);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    private void startMedia(long roomId) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                pocRoom.startMedia(roomId);
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pauseMedia(long roomId) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) == null) return;
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) == null) return;
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mute(long roomId, boolean enable) {
        try {
            POCRoom pocRoom;
            if (!this.isRoomCacheContains(String.valueOf(roomId)) || (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) == null) return;
            Map<String, String> allSpeakers = this.getAllSpeakers();
            pocRoom.mute(enable);
            if (allSpeakers != null && allSpeakers.size() > 0 && !allSpeakers.containsKey(String.valueOf(roomId))) return;
        }
        catch (Throwable throwable) {
            LogUtils.ELog((Throwable)throwable);
        }
    }

    public void muteAndNotifyUI(long roomId, boolean enable) {
        LogUtils.ELog((String)TAG, (String)("muteAndNotifyUI: " + roomId + " enable: " + enable));
        try {
            if (this.isRoomCacheContains(String.valueOf(roomId))) {
                POCRoom pocRoom = this.pocRoomCache.get(String.valueOf(roomId));
                if (pocRoom != null) {
                    this.lastMuteStatus.put(String.valueOf(roomId), enable);
                    pocRoom.mute(enable);
                    this.releaseSetPlayStatus(String.valueOf(roomId));
                } else {
                    LogUtils.ELog((String)TAG, (String)("muteAndNotifyUI:  pocRoomCache contains " + roomId + " but pocRoom is null"));
                }
            }
            this.updateGroupMuteStatus(this.mUserId, String.valueOf(roomId), enable);
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("muteAndNotifyUI:  " + throwable.getLocalizedMessage()));
        }
    }

    public void muteAllRoomStatus(boolean enable, String channelId) {
        LogUtils.ELog((String)TAG, (String)("muteAllRoomStatus: enable:" + enable));
        for (String id2 : this.pocRoomCache.keySet()) {
            POCRoom pocRoom = this.pocRoomCache.get(String.valueOf(id2));
            if (pocRoom == null) continue;
            pocRoom.setPlayerStatus(false);
            pocRoom.mute(enable);
            if (pocRoom.getCurrTBCPStatus() != 9010) continue;
            pocRoom.releaseTBCP();
        }
    }

    public void reMuteLastStatus() {
        LogUtils.ELog((String)TAG, (String)("reMuteLastStatus: lastMuteStatus:" + (this.lastMuteStatus != null ? this.lastMuteStatus.size() : 0)));
        for (String roomId : this.lastMuteStatus.keySet()) {
            if (!this.isRoomCacheContains(String.valueOf(roomId))) continue;
            boolean muteStatus = this.lastMuteStatus.get(roomId);
            LogUtils.DLog((String)TAG, (String)("reMuteLastStatus  lastMuteStatus: " + muteStatus));
            POCRoom pocRoom = this.pocRoomCache.get(String.valueOf(roomId));
            if (pocRoom == null) continue;
            pocRoom.setPlayerStatus(true);
            pocRoom.mute(muteStatus);
        }
    }

    private synchronized void handleNetConnectFailed() {
        LogUtils.ILog((String)("Join room success: pocRoomCache= " + (this.pocRoomCache != null ? this.pocRoomCache.size() : 0)));
        for (String roomId : this.pocRoomCache.keySet()) {
            this.mCacheReConnectRoomId.add(roomId);
            if (this.pocRoomCache.get(roomId) != null) {
                this.pocRoomCache.get(roomId).hangupPeerConnection();
            }
            this.pocRoomCache.remove(roomId);
            LogUtils.ILog((String)"pocRoomCache handleNetConnectFailed");
        }
        this.pocRoomCache.clear();
    }

    private synchronized void handleNetConnectSuccess() {
        this.isReConnect = true;
        this.workHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                LogUtils.ILog((String)("handleNetConnectSuccess: mCacheReConnectRoomId= " + (POCService.this.mCacheReConnectRoomId != null ? POCService.this.mCacheReConnectRoomId.size() : 0)));
                PeerConnectionClient.resetPlayerStatus();
                POCService.this.reconnectTimes = 0;
                if (POCService.this.mCacheReConnectRoomId != null && POCService.this.mCacheReConnectRoomId.size() > 0) {
                    POCService.this.createRoom(Long.valueOf((String)POCService.this.mCacheReConnectRoomId.get(0)), "xdja_1234", "xdja_4321", POCService.this.mUserId, POCService.this.mUserId, "", false, false);
                }
            }
        }, 1000L);
    }

    private List<String> getMemberList(long roomId) {
        try {
            POCRoom pocRoom;
            if (this.isRoomCacheContains(String.valueOf(roomId)) && (pocRoom = this.pocRoomCache.get(String.valueOf(roomId))) != null) {
                return pocRoom.getMemberList();
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("getMemberList: " + throwable.getLocalizedMessage()));
        }
        return null;
    }

    private void getPocRoom(final long roomId, final String userId, final int bCreateFlg, final PocRoomGetCallback pocRoomGetCallback) {
        try {
            this.getPocRoomServer(roomId, new GetJanusUrlCallback(){

                @Override
                public void onSuccess(String path) {
                    LogUtils.DLog((String)TAG, (String)("getPocRoomServer: onSuccess, id==" + roomId + "url==" + path));
                    POCRoom pocRoom = new POCRoom(path, roomId, userId, bCreateFlg, new JanusRoomEvent(String.valueOf(roomId)), (Context)POCService.this);
                    pocRoomGetCallback.onSuccess(pocRoom, false);
                }

                @Override
                public void onFail(String msg) {
                    LogUtils.DLog((String)TAG, (String)("getPocRoomServer: onFail:" + msg));
                    pocRoomGetCallback.onFail(msg);
                }
            });
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("getPocRoom: " + throwable.getLocalizedMessage()));
            pocRoomGetCallback.onFail(throwable.getMessage());
        }
    }

    private void reconnectNextRoom(long roomId) {
        if (this.mCacheReConnectRoomId != null && this.mCacheReConnectRoomId.size() > 0) {
            LogUtils.ILog((String)"reconnectNextRoom:  remove  from reconnectList");
            this.mCacheReConnectRoomId.remove(String.valueOf(roomId));
        }
        LogUtils.ILog((String)("Room can talk: " + (this.mCacheReConnectRoomId != null ? this.mCacheReConnectRoomId.size() : 0)));
        this.workHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    if (POCService.this.mCacheReConnectRoomId.iterator().hasNext()) {
                        String next = (String)POCService.this.mCacheReConnectRoomId.iterator().next();
                        LogUtils.ILog((String)("Room can talk has next " + next));
                        POCService.this.createRoom(Long.valueOf(next), "xdja_1234", "xdja_4321", POCService.this.mUserId, POCService.this.mUserId, "", false, false);
                    } else {
                        POCService.this.isReConnect = false;
                    }
                }
                catch (Exception E) {
                    LogUtils.ELog((Throwable)E);
                }
            }
        }, 100L);
    }

    private POCRoom getPocRoom(String roomId) {
        LogUtils.ELog((String)TAG, (String)("getPocRoom: " + roomId));
        try {
            if (this.isRoomCacheContains(roomId)) {
                return this.pocRoomCache.get(roomId);
            }
            LogUtils.ELog((String)TAG, (String)("getPocRoom: pocRoomCache not contains  " + roomId));
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("getPocRoom: " + throwable.getLocalizedMessage()));
        }
        return null;
    }

    private void initParams() {
        LogUtils.ELog((String)TAG, (String)" initParams ");
        try {
            this.mUserId = PreferenceHelper.getString((String)"login_account", (String)"");
            PocBroadReceiver.currentNetState = NetUtils.getNetworkState((Context)this);
            this.workThread = new HandlerThread("workThread");
            this.workThread.start();
            this.workHandler = new WorkHandler(this.workThread.getLooper());
            PeerConnectionClient.DataChannelParameters dataChannelParameters = new PeerConnectionClient.DataChannelParameters(true, -1, -1, "json", true, -1);
            this.peerConnectionParameters = new PeerConnectionClient.PeerConnectionParameters(false, false, false, 640, 480, 15, 800, "VP8", false, false, 16, "opus", false, false, true, false, true, true, true, false, false, false, dataChannelParameters);
            this.initReceiver();
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("initParams: " + throwable.getLocalizedMessage()));
        }
    }

    private boolean isRoomCacheContains(String roomId) {
        try {
            if (this.pocRoomCache != null && this.pocRoomCache.size() > 0 && this.pocRoomCache.containsKey(roomId)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            LogUtils.ELog((String)TAG, (String)("isRoomCacheContains" + throwable.getLocalizedMessage()));
        }
        return false;
    }

    private void removeRoomFromCache(boolean isLeave, String roomId) {
        LogUtils.ELog((String)TAG, (String)("removeRoomFromCache: isLeave=" + isLeave + " roomId=" + roomId));
        if (this.isRoomCacheContains(roomId)) {
            if (this.pocRoomCache.get(roomId) != null && isLeave) {
                this.pocRoomCache.get(roomId).leaveRoom();
            }
            this.pocRoomCache.remove(roomId);
            this.removeRoomStatusCache(String.valueOf(roomId));
        } else {
            LogUtils.ELog((String)TAG, (String)("removeRoomFromCache: pocRoomCache not contains " + roomId));
        }
    }

    private boolean netTips() {
        if (!NetUtils.isNetworkAvailable((Context)this)) {
            this.showToast(this.getString(R.string.common_net_failed));
            return true;
        }
        return false;
    }

    private void releaseSetPlayStatus(String roomId) {
        POCRoom pocRoom;
        Map<String, String> allSpeakers = this.getAllSpeakers();
        boolean playStatus_ = false;
        if (allSpeakers != null && allSpeakers.size() > 0) {
            for (String _roomId : allSpeakers.keySet()) {
                if (this.lastMuteStatus == null || !this.lastMuteStatus.containsKey(_roomId) || this.lastMuteStatus.get(_roomId).booleanValue()) continue;
                playStatus_ = true;
                break;
            }
        }
        if ((pocRoom = this.getPocRoom(roomId)) != null) {
            pocRoom.setPlayerStatus(playStatus_);
        }
    }

    private class JanusRoomEvent
    implements POCRoom.RoomEvent {
        private final String roomId;

        public JanusRoomEvent(String roomId) {
            this.roomId = roomId;
        }

        @Override
        public void onRoom(long roomId, int status, String desc) {
            LogUtils.ILog((String)TAG, (String)("onRoom status:" + status + "  roomId:" + roomId));
            switch (status) {
                case 9100: {
                    LogUtils.ILog((String)"Connect room server failed");
                    POCService.this.setRoomStatusDestroyed(String.valueOf(roomId));
                    if (!POCService.this.mCacheReConnectRoomId.contains(String.valueOf(roomId))) {
                        POCService.this.mCacheReConnectRoomId.add(String.valueOf(roomId));
                    }
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId), 9100);
                    if (POCService.this.pocRoomCache == null) {
                        return;
                    }
                    POCRoom pocroom = (POCRoom)POCService.this.pocRoomCache.remove(String.valueOf(roomId));
                    if (pocroom != null) {
                        pocroom.hangupPeerConnection();
                    }
                    POCService.this.removeRoomStatusCache(String.valueOf(roomId));
                    if (POCService.this.pocRoomCache != null && POCService.this.pocRoomCache.size() == 0) {
                        LogUtils.ILog((String)"No cacheRoom exist, disconnect server with janus.");
                        POCRoom.disconnectServer();
                    }
                    if (POCService.this.reconnectTimes++ >= 1 || !NetUtils.isNetworkAvailable((Context)POCService.this.getApplicationContext())) break;
                    POCService.this.handleNetConnectSuccess();
                    break;
                }
                case 9000: 
                case 9002: 
                case 9050: {
                    POCService.this.setRoomStatusDestroyed(String.valueOf(roomId));
                    LogUtils.ILog((String)"ROOM_SEVER_CONNECT_FAILED connect room server failed");
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId), 9000);
                    break;
                }
                case 8999: 
                case 9005: 
                case 9007: 
                case 9008: 
                case 9018: {
                    POCService.this.setRoomStatusDestroyed(String.valueOf(roomId));
                    LogUtils.ILog((String)("Room has been left:" + status));
                    if (POCService.this.pocRoomCache != null && POCService.this.pocRoomCache.containsKey(String.valueOf(roomId))) {
                        POCRoom pocRoom = (POCRoom)POCService.this.pocRoomCache.remove(String.valueOf(roomId));
                        if (pocRoom != null) {
                            pocRoom.removeCallbackFromJanusServer();
                        }
                        POCService.this.removeRoomStatusCache(String.valueOf(roomId));
                    }
                    POCService.this.reconnectTimes = 0;
                    POCService.this.removeRoomFromCache(false, String.valueOf(roomId));
                    MessageProxy.sendSelfLeaveEvent((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId));
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId), 9007);
                    if (POCService.this.pocRoomCache == null || POCService.this.pocRoomCache.size() != 0) break;
                    LogUtils.ILog((String)"No Room exist, disconnect server with janus.");
                    POCRoom.disconnectServer();
                    break;
                }
                case 9016: {
                    ArrayList<String> strings = new ArrayList<String>();
                    strings.add(desc);
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), strings, 9005);
                    MessageProxy.sendUserIncomeOrLeave((Context)POCService.this, String.valueOf(roomId), desc, 9005);
                    LogUtils.ILog((String)(" User :" + desc + " left"));
                    break;
                }
                case 9017: {
                    ArrayList<String> incomingUsers = new ArrayList<String>();
                    incomingUsers.add(desc);
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), incomingUsers, 9003);
                    MessageProxy.sendUserIncomeOrLeave((Context)POCService.this, String.valueOf(roomId), desc, 9003);
                    LogUtils.ILog((String)(" User :" + desc + " inComing"));
                    break;
                }
                case 9019: {
                    LogUtils.ILog((String)desc);
                    POCService.this.removeRoomFromCache(true, String.valueOf(roomId));
                    break;
                }
                case 9001: {
                    LogUtils.ILog((String)"Create room success");
                    break;
                }
                case 9051: {
                    break;
                }
                case 9101: {
                    LogUtils.ILog((String)"Room can talk");
                    POCService.this.reconnectTimes = 0;
                    LogUtils.ILog((String)TAG, (String)"Room can talk");
                    POCService.this.setRoomStatusCreated(String.valueOf(roomId));
                    String room = String.valueOf(roomId);
                    POCRoom pocRoom = POCService.this.getPocRoom(room);
                    if (pocRoom != null) {
                        if (POCService.this.lastMuteStatus != null && POCService.this.lastMuteStatus.containsKey(room)) {
                            LogUtils.DLog((String)TAG, (String)"ROOM_CAN_TALK:\u3000mute ");
                            pocRoom.mute(POCService.this.lastMuteStatus.get(room));
                        }
                        MessageProxy.sendUserChanged((Context)POCService.this, room, pocRoom.getMemberList(), 9003);
                        POCService.this.releaseSetPlayStatus(String.valueOf(roomId));
                    } else {
                        LogUtils.ELog((String)TAG, (String)("Room can talk,but pocRoom is null: " + roomId));
                    }
                    if (!POCService.this.isReConnect) break;
                    POCService.this.reconnectNextRoom(roomId);
                    break;
                }
                case 9003: {
                    LogUtils.ILog((String)"Join room success");
                    String room = String.valueOf(roomId);
                    POCRoom pocRoom = POCService.this.getPocRoom(room);
                    if (pocRoom == null) break;
                    MessageProxy.sendMeIncomingRoom((Context)POCService.this, pocRoom.getMemberList(), String.valueOf(roomId));
                    break;
                }
                case 9004: {
                    POCService.this.setRoomStatusDestroyed(String.valueOf(roomId));
                    LogUtils.ILog((String)"Join room failed");
                    POCService.this.removeRoomFromCache(true, String.valueOf(roomId));
                    break;
                }
                case 9023: {
                    LogUtils.ILog((String)"\u8e22\u4eba\u6210\u529f");
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId));
                    break;
                }
                case 9024: {
                    LogUtils.ILog((String)"\u8e22\u4eba\u5931\u8d25");
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId));
                    break;
                }
                case 9027: {
                    LogUtils.ILog((String)"PUBLISH\u5931\u8d25");
                    MessageProxy.sendUserChanged((Context)POCService.this, String.valueOf(roomId), POCService.this.getMemberList(roomId));
                    break;
                }
                case 9028: {
                    LogUtils.ILog((String)"PUBLISH\u6210\u529f");
                    break;
                }
                case 9029: {
                    LogUtils.ILog((String)"UNPUBLISH\u6210\u529f");
                    break;
                }
                case 9030: {
                    LogUtils.ILog((String)"UNPUBLISH\u5931\u8d25");
                    break;
                }
                case 9031: {
                    LogUtils.ILog((String)"CONFIGURE\u6210\u529f");
                    break;
                }
                case 9032: {
                    LogUtils.ILog((String)"CONFIGURE\u5931\u8d25");
                    break;
                }
                case 9033: {
                    LogUtils.ILog((String)"STARTMEDIA\u5931\u8d25");
                    break;
                }
                case 9034: {
                    LogUtils.ILog((String)"STARTMEDIA\u6210\u529f");
                    break;
                }
                case 9035: {
                    LogUtils.ILog((String)"PAUSEMEDIA\u6210\u529f");
                    break;
                }
                case 9036: {
                    LogUtils.ILog((String)"PAUSEMEDIA\u5931\u8d25");
                    break;
                }
                case 9037: {
                    LogUtils.ILog((String)"SWITCH_SUBSCRIBER\u5931\u8d25");
                    break;
                }
                case 9038: {
                    LogUtils.ILog((String)"SWITCH_SUBSCRIBER SUCCESS");
                    break;
                }
                case 9039: {
                    LogUtils.ILog((String)"room not  exist");
                    break;
                }
                case 9040: {
                    LogUtils.ILog((String)"room exist");
                    break;
                }
                case 9041: {
                    LogUtils.ILog((String)"room list \u5931\u8d25");
                    break;
                }
                case 9042: {
                    LogUtils.ILog((String)"room list \u6210\u529f");
                    break;
                }
                case 9043: {
                    LogUtils.ILog((String)"room list people \u5931\u8d25");
                    break;
                }
                case 9044: {
                    LogUtils.ILog((String)"room list people \u6210\u529f");
                    break;
                }
                case 9045: {
                    LogUtils.ILog((String)"room list FORWARDERS \u5931\u8d25");
                    break;
                }
                case 9046: {
                    LogUtils.ILog((String)"room list FORWARDERS \u6210\u529f");
                    break;
                }
                case 9047: {
                    LogUtils.ILog((String)"\u5207\u6362\u8ba2\u9605\u8005 \u5931\u8d25");
                    POCService.this.removeRoomFromCache(true, String.valueOf(roomId));
                    break;
                }
                case 9048: {
                    LogUtils.ILog((String)"\u5207\u6362\u8ba2\u9605\u8005 \u6210\u529f");
                    break;
                }
            }
        }

        @Override
        public void onTBCP(int status, String ownerUser) {
            LogUtils.ELog((String)TAG, (String)("onTBCP: status " + status + " ownerUser: " + ownerUser));
            switch (status) {
                case 9010: {
                    LogUtils.ILog((String)(ownerUser + " request talk success"));
                    Intent requestSuc = new Intent("com.xdja.poc.service");
                    requestSuc.setPackage(POCService.this.getPackageName());
                    requestSuc.putExtra("userId", ownerUser);
                    requestSuc.putExtra("roomId", this.roomId);
                    requestSuc.putExtra("status", 2);
                    requestSuc.putExtra("Behavior", 1007);
                    requestSuc.putExtra("flag", 1014);
                    POCService.this.sendBroadcast(requestSuc);
                    break;
                }
                case 9011: {
                    LogUtils.ILog((String)(ownerUser + " request talk failed "));
                    Intent requestFailed = new Intent("com.xdja.poc.service");
                    requestFailed.setPackage(POCService.this.getPackageName());
                    requestFailed.putExtra("userId", ownerUser);
                    requestFailed.putExtra("roomId", this.roomId);
                    requestFailed.putExtra("status", 1);
                    requestFailed.putExtra("Behavior", 1008);
                    requestFailed.putExtra("flag", 1014);
                    POCService.this.sendBroadcast(requestFailed);
                    break;
                }
                case 9012: {
                    LogUtils.ILog((String)(ownerUser + " release talk success "));
                    Intent releaseSuc = new Intent("com.xdja.poc.service");
                    releaseSuc.setPackage(POCService.this.getPackageName());
                    releaseSuc.putExtra("userId", ownerUser);
                    releaseSuc.putExtra("roomId", this.roomId);
                    releaseSuc.putExtra("status", 1);
                    releaseSuc.putExtra("Behavior", 1005);
                    releaseSuc.putExtra("flag", 1014);
                    POCService.this.sendBroadcast(releaseSuc);
                    POCService.this.releaseSetPlayStatus(this.roomId);
                    break;
                }
                case 9013: {
                    LogUtils.ILog((String)(ownerUser + " release talk failed"));
                    Intent releaseFailed = new Intent("com.xdja.poc.service");
                    releaseFailed.setPackage(POCService.this.getPackageName());
                    releaseFailed.putExtra("userId", ownerUser);
                    releaseFailed.putExtra("roomId", this.roomId);
                    releaseFailed.putExtra("status", 1);
                    releaseFailed.putExtra("Behavior", 1006);
                    releaseFailed.putExtra("flag", 1014);
                    POCService.this.sendBroadcast(releaseFailed);
                    break;
                }
                case 9014: {
                    LogUtils.ILog((String)(this.roomId + ":" + ownerUser + " Talk "));
                    if (POCService.this.getPocRoom(String.valueOf(this.roomId)) != null) {
                        boolean muteStatus;
                        POCService.this.getPocRoom(String.valueOf(this.roomId)).setPlayerStatus(true);
                        if (POCService.this.lastMuteStatus != null && POCService.this.lastMuteStatus.size() > 0 && POCService.this.lastMuteStatus.containsKey(String.valueOf(this.roomId))) {
                            muteStatus = POCService.this.lastMuteStatus.get(String.valueOf(this.roomId));
                            LogUtils.ELog((String)TAG, (String)("other_request_success, but lastMuteStatus not contains roomId : " + this.roomId));
                        } else {
                            LogUtils.ELog((String)TAG, (String)("other_request_success, but lastMuteStatus not contains roomId: " + this.roomId));
                            muteStatus = false;
                        }
                        POCService.this.getPocRoom(String.valueOf(this.roomId)).mute(muteStatus);
                    } else {
                        LogUtils.ELog((String)TAG, (String)("other_request_success, but pocRoom is null roomId: " + this.roomId));
                    }
                    Intent intent = new Intent("com.xdja.poc.service");
                    intent.setPackage(POCService.this.getPackageName());
                    intent.putExtra("userId", ownerUser);
                    intent.putExtra("roomId", this.roomId);
                    intent.putExtra("member_info", POCClient.getInstance().generateListString(POCService.this.getMemberList(Long.parseLong(this.roomId))));
                    intent.putExtra("status", 2);
                    intent.putExtra("Behavior", 2);
                    intent.putExtra("flag", 1);
                    POCService.this.sendBroadcast(intent);
                    if (!POCService.this.isRinging) break;
                    POCService.this.muteAllRoomStatus(true, "");
                    break;
                }
                case 9015: {
                    LogUtils.ILog((String)(ownerUser + " Not Talk"));
                    POCService.this.releaseSetPlayStatus(this.roomId);
                    Intent intent_ = new Intent("com.xdja.poc.service");
                    intent_.setPackage(POCService.this.getPackageName());
                    intent_.putExtra("userId", ownerUser);
                    intent_.putExtra("roomId", this.roomId);
                    intent_.putExtra("member_info", POCClient.getInstance().generateListString(POCService.this.getMemberList(Long.parseLong(this.roomId))));
                    intent_.putExtra("status", 1);
                    intent_.putExtra("Behavior", 1);
                    intent_.putExtra("flag", 1);
                    POCService.this.sendBroadcast(intent_);
                    break;
                }
            }
        }

        @Override
        public void onRecord(String mp3RecordUri) {
            LogUtils.ELog((String)TAG, (String)("onRecord: roomId: " + this.roomId + "-" + this));
            MessageProxy.sendRecordCompletedBroadcast((Context)POCService.this, this.roomId, mp3RecordUri);
            if (StringUtils.isEmpty((String)mp3RecordUri)) {
                return;
            }
            File file = new File(mp3RecordUri);
            if (file == null || !file.exists()) {
                return;
            }
            long time = new RecordFileUtils().getRecordDuration(file.getAbsolutePath());
            if (time <= 1L) {
                return;
            }
            RecordMessage recordMessage = new RecordMessage();
            recordMessage.setRecordUri(file.getAbsolutePath());
            recordMessage.setRecordRoom(this.roomId);
            recordMessage.setRecordName(file.getName());
            recordMessage.setRecordSize(String.valueOf(file.length()));
            recordMessage.setRecordTimeLen(String.valueOf(time));
            LocalRecordDBHelper.getInstance().insert(recordMessage);
            LogUtils.DLog((String)TAG, (String)("onRecordCompleted: roomId = " + this.roomId));
            POCService.this.realUploadRecord(recordMessage.getRecordUri());
        }
    }

    private class SubProgressReceiver
    extends BroadcastReceiver {
        private SubProgressReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "action_poc_all_room": {
                    break;
                }
                case "action_stop_self": {
                    POCService.this.stopSelf(POCService.this.mServiceStartId);
                    break;
                }
                case "ACTION_CHECK_JANUS_SCHEDULE": {
                    String serverUri = intent.getStringExtra("SERVER_URI");
                    if (serverUri != null) {
                        JanusServer.getJanusServer(serverUri).doSchedule(serverUri);
                        break;
                    }
                    JanusServer.doAllSchedule();
                    break;
                }
                case "action_poc_switch_mute_status": {
                    boolean status = intent.getBooleanExtra("switch_mute_status", true);
                    if (status) {
                        POCClient.muteAllRoomStatus(true, "");
                        break;
                    }
                    POCClient.reMuteLastStatus();
                    break;
                }
                case "action_poc_start_waiting_activity": {
                    if (intent.getSerializableExtra("intent_key_call_waiting_data") != null) {
                        LogUtils.DLog((String)TAG, (String)"start POCWaitingActivity ");
                        POCCallMessage callMessage = (POCCallMessage)intent.getSerializableExtra("intent_key_call_waiting_data");
                        AMnager.startPOCCallWaitingActivity(GlobalContext.getContext(), callMessage);
                        POCClient.getInstance().clearNotify(POCClient.TRYCALL_POC_BANK);
                        return;
                    }
                    LogUtils.DLog((String)TAG, (String)"start POCWaitingActivity,but extra is null ");
                    break;
                }
                case "android.intent.action.HEADSET_PLUG": {
                    boolean isHeadsetIn = intent.getIntExtra("state", 0) == 1;
                    LogUtils.ILog((String)("processHeadsetChanged: headsetIn: " + isHeadsetIn));
                    if (!isHeadsetIn) {
                        RingPlayer.getInstance(context).setAudioMode(true);
                        break;
                    }
                    RingPlayer.getInstance(context).setAudioMode(false);
                    break;
                }
                case "android.intent.action.SCREEN_ON": {
                    if (!NetUtils.isNetworkAvailable((Context)GlobalContext.getContext())) break;
                    POCClient.handleNetConnectSuccess();
                    break;
                }
                case "android.intent.action.PHONE_STATE": {
                    String state = intent.getStringExtra("state");
                    if (StringUtils.isEmpty((String)state)) {
                        return;
                    }
                    switch (state) {
                        case "IDLE": {
                            AppRTCAudioManager.create(GlobalContext.getContext()).start(new AppRTCAudioManager.AudioManagerEvents(){

                                @Override
                                public void onAudioDeviceChanged(AppRTCAudioManager.AudioDevice audioDevice, Set<AppRTCAudioManager.AudioDevice> availableAudioDevices) {
                                }
                            });
                            POCClient.reMuteLastStatus();
                            POCService.this.isRinging = false;
                            break;
                        }
                        case "OFFHOOK": {
                            if (POCService.this.isRinging) break;
                            POCService.this.isRinging = true;
                            POCClient.muteAllRoomStatus(true, "");
                            break;
                        }
                        case "RINGING": {
                            if (POCService.this.isRinging) break;
                            POCService.this.isRinging = true;
                            POCClient.muteAllRoomStatus(true, "");
                        }
                    }
                    break;
                }
                case "android.bluetooth.adapter.action.STATE_CHANGED": 
                case "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED": {
                    BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                    int bluetoothState = adapter.getProfileConnectionState(1);
                    if (bluetoothState == 0) {
                        RingPlayer.getInstance(context).setAudioMode(true);
                        break;
                    }
                    RingPlayer.getInstance(context).setAudioMode(false);
                    break;
                }
            }
        }
    }

    static interface GetJanusUrlCallback {
        public void onSuccess(String var1);

        public void onFail(String var1);
    }

    static interface PocRoomGetCallback {
        public void onSuccess(POCRoom var1, boolean var2);

        public void onFail(String var1);
    }

    private static class ServiceStub
    extends POCMediaAidlInterface.Stub {
        private WeakReference<POCService> mService;

        private ServiceStub(POCService service) {
            this.mService = new WeakReference<POCService>(service);
        }

        @Override
        public void initParams() throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).initParams();
            } else {
                LogUtils.ELog((String)TAG, (String)"initParams: mService.get() is null");
            }
        }

        @Override
        public void leaveRoom(String userId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).leaveRoom(userId, roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"leaveRoom: mService.get() is null");
            }
        }

        @Override
        public void hangUpRoom(String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).hangUpRoom(roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"hangUpRoom: mService.get() is null");
            }
        }

        @Override
        public void destroyRoom(String userId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).destroyRoom(userId, roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"destroyRoom: mService.get() is null");
            }
        }

        @Override
        public void forceQuitRoom(String userId, String targetId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).forceQuitRoom(userId, targetId, roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"forceQuitRoom: mService.get() is null");
            }
        }

        @Override
        public void deletePocRoomFromServer(String userId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).deletePocRoomFromServer(userId, roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"deletePocRoomFromServer: mService.get() is null");
            }
        }

        @Override
        public void controlRoomStatus(String roomId, boolean isSilence) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).controlRoomStatus(roomId, isSilence);
            } else {
                LogUtils.ELog((String)TAG, (String)"controlRoomStatus: mService.get() is null");
            }
        }

        @Override
        public void removeRoomFromCache(String userId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).removeRoomFromCache(true, roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"removeRoomFromCache: mService.get() is null");
            }
        }

        @Override
        public void removeRoomListFromCache() throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).removeRommListFromCache();
            } else {
                LogUtils.ELog((String)TAG, (String)"removeRoomListFromCache: mService.get() is null");
            }
        }

        @Override
        public void removeFromReconnectCache(String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).removeFromReconnectCache(roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"removeFromReconnectCache: mService.get() is null");
            }
        }

        @Override
        public void getPocRoom(String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).getPocRoom(roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"getPocRoom: mService.get() is null");
            }
        }

        @Override
        public void takenTBCP(String roomId, int isForce) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).takenTBCP(roomId, isForce);
            } else {
                LogUtils.ELog((String)TAG, (String)"takenTBCP: mService.get() is null");
            }
        }

        @Override
        public void releaseTBCP(String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).releaseTBCP(roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"releaseTBCP: mService.get() is null");
            }
        }

        @Override
        public void destroyAllRoom() throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).destroyAllRoom();
            } else {
                LogUtils.ELog((String)TAG, (String)"destroyAllRoom: mService.get() is null");
            }
        }

        @Override
        public void updateForceInsert(String roomId, boolean isForceInsert) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).updateForceInsert(roomId, isForceInsert);
            } else {
                LogUtils.ELog((String)TAG, (String)"updateForceInsert: mService.get() is null");
            }
        }

        @Override
        public boolean getRoomForceInsertStatus(String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                return ((POCService)((Object)this.mService.get())).getRoomForceInsertStatus(roomId);
            }
            return false;
        }

        @Override
        public Map getAllSpeakers() throws RemoteException {
            return this.mService.get() != null ? ((POCService)((Object)this.mService.get())).getAllSpeakers() : null;
        }

        @Override
        public void switchAudioTrack() throws RemoteException {
        }

        @Override
        public void createRoom(long roomId, String secret, String pin, String userId, String userName, String description, boolean permanent, boolean isPrivate) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).createRoom(roomId, secret, pin, userId, userName, description, permanent, isPrivate);
            } else {
                LogUtils.ELog((String)TAG, (String)"createRoom: mService.get() is null");
            }
        }

        @Override
        public void editRoom(long roomid, String secret, String newDescription, String newSecret, String newPin, boolean newIsPrivated, boolean newRequirePrivated, int newBitrate, int newFirFreq, int newPublishers, boolean permanent) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).editRoom(roomid, secret, newDescription, newSecret, newPin, newIsPrivated, newRequirePrivated, newBitrate, newFirFreq, newPublishers, permanent);
            } else {
                LogUtils.ELog((String)TAG, (String)"editRoom: mService.get() is null");
            }
        }

        @Override
        public void existRoom(long roomid) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).existsRoom(roomid);
            } else {
                LogUtils.ELog((String)TAG, (String)"existRoom: mService.get() is null");
            }
        }

        @Override
        public void kickPerson(long roomId, int peopleId, String secret) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).kickPerson(roomId, peopleId, secret);
            } else {
                LogUtils.ELog((String)TAG, (String)"kickPerson: mService.get() is null");
            }
        }

        @Override
        public void listRooms(long roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).listRoom(roomId);
            } else {
                LogUtils.ELog((String)TAG, (String)"listRooms: mService.get() is null");
            }
        }

        @Override
        public void listPeoples(long roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).listParticipants(roomId);
            }
        }

        @Override
        public void joinRoom(long roomId, int userId, String userName, String pin, String token) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).joinRoom(roomId, 0, userName, pin, token);
            }
        }

        @Override
        public void createSessionAndAttach(String roomId, String userId, String pin, String userName, String token, int flag) throws RemoteException {
        }

        @Override
        public void publish(long roomId, boolean audio, boolean video, boolean data, String audioCode, String videoCode, int bitrate, boolean record, String fileName, String display) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).publish(roomId, audio, video, data, audioCode, videoCode, bitrate, record, fileName, display);
            } else {
                LogUtils.ELog((String)TAG, (String)"publish: mService.get() is null");
            }
        }

        @Override
        public void unpublish(long roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).unpublish(roomId);
            }
        }

        @Override
        public void configure(long roomId, boolean audio, boolean video, boolean data, int bitrate, boolean record, String fileName, String display) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).configure(roomId, audio, video, data, bitrate, record, fileName, display);
            }
        }

        @Override
        public void listforwarders(long roomID, String secret) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).listforwarders(roomID, secret);
            }
        }

        @Override
        public void subscriberJoin(long roomId, int feedId, String pin, int privateId, boolean closePc, boolean audio, boolean video, boolean data, boolean offerAudio, boolean offerVideo, boolean offerData) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).subscriberJoin(roomId, new BigInteger(Integer.toString(feedId)), pin, new BigInteger(Integer.toString(privateId)), closePc, audio, video, data, offerAudio, offerVideo, offerData);
            }
        }

        @Override
        public void startMedia(long roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).startMedia(roomId);
            }
        }

        @Override
        public void pauseMedia(long roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).pauseMedia(roomId);
            }
        }

        @Override
        public void switchSubscriber(long roomId, int feed, boolean audio, boolean video, boolean data) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).switchSubscriber(roomId, feed, audio, video, data);
            }
        }

        @Override
        public void mute(long roomId, boolean enable) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).mute(roomId, enable);
            }
        }

        @Override
        public void muteAndNotifyUI(long roomId, boolean enable) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).muteAndNotifyUI(roomId, enable);
            } else {
                LogUtils.ELog((String)TAG, (String)"muteAndNotifyUI: mService.get() is null");
            }
        }

        @Override
        public void muteAllRoomStatus(boolean enable, String channelId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).muteAllRoomStatus(enable, channelId);
            } else {
                LogUtils.ELog((String)TAG, (String)"muteAllRoomStatus: mService.get() is null");
            }
        }

        @Override
        public void reMuteLastStatus() throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).reMuteLastStatus();
            } else {
                LogUtils.ELog((String)TAG, (String)"reMuteLastStatus: mService.get() is null");
            }
        }

        @Override
        public List<String> getMemberList(long roomId) throws RemoteException {
            return this.mService.get() != null ? ((POCService)((Object)this.mService.get())).getMemberList(roomId) : null;
        }

        @Override
        public void sendPocCallMember(String json, String imeiArray, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).sendPocCallMember(json, imeiArray, roomId);
            }
        }

        @Override
        public void sendPocUserBusy(String json, String senderUserId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).sendPocUserBusy(json, senderUserId, roomId);
            }
        }

        @Override
        public void sendPocRejectCall(String json, String senderUserId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).sendPocRejectCall(json, senderUserId, roomId);
            }
        }

        @Override
        public void sendPocAcceptCall(String json, String senderUserId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).sendPocAcceptCall(json, senderUserId, roomId);
            }
        }

        @Override
        public void sendPocDelayCall(String json, String senderUserId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).sendPocDelayCall(json, senderUserId, roomId);
            }
        }

        @Override
        public void insertTempGroupData(String roomId, String roomName, String userIds, String ownerId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).insertTempGroupData(roomId, roomName, userIds, ownerId);
            }
        }

        @Override
        public void deleteRoomByRoomId(String userId, String roomId) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).deleteRoomByRoomId(userId, roomId);
            }
        }

        @Override
        public void deleteRoomByIdWithNotifyUI(String userId, String roomId, int position) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).deleteRoomByIdWithNotifyUI(userId, roomId, position);
            }
        }

        @Override
        public void updateGroupMuteStatus(String userId, String roomId, boolean status) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).updateGroupMuteStatus(userId, roomId, status);
            }
        }

        @Override
        public void handleNetConnectFailed() throws RemoteException {
        }

        @Override
        public void handleNetConnectSuccess() throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).handleNetConnectSuccess();
            } else {
                LogUtils.ELog((String)TAG, (String)"handleNetConnectSuccess: mService.get() is null");
            }
        }

        @Override
        public List<String> getOnLineRoom() throws RemoteException {
            return this.mService.get() != null ? ((POCService)((Object)this.mService.get())).getOnLineRoom() : null;
        }

        @Override
        public List<String> getReconnectRoom() throws RemoteException {
            return this.mService.get() != null ? ((POCService)((Object)this.mService.get())).getReconnectRoom() : null;
        }

        @Override
        public boolean insertStickGroupData(String json) throws RemoteException {
            return this.mService.get() != null ? ((POCService)((Object)this.mService.get())).insertStickGroupData(json) : false;
        }

        @Override
        public void uploadRecord(String recordUri) throws RemoteException {
            if (this.mService.get() != null) {
                ((POCService)((Object)this.mService.get())).realUploadRecord(recordUri);
            }
        }
    }
}

