/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;

public class ScreenObserverManager {
    private OnScreenStateUpdateListener mOnScreenStateUpdateListener;
    private ScreenBroadcastReceiver mScreenBroadcastReceiver;
    private Context mContext;

    public ScreenObserverManager(Context context) {
        this.mContext = context;
        this.mScreenBroadcastReceiver = new ScreenBroadcastReceiver();
    }

    public void register(OnScreenStateUpdateListener listener) {
        this.mOnScreenStateUpdateListener = listener;
        this.registerListener();
        this.getScreenState();
    }

    public void unregister(OnScreenStateUpdateListener listener) {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mScreenBroadcastReceiver);
    }

    private void getScreenState() {
        PowerManager mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        if (mPowerManager.isScreenOn()) {
            if (this.mOnScreenStateUpdateListener != null) {
                this.mOnScreenStateUpdateListener.onScreenOn();
            }
        } else if (this.mOnScreenStateUpdateListener != null) {
            this.mOnScreenStateUpdateListener.onScreenOff();
        }
    }

    private void registerListener() {
        IntentFilter mIntentFilter = new IntentFilter();
        mIntentFilter.addAction("android.intent.action.SCREEN_ON");
        mIntentFilter.addAction("android.intent.action.SCREEN_OFF");
        mIntentFilter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver((BroadcastReceiver)this.mScreenBroadcastReceiver, mIntentFilter);
    }

    public static interface OnScreenStateUpdateListener {
        public void onScreenOn();

        public void onScreenOff();

        public void onUserPresent();
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private ScreenBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                ScreenObserverManager.this.mOnScreenStateUpdateListener.onScreenOn();
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                ScreenObserverManager.this.mOnScreenStateUpdateListener.onScreenOff();
            } else if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                ScreenObserverManager.this.mOnScreenStateUpdateListener.onUserPresent();
            }
        }
    }
}

