/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.record.http;

import com.xdja.poc.sdk.record.http.HttpClient;
import com.xdja.poc.sdk.record.http.HttpRequest;
import com.xdja.poc.sdk.record.http.HttpUploadFileRequest;
import com.xdja.poc.sdk.record.http.HttpsClient;
import com.xdja.poc.sdk.record.http.IHttpClient;
import java.util.Map;
import okhttp3.Callback;
import okhttp3.Request;

public class HttpClientProxy
implements IHttpClient {
    private static final String HTTPS_PREFIX = "https";
    private IHttpClient httpClient;
    private IHttpClient httpsClient;

    HttpClientProxy() {
    }

    @Override
    public int exec(String url, Map<String, Object> params, Map<String, String> headers, IHttpClient.Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().exec(url, params, headers, callback);
        }
        return this.getHttpClient().exec(url, params, headers, callback);
    }

    @Override
    public int exec(String methodType, String url, Object body, Map<String, String> headers, IHttpClient.Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().exec(methodType, url, body, headers, callback);
        }
        return this.getHttpClient().exec(methodType, url, body, headers, callback);
    }

    @Override
    public int execFormData(String url, Map<String, String> params, Map<String, String> headers, IHttpClient.Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().execFormData(url, params, headers, callback);
        }
        return this.getHttpClient().execFormData(url, params, headers, callback);
    }

    @Override
    public int execGet(String url, Map<String, String> headers, IHttpClient.Callback callback) {
        if (url.startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().execGet(url, headers, callback);
        }
        return this.getHttpClient().execGet(url, headers, callback);
    }

    @Override
    public int request(HttpRequest request, IHttpClient.Callback callback) {
        if (request.getUrl().startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().request(request, callback);
        }
        return this.getHttpClient().request(request, callback);
    }

    @Override
    public int uploadFile(HttpUploadFileRequest request, IHttpClient.UploadFileCallback callback) {
        if (request.getUrl().startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().uploadFile(request, callback);
        }
        return this.getHttpClient().uploadFile(request, callback);
    }

    @Override
    public void cancelRequest(int requestId) {
        if (this.httpClient != null) {
            this.httpClient.cancelRequest(requestId);
        }
        if (this.httpsClient != null) {
            this.httpsClient.cancelRequest(requestId);
        }
    }

    private synchronized IHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        return this.httpClient;
    }

    private synchronized IHttpClient getHttpsClient() {
        if (this.httpsClient == null) {
            this.httpsClient = new HttpsClient();
        }
        return this.httpsClient;
    }

    @Override
    public int downloadFile(Request request, Callback callback) {
        if (request.url().toString().startsWith(HTTPS_PREFIX)) {
            return this.getHttpsClient().downloadFile(request, callback);
        }
        return this.getHttpClient().downloadFile(request, callback);
    }
}

