/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.history;

import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.ui.history.HistoryVoicePlayer;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import com.xdja.poc.sdk.ui.history.POCHistoryMessageAdapter;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessageContract;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessagePresenter;
import java.util.List;

@TitleViewAnnotation
public class POCHistoryMessageActivity
extends BaseActivity
implements POCHistoryMessageContract.IView {
    private EasyRecyclerView mRecyclerView;
    private POCHistoryMessageAdapter mAdapter;
    private POCHistoryMessagePresenter pocHistoryMessagePresenter;
    private static final String ROOM_ID = "roomId";
    private String roomId;
    private int pageSize = 15;
    private long syncTime = 0L;
    private LinearLayoutManager lm;

    public static void startPOCHistoryMessageActivity(Context context, String roomId) {
        if (!PreferenceHelper.getBoolean((String)"poc_is_save_record", (boolean)true)) {
            ToastUtils.showToast((String)"\u6682\u4e0d\u652f\u6301\u5386\u53f2\u8bed\u97f3\u67e5\u770b");
            return;
        }
        Intent target = new Intent(context, POCHistoryMessageActivity.class);
        target.putExtra(ROOM_ID, roomId);
        context.startActivity(target);
    }

    protected int generateLayout() {
        return R.layout.poc_activity_history_message;
    }

    protected int getTranslucentStatusBarColor() {
        return this.getResources().getColor(R.color.common_main_color);
    }

    protected void initView() {
        this.roomId = this.getIntent().getStringExtra(ROOM_ID);
        if (StringUtils.isEmpty((String)this.roomId)) {
            this.finish();
            return;
        }
        this.initTitleBar();
        this.mRecyclerView = (EasyRecyclerView)this.findViewById(R.id.rv_history_message);
        this.lm = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.lm);
        this.mRecyclerView.getSwipeToRefresh().setColorSchemeResources(new int[]{R.color.common_main_color});
        this.mAdapter = new POCHistoryMessageAdapter((Context)this);
        this.pocHistoryMessagePresenter = new POCHistoryMessagePresenter(this);
    }

    private void initTitleBar() {
        this.getTitleBarView().setTile("\u5386\u53f2\u6d88\u606f");
        this.getTitleBarView().setBackgroundRecource(R.color.common_main_color);
        this.getTitleBarView().setLeftViewRecource(R.mipmap.common_back_n);
        this.getTitleBarView().setTitleColor(this.getResources().getColor(R.color.common_white_color));
        this.getTitleBarView().setTextSize(18);
        this.getTitleBarView().setLeftViewClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                POCHistoryMessageActivity.this.finish();
            }
        });
    }

    protected void initEvent() {
        this.mRecyclerView.setRefreshListener(() -> {
            POCHistoryMessage firstMessage;
            if (this.mAdapter.getCount() > 0 && (firstMessage = (POCHistoryMessage)this.mAdapter.getAllData().get(0)) != null) {
                this.syncTime = Long.valueOf(firstMessage.getSyncTime());
                this.pocHistoryMessagePresenter.loadUpMessage(this.roomId, this.pageSize, this.syncTime);
                return;
            }
            this.syncTime = 0L;
            this.pocHistoryMessagePresenter.loadUpMessage(this.roomId, this.pageSize, this.syncTime);
        });
        this.mAdapter.setMore(R.layout.poc_history_message_view_more, () -> {
            POCHistoryMessage lastMessage;
            List temp = this.mAdapter.getAllData();
            if (temp != null && (lastMessage = (POCHistoryMessage)temp.get(temp.size() - 1)) != null) {
                this.syncTime = Long.valueOf(lastMessage.getSyncTime());
                this.pocHistoryMessagePresenter.loadMoreHistoryMessage(this.roomId, this.pageSize, this.syncTime);
            }
        });
        this.mAdapter.setError(R.layout.poc_view_history_message_loadmore_error, new RecyclerArrayAdapter.OnErrorListener(){

            public void onErrorShow() {
            }

            public void onErrorClick() {
                POCHistoryMessageActivity.this.mAdapter.resumeMore();
            }
        });
        this.mRecyclerView.getErrorView().findViewById(R.id.reload_btn).setOnClickListener(v -> {
            this.mRecyclerView.showProgress();
            this.syncTime = 0L;
            this.pocHistoryMessagePresenter.loadFirstMessage(this.roomId, this.pageSize, this.syncTime);
        });
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerView.getSwipeToRefresh().setEnabled(true);
        this.mRecyclerView.showProgress();
        this.pocHistoryMessagePresenter.loadFirstMessage(this.roomId, this.pageSize, this.syncTime);
    }

    @Override
    public void loadMessageSuccess(List<POCHistoryMessage> historyMessages, int totalRecord) {
        if (historyMessages == null || historyMessages.size() == 0) {
            if (this.mAdapter.getCount() == 0 && this.mAdapter.getCount() == 0) {
                this.mRecyclerView.showEmpty();
            }
            if (totalRecord != -1) {
                this.mAdapter.stopMore();
            }
            if (totalRecord == -1) {
                this.mRecyclerView.setRefreshing(false);
            }
            this.mRecyclerView.scrollToPosition(this.mAdapter.getCount() - 1);
            return;
        }
        if (totalRecord == -1 && this.mAdapter.getCount() != 0) {
            this.mAdapter.insertAll(historyMessages, 0);
            this.mAdapter.notifyItemRangeInserted(0, historyMessages.size());
            this.mRecyclerView.scrollToPosition(this.mAdapter.getCount() - 1);
            return;
        }
        this.mAdapter.addAll(historyMessages);
        if (this.mAdapter.getCount() < this.pageSize) {
            this.mAdapter.resumeMore();
        }
        if (historyMessages.size() < this.pageSize) {
            this.mAdapter.stopMore();
        }
        this.mRecyclerView.scrollToPosition(this.mAdapter.getCount() - 1);
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void loadMessageFailed() {
        if (this.mAdapter.getCount() == 0) {
            this.mRecyclerView.showError();
            this.mAdapter.stopMore();
            return;
        }
        this.mAdapter.pauseMore();
    }

    @Override
    public boolean isExist() {
        return !this.isFinishing();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mAdapter != null) {
            this.mAdapter.stopAnim();
        }
        HistoryVoicePlayer.getInstance().releasePlay();
    }
}

