/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.poc.sdk.ui.main.holder;

import android.content.Context;
import android.support.annotation.IdRes;
import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jude.easyrecyclerview.adapter.BaseViewHolder;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import java.util.List;

public class PocSearchGroupListHolder
extends BaseViewHolder<DBGroupEntity> {
    private TextView tvGroupName;
    private TextView tvMemberStatus;
    private ImageView ivAudioSwitch;
    private TextView tvMemberCount;
    private String keyWords = "";
    private ImageView ivGroupAvatar;
    private TextView tvPttView;
    private LinearLayout itemRootView;
    private onViewClickListener mListener;

    public PocSearchGroupListHolder(ViewGroup itemView, String keyWords, onViewClickListener onViewClickListener2) {
        super(itemView, R.layout.poc_fragment_group_list_item);
        this.mListener = onViewClickListener2;
        this.tvGroupName = (TextView)this.$(R.id.tv_group_name);
        this.tvMemberStatus = (TextView)this.$(R.id.tv_member_status);
        this.ivAudioSwitch = (ImageView)this.$(R.id.iv_audio_switch);
        this.tvMemberCount = (TextView)this.$(R.id.tv_member_count);
        this.keyWords = keyWords;
        this.ivGroupAvatar = (ImageView)this.$(R.id.iv_group_avatar);
        this.tvPttView = (TextView)this.$(R.id.iv_ptt_view);
        this.itemRootView = (LinearLayout)this.$(R.id.rl_item_root);
    }

    public void setData(DBGroupEntity data) {
        super.setData((Object)data);
        this.tvGroupName.setText((CharSequence)StringUtils.getSpanned((String)data.getRoomName(), (String)this.keyWords, (Context)this.getContext()));
        String memberStatus = "";
        this.itemView.setBackgroundColor(data.getIsTopStick() ? this.getContext().getResources().getColor(R.color.poc_item_bg) : this.getContext().getResources().getColor(R.color.common_white_color));
        if (data.getIsSilence()) {
            this.ivAudioSwitch.setBackgroundResource(R.mipmap.poc_audio_off);
        } else {
            this.ivAudioSwitch.setBackgroundResource(R.mipmap.poc_audio_on);
        }
        if (data.getIsPttKey()) {
            this.tvPttView.setVisibility(0);
        } else {
            this.tvPttView.setVisibility(8);
        }
        this.ivGroupAvatar.setBackgroundResource(R.mipmap.poc_iv_temp_group_avatar);
        String memeberIds = data.getMemeberIds();
        List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(memeberIds);
        int[] memberOnLineCount = new int[]{data.getOnLineCount(), allCountList == null ? 0 : allCountList.size()};
        String memberOnLineCountStatus = this.getContext().getResources().getString(R.string.poc_member_online_count_status);
        if (memberOnLineCount[0] <= 0 || data.getStatus() == 0) {
            memberOnLineCount[0] = 0;
            data.setStatus(0);
        }
        if (data.getStatus() == 0) {
            this.tvMemberStatus.setText((CharSequence)"\u6302\u65ad");
            this.itemRootView.setBackground(this.getContext().getDrawable(R.drawable.poc_list_select_off_bg));
            this.tvMemberStatus.setBackgroundResource(R.drawable.common_drawable_bg_red);
            this.tvMemberStatus.setTextColor(this.getContext().getResources().getColor(R.color.common_poc_red));
        } else if (data.getStatus() == 1 || data.getStatus() == 1) {
            this.tvMemberStatus.setText((CharSequence)"\u7a7a\u95f2");
            this.itemRootView.setBackground(this.getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            this.tvMemberStatus.setBackgroundResource(R.drawable.common_drawable_bg_green);
            this.tvMemberStatus.setTextColor(this.getContext().getResources().getColor(R.color.common_poc_green));
        } else if (data.getStatus() == 2) {
            this.itemRootView.setBackground(this.getContext().getDrawable(R.drawable.poc_list_select_on_bg));
            this.tvMemberStatus.setText((CharSequence)(StringUtils.generateContent((String)data.getSpeakerUserName()) + "  \u6b63\u5728\u8bb2\u8bdd"));
            this.tvMemberStatus.setBackgroundResource(R.drawable.common_drawable_bg_green);
            this.tvMemberStatus.setTextColor(this.getContext().getResources().getColor(R.color.common_poc_green));
        }
        if (memberOnLineCount[0] > memberOnLineCount[1]) {
            memberOnLineCount[0] = memberOnLineCount[1];
        }
        memberStatus = "<font color='#808080'>" + memberOnLineCountStatus + "</font> <font color='#7eb606'><strong>" + memberOnLineCount[0] + "</strong></font> / <font color='#808080'>" + memberOnLineCount[1] + "</font>";
        this.tvMemberCount.setText((CharSequence)Html.fromHtml((String)memberStatus));
        this.ivAudioSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PocSearchGroupListHolder.this.mListener.onClick(v.getId(), PocSearchGroupListHolder.this.getAdapterPosition());
            }
        });
    }

    public void setSearchKey(String searchKey) {
        this.keyWords = searchKey;
    }

    public static interface onViewClickListener {
        public void onClick(@IdRes int var1, int var2);
    }
}

