package com.xdja.poc.sdk.greendao;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.greendao.dao.RecordMessageDao;
import com.xdja.poc.sdk.greendao.manager.GreenDaoManager;
import com.xdja.poc.sdk.record.RecordMessage;

import java.util.List;

/**
 * Created by xdjaxa on 2019/1/7.
 */

public class LocalRecordDBHelper {
    private static final String TAG = LocalRecordDBHelper.class.getSimpleName();
    private final GreenDaoManager daoManager;
    private static LocalRecordDBHelper dbHelper;

    private LocalRecordDBHelper() {
        daoManager = GreenDaoManager.getInstance();
    }

    public static LocalRecordDBHelper getInstance() {
        if (dbHelper == null) {
            synchronized (LocalRecordDBHelper.class) {
                if (dbHelper == null) {
                    dbHelper = new LocalRecordDBHelper();
                }
            }
        }
        return dbHelper;
    }

    public synchronized void insert(RecordMessage recordMessage) {
        getRecordMessageDao().insert(recordMessage);
        LogUtils.DLog(TAG, "insert success");
    }

    public synchronized List<RecordMessage> query(int offset, int pageCount) {
        List<RecordMessage> temp = getRecordMessageDao().queryBuilder()
                .orderDesc(RecordMessageDao.Properties.RecordUri)
                .offset(offset)
                .limit(pageCount)
                .build()
                .list();
        return temp;
    }

    public synchronized RecordMessage queryNoUploadRecord() {
        List<RecordMessage> temp = getRecordMessageDao().queryBuilder()
//                .where(RecordMessageDao.Properties.RecordMessageId.eq(""))
                .orderDesc(RecordMessageDao.Properties.RecordUri)
                .limit(1)
                .build()
                .list();
        if (temp != null && temp.size() > 0) {
            return temp.get(0);
        }
        return null;
    }

    public synchronized RecordMessage update(String key, String remoteUrl) {
        RecordMessage temp = getRecordMessageDao().load(key);
        if (temp != null) {
            temp.setRecordRemoteUrl(remoteUrl);
            getRecordMessageDao().update(temp);
            LogUtils.DLog(TAG, "update success");
        }
        return temp;
    }

    public synchronized void delete(String key) {
        getRecordMessageDao().deleteByKey(key);
        LogUtils.DLog(TAG, "delete success");
    }

    private RecordMessageDao getRecordMessageDao() {
        return daoManager.getDaoSession().getRecordMessageDao();
    }
}
