package com.xdja.poc.sdk.proxy;

import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCConversationUserChangeEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
/**
 * janus-gateway-android-master
 * 功能
 * 描述  频道事件的回调接口
 * created by Wwq : 2018/9/29
 */

public interface IPOCRoomEventCallBack {
    /**
     * 固定频道创建成功回调
     *
     * @param event
     */
    void onCreateServerRooomCallBack(GroupEvent event, boolean status);

    /**
     * 创建临时频道成功回调
     *
     * @param entity
     */
    void onCreateTempRooomCallBack(DBGroupEntity entity,String channelName, boolean status);


    void onDeleteServerRoomCallBack(GroupEvent event,boolean status);
    void onAddMembersCallBack(GroupEvent event,boolean status);
    void onDeleteTempRoomCallBack(GroupEvent event,boolean status);

    void onRemoveMembersCallBack(GroupEvent event,boolean status);
    void onUpdateMembersCallBack(GroupEvent event,boolean status);
    void onSelfLeaveRoomCallBack(POCSelfLeaveEvent selfLeaveEvent);

    void onTBCPEventCallBack(POCConverationTbcpStatusEvent tbcpStatusEvent);

    void onMeIncomeRoomCallBack(POCConversationMeIncomeRoom meIncomeRoom);

    void onMemberEventCallBack(POCMemberEvent memberEvent);

    void onUserChangedCallBack(POCConversationUserChangeEvent userChangeEvent);
}
