package com.xdja.poc.sdk.record.api;

import com.google.gson.Gson;
import com.xdja.poc.sdk.record.api.bean.BaseRecordResponse;
import com.xdja.poc.sdk.record.api.bean.CancelMessageRequest;
import com.xdja.poc.sdk.record.api.bean.CreateMessageRequest;
import com.xdja.poc.sdk.record.api.bean.PageMessageRequest;
import com.xdja.poc.sdk.record.api.bean.RemoveMessageRequest;
import com.xdja.poc.sdk.record.api.bean.SynctimeMessageRequest;
import com.xdja.poc.sdk.ui.history.POCHistoryMessage;
import com.xdja.poc.sdk.utils.IPHost;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * 业务处理类
 * Created by xdjaxa on 2019/1/10.
 */

public class RecordBusiness {

    /**
     * 创建消息记录
     *
     * @param request
     * @return
     */
    public static Observable<BaseRecordResponse<String>> createTalkGroupMessage(CreateMessageRequest request) {
        RequestBody body = RequestBody.create(MediaType.parse(IPHost.DEFAULT_CONTENT_TYPE), new Gson().toJson(request));
        return RecordApiFactory.getRecordApi().createTalkGroupMessage(body);
    }

    /**
     * 移除消息记录
     *
     * @param request
     * @return
     */
    public static Observable<BaseRecordResponse<Object>> removeTalkGroupMessage(RemoveMessageRequest request) {
        RequestBody body = RequestBody.create(MediaType.parse(IPHost.DEFAULT_CONTENT_TYPE), new Gson().toJson(request));
        return RecordApiFactory.getRecordApi().removeTalkGroupMessage(body);
    }

    /**
     * 撤销消息记录
     *
     * @param request
     * @return
     */
    public static Observable<BaseRecordResponse<Object>> cancelTalkGroupMessage(CancelMessageRequest request) {
        RequestBody body = RequestBody.create(MediaType.parse(IPHost.DEFAULT_CONTENT_TYPE), new Gson().toJson(request));
        return RecordApiFactory.getRecordApi().cancelTalkGroupMessage(body);
    }

    /**
     * 分页拉取消息记录
     *
     * @param request
     * @return
     */
    public static Observable<BaseRecordResponse<List<POCHistoryMessage>>> gettTalkGroupMessageByPage(PageMessageRequest request) {
        RequestBody body = RequestBody.create(MediaType.parse(IPHost.DEFAULT_CONTENT_TYPE), new Gson().toJson(request));
        return RecordApiFactory.getRecordApi().gettTalkGroupMessageByPage(body);
    }

    /**
     * 同步时间拉取消息记录
     *
     * @param request
     * @return
     */
    public static Observable<BaseRecordResponse<List<POCHistoryMessage>>> gettTalkGroupMessageBySynctime(SynctimeMessageRequest request) {
        RequestBody body = RequestBody.create(MediaType.parse(IPHost.DEFAULT_CONTENT_TYPE), new Gson().toJson(request));
        return RecordApiFactory.getRecordApi().gettTalkGroupMessageBySynctime(body);
    }
}
