package com.xdja.poc.sdk.ui.history;

/**
 * Created by xdjaxa on 2019/1/10.
 */

import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.LinearLayoutManager;
import android.view.View;

import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.annotation.TitleViewAnnotation;
import com.xdja.poc.common.base.BaseActivity;
import com.xdja.poc.common.utils.DisplayUtil;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.BuildConfig;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessageContract;
import com.xdja.poc.sdk.ui.main.mvp.POCHistoryMessagePresenter;

import java.util.List;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

/**
 * poc-历史消息
 * Created by xdjaxa on 2019/1/4.
 */

@TitleViewAnnotation
public class POCHistoryMessageActivity extends BaseActivity implements POCHistoryMessageContract.IView {

    private EasyRecyclerView mRecyclerView;
    private POCHistoryMessageAdapter mAdapter;
    private POCHistoryMessagePresenter pocHistoryMessagePresenter;

    private static final String ROOM_ID = "roomId";
    private String roomId;

    private int pageSize = 15;
    private long syncTime = 0;
    private LinearLayoutManager lm;

    public static void startPOCHistoryMessageActivity(Context context, String roomId) {
        if (!PreferenceHelper.getBoolean(UserConfig.POC_IS_SAVE_RECORD,true)) {
            ToastUtils.showToast("暂不支持历史语音查看");
            return;
        }
        Intent target = new Intent(context, POCHistoryMessageActivity.class);
        target.putExtra(ROOM_ID, roomId);
        context.startActivity(target);
    }

    @Override
    protected int generateLayout() {
        return R.layout.poc_activity_history_message;
    }

    protected int getTranslucentStatusBarColor() {
        return getResources().getColor(R.color.common_main_color);
    }

    @Override
    protected void initView() {
        roomId = getIntent().getStringExtra(ROOM_ID);
        if (StringUtils.isEmpty(roomId)) {
            finish();
            return;
        }

        initTitleBar();

        mRecyclerView = findViewById(R.id.rv_history_message);
        lm = new LinearLayoutManager(this);
        mRecyclerView.setLayoutManager(lm);
        mRecyclerView.getSwipeToRefresh().setColorSchemeResources(new int[]{R.color.common_main_color});
        mAdapter = new POCHistoryMessageAdapter(this);

        pocHistoryMessagePresenter = new POCHistoryMessagePresenter(this);
    }

    private void initTitleBar() {
        getTitleBarView().setTile("历史消息");
        getTitleBarView().setBackgroundRecource(R.color.common_main_color);
        getTitleBarView().setLeftViewRecource(R.mipmap.common_back_n);
        getTitleBarView().setTitleColor(getResources().getColor(R.color.common_white_color));
        getTitleBarView().setTextSize(18);
        getTitleBarView().setLeftViewClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    @Override
    protected void initEvent() {
        mRecyclerView.setRefreshListener(() -> {
            if (mAdapter.getCount() > 0) {
                POCHistoryMessage firstMessage = mAdapter.getAllData().get(0);
                if (firstMessage != null) {
                    syncTime = Long.valueOf(firstMessage.getSyncTime());
                    pocHistoryMessagePresenter.loadUpMessage(roomId, pageSize, syncTime);
                    return;
                }
            }
            syncTime = 0;
            pocHistoryMessagePresenter.loadUpMessage(roomId, pageSize, syncTime);
        });
        mAdapter.setMore(R.layout.poc_history_message_view_more, () -> {
            List<POCHistoryMessage> temp = mAdapter.getAllData();
            if (temp != null) {
                POCHistoryMessage lastMessage = temp.get(temp.size() - 1);
                if (lastMessage != null) {
                    syncTime = Long.valueOf(lastMessage.getSyncTime());
                    pocHistoryMessagePresenter.loadMoreHistoryMessage(roomId, pageSize, syncTime);
                }
            }
        });
        mAdapter.setError(R.layout.poc_view_history_message_loadmore_error, new RecyclerArrayAdapter.OnErrorListener() {
            @Override
            public void onErrorShow() {

            }

            @Override
            public void onErrorClick() {
                mAdapter.resumeMore();
            }
        });

        mRecyclerView.getErrorView().findViewById(R.id.reload_btn).setOnClickListener(v -> {
            mRecyclerView.showProgress();
            syncTime = 0;
            pocHistoryMessagePresenter.loadFirstMessage(roomId, pageSize, syncTime);
        });

        mRecyclerView.setAdapter(mAdapter);
        mRecyclerView.getSwipeToRefresh().setEnabled(true);

        mRecyclerView.showProgress();
        pocHistoryMessagePresenter.loadFirstMessage(roomId, pageSize, syncTime);
    }

    /**
     * @param historyMessages
     * @param totalRecord     -1：代表数据为缓存数据 other：数据总数
     */
    @Override
    public void loadMessageSuccess(List<POCHistoryMessage> historyMessages, int totalRecord) {
        if (historyMessages == null || historyMessages.size() == 0) {
            if (mAdapter.getCount() == 0 && mAdapter.getCount() == 0) {
                mRecyclerView.showEmpty();
            }
            if (totalRecord != -1) {
                mAdapter.stopMore();
            }
            if (totalRecord == -1) {
                mRecyclerView.setRefreshing(false);
            }
            mRecyclerView.scrollToPosition(mAdapter.getCount() - 1);
            return;
        }
        //加载本地
        if (totalRecord == -1 && mAdapter.getCount() != 0) {
            mAdapter.insertAll(historyMessages, 0);
            //防止上面插入数据时原数据被顶下来
            mAdapter.notifyItemRangeInserted(0, historyMessages.size());
            //解决第一次进入，录音条数未占满屏幕加载更多功能无效问题
            mRecyclerView.scrollToPosition(mAdapter.getCount() - 1);
            return;
        }
        //加载网络数据
        mAdapter.addAll(historyMessages);
        if (mAdapter.getCount() < pageSize) {
            mAdapter.resumeMore();
        }
        if (historyMessages.size() < pageSize) {
            mAdapter.stopMore();
        }
        mRecyclerView.scrollToPosition(mAdapter.getCount() - 1);
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void loadMessageFailed() {
        if (mAdapter.getCount() == 0) {
            mRecyclerView.showError();
            mAdapter.stopMore();
            return;
        }
        mAdapter.pauseMore();
    }

    @Override
    public boolean isExist() {
        return !isFinishing();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mAdapter != null) {
            mAdapter.stopAnim();
        }
        HistoryVoicePlayer.getInstance().releasePlay();
    }
}
