package com.xdja.poc.sdk.ui.main.mvp;

import android.content.Context;

import com.google.gson.Gson;
import com.jude.easyrecyclerview.EasyRecyclerView;
import com.jude.easyrecyclerview.adapter.RecyclerArrayAdapter;
import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.common.utils.PinyinUtil;
import com.xdja.poc.sdk.bean.GroupList;
import com.xdja.poc.sdk.bean.POCMemberInfo;
import com.xdja.poc.sdk.event.GroupEvent;
import com.xdja.poc.sdk.event.POCConverationTbcpStatusEvent;
import com.xdja.poc.sdk.event.POCConversationMeIncomeRoom;
import com.xdja.poc.sdk.event.POCGroupUpdateEvent;
import com.xdja.poc.sdk.event.POCMemberEvent;
import com.xdja.poc.sdk.event.POCSelfLeaveEvent;
import com.xdja.poc.common.utils.NetUtils;
import com.xdja.poc.common.utils.PreferenceHelper;
import com.xdja.poc.common.utils.StringUtils;
import com.xdja.poc.common.utils.ToastUtils;
import com.xdja.poc.sdk.POCClient;
import com.xdja.poc.sdk.R;
import com.xdja.poc.sdk.business.POCHandlerService;
import com.xdja.poc.sdk.business.PocBroadReceiver;
import com.xdja.poc.sdk.config.GroupConfig;
import com.xdja.poc.sdk.config.UserConfig;
import com.xdja.poc.sdk.db.entity.DBGroupEntity;
import com.xdja.poc.sdk.proxy.IPOCAbstractRoomEventCallBack;
import com.xdja.poc.sdk.proxy.IPOCChannelInfoCallBack;
import com.xdja.poc.sdk.proxy.IPOCRoomEventCallBack;
import com.xdja.poc.sdk.proxy.POCUiKitProxyImpl;
import com.xdja.poc.sdk.utils.GroupUtils;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * janus-gateway-android-master
 * 功能 POC网络层Presenter层
 * 描述
 * created by Wwq : 2018/8/27
 */

public class POCGroupListPresenter implements POCGroupListContract.IPresenter {
    private POCGroupListContract.IView mView;
    private Context mContext;
    private RecyclerArrayAdapter<DBGroupEntity> mAdapter;
    private RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter;
    private EasyRecyclerView recyclerView;
    private String mUserId;
    private Gson gson;
    private IPOCRoomEventCallBack roomEventCallBack;
    private boolean isDeleteRoom = false;
    private boolean isSelfOwner = false;
    private Map<String, Boolean> currentSpeakCache = new HashMap<>();
    private Map<String, POCMemberInfo> mAccountToName = new HashMap<>();
    public static Map<String, String> selfSpeakRoomInfo = new HashMap<>();

    public POCGroupListPresenter(POCGroupListContract.IView mView, Context context) {
        this.mView = mView;
        this.mContext = context;
        gson = new Gson();
        mUserId = PreferenceHelper.getString(UserConfig.LOGIN_ACCOUNT, "");
        initEvent();
    }

    private void initEvent() {
        roomEventCallBack = new IPOCAbstractRoomEventCallBack() {
            @Override
            public void onMemberEventCallBack(POCMemberEvent memberEvent) {
                super.onMemberEventCallBack(memberEvent);
                LogUtils.DLog("POCListPresenter", "onMemberEventCallBack: " + memberEvent.getUserBehavior());
                String roomId = memberEvent.getRoomId();
                List<DBGroupEntity> allData = mAdapter.getAllData();
                Map<String, String> map = POCClient.getAllSpeakers();
                for (DBGroupEntity group : allData) {
                    if (group.getRooomId().equalsIgnoreCase(roomId)) {
                        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(group.getRooomId()));
                        group.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                        boolean b = GroupUtils.resetGroupStatus(group);
                        group.setStatus(b ? GroupConfig.GROUP_FREE : GroupConfig.GROUP_HANGUP);
                        if (map != null && map.containsKey(group.getRooomId())) {
                            group.setStatus(GroupConfig.GROUP_BUSY);
                            String speakUserId = map.get(group.getRooomId());
                            if (speakUserId.equals(mUserId)) {
                                group.setStatus(GroupConfig.GROUP_BUSY);
                                group.setSpeakerUserName("您");
                            } else {
                                String speakName = speakUserId;
                                mAccountToName = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                                if (mAccountToName != null && mAccountToName.containsKey(speakUserId)) {
                                    speakName = mAccountToName.get(speakUserId).getName();
                                } else {
                                    if (mAccountToName == null) {
                                        mAccountToName = new HashMap<>();
                                    }
                                    if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId)
                                            && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(speakUserId)) {
                                        POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(speakUserId);
                                        speakName = info.getName();
                                        mAccountToName.put(speakUserId, info);
                                    }
                                }
                                group.setSpeakerUserName(speakName);
                            }
                        }
                        Collections.sort(allData, mView.getComparator());
                        mAdapter.clear();
                        mAdapter.addAll(allData);
                        if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
                            List<DBGroupEntity> allData1 = mSearchAdapter.getAllData();
                            for (DBGroupEntity entity : allData1) {
                                if (entity.getRooomId().equals(roomId)) {
                                    entity.setStatus(group.getStatus());
                                    entity.setOnLineCount(group.getOnLineCount());
                                    entity.setSpeakerUserName(group.getSpeakerUserName());
                                    break;
                                }
                            }
                            mSearchAdapter.notifyDataSetChanged();
                        }
                        break;
                    }
                }

            }

            @Override
            public void onMeIncomeRoomCallBack(POCConversationMeIncomeRoom meIncomeRoom) {
                super.onMeIncomeRoomCallBack(meIncomeRoom);
                mView.onSelfInComing(meIncomeRoom.getRoomId());
            }

            @Override
            public void onSelfLeaveRoomCallBack(POCSelfLeaveEvent selfLeaveEvent) {
                super.onSelfLeaveRoomCallBack(selfLeaveEvent);
                String roomId = selfLeaveEvent.getRoomId();
                List<DBGroupEntity> allData = mAdapter.getAllData();
                int dataPosition = -1;
                for (DBGroupEntity group : allData) {
                    if (group.getRooomId().equalsIgnoreCase(roomId)) {
                        dataPosition = mAdapter.getPosition(group);
                        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(group.getRooomId()));
                        group.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                        group.setStatus(GroupConfig.GROUP_HANGUP);
                        if (isDeleteRoom) {
                            isDeleteRoom = false;
                            if (group.getGroupType() == GroupConfig.TEMP_GROUP) {
                                checkAdapterData(mAdapter, roomId, false);
                                checkSearchAdapter(roomId, false);
                            } else if (group.getGroupType() == GroupConfig.STICK_GROUP) {
                                if (group.getOwnerId() != null && group.getOwnerId().equalsIgnoreCase(mUserId)) {
                                    POCUiKitProxyImpl.getInstance().doDeleteServerRoom(roomId);
                                } else {
                                    POCUiKitProxyImpl.getInstance().doRemoveMembersFromRoom(roomId, mUserId);
                                }
                            }
                        } else {
                            if (group.getGroupType() == GroupConfig.TEMP_GROUP) {
                                checkAdapterData(mAdapter, roomId, true);
                                checkSearchAdapter(roomId, false);
                            }
                        }
                        break;
                    }
                }

            }

            @Override
            public void onDeleteServerRoomCallBack(GroupEvent event, boolean status) {
                super.onDeleteServerRoomCallBack(event, status);
                if (status) {
                    checkAdapterData(mAdapter, event.getRoomId(), false);
                    checkSearchAdapter(event.getRoomId(), false);
                    POCClient.destroyRoom(mUserId, event.getRoomId());
                } else {
                    if (mView != null)
                        mView.dismissLoading();
                }
            }

            @Override
            public void onRemoveMembersCallBack(GroupEvent event, boolean status) {
                super.onRemoveMembersCallBack(event, status);
                List<DBGroupEntity> allData = mAdapter.getAllData();
                int position = -1;
                if (event.getMembers().equals(mUserId)) {
//                    POCClient.leaveRoom(mUserId, event.getRoomId());
//                    DBGroupEntity entity = new DBGroupEntity();
//                    entity.setRoomName("");
//                    entity.setRooomId(event.getRoomId());
//                    if (!event.getFrom().equals(mUserId)) {
//                        POCUiKitProxyImpl.getInstance().notifyRefreshChannelMembersInfo(entity);
//                    }
                    checkAdapterData(mAdapter, event.getRoomId(), false);
                } else {
                    for (DBGroupEntity entity : allData) {
                        if (entity.getRooomId().equals(event.getRoomId())) {
                            position = mAdapter.getPosition(entity);
                            String memeberIds = entity.getMemeberIds();
                            List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                            if (memberInfoList != null) {
                                Iterator<POCMemberInfo> iterator = memberInfoList.iterator();
                                if (iterator != null) {
                                    while (iterator.hasNext()) {
                                        POCMemberInfo next = iterator.next();
                                        if (next.getAccount().equals(event.getMembers())) {
                                            iterator.remove();
                                        }
                                    }
                                    entity.setMemeberIds(POCClient.getInstance().generateListString(memberInfoList));
                                }
                            }
                            break;
                        }
                    }
                    if (position != -1) {
                        mAdapter.notifyItemChanged(position);
                    }
                    if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
                        int mPosition = -1;
                        for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                            if (entity.getRooomId().equals(event.getRoomId())) {
                                mPosition = mSearchAdapter.getPosition(entity);
                                String memeberIds = entity.getMemeberIds();
                                List<POCMemberInfo> memberInfoList = POCClient.getInstance().generateStringToList(memeberIds);
                                if (memberInfoList != null) {
                                    Iterator<POCMemberInfo> iterator = memberInfoList.iterator();
                                    if (iterator != null) {
                                        while (iterator.hasNext()) {
                                            POCMemberInfo next = iterator.next();
                                            if (next.getAccount().equals(event.getMembers())) {
                                                iterator.remove();
                                            }
                                        }
                                        entity.setMemeberIds(POCClient.getInstance().generateListString(memberInfoList));
                                    }
                                }
                            }
                        }
                        if (mPosition != -1) {
                            mSearchAdapter.notifyItemChanged(mPosition);
                        }
                    }

                }
//                POCUiKitProxyImpl.getInstance().notifyRefreshGroupList();
            }

            @Override
            public void onTBCPEventCallBack(POCConverationTbcpStatusEvent tbcpStatusEvent) {
                super.onTBCPEventCallBack(tbcpStatusEvent);
                String userId = tbcpStatusEvent.getUserId();
                String roomId = tbcpStatusEvent.getRoomId();
                List<DBGroupEntity> allData = mAdapter.getAllData();
                if (selfSpeakRoomInfo == null) {
                    selfSpeakRoomInfo = new HashMap<>();
                }
                selfSpeakRoomInfo.clear();
                switch (tbcpStatusEvent.getUserBehavior()) {
                    case PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS:
                        currentSpeakCache.put(roomId, true);
                        break;
                    case PocBroadReceiver.ROOM_REQUEST_TBCP_FAILED:
                        if (currentSpeakCache.containsKey(roomId) && !currentSpeakCache.get(roomId)) {
                            currentSpeakCache.put(roomId, false);
                        }
                        break;
                    case PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS:
                        currentSpeakCache.put(roomId, false);
                        break;
                    case PocBroadReceiver.ROOM_RELEASE_TBCP_SUCCESS:
                        currentSpeakCache.put(roomId, false);
                        break;
                    case PocBroadReceiver.ROOM_RELEASE_TBCP_FAILED:
                        currentSpeakCache.put(roomId, false);
                        break;
                    case PocBroadReceiver.ROOM_OTHER_RELEASE_TBCP_SUCCESS:
                        currentSpeakCache.put(roomId, false);
                        break;
                }
                for (DBGroupEntity pocGroup : allData) {
                    if (pocGroup.getRooomId().equalsIgnoreCase(roomId)) {
                        if (userId.equals(mUserId)) {
                            if (PocBroadReceiver.ROOM_REQUEST_TBCP_SUCCESS == tbcpStatusEvent.getUserBehavior()
                                    || PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS == tbcpStatusEvent.getUserBehavior()) {
                                selfSpeakRoomInfo.put(pocGroup.getRooomId(), mUserId);
                                pocGroup.setStatus(GroupConfig.GROUP_BUSY);
                                if(PocBroadReceiver.ROOM_OTHER_REQUEST_TBCP_SUCCESS == tbcpStatusEvent.getUserBehavior()){
                                    pocGroup.setSpeakerUserName("您正在其他设备讲话");
                                }else{
                                    pocGroup.setSpeakerUserName("您");
                                }

                            } else {
                                pocGroup.setStatus(GroupConfig.GROUP_FREE);
                            }
                        } else {
                            String speakName = StringUtils.isEmpty(pocGroup.getSpeakerUserName()) ? userId : pocGroup.getSpeakerUserName();
                            mAccountToName = POCUiKitProxyImpl.getInstance().getUserInfosCache();
                            if (mAccountToName != null && mAccountToName.containsKey(userId)) {
                                speakName = mAccountToName.get(userId).getName();
                            } else {
                                if (mAccountToName == null) {
                                    mAccountToName = new HashMap<>();
                                }
                                if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId)
                                        && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(userId)) {
                                    POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(userId);
                                    speakName = info.getName();
                                    mAccountToName.put(userId, info);
                                }
                            }
                            if (currentSpeakCache.containsKey(roomId) && currentSpeakCache.get(roomId)) {
                                pocGroup.setStatus(GroupConfig.GROUP_BUSY);
                                pocGroup.setSpeakerUserName(speakName);
                            } else {
                                pocGroup.setStatus(tbcpStatusEvent.getStatus());
                                pocGroup.setSpeakerUserName(speakName);
                            }
                        }

                        List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(pocGroup.getRooomId()));
                        pocGroup.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                        List<POCMemberInfo> allCountList = POCClient.getInstance().generateStringToList(pocGroup.getMemeberIds());
                        pocGroup.setTotalCount(allCountList == null ? 0 : allCountList.size());
                    }
                }
                Collections.sort(allData, mView.getComparator());
                mAdapter.notifyDataSetChanged();
                if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
                    List<DBGroupEntity> allData1 = mSearchAdapter.getAllData();
                    for (DBGroupEntity entity : allData1) {
                        if (entity.getRooomId().equals(roomId)) {
                            if (currentSpeakCache.containsKey(roomId) && currentSpeakCache.get(roomId)) {
                                entity.setStatus(GroupConfig.GROUP_BUSY);
                                entity.setSpeakerUserName(entity.getSpeakerUserName());
                            } else {
                                entity.setStatus(tbcpStatusEvent.getStatus());
//                                Map<String, String> map = GroupUtils.generateStringToMap(entity.getUserNames());
                                String speakName = userId;
                                mAccountToName = POCUiKitProxyImpl.getInstance().getUserInfosCache();

                                if (mAccountToName != null && mAccountToName.containsKey(userId)) {
                                    speakName = mAccountToName.get(userId).getName();
                                } else {
                                    if (mAccountToName == null) {
                                        mAccountToName = new HashMap<>();
                                    }
                                    if (UserConfig.userNameMap != null && UserConfig.userNameMap.containsKey(roomId)
                                            && UserConfig.userNameMap.get(roomId) != null && UserConfig.userNameMap.get(roomId).containsKey(userId)) {
                                        POCMemberInfo info = UserConfig.userNameMap.get(roomId).get(userId);
                                        speakName = info.getName();
                                        mAccountToName.put(userId, info);
                                    }
                                }
                                entity.setSpeakerUserName(speakName);
                            }
                            List<String> onLineMemberList = POCClient.getOnLineMemberList(Long.parseLong(entity.getRooomId()));
                            entity.setOnLineCount(onLineMemberList == null ? 0 : onLineMemberList.size());
                        }
                    }
//                    Collections.sort(allData, mView.getComparator());
                    mSearchAdapter.notifyDataSetChanged();
                }
            }

            @Override
            public void onDeleteTempRoomCallBack(GroupEvent event, boolean status) {
                super.onDeleteTempRoomCallBack(event, status);
                if (status) {
                    checkAdapterData(mAdapter, event.getRoomId(), false);
                    checkSearchAdapter(event.getRoomId(), false);
                    POCClient.destroyRoom(mUserId, event.getRoomId());
                } else {
                    if (mView != null)
                        mView.dismissLoading();
                    ToastUtils.showToast("网络异常,请检查网络设置");
                }

            }

            @Override
            public void onAddMembersCallBack(GroupEvent event, boolean status) {
                super.onAddMembersCallBack(event, status);
                // TODO: 2018/10/26 新增成员 直接刷新列表

                // TODO: 2018/10/26新增成员
                String members = event.getMembers();
                // TODO: 2018/10/26新增成员
//                POCUiKitProxyImpl.getInstance().notifyRefreshGroupList(0, 10, 1);
                DBGroupEntity entity = new DBGroupEntity();
                entity.setRooomId(event.getRoomId());
                entity.setRoomName(event.getGroupName());
                POCUiKitProxyImpl.getInstance().notifyRefreshChannelMembersInfo(entity);
            }

        };

        POCUiKitProxyImpl.getInstance().addRoomEventCallBack(roomEventCallBack);
        POCUiKitProxyImpl.getInstance().addPttKeyEventCallBack(pttEventCallBack);
    }

    private IPOCChannelInfoCallBack pttEventCallBack = new IPOCChannelInfoCallBack() {
        @Override
        public void onPttKeyEvent(String channelId, boolean pttStatus) {
            POCHandlerService.updateGroupPttKey(mContext, (ArrayList<DBGroupEntity>) mAdapter.getAllData(), mUserId, channelId, pttStatus);
            for (DBGroupEntity entity : mAdapter.getAllData()) {
                entity.setIsPttKey(0);
                if (entity.getRooomId().equals(channelId)) {
                    entity.setIsPttKey(pttStatus ? 1 : 0);
                }
            }
            mAdapter.notifyDataSetChanged();
            if (mSearchAdapter != null && mSearchAdapter.getAllData().size() > 0) {
                POCHandlerService.updateGroupPttKey(mContext, (ArrayList<DBGroupEntity>) mSearchAdapter.getAllData(), mUserId, channelId, pttStatus);
                for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                    entity.setIsPttKey(0);
                    if (entity.getRooomId().equals(channelId)) {
                        entity.setIsPttKey(pttStatus ? 1 : 0);
                    }
                }
                mSearchAdapter.notifyDataSetChanged();
            }
        }

        @Override
        public void onChannelNameEvent(String channelId, String channelName) {
            POCHandlerService.updateGroupName(mContext, mUserId, channelId, channelName);
            int position = -1;
            List<DBGroupEntity> allData = mAdapter.getAllData();
            for (DBGroupEntity entity : allData) {
                if (entity.getRooomId().equals(channelId)) {
                    position = 1;
                    entity.setRoomName(channelName);
                    entity.setPinyin(PinyinUtil.getPingYin(channelName));
                    break;
                }
            }
            if (position != -1) {
                Collections.sort(allData, mView.getComparator());
                mAdapter.clear();
                mAdapter.addAll(allData);
            }
            if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
                int position1 = -1;
                for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                    if (entity.getRooomId().equals(channelId)) {
                        position1 = mSearchAdapter.getPosition(entity);
                        entity.setRoomName(channelName);
                        break;
                    }
                }
                if (position1 != -1) {
                    mSearchAdapter.notifyItemChanged(position1);
                }
            }
        }

        @Override
        public void onChannelPwdEvent(String channelId, String channelPwd) {
            POCHandlerService.updateGroupPwd(mContext, mUserId, channelId, channelPwd);
            int position = -1;
            for (DBGroupEntity entity : mAdapter.getAllData()) {
                if (entity.getRooomId().equals(channelId)) {
                    position = mAdapter.getPosition(entity);
                    entity.setChannelPwd(channelPwd);
                    break;
                }
            }
            if (position != -1) {
                mAdapter.notifyItemChanged(position);
            }
            if (mSearchAdapter != null && mSearchAdapter.getAllData().size() > 0) {
                int position1 = -1;
                for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                    if (entity.getRooomId().equals(channelId)) {
                        position1 = mSearchAdapter.getPosition(entity);
                        entity.setChannelPwd(channelPwd);
                        break;
                    }
                }
                if (position1 != -1) {
                    mSearchAdapter.notifyItemChanged(position1);
                }
            }
        }

        @Override
        public void onChannelPwdModeEvent(String channelId, boolean channelPwdMode) {
            POCHandlerService.updateGroupPwdMode(mContext, mUserId, channelId, channelPwdMode);
            int position = -1;
            for (DBGroupEntity entity : mAdapter.getAllData()) {
                if (entity.getRooomId().equals(channelId)) {
                    position = mAdapter.getPosition(entity);
                    entity.setChannelPwdMode(channelPwdMode ? 1 : 0);
                    break;
                }
            }
            if (position != -1) {
                mAdapter.notifyItemChanged(position);
            }
            if (mSearchAdapter != null && mSearchAdapter.getAllData().size() > 0) {
                int position1 = -1;
                for (DBGroupEntity entity : mSearchAdapter.getAllData()) {
                    if (entity.getRooomId().equals(channelId)) {
                        position1 = mSearchAdapter.getPosition(entity);
                        entity.setChannelPwdMode(channelPwdMode ? 1 : 0);
                        break;
                    }
                }
                if (position1 != -1) {
                    mSearchAdapter.notifyItemChanged(position1);
                }

            }
        }
    };

    @Override
    public void showMenuDialog(int position) {
//        dialog = new ConversionMenuDialog(mContext);
//        DBGroupEntity groupEntity = mAdapter.getAllData().get(position);
//        dialog.showDialog(position, groupEntity.getIsSilence(), groupEntity.getIsTopStick());
//        dialog.setMenuClickListener(this);
    }

    /**
     * 这种情况是频道在线的时候才走这个回调处理,
     * 因为逻辑比较绕,需要先离开频道才再删除服务器数据
     *
     * @param groupEntity
     */
    @Override
    public void deleteRoom(DBGroupEntity groupEntity) {
        if (!NetUtils.isNetworkAvailable(mContext)) {
            ToastUtils.showToast(mContext.getResources().getString(R.string.common_net_failed));
            return;
        }
        if (!NetUtils.isNetworkAvailable(mContext)) {
            ToastUtils.showToast(mContext.getResources().getString(R.string.common_net_failed));
            return;
        }
        if (groupEntity.getStatus() == GroupConfig.GROUP_HANGUP) {
            if (groupEntity.getGroupType() == GroupConfig.STICK_GROUP) {
                if (groupEntity.getOwnerId().equalsIgnoreCase(mUserId)) {
                    POCUiKitProxyImpl.getInstance().doDeleteServerRoom(groupEntity.getRooomId());
                } else {
                    POCUiKitProxyImpl.getInstance().doRemoveMembersFromRoom(groupEntity.getRooomId(), mUserId);
                }
            } else if (groupEntity.getGroupType() == GroupConfig.TEMP_GROUP) {
                EventBus.getDefault().post(null);
            }
        } else {
            //通知sdk 频道离开并删除频道 GroupDeleteEvent
            isDeleteRoom = true;
            POCClient.leaveRoom(mUserId, groupEntity.getRooomId());
        }
    }


    @Override
    public void attatchAdapter(EasyRecyclerView mRecycleView, RecyclerArrayAdapter<DBGroupEntity> mSearchAdapter, RecyclerArrayAdapter<DBGroupEntity> adapter) {
        recyclerView = mRecycleView;
        this.mAdapter = adapter;
        this.mSearchAdapter = mSearchAdapter;
    }

    @Override
    public void refreshGroupList(POCGroupUpdateEvent pocGroupUpdateEvent) {
        Object t = pocGroupUpdateEvent.getT();
        ArrayList<GroupList.GroupData> mList = new ArrayList<>();
        if (t != null) {
            mList = (ArrayList<GroupList.GroupData>) t;
        }
        POCHandlerService.insertOrReplaceGroupData(mContext, mList);
//        if (pocGroupUpdateEvent.getGroupType() == 0) {
//
//        } else if (pocGroupUpdateEvent.getGroupType() == 1) {
//            if (t != null) {
//                /**
//                 *String memberInfoList = intent.getStringExtra(MEMBER_INFOS_STRING);
//                 String groupName = intent.getStringExtra(GROUP_NAME);
//                 String ownerId = intent.getStringExtra(OWNERID);
//                 DBGroupEntity entity = GroupUtils.generateTempGroupEntity(userId, roomId, memberInfoList, groupName, ownerId);
//
//                 */
//                DBGroupEntity entity = (DBGroupEntity) t;
//                POCHandlerService.insertTempGroupData(mContext, entity);
//            }
//        }

    }

    @Override
    public void destroy() {
        mView = null;
        POCUiKitProxyImpl.getInstance().removeRoomEventCallBack(roomEventCallBack);
        POCUiKitProxyImpl.getInstance().removePttKeyEventCallBack(pttEventCallBack);
        currentSpeakCache.clear();
        currentSpeakCache = null;
        selfSpeakRoomInfo.clear();
        selfSpeakRoomInfo = null;
    }

    @Override
    public void setUserCacheInfo(Map<String, POCMemberInfo> mapMap) {
        mAccountToName = mapMap;
    }

    //    @Override
    public void onMenu(int menuPosition, int dataPosition, boolean b) {
//        if (mView != null) {
//            if (mAdapter == null) {
//                return;
//            }
//            List<DBGroupEntity> allData = mAdapter.getAllData();
//            DBGroupEntity groupEntity = allData.get(dataPosition);
//            switch (menuPosition) {
//                case ConversionMenuDialog.MENU_TOP_STICK:
//                    groupEntity.setIsTopStick(b);
//                    if (b) {
//                        groupEntity.setTopStickTime(System.currentTimeMillis());
//                    }
//                    Collections.sort(allData, new POCGroupOrderComparator());
//                    mAdapter.clear();
//                    mAdapter.addAll(allData);
//                    POCHandlerService.updateGroupIsTopStick(mContext, mUserId, groupEntity.getRooomId(), b);
//                    break;
//                case ConversionMenuDialog.MENU_SILENCE:
//                    POCClient.muteAndNotifyUI(Long.valueOf(groupEntity.getRooomId()), b);
//                    break;
//                case ConversionMenuDialog.MENU_DELETE:
//                    if (!NetUtils.isNetworkAvailable(mContext)) {
//                        ToastUtils.showToast(mContext.getResources().getString(R.string.common_net_failed));
//                        return;
//                    }
//                    mView.showLoading(mContext.getString(R.string.poc_deleting_group));
//                    POCUiKitProxyImpl.getInstance().notifyMenuClick(menuPosition, groupEntity);
//                    break;
//            }
//        }
    }

    /**
     * 删除频道回调后处理的的方法
     *
     * @param roomId
     */
    private void removeRoom(String roomId) {
        for (DBGroupEntity entity : mAdapter.getAllData()) {
            if (entity.getRooomId().equalsIgnoreCase(roomId)) {
                POCClient.leaveRoom(mUserId, roomId);
                break;
            }
        }
        checkAdapterData(mAdapter, roomId, false);
        checkSearchAdapter(roomId, false);
    }

    /**
     * 刷新adapter View
     *
     * @param roomId
     */
    public void refreshAdapter(String roomId) {
        checkAdapterData(mAdapter, roomId, true);
        checkSearchAdapter(roomId, false);
    }

    private void checkSearchAdapter(String roomId, boolean isSort) {
        if (mSearchAdapter != null && mSearchAdapter.getAllData() != null && mSearchAdapter.getAllData().size() > 0) {
            checkAdapterData(mSearchAdapter, roomId, isSort);
        }
    }

    private void checkAdapterData(RecyclerArrayAdapter<DBGroupEntity> adapter, String roomId, boolean isSort) {
        if (mView != null)
            mView.dismissLoading();
        boolean isRemove = false;
        int position = -1;
        for (DBGroupEntity groupEntity : adapter.getAllData()) {
            if (roomId.equalsIgnoreCase(groupEntity.getRooomId())) {
                position = adapter.getPosition(groupEntity);
                POCClient.deleteLocalRoomById(mUserId, roomId);
                POCClient.leaveRoom(mUserId, roomId);
                POCClient.removeFromReconnectCache(roomId);
                adapter.remove(groupEntity);
                isRemove = true;
                break;
            }
        }
        if (adapter.getAllData() == null || adapter.getAllData().size() <= 0) {
//            recyclerView.setEmptyView(mView.getEmptyView());
            if (mAdapter.getAllData() == null || mAdapter.getAllData().size() == 0) {

                mView.switchViewStatus(UserConfig.VIEW_STTAUS_EMPTY);
            }
        } else {
            if (isSort) {
                Collections.sort(adapter.getAllData(), mView.getComparator());
            } else {
                if (position != -1) {
                    adapter.notifyDataSetChanged();
                }
            }
        }
        if (isRemove &&
                mSearchAdapter != null &&
                mSearchAdapter.getAllData() != null &&
                mSearchAdapter.getAllData().size() > 0) {
            mView.resetFragment();
        }
    }


}
