package com.xdja.poc.sdk.utils;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.xdja.poc.sdk.R;
import com.xdja.poc.common.utils.StringUtils;

/**
 * janus-gateway-android-master
 * 功能
 * 描述
 * created by Wwq : 2018/8/30
 */

public class DialogFactory extends Dialog {
    private TextView tipTextView;

    public DialogFactory(@NonNull Context context) {
        super(context);
        LayoutInflater inflater = LayoutInflater.from(context);
        View v = inflater.inflate(R.layout.poc_dialog_loading, null);// 得到加载view
        LinearLayout layout = v
                .findViewById(R.id.dialog_loading_view);// 加载布局
        tipTextView = v.findViewById(R.id.tipTextView);// 提示文字
        Dialog loadingDialog = new Dialog(context, R.style.MyDialogStyle);// 创建自定义样式dialog
        loadingDialog.setCancelable(false); // 是否可以按“返回键”消失
        loadingDialog.setCanceledOnTouchOutside(false); // 点击加载框以外的区域
        loadingDialog.setContentView(layout, new LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT,
                LinearLayout.LayoutParams.MATCH_PARENT));// 设置布局
        /**
         *将显示Dialog的方法封装在这里面
         */
        Window window = loadingDialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        window.setGravity(Gravity.CENTER);
        window.setAttributes(lp);
        window.setWindowAnimations(R.style.PopWindowAnimStyle);
    }

    public void closeDialog() {
        if (isShowing()) {
            dismiss();
        }
    }

    public void setDialogDesc(String desc) {
        if (tipTextView != null) {
            tipTextView.setText(StringUtils.generateContent(desc));
        }
    }

    public void show(String message) {
        setDialogDesc(message);
        show();
    }
}
