package com.xdja.poc.sdk.business.plugincallback;

import android.util.Log;

import com.xdja.poc.common.utils.LogUtils;
import com.xdja.poc.sdk.business.POCRoom;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IJanusPluginCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.IPluginHandleSendMessageCallbacks;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusPluginHandleWithWebrtc;
import com.xdja.poc.sdk.business.webrtc.janusclientapi.JanusSupportedPluginPackages;
import com.xdja.poc.sdk.config.Constants;
import com.xdja.poc.sdk.config.JaunsApi;

import org.json.JSONObject;
import org.webrtc.MediaStream;

/**
 * Created by john on 2018/9/6.
 */


public class JaunsUnassociationRoomPluginCallbacks implements IJanusPluginCallbacks {
    private JanusPluginHandleWithWebrtc mHandle = null;

    private long roomId;
    private String userName;
    private POCRoom pocRoom;

    public JaunsUnassociationRoomPluginCallbacks(long roomId, String userName, POCRoom pocRoom){
        this.roomId = roomId;
        this.userName = userName;
        this.pocRoom = pocRoom;
    }

    public void existRoom(final long roomID) {
        if (mHandle != null) {
            final JSONObject jsonObject = JaunsApi.existsRoom(roomID);
            mHandle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "existRoom 811 : " + obj.toString());
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_EXIST_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomID, Constants.ROOM_EXIST_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtils.ELog("zs", "onCallbackError: " + error);
                }
            });
        }
    }

    public void listRooms() {
        if (mHandle != null) {
            final JSONObject jsonObject = JaunsApi.listRooms();
            mHandle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "listrooms 863 : " + obj.toString());
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(0, Constants.ROOM_LIST_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(0, Constants.ROOM_LIST_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void listParticipants(final long roomId) {
        if (mHandle != null) {
            final JSONObject jsonObject = JaunsApi.listParticipants(roomId);
            mHandle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "listParticipants 889 : " + obj.toString());
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_LIST_PARTICIPANTS_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_LIST_PARTICIPANTS_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    public void listforwarders(final long roomId, String secret) {
        if (mHandle != null) {
            final JSONObject jsonObject = JaunsApi.listforwarders(roomId, secret);
            mHandle.sendMessage(new IPluginHandleSendMessageCallbacks() {
                @Override
                public void onSuccessSynchronous(JSONObject obj) {
                    LogUtils.DLog("Zhangs", "listforwarders 1096 : " + obj);
                    if (obj.has("error_code")) {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_LIST_FORWARDERS_FAILED, obj.optString("error"));
                    } else {
                        pocRoom.onRoomStatus(roomId, Constants.ROOM_LIST_FORWARDERS_SUCCESS, obj.toString());
                    }
                }

                @Override
                public void onSuccesAsynchronous() {

                }

                @Override
                public JSONObject getMessage() {
                    return jsonObject;
                }

                @Override
                public void onCallbackError(String error) {

                }
            });
        }
    }

    @Override
    public void onCallbackError(String error) {
        LogUtils.DLog("Zhangs", "1569 : " + error);
    }

    @Override
    public void success(JanusPluginHandleWithWebrtc handle) {
        LogUtils.DLog("Zhangs", "1560 : JaunsUnassociationRoomPluginCallbacks  create success");
        mHandle = handle;
        pocRoom.attachSuccess();
    }

    @Override
    public void onMessage(JSONObject msg, JSONObject jsep) {
        LogUtils.DLog("Zhangs", "1567 : " + msg);
    }

    @Override
    public void onLocalStream(MediaStream stream) {

    }

    @Override
    public void onRemoteStream(MediaStream stream) {

    }

    @Override
    public void onDataOpen(Object data) {

    }

    @Override
    public void onData(Object data) {

    }

    @Override
    public void onCleanup() {

    }

    @Override
    public void onDetached() {

    }

    @Override
    public JanusSupportedPluginPackages getPlugin() {
        return JanusSupportedPluginPackages.JANUS_POC_ROOM;
    }
}
